/*
 * Decompiled with CFR 0.152.
 */
package icy.image.lut;

import icy.image.colormap.IcyColorMap;
import icy.image.colorspace.IcyColorSpace;
import icy.image.colorspace.IcyColorSpaceEvent;
import icy.image.colorspace.IcyColorSpaceListener;
import icy.image.lut.LUT;
import icy.image.lut.LUTBandEvent;
import icy.image.lut.LUTBandListener;
import icy.math.Scaler;
import icy.math.ScalerEvent;
import icy.math.ScalerListener;
import javax.swing.event.EventListenerList;

@Deprecated
public class LUTBand
implements ScalerListener,
IcyColorSpaceListener {
    private final LUT lut;
    private final int component;
    private boolean enabled;
    private final Scaler scaler;
    private EventListenerList listeners;

    public LUTBand(LUT lut, int component) {
        this.lut = lut;
        this.component = component;
        this.getColorSpace().addListener(this);
        this.scaler = lut.getScalers()[component];
        this.scaler.addListener(this);
        this.enabled = true;
        this.listeners = new EventListenerList();
    }

    protected void finalize() throws Throwable {
        this.getColorSpace().removeListener(this);
        this.scaler.removeListener(this);
        super.finalize();
    }

    public LUT getLut() {
        return this.lut;
    }

    public IcyColorSpace getColorSpace() {
        return this.lut.getColorSpace();
    }

    public IcyColorMap getColorMap() {
        return this.getColorSpace().getColorMap(this.component);
    }

    public void copyColorMap(IcyColorMap colorMap, boolean copyName, boolean copyAlpha) {
        this.getColorSpace().copyColormap(this.component, colorMap, copyName, copyAlpha);
    }

    public void copyColorMap(IcyColorMap colorMap) {
        this.copyColorMap(colorMap, true, true);
    }

    public Scaler getScaler() {
        return this.scaler;
    }

    public double getMin() {
        return this.scaler.getLeftIn();
    }

    public void setMin(double value) {
        this.scaler.setLeftIn(value);
    }

    public double getMax() {
        return this.scaler.getRightIn();
    }

    public void setMax(double value) {
        this.scaler.setRightIn(value);
    }

    public void setMinMax(double min, double max) {
        this.scaler.setLeftRightIn(min, max);
    }

    public double getMinBound() {
        return this.scaler.getAbsLeftIn();
    }

    public double getMaxBound() {
        return this.scaler.getAbsRightIn();
    }

    public void setMinBound(double value) {
        this.scaler.setAbsLeftIn(value);
    }

    public void setMaxBound(double value) {
        this.scaler.setAbsRightIn(value);
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public int getComponent() {
        return this.component;
    }

    public void addListener(LUTBandListener listener) {
        this.listeners.add(LUTBandListener.class, listener);
    }

    public void removeListener(LUTBandListener listener) {
        this.listeners.remove(LUTBandListener.class, listener);
    }

    public void fireEvent(LUTBandEvent e) {
        LUTBandListener[] lUTBandListenerArray = (LUTBandListener[])this.listeners.getListeners(LUTBandListener.class);
        int n = lUTBandListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            LUTBandListener listener = lUTBandListenerArray[n2];
            listener.lutBandChanged(e);
            ++n2;
        }
    }

    @Override
    public void scalerChanged(ScalerEvent e) {
        if (e.getType() == ScalerEvent.ScalerEventType.CHANGED) {
            this.fireEvent(new LUTBandEvent(this, LUTBandEvent.LUTBandEventType.SCALER_CHANGED));
        }
    }

    @Override
    public void colorSpaceChanged(IcyColorSpaceEvent e) {
        if (e.getType() == IcyColorSpaceEvent.IcyColorSpaceEventType.CHANGED && e.getComponent() == this.component) {
            this.fireEvent(new LUTBandEvent(this, LUTBandEvent.LUTBandEventType.COLORMAP_CHANGED));
        }
    }
}

