/*
 * Decompiled with CFR 0.152.
 */
package icy.roi.edit;

import icy.roi.ROI;
import icy.roi.edit.AbstractROIEdit;
import icy.type.rectangle.Rectangle5D;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoableEdit;

public class BoundsROIEdit
extends AbstractROIEdit {
    Rectangle5D prevBounds;
    Rectangle5D currentBounds;

    public BoundsROIEdit(ROI roi, Rectangle5D prevBounds, boolean mergeable) {
        super(roi, "ROI bounds changed");
        this.prevBounds = prevBounds;
        this.currentBounds = roi.getBounds5D();
        this.setMergeable(mergeable);
    }

    public BoundsROIEdit(ROI roi, Rectangle5D prevBounds) {
        this(roi, prevBounds, true);
    }

    @Override
    public void undo() throws CannotUndoException {
        super.undo();
        this.getROI().setBounds5D(this.prevBounds);
    }

    @Override
    public void redo() throws CannotRedoException {
        super.redo();
        this.getROI().setBounds5D(this.currentBounds);
    }

    @Override
    public boolean addEdit(UndoableEdit edit) {
        BoundsROIEdit bndEdit;
        if (!this.isMergeable()) {
            return false;
        }
        if (edit instanceof BoundsROIEdit && (bndEdit = (BoundsROIEdit)edit).getROI() == this.getROI()) {
            this.currentBounds = bndEdit.currentBounds;
            return true;
        }
        return false;
    }

    @Override
    public void die() {
        super.die();
        this.prevBounds = null;
        this.currentBounds = null;
    }
}

