/*
 * Decompiled with CFR 0.152.
 */
package plugins.kernel.roi.descriptor.intensity;

import icy.roi.ROI;
import icy.roi.ROIDescriptor;
import icy.sequence.Sequence;
import icy.sequence.SequenceEvent;
import plugins.kernel.roi.descriptor.intensity.ROIIntensityDescriptorsPlugin;

public class ROIMeanIntensityDescriptor
extends ROIDescriptor {
    public static final String ID = "Mean intensity";

    public ROIMeanIntensityDescriptor() {
        super(ID, "Mean Intensity", Double.class);
    }

    @Override
    public String getDescription() {
        return ID;
    }

    @Override
    public boolean separateChannel() {
        return true;
    }

    @Override
    public boolean needRecompute(SequenceEvent change) {
        return change.getSourceType() == SequenceEvent.SequenceEventSourceType.SEQUENCE_DATA;
    }

    @Override
    public Object compute(ROI roi, Sequence sequence) throws UnsupportedOperationException, InterruptedException {
        return ROIMeanIntensityDescriptor.computeMeanIntensity(roi, sequence);
    }

    public static double computeMeanIntensity(ROI roi, Sequence sequence) throws UnsupportedOperationException, InterruptedException {
        return ROIIntensityDescriptorsPlugin.computeIntensityDescriptors((ROI)roi, (Sequence)sequence, (boolean)false).mean;
    }
}

