/*
 * Decompiled with CFR 0.152.
 */
package io.bioimage.modelrunner.bioimageio.description;

import io.bioimage.modelrunner.bioimageio.description.ModelDescriptor;
import io.bioimage.modelrunner.bioimageio.description.ModelDescriptorV04;
import io.bioimage.modelrunner.bioimageio.description.ModelDescriptorV05;
import io.bioimage.modelrunner.bioimageio.description.cellpose.ModelDescriptorCellposeV04;
import io.bioimage.modelrunner.bioimageio.description.cellpose.ModelDescriptorCellposeV05;
import io.bioimage.modelrunner.bioimageio.description.stardist.ModelDescriptorStardistV04;
import io.bioimage.modelrunner.bioimageio.description.stardist.ModelDescriptorStardistV05;
import io.bioimage.modelrunner.model.special.cellpose.Cellpose;
import io.bioimage.modelrunner.model.special.stardist.StardistAbstract;
import io.bioimage.modelrunner.utils.YAMLUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class ModelDescriptorFactory {
    private static final String V05_START = "0.5";
    private static final String V04_START = "0.4";
    private static final String FORMAT = "format_version";

    public static ModelDescriptor readFromLocalFile(String modelFile) throws FileNotFoundException, IOException {
        Map<String, Object> yamlElements = YAMLUtils.load(modelFile);
        yamlElements.put("modelPath", new File(modelFile).getParentFile().getAbsolutePath());
        return ModelDescriptorFactory.fromMap(yamlElements);
    }

    public static ModelDescriptor readFromLocalFile(String modelFile, boolean specialModel) throws FileNotFoundException, IOException {
        Map<String, Object> yamlElements = YAMLUtils.load(modelFile);
        yamlElements.put("modelPath", new File(modelFile).getParentFile().getAbsolutePath());
        return ModelDescriptorFactory.fromMap(yamlElements, specialModel);
    }

    public static ModelDescriptor readFromYamlTextString(String yamlText) {
        Map<String, Object> yamlElements = YAMLUtils.loadFromString(yamlText);
        return ModelDescriptorFactory.fromMap(yamlElements, true);
    }

    private static ModelDescriptor fromMap(Map<String, Object> yamlElements) {
        return ModelDescriptorFactory.fromMap(yamlElements, true);
    }

    private static ModelDescriptor fromMap(Map<String, Object> yamlElements, boolean specialModel) {
        if (ModelDescriptorFactory.isStardist(yamlElements) && (StardistAbstract.isInstalled() || specialModel)) {
            return ModelDescriptorFactory.fromStardistMap(yamlElements);
        }
        if (ModelDescriptorFactory.isCellpose(yamlElements) && (Cellpose.isInstalled() || specialModel)) {
            return ModelDescriptorFactory.fromCellposeMap(yamlElements);
        }
        Object formatVersion = yamlElements.get(FORMAT);
        if (formatVersion instanceof String && ((String)formatVersion).startsWith(V04_START)) {
            return new ModelDescriptorV04(yamlElements);
        }
        if (formatVersion instanceof String && ((String)formatVersion).startsWith(V05_START)) {
            return new ModelDescriptorV05(yamlElements);
        }
        if (formatVersion instanceof String) {
            throw new IllegalArgumentException("JDLL only supports the Bioimage.io model specs 0.4 and 0.5.");
        }
        throw new IllegalArgumentException("Incorrect format, missing 'format_version' field.");
    }

    private static ModelDescriptor fromStardistMap(Map<String, Object> yamlElements) {
        Object formatVersion = yamlElements.get(FORMAT);
        if (formatVersion instanceof String && ((String)formatVersion).startsWith(V04_START)) {
            return new ModelDescriptorStardistV04(yamlElements);
        }
        if (formatVersion instanceof String && ((String)formatVersion).startsWith(V05_START)) {
            return new ModelDescriptorStardistV05(yamlElements);
        }
        if (formatVersion instanceof String) {
            throw new IllegalArgumentException("JDLL only supports the Bioimage.io model specs 0.4 and 0.5.");
        }
        throw new IllegalArgumentException("Incorrect format, missing 'format_version' field.");
    }

    private static ModelDescriptor fromCellposeMap(Map<String, Object> yamlElements) {
        Object formatVersion = yamlElements.get(FORMAT);
        if (formatVersion instanceof String && ((String)formatVersion).startsWith(V04_START)) {
            return new ModelDescriptorCellposeV04(yamlElements);
        }
        if (formatVersion instanceof String && ((String)formatVersion).startsWith(V05_START)) {
            return new ModelDescriptorCellposeV05(yamlElements);
        }
        if (formatVersion instanceof String) {
            throw new IllegalArgumentException("JDLL only supports the Bioimage.io model specs 0.4 and 0.5.");
        }
        throw new IllegalArgumentException("Incorrect format, missing 'format_version' field.");
    }

    public static List<ModelDescriptor> getModelsAtLocalRepo(String localRepo) {
        File repoFile = new File(localRepo);
        if (!repoFile.isDirectory()) {
            return Collections.emptyList();
        }
        return Arrays.asList(repoFile.listFiles()).stream().map(ff -> {
            String rdfPath = ff.getAbsolutePath() + File.separator + "rdf.yaml";
            if (!new File(rdfPath).isFile()) {
                return null;
            }
            try {
                return ModelDescriptorFactory.readFromLocalFile(rdfPath);
            }
            catch (Exception e) {
                System.err.println(rdfPath);
                e.printStackTrace();
                return null;
            }
        }).filter(mm -> mm != null).collect(Collectors.toList());
    }

    public static List<ModelDescriptor> getModelsAtLocalRepo() {
        return ModelDescriptorFactory.getModelsAtLocalRepo(new File("models").getAbsolutePath());
    }

    protected static String checkUrl(String str) {
        try {
            new URL(str);
            return str;
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    protected static List<String> buildUrlElements(Object coverElements) {
        ArrayList<String> covers = new ArrayList<String>();
        if (coverElements instanceof List) {
            List elems = (List)coverElements;
            for (Object elem : elems) {
                covers.add((String)elem);
            }
        } else if (coverElements instanceof String) {
            covers.add((String)coverElements);
        } else {
            covers = null;
        }
        return covers;
    }

    public static boolean isStardist(Map<String, Object> yamlElements) {
        boolean nameCheck = yamlElements.get("name") != null && yamlElements.get("name") instanceof String && ((String)yamlElements.get("name")).toLowerCase().contains("stardist");
        boolean configCheck = yamlElements.get("config") != null && yamlElements.get("config") instanceof Map && ((Map)yamlElements.get("config")).get("stardist") != null;
        return nameCheck && configCheck;
    }

    public static boolean isCellpose(Map<String, Object> yamlElements) {
        return false;
    }
}

