/*
 * Decompiled with CFR 0.152.
 */
package io.bioimage.modelrunner.gui;

import io.bioimage.modelrunner.gui.Gui;
import io.bioimage.modelrunner.gui.LogoPanel;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.URL;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Consumer;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.SwingUtilities;

public class DefaultIcon {
    protected static String DIJ_ICON_PATH;
    private static final Map<Dimension, CompletableFuture<ImageIcon>> PENDING_ICONS;
    private static Map<Dimension, ImageIcon> ICONS_CACHE;
    private static final Map<URL, CompletableFuture<BufferedImage>> PENDING;
    private static Map<URL, BufferedImage> CACHE;
    private static ExecutorService scaleExecutor;
    private static BufferedImage MASTER_IMAGE;
    private static String MASTER_PATH;
    private static final Map<String, String> DISPLAYED;

    protected static BufferedImage getImmediateLoadingSquareLogo() {
        BufferedImage bi = new BufferedImage(50, 50, 2);
        Graphics2D g = bi.createGraphics();
        g.setColor(Color.GRAY);
        g.drawString("Loading...", 5, 25);
        g.dispose();
        return bi;
    }

    protected static BufferedImage getSoftwareLogo() {
        try {
            CompletableFuture<BufferedImage> pending;
            if (DIJ_ICON_PATH == null) {
                throw new IOException();
            }
            if (MASTER_IMAGE != null && DIJ_ICON_PATH.equals(MASTER_PATH)) {
                return MASTER_IMAGE;
            }
            URL defaultIconUrl = DefaultIcon.class.getClassLoader().getResource(DIJ_ICON_PATH);
            if (defaultIconUrl == null) {
                throw new IOException();
            }
            BufferedImage cached = CACHE.get(defaultIconUrl);
            if (cached != null) {
                return cached;
            }
            if (scaleExecutor.isShutdown()) {
                scaleExecutor = Executors.newFixedThreadPool(2);
            }
            if ((pending = PENDING.get(defaultIconUrl)) == null) {
                pending = CompletableFuture.supplyAsync(() -> {
                    try {
                        MASTER_IMAGE = ImageIO.read(defaultIconUrl);
                        CACHE.put(defaultIconUrl, MASTER_IMAGE);
                        MASTER_PATH = DIJ_ICON_PATH;
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        MASTER_IMAGE = DefaultIcon.getImmediateLoadingSquareLogo();
                    }
                    PENDING.remove(defaultIconUrl);
                    return MASTER_IMAGE;
                }, scaleExecutor);
                PENDING.put(defaultIconUrl, pending);
            }
            return DefaultIcon.getImmediateLoadingSquareLogo();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return DefaultIcon.getImmediateLoadingSquareLogo();
        }
    }

    public static void drawImOrLogo(URL imURL, LogoPanel panel, String panelID) {
        DISPLAYED.put(panelID, imURL.toExternalForm());
        BufferedImage img = CACHE.get(imURL);
        if (img != null && DISPLAYED.get(panelID).equals(imURL.toExternalForm())) {
            SwingUtilities.invokeLater(() -> panel.setImage(img, false));
            return;
        }
        if (scaleExecutor.isShutdown()) {
            scaleExecutor = Executors.newFixedThreadPool(2);
        }
        PENDING.computeIfAbsent(imURL, u -> CompletableFuture.supplyAsync(() -> {
            try {
                BufferedImage loaded = ImageIO.read(u);
                CACHE.put((URL)u, loaded);
                return loaded;
            }
            catch (Error | Exception e) {
                e.printStackTrace();
                return DefaultIcon.getImmediateLoadingSquareLogo();
            }
        }, scaleExecutor));
        PENDING.get(imURL).whenComplete((bi, err) -> {
            PENDING.remove(imURL);
            SwingUtilities.invokeLater(() -> {
                if (DISPLAYED.get(panelID).equals(imURL.toExternalForm())) {
                    panel.setImage((BufferedImage)bi, false);
                } else {
                    System.out.println("discarded " + imURL + " at " + panelID);
                }
            });
        });
    }

    public static void drawImOrLogo(URL imURL, URL logoUrl, LogoPanel panel, String panelID) {
        DISPLAYED.put(panelID, imURL.toExternalForm());
        BufferedImage img = CACHE.get(imURL);
        if (img != null && DISPLAYED.get(panelID).equals(imURL.toExternalForm())) {
            SwingUtilities.invokeLater(() -> panel.setImage(img, false));
            return;
        }
        DefaultIcon.drawLogo(logoUrl, panel);
        if (scaleExecutor.isShutdown()) {
            scaleExecutor = Executors.newFixedThreadPool(2);
        }
        PENDING.computeIfAbsent(imURL, u -> CompletableFuture.supplyAsync(() -> {
            try {
                BufferedImage loaded = ImageIO.read(u);
                CACHE.put((URL)u, loaded);
                return loaded;
            }
            catch (Error | Exception e) {
                e.printStackTrace();
                return DefaultIcon.getImmediateLoadingSquareLogo();
            }
        }, scaleExecutor));
        PENDING.get(imURL).whenComplete((bi, err) -> {
            PENDING.remove(imURL);
            SwingUtilities.invokeLater(() -> {
                if (DISPLAYED.get(panelID).equals(imURL.toExternalForm())) {
                    panel.setImage((BufferedImage)bi, false);
                }
            });
        });
    }

    public static void drawImOrLogo(URL imURL, URL logoUrl, LogoPanel panel) {
        BufferedImage img = CACHE.get(imURL);
        if (img != null) {
            SwingUtilities.invokeLater(() -> panel.setImage(img, false));
            return;
        }
        DefaultIcon.drawLogo(logoUrl, panel);
        if (scaleExecutor.isShutdown()) {
            scaleExecutor = Executors.newFixedThreadPool(2);
        }
        PENDING.computeIfAbsent(imURL, u -> CompletableFuture.supplyAsync(() -> {
            try {
                BufferedImage loaded = ImageIO.read(u);
                CACHE.put((URL)u, loaded);
                return loaded;
            }
            catch (Error | Exception e) {
                e.printStackTrace();
                return DefaultIcon.getImmediateLoadingSquareLogo();
            }
        }, scaleExecutor));
        PENDING.get(imURL).whenComplete((bi, err) -> {
            PENDING.remove(imURL);
            SwingUtilities.invokeLater(() -> panel.setImage((BufferedImage)bi, false));
        });
    }

    public static void drawLogo(URL url, LogoPanel panel) {
        if (url == null) {
            SwingUtilities.invokeLater(() -> panel.setImage(DefaultIcon.getImmediateLoadingSquareLogo(), true));
            return;
        }
        BufferedImage img = CACHE.get(url);
        if (img != null) {
            SwingUtilities.invokeLater(() -> panel.setImage(img, false));
            return;
        }
        if (scaleExecutor.isShutdown()) {
            scaleExecutor = Executors.newFixedThreadPool(2);
        }
        PENDING.computeIfAbsent(url, u -> CompletableFuture.supplyAsync(() -> {
            try {
                BufferedImage loaded = ImageIO.read(u);
                CACHE.put((URL)u, loaded);
                return loaded;
            }
            catch (Error | Exception e) {
                e.printStackTrace();
                return DefaultIcon.getImmediateLoadingSquareLogo();
            }
        }, scaleExecutor));
        PENDING.get(url).whenComplete((bi, err) -> {
            PENDING.remove(url);
            SwingUtilities.invokeLater(() -> panel.setImage((BufferedImage)bi, false));
        });
        SwingUtilities.invokeLater(() -> panel.setImage(DefaultIcon.getImmediateLoadingSquareLogo(), true));
    }

    protected static void setIconPath(String iconPath) {
        DIJ_ICON_PATH = iconPath;
        DefaultIcon.getSoftwareLogo();
    }

    public static ImageIcon getDefaultIcon(int width, int height) {
        if (DIJ_ICON_PATH == null) {
            return null;
        }
        URL defaultIconUrl = Gui.class.getClassLoader().getResource(DIJ_ICON_PATH);
        if (defaultIconUrl == null) {
            return null;
        }
        Image scaledDefaultImage = MASTER_IMAGE.getScaledInstance(width, height, 2);
        return new ImageIcon(scaledDefaultImage);
    }

    public static ImageIcon getLoadingIcon(int width, int height) {
        Dimension size = new Dimension(width, height);
        ImageIcon cached = ICONS_CACHE.get(size);
        if (cached != null) {
            return cached;
        }
        CompletableFuture<ImageIcon> pending = PENDING_ICONS.get(size);
        if (pending == null && !scaleExecutor.isShutdown()) {
            pending = CompletableFuture.supplyAsync(() -> {
                Image scaledImage = MASTER_IMAGE.getScaledInstance(width, height, 4);
                ImageIcon icon = new ImageIcon(scaledImage);
                ICONS_CACHE.put(size, icon);
                PENDING_ICONS.remove(size);
                return icon;
            }, scaleExecutor);
            PENDING_ICONS.put(size, pending);
        }
        return DefaultIcon.createTransparentIcon(width, height);
    }

    private static ImageIcon createTransparentIcon(int width, int height) {
        return new ImageIcon(new BufferedImage(width, height, 2));
    }

    private static ImageIcon createPlaceholderIcon(int width, int height) {
        BufferedImage bi = new BufferedImage(width, height, 2);
        Graphics2D g2d = bi.createGraphics();
        g2d.setColor(Color.LIGHT_GRAY);
        g2d.drawRect(0, 0, width - 1, height - 1);
        g2d.dispose();
        return new ImageIcon(bi);
    }

    public static void getLoadingIconWithCallback(int width, int height, Consumer<ImageIcon> callback) {
        ImageIcon immediate = DefaultIcon.getLoadingIcon(width, height);
        Dimension size = new Dimension(width, height);
        CompletableFuture<ImageIcon> pending = PENDING_ICONS.get(size);
        if (pending != null && !scaleExecutor.isShutdown()) {
            pending.thenAcceptAsync(icon -> SwingUtilities.invokeLater(() -> callback.accept((ImageIcon)icon)), (Executor)scaleExecutor);
        }
        callback.accept(immediate);
    }

    public static void closeThreads() {
        if (scaleExecutor != null) {
            scaleExecutor.shutdown();
        }
    }

    static {
        PENDING_ICONS = new ConcurrentHashMap<Dimension, CompletableFuture<ImageIcon>>();
        ICONS_CACHE = new ConcurrentHashMap<Dimension, ImageIcon>();
        PENDING = new ConcurrentHashMap<URL, CompletableFuture<BufferedImage>>();
        CACHE = new ConcurrentHashMap<URL, BufferedImage>();
        scaleExecutor = Executors.newFixedThreadPool(2);
        DISPLAYED = new ConcurrentHashMap<String, String>();
    }
}

