/*
 * Decompiled with CFR 0.152.
 */
package plugins.kernel.roi.descriptor.property;

import icy.roi.ROI;
import icy.roi.ROIDescriptor;
import icy.roi.ROIEvent;
import icy.sequence.Sequence;
import icy.util.StringUtil;

public class ROIOpacityDescriptor
extends ROIDescriptor {
    public static final String ID = "Opacity";

    public ROIOpacityDescriptor() {
        super(ID, ID, Float.class);
    }

    @Override
    public String getDescription() {
        return "Opacity factor to display ROI content";
    }

    @Override
    public boolean needRecompute(ROIEvent change) {
        return change.getType() == ROIEvent.ROIEventType.PROPERTY_CHANGED && StringUtil.equals(change.getPropertyName(), "opacity");
    }

    @Override
    public Object compute(ROI roi, Sequence sequence) throws UnsupportedOperationException {
        return Float.valueOf(ROIOpacityDescriptor.getOpacity(roi));
    }

    public static float getOpacity(ROI roi) {
        if (roi == null) {
            return 1.0f;
        }
        return roi.getOpacity();
    }
}

