/*
 * Decompiled with CFR 0.152.
 */
package icy.type.geom.areax;

import icy.type.geom.areax.AreaXBody;
import icy.type.geom.areax.CurveX;
import java.awt.geom.AffineTransform;
import java.awt.geom.PathIterator;
import java.util.NoSuchElementException;

class AreaXIterator
implements PathIterator {
    private AffineTransform transform;
    protected AreaXBody curves;
    private int index;
    private CurveX prevcurve;
    private CurveX curve;

    protected AreaXIterator() {
    }

    public AreaXIterator(AreaXBody curves, AffineTransform at) {
        this.reset(curves, at);
    }

    protected void reset(AreaXBody curves, AffineTransform at) {
        this.curves = curves;
        this.transform = at;
        this.curve = curves.size() >= 1 ? curves.get(0) : null;
        this.prevcurve = null;
        this.index = 0;
    }

    @Override
    public int getWindingRule() {
        return 1;
    }

    @Override
    public boolean isDone() {
        return this.prevcurve == null && this.curve == null;
    }

    @Override
    public void next() {
        if (this.prevcurve != null) {
            this.prevcurve = null;
        } else {
            this.prevcurve = this.curve;
            ++this.index;
            if (this.index < this.curves.size()) {
                this.curve = this.curves.get(this.index);
                if (this.curve.getOrder() != 0 && this.prevcurve.getX1() == this.curve.getX0() && this.prevcurve.getY1() == this.curve.getY0()) {
                    this.prevcurve = null;
                }
            } else {
                this.curve = null;
            }
        }
    }

    @Override
    public int currentSegment(float[] coords) {
        double[] dcoords = new double[6];
        int segtype = this.currentSegment(dcoords);
        int numpoints = segtype == 4 ? 0 : (segtype == 2 ? 2 : (segtype == 3 ? 3 : 1));
        int i = 0;
        while (i < numpoints * 2) {
            coords[i] = (float)dcoords[i];
            ++i;
        }
        return segtype;
    }

    @Override
    public int currentSegment(double[] coords) {
        int numpoints;
        int segtype;
        if (this.prevcurve != null) {
            if (this.curve == null || this.curve.getOrder() == 0) {
                return 4;
            }
            coords[0] = this.curve.getX0();
            coords[1] = this.curve.getY0();
            segtype = 1;
            numpoints = 1;
        } else {
            if (this.curve == null) {
                throw new NoSuchElementException("area iterator out of bounds");
            }
            segtype = this.curve.getSegment(coords);
            numpoints = this.curve.getOrder();
            if (numpoints == 0) {
                numpoints = 1;
            }
        }
        if (this.transform != null) {
            this.transform.transform(coords, 0, coords, 0, numpoints);
        }
        return segtype;
    }
}

