/*
 * Decompiled with CFR 0.152.
 */
package io.bioimage.modelrunner.gui.workers;

import io.bioimage.modelrunner.bioimageio.description.ModelDescriptor;
import io.bioimage.modelrunner.gui.Gui;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;

public class ModelInfoWorker
extends SwingWorker<String, Void> {
    private ModelDescriptor model;
    private TextLoadCallback callback;

    public ModelInfoWorker(ModelDescriptor model, TextLoadCallback callback) {
        this.model = model;
        this.callback = callback;
    }

    @Override
    protected String doInBackground() throws Exception {
        if (this.model == null) {
            return Gui.INSTALL_INSTRUCTIONS;
        }
        return this.model.buildInfo();
    }

    @Override
    protected void done() {
        try {
            String infoText = (String)this.get();
            SwingUtilities.invokeLater(() -> this.callback.onTextLoaded(infoText));
        }
        catch (Exception e) {
            SwingUtilities.invokeLater(() -> this.callback.onTextLoadFailed(e));
        }
    }

    @FunctionalInterface
    public static interface TextLoadCallback {
        public void onTextLoaded(String var1);

        default public void onTextLoadFailed(Exception e) {
            System.err.println("Failed to load text: " + e.getMessage());
        }
    }
}

