/*
 * Decompiled with CFR 0.152.
 */
package io.bioimage.modelrunner.tensor.shm;

import com.sun.jna.Library;
import com.sun.jna.Native;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public interface MacosHelpers
extends Library {
    public static final String LIBRARY_NAME = "ShmCreate";
    public static final String LIBRARY_NAME_SUF = ".dylib";
    public static final MacosHelpers INSTANCE = MacosHelpers.loadLibrary();

    public static MacosHelpers loadLibrary() {
        InputStream in = MacosHelpers.class.getClassLoader().getResourceAsStream("ShmCreate.dylib");
        File tempFile = null;
        try {
            tempFile = File.createTempFile(LIBRARY_NAME, LIBRARY_NAME_SUF);
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        tempFile.deleteOnExit();
        try (FileOutputStream out = new FileOutputStream(tempFile);){
            int readBytes;
            byte[] buffer = new byte[1024];
            while ((readBytes = in.read(buffer)) != -1) {
                ((OutputStream)out).write(buffer, 0, readBytes);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return (MacosHelpers)Native.load((String)tempFile.getAbsolutePath(), MacosHelpers.class);
    }

    public int create_shared_memory(String var1, int var2);

    public void unlink_shared_memory(String var1);

    public long get_shared_memory_size(int var1);
}

