/*
 * Decompiled with CFR 0.152.
 */
package io.bioimage.modelrunner.transformations;

import io.bioimage.modelrunner.tensor.Tensor;
import io.bioimage.modelrunner.transformations.TensorTransformation;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.converter.RealTypeConverters;
import net.imglib2.img.Img;
import net.imglib2.img.ImgFactory;
import net.imglib2.type.NativeType;
import net.imglib2.type.numeric.RealType;
import net.imglib2.type.numeric.real.FloatType;
import net.imglib2.util.Util;

public abstract class AbstractTensorTransformation
extends TensorTransformation {
    private final String name;
    protected static String DEFAULT_MISSING_ARG_ERR = "Cannot execute %s BioImage.io transformation because '%s' parameter was not set.";

    protected AbstractTensorTransformation(String name) {
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public TensorTransformation.Mode getMode() {
        return this.mode;
    }

    protected <R extends RealType<R> & NativeType<R>> Tensor<FloatType> makeOutput(Tensor<R> input) {
        ImgFactory factory = Util.getArrayOrCellImgFactory(input.getData(), (NativeType)new FloatType());
        Img outputImg = factory.create(input.getData());
        RealTypeConverters.copyFromTo(input.getData(), (RandomAccessibleInterval)outputImg);
        Tensor<FloatType> output = Tensor.build(input.getName(), input.getAxesOrderString(), outputImg);
        return output;
    }
}

