/*
 * Decompiled with CFR 0.152.
 */
package icy.math;

import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.util.Iterator;

public class Line2DIterator
implements Iterator<Point2D> {
    protected static final double DEFAULT_STEP = 1.0;
    protected boolean done;
    protected int count;
    protected final boolean forceLast;
    protected final Point2D pos;
    protected final Point2D last;
    protected double sx;
    protected double sy;

    public Line2DIterator(Line2D line, double step, boolean forceLastPoint) {
        double adjStep;
        this.pos = line.getP1();
        this.last = line.getP2();
        this.done = false;
        this.forceLast = forceLastPoint;
        double dx = line.getX2() - line.getX1();
        double dy = line.getY2() - line.getY1();
        double adx = Math.abs(dx);
        double ady = Math.abs(dy);
        double d = adjStep = step <= 0.0 ? 1.0 : step;
        if (adx > ady) {
            this.count = (int)(adx / adjStep);
            this.sx = adjStep;
            this.sy = ady / adx * adjStep;
        } else {
            if (ady == 0.0) {
                this.count = 0;
                this.sx = 0.0;
            } else {
                this.count = (int)(ady / adjStep);
                this.sx = adx / ady * adjStep;
            }
            this.sy = adjStep;
        }
        ++this.count;
        if (dx < 0.0) {
            this.sx = -this.sx;
        }
        if (dy < 0.0) {
            this.sy = -this.sy;
        }
    }

    public Line2DIterator(Line2D line, double step) {
        this(line, step, true);
    }

    public Line2DIterator(Line2D line) {
        this(line, 1.0, true);
    }

    @Override
    public boolean hasNext() {
        return !this.done;
    }

    @Override
    public Point2D next() {
        Point2D result = (Point2D)this.pos.clone();
        if (--this.count <= 0) {
            if (this.forceLast) {
                this.done = this.pos.equals(this.last);
                this.pos.setLocation(this.last);
            } else {
                this.done = true;
            }
        } else {
            this.pos.setLocation(this.pos.getX() + this.sx, this.pos.getY() + this.sy);
        }
        return result;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

