/*
 * Decompiled with CFR 0.152.
 */
package icy.util;

import icy.painter.Anchor2D;
import icy.painter.PathAnchor2D;
import icy.type.geom.areax.AreaX;
import icy.util.GraphicsUtil;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.CubicCurve2D;
import java.awt.geom.Line2D;
import java.awt.geom.Path2D;
import java.awt.geom.PathIterator;
import java.awt.geom.QuadCurve2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class ShapeUtil {
    public static boolean isVisible(Graphics g, Shape shape) {
        if (shape == null) {
            return false;
        }
        return GraphicsUtil.isVisible(g, shape.getBounds2D());
    }

    public static boolean isClosed(Shape shape) {
        PathIterator path = shape.getPathIterator(null);
        double[] crd = new double[6];
        while (!path.isDone()) {
            if (path.currentSegment(crd) == 4) {
                return true;
            }
            path.next();
        }
        return false;
    }

    public static Shape merge(List<Shape> shapes, BooleanOperator operator) {
        Shape result = new AreaX();
        for (Shape shape : shapes) {
            switch (operator) {
                case OR: {
                    result = ShapeUtil.union(result, shape);
                    break;
                }
                case AND: {
                    result = ShapeUtil.intersect(result, shape);
                    break;
                }
                case XOR: {
                    result = ShapeUtil.exclusiveUnion(result, shape);
                }
            }
        }
        return result;
    }

    @Deprecated
    public static Shape merge(Shape[] shapes, ShapeOperation operation) {
        return ShapeUtil.merge(Arrays.asList(shapes), operation.getBooleanOperator());
    }

    public static Shape union(Shape shape1, Shape shape2) {
        AreaX area = new AreaX(ShapeUtil.getClosedPath(shape1));
        area.add(new AreaX(ShapeUtil.getClosedPath(shape2)));
        Path2D.Double result = new Path2D.Double(ShapeUtil.getOpenPath(shape1));
        result.append(ShapeUtil.getOpenPath(shape2), false);
        result.append(area, false);
        return result;
    }

    @Deprecated
    public static Shape add(Shape shape1, Shape shape2) {
        return ShapeUtil.union(shape1, shape2);
    }

    public static AreaX intersect(Shape shape1, Shape shape2) {
        if (!ShapeUtil.isClosed(shape1) || !ShapeUtil.isClosed(shape2)) {
            return new AreaX();
        }
        AreaX result = new AreaX(ShapeUtil.getClosedPath(shape1));
        result.intersect(new AreaX(ShapeUtil.getClosedPath(shape2)));
        return result;
    }

    public static AreaX exclusiveUnion(Shape shape1, Shape shape2) {
        if (!ShapeUtil.isClosed(shape1)) {
            if (!ShapeUtil.isClosed(shape2)) {
                return new AreaX();
            }
            return new AreaX(shape2);
        }
        if (!ShapeUtil.isClosed(shape2)) {
            return new AreaX(shape1);
        }
        AreaX result = new AreaX(ShapeUtil.getClosedPath(shape1));
        result.exclusiveOr(new AreaX(ShapeUtil.getClosedPath(shape2)));
        return result;
    }

    @Deprecated
    public static AreaX xor(Shape shape1, Shape shape2) {
        return ShapeUtil.exclusiveUnion(shape1, shape2);
    }

    public static AreaX subtract(Shape shape1, Shape shape2) {
        if (!ShapeUtil.isClosed(shape1)) {
            return new AreaX();
        }
        if (!ShapeUtil.isClosed(shape2)) {
            return new AreaX(shape1);
        }
        AreaX result = new AreaX(ShapeUtil.getClosedPath(shape1));
        result.subtract(new AreaX(ShapeUtil.getClosedPath(shape2)));
        return result;
    }

    public static void scale(RectangularShape shape, double factor, boolean centered, boolean scalePosition) {
        double newY;
        double newX;
        double w = shape.getWidth();
        double h = shape.getHeight();
        double newW = w * factor;
        double newH = h * factor;
        if (scalePosition) {
            newX = shape.getX() * factor;
            newY = shape.getY() * factor;
        } else {
            newX = shape.getX();
            newY = shape.getY();
        }
        if (centered) {
            double deltaW = (newW - w) / 2.0;
            double deltaH = (newH - h) / 2.0;
            shape.setFrame(newX - deltaW, newY - deltaH, newW, newH);
        } else {
            shape.setFrame(newX, newY, newW, newH);
        }
    }

    public static void scale(RectangularShape shape, double factor, boolean centered) {
        ShapeUtil.scale(shape, factor, centered, false);
    }

    public static void enlarge(RectangularShape shape, double width, double height, boolean centered) {
        double w = shape.getWidth();
        double h = shape.getHeight();
        double newW = w + width;
        double newH = h + height;
        if (centered) {
            double deltaW = (newW - w) / 2.0;
            double deltaH = (newH - h) / 2.0;
            shape.setFrame(shape.getX() - deltaW, shape.getY() - deltaH, newW, newH);
        } else {
            shape.setFrame(shape.getX(), shape.getY(), newW, newH);
        }
    }

    public static void translate(RectangularShape shape, int dx, int dy) {
        shape.setFrame(shape.getX() + (double)dx, shape.getY() + (double)dy, shape.getWidth(), shape.getHeight());
    }

    public static void translate(RectangularShape shape, double dx, double dy) {
        shape.setFrame(shape.getX() + dx, shape.getY() + dy, shape.getWidth(), shape.getHeight());
    }

    public static boolean consumeShapeFromPath(PathIterator path, ShapeConsumer consumer) {
        Line2D.Double line = new Line2D.Double();
        QuadCurve2D.Double quadCurve = new QuadCurve2D.Double();
        CubicCurve2D.Double cubicCurve = new CubicCurve2D.Double();
        double[] crd = new double[6];
        double curX = 0.0;
        double curY = 0.0;
        double movX = 0.0;
        double movY = 0.0;
        while (!path.isDone()) {
            int segType = path.currentSegment(crd);
            double lastX = curX;
            double lastY = curY;
            switch (segType) {
                case 0: {
                    curX = crd[0];
                    curY = crd[1];
                    movX = curX;
                    movY = curY;
                    break;
                }
                case 1: {
                    curX = crd[0];
                    curY = crd[1];
                    line.setLine(lastX, lastY, curX, curY);
                    if (consumer.consume(line)) break;
                    return false;
                }
                case 2: {
                    curX = crd[2];
                    curY = crd[3];
                    quadCurve.setCurve(lastX, lastY, crd[0], crd[1], curX, curY);
                    if (consumer.consume(quadCurve)) break;
                    return false;
                }
                case 3: {
                    curX = crd[4];
                    curY = crd[5];
                    cubicCurve.setCurve(lastX, lastY, crd[0], crd[1], crd[2], crd[3], curX, curY);
                    if (consumer.consume(cubicCurve)) break;
                    return false;
                }
                case 4: {
                    line.setLine(lastX, lastY, movX, movY);
                    if (consumer.consume(line)) break;
                    return false;
                }
            }
            path.next();
        }
        return true;
    }

    public static void consumeSubPath(PathIterator pathIt, PathConsumer consumer) {
        double[] crd = new double[6];
        Path2D current = null;
        while (!pathIt.isDone()) {
            switch (pathIt.currentSegment(crd)) {
                case 0: {
                    if (current != null) {
                        consumer.consumePath(current, false);
                    }
                    current = new Path2D.Double(pathIt.getWindingRule());
                    current.moveTo(crd[0], crd[1]);
                    break;
                }
                case 1: {
                    current.lineTo(crd[0], crd[1]);
                    break;
                }
                case 2: {
                    current.quadTo(crd[0], crd[1], crd[2], crd[3]);
                    break;
                }
                case 3: {
                    current.curveTo(crd[0], crd[1], crd[2], crd[3], crd[4], crd[5]);
                    break;
                }
                case 4: {
                    current.closePath();
                    consumer.consumePath(current, true);
                    current = null;
                }
            }
            pathIt.next();
        }
        if (current != null) {
            consumer.consumePath(current, false);
        }
    }

    public static void consumeSubPath(Shape shape, PathConsumer consumer) {
        ShapeUtil.consumeSubPath(shape.getPathIterator(null), consumer);
    }

    public static Path2D getOpenPath(Shape shape) {
        PathIterator pathIt = shape.getPathIterator(null);
        final Path2D.Double result = new Path2D.Double(pathIt.getWindingRule());
        ShapeUtil.consumeSubPath(pathIt, new PathConsumer(){

            @Override
            public boolean consumePath(Path2D path, boolean closed) {
                if (!closed) {
                    result.append(path, false);
                }
                return true;
            }
        });
        return result;
    }

    public static Path2D getClosedPath(Shape shape) {
        PathIterator pathIt = shape.getPathIterator(null);
        final Path2D.Double result = new Path2D.Double(pathIt.getWindingRule());
        ShapeUtil.consumeSubPath(pathIt, new PathConsumer(){

            @Override
            public boolean consumePath(Path2D path, boolean closed) {
                if (closed) {
                    result.append(path, false);
                }
                return true;
            }
        });
        return result;
    }

    public static ArrayList<PathAnchor2D> getAnchorsFromShape(Shape shape, Color color, Color selectedColor) {
        PathIterator pathIt = shape.getPathIterator(null);
        ArrayList<PathAnchor2D> result = new ArrayList<PathAnchor2D>();
        double[] crd = new double[6];
        double[] mov = new double[2];
        while (!pathIt.isDone()) {
            int segType = pathIt.currentSegment(crd);
            PathAnchor2D pt = null;
            switch (segType) {
                case 0: {
                    mov[0] = crd[0];
                    mov[1] = crd[1];
                }
                case 1: {
                    pt = new PathAnchor2D(crd[0], crd[1], color, selectedColor, segType);
                    break;
                }
                case 2: {
                    pt = new PathAnchor2D(crd[0], crd[1], crd[2], crd[3], color, selectedColor);
                    break;
                }
                case 3: {
                    pt = new PathAnchor2D(crd[0], crd[1], crd[2], crd[3], crd[4], crd[5], color, selectedColor);
                    break;
                }
                case 4: {
                    pt = new PathAnchor2D(mov[0], mov[1], color, selectedColor, segType);
                    pt.setVisible(false);
                }
            }
            if (pt != null) {
                result.add(pt);
            }
            pathIt.next();
        }
        return result;
    }

    public static ArrayList<PathAnchor2D> getAnchorsFromShape(Shape shape) {
        return ShapeUtil.getAnchorsFromShape(shape, Anchor2D.DEFAULT_NORMAL_COLOR, Anchor2D.DEFAULT_SELECTED_COLOR);
    }

    public static Path2D buildPathFromAnchors(Path2D path, List<PathAnchor2D> points, boolean closePath) {
        path.reset();
        for (PathAnchor2D pt : points) {
            switch (pt.getType()) {
                case 0: {
                    path.moveTo(pt.getX(), pt.getY());
                    break;
                }
                case 1: {
                    path.lineTo(pt.getX(), pt.getY());
                    break;
                }
                case 2: {
                    path.quadTo(pt.getPosQExtX(), pt.getPosQExtY(), pt.getX(), pt.getY());
                    break;
                }
                case 3: {
                    path.curveTo(pt.getPosCExtX(), pt.getPosCExtY(), pt.getPosQExtX(), pt.getPosQExtY(), pt.getX(), pt.getY());
                    break;
                }
                case 4: {
                    path.closePath();
                }
            }
        }
        if (points.size() > 1 && closePath) {
            path.closePath();
        }
        return path;
    }

    public static Path2D buildPathFromAnchors(Path2D path, List<PathAnchor2D> points) {
        return ShapeUtil.buildPathFromAnchors(path, points, true);
    }

    public static Path2D getPathFromAnchors(List<PathAnchor2D> points, boolean closePath) {
        return ShapeUtil.buildPathFromAnchors(new Path2D.Double(), points, closePath);
    }

    public static Path2D getPathFromAnchors(List<PathAnchor2D> points) {
        return ShapeUtil.buildPathFromAnchors(new Path2D.Double(), points, true);
    }

    @Deprecated
    public static void drawFromPath(PathIterator path, Graphics2D g) {
        GraphicsUtil.drawPathIterator(path, g);
    }

    public static boolean pathIntersects(PathIterator path, final Rectangle2D rect) {
        return !ShapeUtil.consumeShapeFromPath(path, new ShapeConsumer(){

            @Override
            public boolean consume(Shape shape) {
                return !shape.intersects(rect);
            }
        });
    }

    public static enum BooleanOperator {
        OR,
        AND,
        XOR;

    }

    public static interface PathConsumer {
        public boolean consumePath(Path2D var1, boolean var2);
    }

    public static interface ShapeConsumer {
        public boolean consume(Shape var1);
    }

    @Deprecated
    public static enum ShapeOperation {
        OR{

            @Override
            public BooleanOperator getBooleanOperator() {
                return BooleanOperator.OR;
            }
        }
        ,
        AND{

            @Override
            public BooleanOperator getBooleanOperator() {
                return BooleanOperator.AND;
            }
        }
        ,
        XOR{

            @Override
            public BooleanOperator getBooleanOperator() {
                return BooleanOperator.XOR;
            }
        };


        public abstract BooleanOperator getBooleanOperator();
    }
}

