/*
 * Decompiled with CFR 0.152.
 */
package io.bioimage.modelrunner.utils;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Enumeration;
import java.util.function.Consumer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;

public class ZipUtils {
    private static final int BUFFER_SIZE = 8192;

    public static void unzipFolder(String sourcePath, String targetPath) throws IOException {
        Consumer<Double> progressConsumer = new Consumer<Double>(){

            @Override
            public void accept(Double d) {
            }
        };
        ZipUtils.unzipFolder(sourcePath, targetPath, progressConsumer);
    }

    public static void unzipFolder(String sourcePath, String targetPath, Consumer<Double> consumer) throws IOException {
        FileInputStream fis = new FileInputStream(new File(sourcePath));
        ZipInputStream zis = new ZipInputStream(fis);
        ZipEntry entry = zis.getNextEntry();
        long totalSize = Files.size(Paths.get(sourcePath, new String[0]));
        long extractedSize = 0L;
        while (entry != null) {
            File file = new File(targetPath, entry.getName());
            if (entry.isDirectory()) {
                file.mkdirs();
            } else {
                File parent = file.getParentFile();
                if (!parent.exists()) {
                    parent.mkdirs();
                }
                try (BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(file));){
                    int location;
                    byte[] buffer = new byte[8192];
                    while ((location = zis.read(buffer)) != -1 && !Thread.interrupted()) {
                        bos.write(buffer, 0, location);
                        consumer.accept((double)(extractedSize += (long)location) / (double)totalSize);
                    }
                    bos.close();
                }
                catch (ZipException e) {
                    zis.close();
                    fis.close();
                    throw e;
                }
            }
            entry = zis.getNextEntry();
        }
        zis.close();
        fis.close();
    }

    public static long getUncompressedSize(File zipFile) throws IOException {
        return ZipUtils.getUncompressedSize(zipFile, Thread.currentThread());
    }

    public static long getUncompressedSize(File zipFile, Thread parentThread) throws IOException {
        long totalSize = 0L;
        try (ZipFile zip = new ZipFile(zipFile);){
            Enumeration<? extends ZipEntry> entries = zip.entries();
            while (entries.hasMoreElements() && parentThread.isAlive()) {
                ZipEntry entry = entries.nextElement();
                if (entry.isDirectory()) continue;
                long size = entry.getSize();
                if (size == -1L) {
                    size = ZipUtils.calculateEntrySize(zip, entry, parentThread);
                }
                totalSize += size;
            }
        }
        return totalSize;
    }

    private static long calculateEntrySize(ZipFile zip, ZipEntry entry, Thread parentThread) throws IOException {
        long size = 0L;
        byte[] buffer = new byte[8192];
        try (InputStream is = zip.getInputStream(entry);){
            int read;
            while ((read = is.read(buffer)) != -1 && parentThread.isAlive()) {
                size += (long)read;
            }
        }
        return size;
    }
}

