/*
 * Decompiled with CFR 0.152.
 */
package icy.gui.dialog;

import icy.file.FileUtil;
import icy.gui.dialog.ActionDialog;
import icy.main.Icy;
import icy.plugin.PluginDescriptor;
import icy.plugin.PluginLoader;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.EmptyBorder;

public class ImporterSelectionDialog
extends ActionDialog {
    private static final long serialVersionUID = -7233417975763216494L;
    JList importerList;
    JLabel pathLabel;

    public ImporterSelectionDialog(List<? extends Object> importers, String path) {
        super("Select importer");
        this.initializeGui();
        this.pathLabel.setText("  " + FileUtil.getFileName(path));
        this.importerList.setListData(this.getItems(importers).toArray());
        if (importers.size() > 0) {
            this.importerList.setSelectedIndex(0);
        }
        this.importerList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2 && e.getButton() == 1 && ImporterSelectionDialog.this.importerList.getSelectedIndex() != -1) {
                    ImporterSelectionDialog.this.getOkBtn().doClick();
                }
            }
        });
        this.setPreferredSize(new Dimension(360, 240));
        this.pack();
        this.setLocationRelativeTo((Component)((Object)Icy.getMainInterface().getMainFrame()));
        this.setVisible(true);
    }

    private void initializeGui() {
        this.setTitle("Importer selection");
        this.importerList = new JList();
        this.importerList.setSelectionMode(0);
        JScrollPane scrollPane = new JScrollPane(this.importerList);
        scrollPane.setPreferredSize(new Dimension(320, 80));
        scrollPane.setMinimumSize(new Dimension(320, 80));
        scrollPane.setHorizontalScrollBarPolicy(31);
        this.getMainPanel().add((Component)scrollPane, "Center");
        JPanel panel = new JPanel();
        panel.setBorder(new EmptyBorder(4, 0, 4, 0));
        this.getMainPanel().add((Component)panel, "North");
        GridBagLayout gbl_panel = new GridBagLayout();
        gbl_panel.columnWidths = new int[2];
        gbl_panel.rowHeights = new int[3];
        gbl_panel.columnWeights = new double[]{1.0, Double.MIN_VALUE};
        gbl_panel.rowWeights = new double[]{0.0, 0.0, Double.MIN_VALUE};
        panel.setLayout(gbl_panel);
        JLabel newLabel = new JLabel(" Select the importer to open the following file:");
        newLabel.setFont(new Font("Tahoma", 1, 11));
        GridBagConstraints gbc_newLabel = new GridBagConstraints();
        gbc_newLabel.anchor = 17;
        gbc_newLabel.insets = new Insets(0, 0, 5, 0);
        gbc_newLabel.gridx = 0;
        gbc_newLabel.gridy = 0;
        panel.add((Component)newLabel, gbc_newLabel);
        this.pathLabel = new JLabel("  ");
        this.pathLabel.setFont(new Font("Tahoma", 0, 11));
        GridBagConstraints gbc_pathLabel = new GridBagConstraints();
        gbc_pathLabel.anchor = 17;
        gbc_pathLabel.gridx = 0;
        gbc_pathLabel.gridy = 1;
        panel.add((Component)this.pathLabel, gbc_pathLabel);
    }

    private List<ImporterPluginItem> getItems(List<? extends Object> importers) {
        ArrayList<ImporterPluginItem> result = new ArrayList<ImporterPluginItem>();
        for (Object object : importers) {
            PluginDescriptor plugin = PluginLoader.getPlugin(object.getClass().getName());
            if (plugin == null) continue;
            result.add(new ImporterPluginItem(plugin, object));
        }
        return result;
    }

    public Object getSelectedImporter() {
        return ((ImporterPluginItem)this.importerList.getSelectedValue()).getImporter();
    }

    private class ImporterPluginItem {
        final PluginDescriptor plugin;
        final Object importer;

        ImporterPluginItem(PluginDescriptor plugin, Object importer) {
            this.plugin = plugin;
            this.importer = importer;
        }

        public Object getImporter() {
            return this.importer;
        }

        public String toString() {
            return this.plugin.toString();
        }
    }
}

