/*
 * Decompiled with CFR 0.152.
 */
package icy.gui.dialog;

import icy.file.FileUtil;
import icy.file.ImageFileFormat;
import icy.file.Saver;
import icy.gui.dialog.ConfirmDialog;
import icy.gui.dialog.SaverOptionPanel;
import icy.image.ImageProvider;
import icy.main.Icy;
import icy.preferences.ApplicationPreferences;
import icy.preferences.XMLPreferences;
import icy.sequence.Sequence;
import icy.sequence.SequenceIdImporter;
import icy.system.thread.ThreadUtil;
import icy.util.StringUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import loci.formats.IFormatWriter;
import loci.formats.gui.ExtensionFileFilter;

public class SaverDialog
extends JFileChooser {
    private static final String PREF_ID = "frame/imageSaver";
    private static final String ID_WIDTH = "width";
    private static final String ID_HEIGHT = "height";
    private static final String ID_PATH = "path";
    private static final String ID_MULTIPLEFILE = "multipleFile";
    private static final String ID_OVERWRITENAME = "overwriteName";
    private static final String ID_FPS = "fps";
    private static final String ID_EXTENSION = "extension";
    private SaverOptionPanel settingPanel;
    private final XMLPreferences preferences = ApplicationPreferences.getPreferences().node("frame/imageSaver");
    private final boolean singleZ;
    private final boolean singleT;
    private final boolean singleImage;

    public SaverDialog(Sequence sequence, boolean autoSave) {
        this.singleZ = sequence.getSizeZ() == 1;
        this.singleT = sequence.getSizeT() == 1;
        this.singleImage = this.singleZ && this.singleT;
        this.setCurrentDirectory(new File(this.preferences.get(ID_PATH, "")));
        this.setPreferredSize(new Dimension(this.preferences.getInt(ID_WIDTH, 600), this.preferences.getInt(ID_HEIGHT, 400)));
        this.setDialogTitle("Save image file");
        this.removeChoosableFileFilter(this.getAcceptAllFileFilter());
        this.addChoosableFileFilter((FileFilter)ImageFileFormat.TIFF.getExtensionFileFilter());
        this.addChoosableFileFilter((FileFilter)ImageFileFormat.PNG.getExtensionFileFilter());
        this.addChoosableFileFilter((FileFilter)ImageFileFormat.JPG.getExtensionFileFilter());
        this.addChoosableFileFilter((FileFilter)ImageFileFormat.AVI.getExtensionFileFilter());
        this.setFileFilter(this.getFileFilter(this.preferences.get(ID_EXTENSION, ImageFileFormat.TIFF.getDescription())));
        this.setMultiSelectionEnabled(false);
        this.setFileSelectionMode(0);
        String filename = sequence.getName();
        if (StringUtil.isEmpty(filename) || filename.startsWith("no name")) {
            filename = FileUtil.getFileName(sequence.getOutputFilename(false), false);
        }
        if (!StringUtil.isEmpty(filename)) {
            String ext = this.getDialogExtension(filename = FileUtil.cleanPath(filename.replaceAll("/", " ").replaceAll("\\\\", " ")));
            if (ext != null) {
                FileUtil.setExtension(filename, "");
            }
            this.setSelectedFile(new File(filename));
        }
        this.settingPanel = new SaverOptionPanel();
        this.settingPanel.setMultipleFiles(this.preferences.getBoolean(ID_MULTIPLEFILE, false));
        this.settingPanel.setOverwriteMetadata(this.preferences.getBoolean(ID_OVERWRITENAME, true));
        double ti = sequence.getTimeInterval() * 1000.0;
        if (ti != 0.0) {
            this.settingPanel.setTimeInterval(ti);
        } else {
            this.settingPanel.setFramePerSecond(this.preferences.getInt(ID_FPS, 20));
        }
        this.setAccessory(this.settingPanel);
        this.updateSettingPanel();
        this.addPropertyChangeListener("fileFilterChanged", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                SaverDialog.this.updateSettingPanel();
            }
        });
        ImageFileFormat fileFormat = null;
        IFormatWriter writer = null;
        boolean accepted = false;
        while (!accepted) {
            int value = this.showSaveDialog((Component)((Object)Icy.getMainInterface().getMainFrame()));
            if (value != 0) break;
            fileFormat = this.getSelectedFileFormat();
            writer = Saver.getWriter(fileFormat);
            accepted = !this.isCompatible(fileFormat, sequence) ? ConfirmDialog.confirm("Warning", "Some information will be lost in the " + (Object)((Object)fileFormat) + " saved file(s). Do you want to continue ?") : true;
        }
        if (accepted) {
            File file = this.getSelectedFile();
            String outFilename = file.getAbsolutePath();
            if (this.isFolderRequired()) {
                file = new File(FileUtil.setExtension(outFilename, ""));
                this.setSelectedFile(file);
            } else {
                ExtensionFileFilter extensionFilter = (ExtensionFileFilter)this.getFileFilter();
                if (!SaverDialog.hasExtension(outFilename.toLowerCase(), extensionFilter)) {
                    file = new File(String.valueOf(outFilename) + "." + extensionFilter.getExtension());
                    this.setSelectedFile(file);
                }
            }
            if (autoSave && (!file.exists() || ConfirmDialog.confirm("Overwrite existing file(s) ?"))) {
                if (file.exists()) {
                    String outPath;
                    String impPath;
                    ImageProvider imp = sequence.getImageProvider();
                    if (imp instanceof SequenceIdImporter && StringUtil.equals(impPath = FileUtil.getGenericPath(((SequenceIdImporter)imp).getOpened()), outPath = FileUtil.getGenericPath(outFilename))) {
                        sequence.setVolatile(false);
                        sequence.loadAllData();
                        sequence.setImageProvider(null);
                        System.gc();
                    }
                    FileUtil.delete(file, true);
                }
                this.preferences.put(ID_PATH, this.getCurrentDirectory().getAbsolutePath());
                if (this.isOverwriteMetadataEnabled()) {
                    sequence.setName(FileUtil.getFileName(file.getAbsolutePath(), false));
                }
                final Sequence s = sequence;
                final File f = file;
                final IFormatWriter w = writer;
                ThreadUtil.bgRun(new Runnable(){

                    @Override
                    public void run() {
                        Saver.save(w, s, f, SaverDialog.this.getFps(), SaverDialog.this.isSaveAsMultipleFilesEnabled(), true, true);
                    }
                });
            }
            this.preferences.putInt(ID_WIDTH, this.getWidth());
            this.preferences.putInt(ID_HEIGHT, this.getHeight());
            if (fileFormat == ImageFileFormat.TIFF) {
                this.preferences.putBoolean(ID_MULTIPLEFILE, this.isSaveAsMultipleFilesEnabled());
            }
            this.preferences.putBoolean(ID_OVERWRITENAME, this.settingPanel.getOverwriteMetadata());
            if (fileFormat == ImageFileFormat.AVI) {
                this.preferences.putInt(ID_FPS, this.getFps());
            }
            this.preferences.put(ID_EXTENSION, this.getFileFilter().getDescription());
        }
    }

    public SaverDialog(Sequence sequence) {
        this(sequence, true);
    }

    @Deprecated
    public SaverDialog(Sequence sequence, int defZ, int defT, boolean autoSave) {
        this(sequence, autoSave);
    }

    @Deprecated
    public SaverDialog(Sequence sequence, int defZ, int defT) {
        this(sequence, true);
    }

    protected FileFilter getFileFilter(String description) {
        FileFilter[] filters;
        FileFilter[] fileFilterArray = filters = this.getChoosableFileFilters();
        int n = filters.length;
        int n2 = 0;
        while (n2 < n) {
            FileFilter filter = fileFilterArray[n2];
            if (StringUtil.equals(filter.getDescription(), description)) {
                return filter;
            }
            ++n2;
        }
        return ImageFileFormat.TIFF.getExtensionFileFilter();
    }

    private static boolean hasExtension(String name, ExtensionFileFilter extensionFilter) {
        return SaverDialog.getExtension(name, extensionFilter) != null;
    }

    private static String getExtension(String name, ExtensionFileFilter extensionFilter) {
        String[] stringArray = extensionFilter.getExtensions();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String ext = stringArray[n2];
            if (name.endsWith(ext.toLowerCase())) {
                return ext;
            }
            ++n2;
        }
        return null;
    }

    private String getDialogExtension(String name) {
        FileFilter[] fileFilterArray = this.getChoosableFileFilters();
        int n = fileFilterArray.length;
        int n2 = 0;
        while (n2 < n) {
            FileFilter filter = fileFilterArray[n2];
            String ext = SaverDialog.getExtension(name, (ExtensionFileFilter)filter);
            if (ext != null) {
                return ext;
            }
            ++n2;
        }
        return null;
    }

    public ImageFileFormat getSelectedFileFormat() {
        FileFilter ff = this.getFileFilter();
        if (ff == null || !(ff instanceof ExtensionFileFilter)) {
            return ImageFileFormat.TIFF;
        }
        return ImageFileFormat.getWriteFormat(((ExtensionFileFilter)ff).getExtension(), ImageFileFormat.TIFF);
    }

    public boolean isFolderRequired() {
        return !this.singleImage && this.isSaveAsMultipleFilesEnabled();
    }

    public boolean isSaveAsMultipleFilesEnabled() {
        return this.settingPanel.isMultipleFilesVisible() && this.settingPanel.getMultipleFiles();
    }

    public boolean isOverwriteMetadataEnabled() {
        return this.settingPanel.isOverwriteMetadataVisible() && this.settingPanel.getOverwriteMetadata();
    }

    public int getFps() {
        if (this.settingPanel.isFramePerSecondVisible()) {
            return this.settingPanel.getFramePerSecond();
        }
        return 1;
    }

    public double getTimeInterval() {
        if (this.settingPanel.isFramePerSecondVisible()) {
            return this.settingPanel.getTimeInterval();
        }
        return 100.0;
    }

    @Deprecated
    public int getZMin() {
        return 0;
    }

    @Deprecated
    public int getZMax() {
        return 0;
    }

    @Deprecated
    public int getTMin() {
        return 0;
    }

    @Deprecated
    public int getTMax() {
        return 0;
    }

    void updateSettingPanel() {
        ImageFileFormat fileFormat = this.getSelectedFileFormat();
        if (this.singleImage) {
            this.settingPanel.setMultipleFilesVisible(false);
            this.settingPanel.setForcedMultipleFilesOff();
        } else {
            switch (fileFormat) {
                case AVI: {
                    this.settingPanel.setMultipleFilesVisible(true);
                    this.settingPanel.setForcedMultipleFilesOff();
                    break;
                }
                case PNG: 
                case JPG: {
                    this.settingPanel.setMultipleFilesVisible(true);
                    this.settingPanel.setForcedMultipleFilesOn();
                    break;
                }
                case TIFF: {
                    this.settingPanel.setMultipleFilesVisible(true);
                    this.settingPanel.removeForcedMultipleFiles();
                    this.settingPanel.setMultipleFiles(this.preferences.getBoolean(ID_MULTIPLEFILE, false));
                }
            }
        }
        this.settingPanel.setFramePerSecondVisible(fileFormat == ImageFileFormat.AVI);
    }

    private boolean isCompatible(ImageFileFormat fileFormat, Sequence sequence) {
        if (fileFormat == ImageFileFormat.AVI && !this.singleZ) {
            return false;
        }
        return Saver.isCompatible(fileFormat, sequence.getColorModel());
    }
}

