/*
 * Decompiled with CFR 0.152.
 */
package icy.image.cache;

import icy.image.IcyBufferedImage;
import icy.image.cache.AbstractCache;
import icy.image.cache.CacheException;
import icy.image.cache.EHCache2;
import icy.system.IcyExceptionHandler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class ImageCache {
    public static AbstractCache cache = null;

    public static synchronized boolean init(int cacheSizeMB, String path) {
        if (cache == null) {
            try {
                cache = new EHCache2(cacheSizeMB, String.valueOf(path) + "/icy_cache");
                System.out.println("Image cache initialized (reserved memory = " + cacheSizeMB + " MB, disk cache location = '" + path + "/icy_cache')");
            }
            catch (Exception e) {
                System.err.println("Error while initialize image cache:");
                IcyExceptionHandler.showErrorMessage(e, false, true);
            }
        }
        return cache != null;
    }

    public static synchronized boolean shutDownIfEmpty() {
        if (cache != null) {
            cache.clean();
            if (!cache.isEmpty()) {
                return false;
            }
            ImageCache.shutDown();
        }
        return true;
    }

    public static synchronized void shutDown() {
        if (cache != null) {
            cache.end();
            cache = null;
            System.out.println("Image cache shutdown..");
        }
    }

    public static boolean isInCache(IcyBufferedImage image) throws RuntimeException {
        ImageCache.checkCacheLoaded();
        return cache.isInCache(ImageCache.getKey(image));
    }

    public static boolean isOnMemoryCache(IcyBufferedImage image) throws RuntimeException {
        ImageCache.checkCacheLoaded();
        return cache.isOnMemoryCache(ImageCache.getKey(image));
    }

    public static boolean isOnDiskCache(IcyBufferedImage image) throws RuntimeException {
        ImageCache.checkCacheLoaded();
        return cache.isOnDiskCache(ImageCache.getKey(image));
    }

    public static long usedMemory() throws RuntimeException {
        ImageCache.checkCacheLoaded();
        return cache.usedMemory();
    }

    public static long usedDisk() throws RuntimeException {
        ImageCache.checkCacheLoaded();
        return cache.usedDisk();
    }

    public static Collection<IcyBufferedImage> getAllKeys() throws CacheException, RuntimeException {
        ImageCache.checkCacheLoaded();
        return ImageCache.getImages(cache.getAllKeys(), false);
    }

    private static Collection<IcyBufferedImage> getImages(Collection<Integer> keys, boolean getNull) {
        ArrayList<IcyBufferedImage> result = new ArrayList<IcyBufferedImage>(keys.size());
        for (Integer key : keys) {
            IcyBufferedImage image = ImageCache.getImage(key);
            if (!getNull && image == null) continue;
            result.add(image);
        }
        return result;
    }

    private static IcyBufferedImage getImage(Integer key) {
        return IcyBufferedImage.getIcyBufferedImage(key);
    }

    public static Map<IcyBufferedImage, Object> get(Collection<IcyBufferedImage> keys) throws CacheException, RuntimeException {
        ImageCache.checkCacheLoaded();
        HashMap<IcyBufferedImage, Object> result = new HashMap<IcyBufferedImage, Object>();
        for (IcyBufferedImage key : keys) {
            result.put(key, cache.get(ImageCache.getKey(key)));
        }
        return result;
    }

    public static Object get(IcyBufferedImage key) throws CacheException, RuntimeException {
        ImageCache.checkCacheLoaded();
        return cache.get(ImageCache.getKey(key));
    }

    public static void set(IcyBufferedImage key, Object object, boolean eternal) throws CacheException, RuntimeException {
        ImageCache.checkCacheLoaded();
        cache.set(ImageCache.getKey(key), object, eternal);
    }

    public static void remove(IcyBufferedImage key) throws CacheException, RuntimeException {
        ImageCache.checkCacheLoaded();
        cache.remove(ImageCache.getKey(key));
    }

    private static Integer getKey(IcyBufferedImage image) {
        return System.identityHashCode(image);
    }

    private static void checkCacheLoaded() throws RuntimeException {
        if (!ImageCache.isEnabled()) {
            throw new RuntimeException("Cache module is not been enabled. Check launch parameters!");
        }
    }

    public static boolean isEnabled() {
        return cache != null;
    }
}

