/*
 * Decompiled with CFR 0.152.
 */
package icy.type.collection.array;

import icy.math.MathUtil;
import icy.type.DataType;
import icy.type.TypeUtil;
import icy.type.collection.array.ArrayUtil;
import icy.util.StringUtil;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.lang.reflect.Array;
import java.util.Arrays;

public class Array1DUtil {
    public static int getTotalLength(byte[] array) {
        if (array != null) {
            return array.length;
        }
        return 0;
    }

    public static int getTotalLength(short[] array) {
        if (array != null) {
            return array.length;
        }
        return 0;
    }

    public static int getTotalLength(int[] array) {
        if (array != null) {
            return array.length;
        }
        return 0;
    }

    public static int getTotalLength(long[] array) {
        if (array != null) {
            return array.length;
        }
        return 0;
    }

    public static int getTotalLength(float[] array) {
        if (array != null) {
            return array.length;
        }
        return 0;
    }

    public static int getTotalLength(double[] array) {
        if (array != null) {
            return array.length;
        }
        return 0;
    }

    @Deprecated
    public static int getTotalLenght(byte[] array) {
        return Array1DUtil.getTotalLength(array);
    }

    @Deprecated
    public static int getTotalLenght(short[] array) {
        return Array1DUtil.getTotalLength(array);
    }

    @Deprecated
    public static int getTotalLenght(int[] array) {
        return Array1DUtil.getTotalLength(array);
    }

    @Deprecated
    public static int getTotalLenght(float[] array) {
        return Array1DUtil.getTotalLength(array);
    }

    @Deprecated
    public static int getTotalLenght(double[] array) {
        return Array1DUtil.getTotalLength(array);
    }

    public static Object createArray(DataType dataType, int len) {
        switch (dataType.getJavaType()) {
            case BYTE: {
                return new byte[len];
            }
            case SHORT: {
                return new short[len];
            }
            case INT: {
                return new int[len];
            }
            case LONG: {
                return new long[len];
            }
            case FLOAT: {
                return new float[len];
            }
            case DOUBLE: {
                return new double[len];
            }
        }
        return null;
    }

    @Deprecated
    public static Object createArray(int dataType, int len) {
        return Array1DUtil.createArray(DataType.getDataType(dataType), len);
    }

    public static Object allocIfNull(Object out, DataType dataType, int len) {
        if (out == null) {
            switch (dataType.getJavaType()) {
                case BYTE: {
                    return new byte[len];
                }
                case SHORT: {
                    return new short[len];
                }
                case INT: {
                    return new int[len];
                }
                case LONG: {
                    return new long[len];
                }
                case FLOAT: {
                    return new float[len];
                }
                case DOUBLE: {
                    return new double[len];
                }
            }
        }
        return out;
    }

    public static boolean[] allocIfNull(boolean[] out, int len) {
        if (out == null) {
            return new boolean[len];
        }
        return out;
    }

    public static byte[] allocIfNull(byte[] out, int len) {
        if (out == null) {
            return new byte[len];
        }
        return out;
    }

    public static short[] allocIfNull(short[] out, int len) {
        if (out == null) {
            return new short[len];
        }
        return out;
    }

    public static int[] allocIfNull(int[] out, int len) {
        if (out == null) {
            return new int[len];
        }
        return out;
    }

    public static long[] allocIfNull(long[] out, int len) {
        if (out == null) {
            return new long[len];
        }
        return out;
    }

    public static float[] allocIfNull(float[] out, int len) {
        if (out == null) {
            return new float[len];
        }
        return out;
    }

    public static double[] allocIfNull(double[] out, int len) {
        if (out == null) {
            return new double[len];
        }
        return out;
    }

    public static Object copyOf(Object array) {
        switch (ArrayUtil.getDataType(array)) {
            case BYTE: {
                return Arrays.copyOf((byte[])array, ((byte[])array).length);
            }
            case SHORT: {
                return Arrays.copyOf((short[])array, ((short[])array).length);
            }
            case INT: {
                return Arrays.copyOf((int[])array, ((int[])array).length);
            }
            case LONG: {
                return Arrays.copyOf((long[])array, ((long[])array).length);
            }
            case FLOAT: {
                return Arrays.copyOf((float[])array, ((float[])array).length);
            }
            case DOUBLE: {
                return Arrays.copyOf((double[])array, ((double[])array).length);
            }
        }
        return null;
    }

    public static double getValue(Object array, int offset, boolean signed) {
        return Array1DUtil.getValue(array, offset, ArrayUtil.getDataType(array, signed));
    }

    public static double getValue(Object array, int offset, DataType dataType) {
        switch (dataType) {
            case BYTE: {
                return Array1DUtil.getValue((byte[])array, offset, true);
            }
            case UBYTE: {
                return Array1DUtil.getValue((byte[])array, offset, false);
            }
            case SHORT: {
                return Array1DUtil.getValue((short[])array, offset, true);
            }
            case USHORT: {
                return Array1DUtil.getValue((short[])array, offset, false);
            }
            case INT: {
                return Array1DUtil.getValue((int[])array, offset, true);
            }
            case UINT: {
                return Array1DUtil.getValue((int[])array, offset, false);
            }
            case LONG: {
                return Array1DUtil.getValue((long[])array, offset, true);
            }
            case ULONG: {
                return Array1DUtil.getValue((long[])array, offset, false);
            }
            case FLOAT: {
                return Array1DUtil.getValue((float[])array, offset);
            }
            case DOUBLE: {
                return Array1DUtil.getValue((double[])array, offset);
            }
        }
        return 0.0;
    }

    @Deprecated
    public static double getValue(Object array, int offset, int dataType, boolean signed) {
        return Array1DUtil.getValue(array, offset, DataType.getDataType(dataType, signed));
    }

    public static float getValueAsFloat(Object array, int offset, boolean signed) {
        return Array1DUtil.getValueAsFloat(array, offset, ArrayUtil.getDataType(array, signed));
    }

    public static float getValueAsFloat(Object array, int offset, DataType dataType) {
        switch (dataType) {
            case BYTE: {
                return Array1DUtil.getValueAsFloat((byte[])array, offset, true);
            }
            case UBYTE: {
                return Array1DUtil.getValueAsFloat((byte[])array, offset, false);
            }
            case SHORT: {
                return Array1DUtil.getValueAsFloat((short[])array, offset, true);
            }
            case USHORT: {
                return Array1DUtil.getValueAsFloat((short[])array, offset, false);
            }
            case INT: {
                return Array1DUtil.getValueAsFloat((int[])array, offset, true);
            }
            case UINT: {
                return Array1DUtil.getValueAsFloat((int[])array, offset, false);
            }
            case LONG: {
                return Array1DUtil.getValueAsFloat((long[])array, offset, true);
            }
            case ULONG: {
                return Array1DUtil.getValueAsFloat((long[])array, offset, false);
            }
            case FLOAT: {
                return Array1DUtil.getValueAsFloat((float[])array, offset);
            }
            case DOUBLE: {
                return Array1DUtil.getValueAsFloat((double[])array, offset);
            }
        }
        return 0.0f;
    }

    @Deprecated
    public static float getValueAsFloat(Object array, int offset, int dataType, boolean signed) {
        return Array1DUtil.getValueAsFloat(array, offset, DataType.getDataType(dataType, signed));
    }

    public static int getValueAsInt(Object array, int offset, boolean signed) {
        return Array1DUtil.getValueAsInt(array, offset, ArrayUtil.getDataType(array, signed));
    }

    public static int getValueAsInt(Object array, int offset, DataType dataType) {
        switch (dataType) {
            case BYTE: {
                return Array1DUtil.getValueAsInt((byte[])array, offset, true);
            }
            case UBYTE: {
                return Array1DUtil.getValueAsInt((byte[])array, offset, false);
            }
            case SHORT: {
                return Array1DUtil.getValueAsInt((short[])array, offset, true);
            }
            case USHORT: {
                return Array1DUtil.getValueAsInt((short[])array, offset, false);
            }
            case UINT: 
            case INT: {
                return Array1DUtil.getValueAsInt((int[])array, offset);
            }
            case ULONG: 
            case LONG: {
                return Array1DUtil.getValueAsInt((long[])array, offset);
            }
            case FLOAT: {
                return Array1DUtil.getValueAsInt((float[])array, offset);
            }
            case DOUBLE: {
                return Array1DUtil.getValueAsInt((double[])array, offset);
            }
        }
        return 0;
    }

    @Deprecated
    public static int getValueAsInt(Object array, int offset, int dataType, boolean signed) {
        return Array1DUtil.getValueAsInt(array, offset, DataType.getDataType(dataType, signed));
    }

    public static long getValueAsLong(Object array, int offset, boolean signed) {
        return Array1DUtil.getValueAsLong(array, offset, ArrayUtil.getDataType(array, signed));
    }

    public static long getValueAsLong(Object array, int offset, DataType dataType) {
        switch (dataType) {
            case BYTE: {
                return Array1DUtil.getValueAsLong((byte[])array, offset, true);
            }
            case UBYTE: {
                return Array1DUtil.getValueAsLong((byte[])array, offset, false);
            }
            case SHORT: {
                return Array1DUtil.getValueAsLong((short[])array, offset, true);
            }
            case USHORT: {
                return Array1DUtil.getValueAsLong((short[])array, offset, false);
            }
            case INT: {
                return Array1DUtil.getValueAsLong((int[])array, offset, true);
            }
            case UINT: {
                return Array1DUtil.getValueAsLong((int[])array, offset, false);
            }
            case ULONG: 
            case LONG: {
                return Array1DUtil.getValueAsLong((long[])array, offset);
            }
            case FLOAT: {
                return Array1DUtil.getValueAsLong((float[])array, offset);
            }
            case DOUBLE: {
                return Array1DUtil.getValueAsLong((double[])array, offset);
            }
        }
        return 0L;
    }

    @Deprecated
    public static long getValueAsLong(Object array, int offset, int dataType, boolean signed) {
        return Array1DUtil.getValueAsLong(array, offset, DataType.getDataType(dataType, signed));
    }

    public static void setValue(Object array, int offset, double value) {
        Array1DUtil.setValue(array, offset, ArrayUtil.getDataType(array), value);
    }

    public static void setValue(Object array, int offset, DataType dataType, double value) {
        switch (dataType.getJavaType()) {
            case BYTE: {
                Array1DUtil.setValue((byte[])array, offset, value);
                break;
            }
            case SHORT: {
                Array1DUtil.setValue((short[])array, offset, value);
                break;
            }
            case INT: {
                Array1DUtil.setValue((int[])array, offset, value);
                break;
            }
            case LONG: {
                Array1DUtil.setValue((long[])array, offset, value);
                break;
            }
            case FLOAT: {
                Array1DUtil.setValue((float[])array, offset, value);
                break;
            }
            case DOUBLE: {
                Array1DUtil.setValue((double[])array, offset, value);
            }
        }
    }

    @Deprecated
    public static void setValue(Object array, int offset, int dataType, double value) {
        Array1DUtil.setValue(array, offset, DataType.getDataType(dataType), value);
    }

    public static double getValue(byte[] array, int offset, boolean signed) {
        return TypeUtil.toDouble(array[offset], signed);
    }

    public static double getValue(short[] array, int offset, boolean signed) {
        return TypeUtil.toDouble(array[offset], signed);
    }

    public static double getValue(int[] array, int offset, boolean signed) {
        return TypeUtil.toDouble(array[offset], signed);
    }

    public static double getValue(long[] array, int offset, boolean signed) {
        return TypeUtil.toDouble(array[offset], signed);
    }

    public static double getValue(float[] array, int offset) {
        return array[offset];
    }

    public static double getValue(double[] array, int offset) {
        return array[offset];
    }

    public static float getValueAsFloat(byte[] array, int offset, boolean signed) {
        return TypeUtil.toFloat(array[offset], signed);
    }

    public static float getValueAsFloat(short[] array, int offset, boolean signed) {
        return TypeUtil.toFloat(array[offset], signed);
    }

    public static float getValueAsFloat(int[] array, int offset, boolean signed) {
        return TypeUtil.toFloat(array[offset], signed);
    }

    public static float getValueAsFloat(long[] array, int offset, boolean signed) {
        return TypeUtil.toFloat(array[offset], signed);
    }

    public static float getValueAsFloat(float[] array, int offset) {
        return array[offset];
    }

    public static float getValueAsFloat(double[] array, int offset) {
        return (float)array[offset];
    }

    public static int getValueAsInt(byte[] array, int offset, boolean signed) {
        return TypeUtil.toInt(array[offset], signed);
    }

    public static int getValueAsInt(short[] array, int offset, boolean signed) {
        return TypeUtil.toInt(array[offset], signed);
    }

    public static int getValueAsInt(int[] array, int offset) {
        return array[offset];
    }

    public static int getValueAsInt(long[] array, int offset) {
        return (int)array[offset];
    }

    public static int getValueAsInt(float[] array, int offset) {
        return (int)array[offset];
    }

    public static int getValueAsInt(double[] array, int offset) {
        return (int)array[offset];
    }

    public static long getValueAsLong(byte[] array, int offset, boolean signed) {
        return TypeUtil.toLong(array[offset], signed);
    }

    public static long getValueAsLong(short[] array, int offset, boolean signed) {
        return TypeUtil.toLong(array[offset], signed);
    }

    public static long getValueAsLong(int[] array, int offset, boolean signed) {
        return TypeUtil.toLong(array[offset], signed);
    }

    public static long getValueAsLong(long[] array, int offset) {
        return array[offset];
    }

    public static long getValueAsLong(float[] array, int offset) {
        return (long)array[offset];
    }

    public static long getValueAsLong(double[] array, int offset) {
        return (long)array[offset];
    }

    public static void setValue(byte[] array, int offset, double value) {
        array[offset] = (byte)value;
    }

    public static void setValue(short[] array, int offset, double value) {
        array[offset] = (short)value;
    }

    public static void setValue(int[] array, int offset, double value) {
        array[offset] = (int)value;
    }

    public static void setValue(long[] array, int offset, double value) {
        array[offset] = (long)value;
    }

    public static void setValue(float[] array, int offset, double value) {
        array[offset] = (float)value;
    }

    public static void setValue(double[] array, int offset, double value) {
        array[offset] = value;
    }

    public static boolean arrayByteCompare(byte[] array1, byte[] array2) {
        return Arrays.equals(array1, array2);
    }

    public static boolean arrayShortCompare(short[] array1, short[] array2) {
        return Arrays.equals(array1, array2);
    }

    public static boolean arrayIntCompare(int[] array1, int[] array2) {
        return Arrays.equals(array1, array2);
    }

    public static boolean arrayLongCompare(long[] array1, long[] array2) {
        return Arrays.equals(array1, array2);
    }

    public static boolean arrayFloatCompare(float[] array1, float[] array2) {
        return Arrays.equals(array1, array2);
    }

    public static boolean arrayDoubleCompare(double[] array1, double[] array2) {
        return Arrays.equals(array1, array2);
    }

    public static void copyRect(Object src, Dimension srcDim, Rectangle srcRegion, Object dst, Dimension dstDim, Point dstPt, boolean signed) {
        Rectangle adjSrcRegion;
        if (src == null || srcDim == null || dst == null || dstDim == null) {
            return;
        }
        Rectangle rectangle = adjSrcRegion = srcRegion != null ? srcRegion : new Rectangle(srcDim);
        if (dstPt != null && dstPt.x < 0) {
            adjSrcRegion.x += -dstPt.x;
            adjSrcRegion.width -= -dstPt.x;
        }
        if (dstPt != null && dstPt.y < 0) {
            adjSrcRegion.y += -dstPt.y;
            adjSrcRegion.height -= -dstPt.y;
        }
        adjSrcRegion = adjSrcRegion.intersection(new Rectangle(srcDim));
        Rectangle adjDstRegion = new Rectangle(dstPt != null ? dstPt : new Point(), adjSrcRegion.getSize());
        adjDstRegion = adjDstRegion.intersection(new Rectangle(dstDim));
        int w = Math.min(adjSrcRegion.width, adjDstRegion.width);
        int h = Math.min(adjSrcRegion.height, adjDstRegion.height);
        if (w <= 0 || h <= 0) {
            return;
        }
        int srcSizeX = srcDim.width;
        int dstSizeX = dstDim.width;
        int srcOffset = adjSrcRegion.x + adjSrcRegion.y * srcSizeX;
        int dstOffset = adjDstRegion.x + adjDstRegion.y * dstSizeX;
        int y = 0;
        while (y < h) {
            Array1DUtil.arrayToArray(src, srcOffset, dst, dstOffset, w, signed);
            srcOffset += srcSizeX;
            dstOffset += dstSizeX;
            ++y;
        }
    }

    public static void fill(Object array, double value) {
        Array1DUtil.fill(array, 0, ArrayUtil.getLength(array), value);
    }

    public static void fill(Object array, int from, int to, double value) {
        switch (ArrayUtil.getDataType(array)) {
            case BYTE: {
                Array1DUtil.fill((byte[])array, from, to, (byte)value);
                break;
            }
            case SHORT: {
                Array1DUtil.fill((short[])array, from, to, (short)value);
                break;
            }
            case INT: {
                Array1DUtil.fill((int[])array, from, to, (int)value);
                break;
            }
            case LONG: {
                Array1DUtil.fill((long[])array, from, to, (long)value);
                break;
            }
            case FLOAT: {
                Array1DUtil.fill((float[])array, from, to, (float)value);
                break;
            }
            case DOUBLE: {
                Array1DUtil.fill((double[])array, from, to, value);
            }
        }
    }

    public static void fill(byte[] array, int from, int to, byte value) {
        int i = from;
        while (i < to) {
            array[i] = value;
            ++i;
        }
    }

    public static void fill(short[] array, int from, int to, short value) {
        int i = from;
        while (i < to) {
            array[i] = value;
            ++i;
        }
    }

    public static void fill(int[] array, int from, int to, int value) {
        int i = from;
        while (i < to) {
            array[i] = value;
            ++i;
        }
    }

    public static void fill(long[] array, int from, int to, long value) {
        int i = from;
        while (i < to) {
            array[i] = value;
            ++i;
        }
    }

    public static void fill(float[] array, int from, int to, float value) {
        int i = from;
        while (i < to) {
            array[i] = value;
            ++i;
        }
    }

    public static void fill(double[] array, int from, int to, double value) {
        int i = from;
        while (i < to) {
            array[i] = value;
            ++i;
        }
    }

    public static void innerCopy(Object array, int from, int to, int cnt) {
        if (array == null) {
            return;
        }
        switch (ArrayUtil.getDataType(array)) {
            case BYTE: {
                Array1DUtil.innerCopy((byte[])array, from, to, cnt);
                return;
            }
            case SHORT: {
                Array1DUtil.innerCopy((short[])array, from, to, cnt);
                return;
            }
            case INT: {
                Array1DUtil.innerCopy((int[])array, from, to, cnt);
                return;
            }
            case LONG: {
                Array1DUtil.innerCopy((long[])array, from, to, cnt);
                return;
            }
            case FLOAT: {
                Array1DUtil.innerCopy((float[])array, from, to, cnt);
                return;
            }
            case DOUBLE: {
                Array1DUtil.innerCopy((double[])array, from, to, cnt);
                return;
            }
        }
        int delta = to - from;
        if (delta == 0) {
            return;
        }
        int length = Array.getLength(array);
        if (from < 0 || to < 0 || from >= length || to >= length) {
            return;
        }
        if (delta < 0) {
            int adjCnt = from + cnt >= length ? length - from : cnt;
            int to_ = to;
            int from_ = from;
            int i = 0;
            while (i < adjCnt) {
                Array.set(array, to_++, Array.get(array, from_++));
                ++i;
            }
        } else {
            int adjCnt = to + cnt >= length ? length - to : cnt;
            int to_ = to + cnt;
            int from_ = from + cnt;
            int i = 0;
            while (i < adjCnt) {
                Array.set(array, --to_, Array.get(array, --from_));
                ++i;
            }
        }
    }

    public static void innerCopy(byte[] array, int from, int to, int cnt) {
        int delta = to - from;
        if (array == null || delta == 0) {
            return;
        }
        int length = array.length;
        if (from < 0 || to < 0 || from >= length || to >= length) {
            return;
        }
        if (delta < 0) {
            int adjCnt = from + cnt >= length ? length - from : cnt;
            int to_ = to;
            int from_ = from;
            int i = 0;
            while (i < adjCnt) {
                array[to_++] = array[from_++];
                ++i;
            }
        } else {
            int adjCnt = to + cnt >= length ? length - to : cnt;
            int to_ = to + cnt;
            int from_ = from + cnt;
            int i = 0;
            while (i < adjCnt) {
                array[--to_] = array[--from_];
                ++i;
            }
        }
    }

    public static void innerCopy(short[] array, int from, int to, int cnt) {
        int delta = to - from;
        if (array == null || delta == 0) {
            return;
        }
        int length = array.length;
        if (from < 0 || to < 0 || from >= length || to >= length) {
            return;
        }
        if (delta < 0) {
            int adjCnt = from + cnt >= length ? length - from : cnt;
            int to_ = to;
            int from_ = from;
            int i = 0;
            while (i < adjCnt) {
                array[to_++] = array[from_++];
                ++i;
            }
        } else {
            int adjCnt = to + cnt >= length ? length - to : cnt;
            int to_ = to + cnt;
            int from_ = from + cnt;
            int i = 0;
            while (i < adjCnt) {
                array[--to_] = array[--from_];
                ++i;
            }
        }
    }

    public static void innerCopy(int[] array, int from, int to, int cnt) {
        int delta = to - from;
        if (array == null || delta == 0) {
            return;
        }
        int length = array.length;
        if (from < 0 || to < 0 || from >= length || to >= length) {
            return;
        }
        if (delta < 0) {
            int adjCnt = from + cnt >= length ? length - from : cnt;
            int to_ = to;
            int from_ = from;
            int i = 0;
            while (i < adjCnt) {
                array[to_++] = array[from_++];
                ++i;
            }
        } else {
            int adjCnt = to + cnt >= length ? length - to : cnt;
            int to_ = to + cnt;
            int from_ = from + cnt;
            int i = 0;
            while (i < adjCnt) {
                array[--to_] = array[--from_];
                ++i;
            }
        }
    }

    public static void innerCopy(long[] array, int from, int to, int cnt) {
        int delta = to - from;
        if (array == null || delta == 0) {
            return;
        }
        int length = array.length;
        if (from < 0 || to < 0 || from >= length || to >= length) {
            return;
        }
        if (delta < 0) {
            int adjCnt = from + cnt >= length ? length - from : cnt;
            int to_ = to;
            int from_ = from;
            int i = 0;
            while (i < adjCnt) {
                array[to_++] = array[from_++];
                ++i;
            }
        } else {
            int adjCnt = to + cnt >= length ? length - to : cnt;
            int to_ = to + cnt;
            int from_ = from + cnt;
            int i = 0;
            while (i < adjCnt) {
                array[--to_] = array[--from_];
                ++i;
            }
        }
    }

    public static void innerCopy(float[] array, int from, int to, int cnt) {
        int delta = to - from;
        if (array == null || delta == 0) {
            return;
        }
        int length = array.length;
        if (from < 0 || to < 0 || from >= length || to >= length) {
            return;
        }
        if (delta < 0) {
            int adjCnt = from + cnt >= length ? length - from : cnt;
            int to_ = to;
            int from_ = from;
            int i = 0;
            while (i < adjCnt) {
                array[to_++] = array[from_++];
                ++i;
            }
        } else {
            int adjCnt = to + cnt >= length ? length - to : cnt;
            int to_ = to + cnt;
            int from_ = from + cnt;
            int i = 0;
            while (i < adjCnt) {
                array[--to_] = array[--from_];
                ++i;
            }
        }
    }

    public static void innerCopy(double[] array, int from, int to, int cnt) {
        int delta = to - from;
        if (array == null || delta == 0) {
            return;
        }
        int length = array.length;
        if (from < 0 || to < 0 || from >= length || to >= length) {
            return;
        }
        if (delta < 0) {
            int adjCnt = from + cnt >= length ? length - from : cnt;
            int to_ = to;
            int from_ = from;
            int i = 0;
            while (i < adjCnt) {
                array[to_++] = array[from_++];
                ++i;
            }
        } else {
            int adjCnt = to + cnt >= length ? length - to : cnt;
            int to_ = to + cnt;
            int from_ = from + cnt;
            int i = 0;
            while (i < adjCnt) {
                array[--to_] = array[--from_];
                ++i;
            }
        }
    }

    public static byte[] toByteArray1D(byte[] in, byte[] out, int offset) {
        int len = Array1DUtil.getTotalLength(in);
        byte[] result = Array1DUtil.allocIfNull(out, offset + len);
        if (in != null) {
            System.arraycopy(in, 0, result, offset, len);
        }
        return result;
    }

    public static short[] toShortArray1D(short[] in, short[] out, int offset) {
        int len = Array1DUtil.getTotalLength(in);
        short[] result = Array1DUtil.allocIfNull(out, offset + len);
        if (in != null) {
            System.arraycopy(in, 0, result, offset, len);
        }
        return result;
    }

    public static int[] toIntArray1D(int[] in, int[] out, int offset) {
        int len = Array1DUtil.getTotalLength(in);
        int[] result = Array1DUtil.allocIfNull(out, offset + len);
        if (in != null) {
            System.arraycopy(in, 0, result, offset, len);
        }
        return result;
    }

    public static long[] toLongArray1D(long[] in, long[] out, int offset) {
        int len = Array1DUtil.getTotalLength(in);
        long[] result = Array1DUtil.allocIfNull(out, offset + len);
        if (in != null) {
            System.arraycopy(in, 0, result, offset, len);
        }
        return result;
    }

    public static float[] toFloatArray1D(float[] in, float[] out, int offset) {
        int len = Array1DUtil.getTotalLength(in);
        float[] result = Array1DUtil.allocIfNull(out, offset + len);
        if (in != null) {
            System.arraycopy(in, 0, result, offset, len);
        }
        return result;
    }

    public static double[] toDoubleArray1D(double[] in, double[] out, int offset) {
        int len = Array1DUtil.getTotalLength(in);
        double[] result = Array1DUtil.allocIfNull(out, offset + len);
        if (in != null) {
            System.arraycopy(in, 0, result, offset, len);
        }
        return result;
    }

    public static Object arrayToArray(Object in, int inOffset, Object out, int outOffset, int length, boolean signed) {
        switch (ArrayUtil.getDataType(in)) {
            case BYTE: {
                return Array1DUtil.byteArrayToArray((byte[])in, inOffset, out, outOffset, length, signed);
            }
            case SHORT: {
                return Array1DUtil.shortArrayToArray((short[])in, inOffset, out, outOffset, length, signed);
            }
            case INT: {
                return Array1DUtil.intArrayToArray((int[])in, inOffset, out, outOffset, length, signed);
            }
            case LONG: {
                return Array1DUtil.longArrayToArray((long[])in, inOffset, out, outOffset, length, signed);
            }
            case FLOAT: {
                return Array1DUtil.floatArrayToArray((float[])in, inOffset, out, outOffset, length);
            }
            case DOUBLE: {
                return Array1DUtil.doubleArrayToArray((double[])in, inOffset, out, outOffset, length);
            }
        }
        return out;
    }

    public static Object arrayToArray(Object in, Object out, boolean signed) {
        return Array1DUtil.arrayToArray(in, 0, out, 0, -1, signed);
    }

    public static Object doubleArrayToArray(double[] in, int inOffset, Object out, int outOffset, int length) {
        switch (ArrayUtil.getDataType(out)) {
            case BYTE: {
                return Array1DUtil.doubleArrayToByteArray(in, inOffset, (byte[])out, outOffset, length);
            }
            case SHORT: {
                return Array1DUtil.doubleArrayToShortArray(in, inOffset, (short[])out, outOffset, length);
            }
            case INT: {
                return Array1DUtil.doubleArrayToIntArray(in, inOffset, (int[])out, outOffset, length);
            }
            case LONG: {
                return Array1DUtil.doubleArrayToLongArray(in, inOffset, (long[])out, outOffset, length);
            }
            case FLOAT: {
                return Array1DUtil.doubleArrayToFloatArray(in, inOffset, (float[])out, outOffset, length);
            }
            case DOUBLE: {
                return Array1DUtil.doubleArrayToDoubleArray(in, inOffset, (double[])out, outOffset, length);
            }
        }
        return out;
    }

    public static Object doubleArrayToArray(double[] in, Object out) {
        return Array1DUtil.doubleArrayToArray(in, 0, out, 0, -1);
    }

    public static Object floatArrayToArray(float[] in, int inOffset, Object out, int outOffset, int length) {
        switch (ArrayUtil.getDataType(out)) {
            case BYTE: {
                return Array1DUtil.floatArrayToByteArray(in, inOffset, (byte[])out, outOffset, length);
            }
            case SHORT: {
                return Array1DUtil.floatArrayToShortArray(in, inOffset, (short[])out, outOffset, length);
            }
            case INT: {
                return Array1DUtil.floatArrayToIntArray(in, inOffset, (int[])out, outOffset, length);
            }
            case LONG: {
                return Array1DUtil.floatArrayToLongArray(in, inOffset, (long[])out, outOffset, length);
            }
            case FLOAT: {
                return Array1DUtil.floatArrayToFloatArray(in, inOffset, (float[])out, outOffset, length);
            }
            case DOUBLE: {
                return Array1DUtil.floatArrayToDoubleArray(in, inOffset, (double[])out, outOffset, length);
            }
        }
        return out;
    }

    public static Object floatArrayToArray(float[] in, Object out) {
        return Array1DUtil.floatArrayToArray(in, 0, out, 0, -1);
    }

    public static Object longArrayToArray(long[] in, int inOffset, Object out, int outOffset, int length, boolean signed) {
        switch (ArrayUtil.getDataType(out)) {
            case BYTE: {
                return Array1DUtil.longArrayToByteArray(in, inOffset, (byte[])out, outOffset, length);
            }
            case SHORT: {
                return Array1DUtil.longArrayToShortArray(in, inOffset, (short[])out, outOffset, length);
            }
            case INT: {
                return Array1DUtil.longArrayToIntArray(in, inOffset, (int[])out, outOffset, length);
            }
            case LONG: {
                return Array1DUtil.longArrayToLongArray(in, inOffset, (long[])out, outOffset, length);
            }
            case FLOAT: {
                return Array1DUtil.longArrayToFloatArray(in, inOffset, (float[])out, outOffset, length, signed);
            }
            case DOUBLE: {
                return Array1DUtil.longArrayToDoubleArray(in, inOffset, (double[])out, outOffset, length, signed);
            }
        }
        return out;
    }

    public static Object longArrayToArray(long[] in, Object out, boolean signed) {
        return Array1DUtil.longArrayToArray(in, 0, out, 0, -1, signed);
    }

    public static Object intArrayToArray(int[] in, int inOffset, Object out, int outOffset, int length, boolean signed) {
        switch (ArrayUtil.getDataType(out)) {
            case BYTE: {
                return Array1DUtil.intArrayToByteArray(in, inOffset, (byte[])out, outOffset, length);
            }
            case SHORT: {
                return Array1DUtil.intArrayToShortArray(in, inOffset, (short[])out, outOffset, length);
            }
            case INT: {
                return Array1DUtil.intArrayToIntArray(in, inOffset, (int[])out, outOffset, length);
            }
            case LONG: {
                return Array1DUtil.intArrayToLongArray(in, inOffset, (long[])out, outOffset, length, signed);
            }
            case FLOAT: {
                return Array1DUtil.intArrayToFloatArray(in, inOffset, (float[])out, outOffset, length, signed);
            }
            case DOUBLE: {
                return Array1DUtil.intArrayToDoubleArray(in, inOffset, (double[])out, outOffset, length, signed);
            }
        }
        return out;
    }

    public static Object intArrayToArray(int[] in, Object out, boolean signed) {
        return Array1DUtil.intArrayToArray(in, 0, out, 0, -1, signed);
    }

    public static Object shortArrayToArray(short[] in, int inOffset, Object out, int outOffset, int length, boolean signed) {
        switch (ArrayUtil.getDataType(out)) {
            case BYTE: {
                return Array1DUtil.shortArrayToByteArray(in, inOffset, (byte[])out, outOffset, length);
            }
            case SHORT: {
                return Array1DUtil.shortArrayToShortArray(in, inOffset, (short[])out, outOffset, length);
            }
            case INT: {
                return Array1DUtil.shortArrayToIntArray(in, inOffset, (int[])out, outOffset, length, signed);
            }
            case LONG: {
                return Array1DUtil.shortArrayToLongArray(in, inOffset, (long[])out, outOffset, length, signed);
            }
            case FLOAT: {
                return Array1DUtil.shortArrayToFloatArray(in, inOffset, (float[])out, outOffset, length, signed);
            }
            case DOUBLE: {
                return Array1DUtil.shortArrayToDoubleArray(in, inOffset, (double[])out, outOffset, length, signed);
            }
        }
        return out;
    }

    public static Object shortArrayToArray(short[] in, Object out, boolean signed) {
        return Array1DUtil.shortArrayToArray(in, 0, out, 0, -1, signed);
    }

    public static Object byteArrayToArray(byte[] in, int inOffset, Object out, int outOffset, int length, boolean signed) {
        switch (ArrayUtil.getDataType(out)) {
            case BYTE: {
                return Array1DUtil.byteArrayToByteArray(in, inOffset, (byte[])out, outOffset, length);
            }
            case SHORT: {
                return Array1DUtil.byteArrayToShortArray(in, inOffset, (short[])out, outOffset, length, signed);
            }
            case INT: {
                return Array1DUtil.byteArrayToIntArray(in, inOffset, (int[])out, outOffset, length, signed);
            }
            case LONG: {
                return Array1DUtil.byteArrayToLongArray(in, inOffset, (long[])out, outOffset, length, signed);
            }
            case FLOAT: {
                return Array1DUtil.byteArrayToFloatArray(in, inOffset, (float[])out, outOffset, length, signed);
            }
            case DOUBLE: {
                return Array1DUtil.byteArrayToDoubleArray(in, inOffset, (double[])out, outOffset, length, signed);
            }
        }
        return out;
    }

    public static Object byteArrayToArray(byte[] in, Object out, boolean signed) {
        return Array1DUtil.byteArrayToArray(in, 0, out, 0, -1, signed);
    }

    public static double[] arrayToDoubleArray(Object in, int inOffset, double[] out, int outOffset, int length, boolean signed) {
        switch (ArrayUtil.getDataType(in)) {
            case BYTE: {
                return Array1DUtil.byteArrayToDoubleArray((byte[])in, inOffset, out, outOffset, length, signed);
            }
            case SHORT: {
                return Array1DUtil.shortArrayToDoubleArray((short[])in, inOffset, out, outOffset, length, signed);
            }
            case INT: {
                return Array1DUtil.intArrayToDoubleArray((int[])in, inOffset, out, outOffset, length, signed);
            }
            case LONG: {
                return Array1DUtil.longArrayToDoubleArray((long[])in, inOffset, out, outOffset, length, signed);
            }
            case FLOAT: {
                return Array1DUtil.floatArrayToDoubleArray((float[])in, inOffset, out, outOffset, length);
            }
            case DOUBLE: {
                return Array1DUtil.doubleArrayToDoubleArray((double[])in, inOffset, out, outOffset, length);
            }
        }
        return out;
    }

    public static double[] arrayToDoubleArray(Object in, double[] out, boolean signed) {
        return Array1DUtil.arrayToDoubleArray(in, 0, out, 0, -1, signed);
    }

    public static double[] arrayToDoubleArray(Object in, boolean signed) {
        return Array1DUtil.arrayToDoubleArray(in, 0, null, 0, -1, signed);
    }

    public static float[] arrayToFloatArray(Object in, int inOffset, float[] out, int outOffset, int length, boolean signed) {
        switch (ArrayUtil.getDataType(in)) {
            case BYTE: {
                return Array1DUtil.byteArrayToFloatArray((byte[])in, inOffset, out, outOffset, length, signed);
            }
            case SHORT: {
                return Array1DUtil.shortArrayToFloatArray((short[])in, inOffset, out, outOffset, length, signed);
            }
            case INT: {
                return Array1DUtil.intArrayToFloatArray((int[])in, inOffset, out, outOffset, length, signed);
            }
            case LONG: {
                return Array1DUtil.longArrayToFloatArray((long[])in, inOffset, out, outOffset, length, signed);
            }
            case FLOAT: {
                return Array1DUtil.floatArrayToFloatArray((float[])in, inOffset, out, outOffset, length);
            }
            case DOUBLE: {
                return Array1DUtil.doubleArrayToFloatArray((double[])in, inOffset, out, outOffset, length);
            }
        }
        return out;
    }

    public static float[] arrayToFloatArray(Object in, float[] out, boolean signed) {
        return Array1DUtil.arrayToFloatArray(in, 0, out, 0, -1, signed);
    }

    public static float[] arrayToFloatArray(Object in, boolean signed) {
        return Array1DUtil.arrayToFloatArray(in, 0, null, 0, -1, signed);
    }

    public static int[] arrayToIntArray(Object in, int inOffset, int[] out, int outOffset, int length, boolean signed) {
        switch (ArrayUtil.getDataType(in)) {
            case BYTE: {
                return Array1DUtil.byteArrayToIntArray((byte[])in, inOffset, out, outOffset, length, signed);
            }
            case SHORT: {
                return Array1DUtil.shortArrayToIntArray((short[])in, inOffset, out, outOffset, length, signed);
            }
            case INT: {
                return Array1DUtil.intArrayToIntArray((int[])in, inOffset, out, outOffset, length);
            }
            case LONG: {
                return Array1DUtil.longArrayToIntArray((long[])in, inOffset, out, outOffset, length);
            }
            case FLOAT: {
                return Array1DUtil.floatArrayToIntArray((float[])in, inOffset, out, outOffset, length);
            }
            case DOUBLE: {
                return Array1DUtil.doubleArrayToIntArray((double[])in, inOffset, out, outOffset, length);
            }
        }
        return out;
    }

    public static int[] arrayToIntArray(Object in, int[] out, boolean signed) {
        return Array1DUtil.arrayToIntArray(in, 0, out, 0, -1, signed);
    }

    public static int[] arrayToIntArray(Object in, boolean signed) {
        return Array1DUtil.arrayToIntArray(in, 0, null, 0, -1, signed);
    }

    public static short[] arrayToShortArray(Object in, int inOffset, short[] out, int outOffset, int length, boolean signed) {
        switch (ArrayUtil.getDataType(in)) {
            case BYTE: {
                return Array1DUtil.byteArrayToShortArray((byte[])in, inOffset, out, outOffset, length, signed);
            }
            case SHORT: {
                return Array1DUtil.shortArrayToShortArray((short[])in, inOffset, out, outOffset, length);
            }
            case INT: {
                return Array1DUtil.intArrayToShortArray((int[])in, inOffset, out, outOffset, length);
            }
            case LONG: {
                return Array1DUtil.longArrayToShortArray((long[])in, inOffset, out, outOffset, length);
            }
            case FLOAT: {
                return Array1DUtil.floatArrayToShortArray((float[])in, inOffset, out, outOffset, length);
            }
            case DOUBLE: {
                return Array1DUtil.doubleArrayToShortArray((double[])in, inOffset, out, outOffset, length);
            }
        }
        return out;
    }

    public static short[] arrayToShortArray(Object in, short[] out, boolean signed) {
        return Array1DUtil.arrayToShortArray(in, 0, out, 0, -1, signed);
    }

    public static short[] arrayToShortArray(Object in, boolean signed) {
        return Array1DUtil.arrayToShortArray(in, 0, null, 0, -1, signed);
    }

    public static byte[] arrayToByteArray(Object in, int inOffset, byte[] out, int outOffset, int length) {
        switch (ArrayUtil.getDataType(in)) {
            case BYTE: {
                return Array1DUtil.byteArrayToByteArray((byte[])in, inOffset, out, outOffset, length);
            }
            case SHORT: {
                return Array1DUtil.shortArrayToByteArray((short[])in, inOffset, out, outOffset, length);
            }
            case INT: {
                return Array1DUtil.intArrayToByteArray((int[])in, inOffset, out, outOffset, length);
            }
            case LONG: {
                return Array1DUtil.longArrayToByteArray((long[])in, inOffset, out, outOffset, length);
            }
            case FLOAT: {
                return Array1DUtil.floatArrayToByteArray((float[])in, inOffset, out, outOffset, length);
            }
            case DOUBLE: {
                return Array1DUtil.doubleArrayToByteArray((double[])in, inOffset, out, outOffset, length);
            }
        }
        return out;
    }

    public static byte[] arrayToByteArray(Object in, byte[] out) {
        return Array1DUtil.arrayToByteArray(in, 0, out, 0, -1);
    }

    public static byte[] arrayToByteArray(Object in) {
        return Array1DUtil.arrayToByteArray(in, 0, null, 0, -1);
    }

    public static double[] doubleArrayToDoubleArray(double[] in, int inOffset, double[] out, int outOffset, int length) {
        int len = ArrayUtil.getCopyLength(in, inOffset, out, outOffset, length);
        double[] result = Array1DUtil.allocIfNull(out, outOffset + len);
        System.arraycopy(in, inOffset, result, outOffset, len);
        return result;
    }

    public static float[] doubleArrayToFloatArray(double[] in, int inOffset, float[] out, int outOffset, int length) {
        int len = ArrayUtil.getCopyLength(in, inOffset, out, outOffset, length);
        float[] result = Array1DUtil.allocIfNull(out, outOffset + len);
        int i = 0;
        while (i < len) {
            result[i + outOffset] = (float)in[i + inOffset];
            ++i;
        }
        return result;
    }

    public static long[] doubleArrayToLongArray(double[] in, int inOffset, long[] out, int outOffset, int length) {
        int len = ArrayUtil.getCopyLength(in, inOffset, out, outOffset, length);
        long[] result = Array1DUtil.allocIfNull(out, outOffset + len);
        int i = 0;
        while (i < len) {
            result[i + outOffset] = TypeUtil.toLong(in[i + inOffset]);
            ++i;
        }
        return result;
    }

    public static int[] doubleArrayToIntArray(double[] in, int inOffset, int[] out, int outOffset, int length) {
        int len = ArrayUtil.getCopyLength(in, inOffset, out, outOffset, length);
        int[] result = Array1DUtil.allocIfNull(out, outOffset + len);
        int i = 0;
        while (i < len) {
            result[i + outOffset] = TypeUtil.toInt(in[i + inOffset]);
            ++i;
        }
        return result;
    }

    public static short[] doubleArrayToShortArray(double[] in, int inOffset, short[] out, int outOffset, int length) {
        int len = ArrayUtil.getCopyLength(in, inOffset, out, outOffset, length);
        short[] result = Array1DUtil.allocIfNull(out, outOffset + len);
        int i = 0;
        while (i < len) {
            result[i + outOffset] = (short)in[i + inOffset];
            ++i;
        }
        return result;
    }

    public static byte[] doubleArrayToByteArray(double[] in, int inOffset, byte[] out, int outOffset, int length) {
        int len = ArrayUtil.getCopyLength(in, inOffset, out, outOffset, length);
        byte[] result = Array1DUtil.allocIfNull(out, outOffset + len);
        int i = 0;
        while (i < len) {
            result[i + outOffset] = (byte)in[i + inOffset];
            ++i;
        }
        return result;
    }

    public static double[] floatArrayToDoubleArray(float[] in, int inOffset, double[] out, int outOffset, int length) {
        int len = ArrayUtil.getCopyLength(in, inOffset, out, outOffset, length);
        double[] result = Array1DUtil.allocIfNull(out, outOffset + len);
        int i = 0;
        while (i < len) {
            result[i + outOffset] = in[i + inOffset];
            ++i;
        }
        return result;
    }

    public static float[] floatArrayToFloatArray(float[] in, int inOffset, float[] out, int outOffset, int length) {
        int len = ArrayUtil.getCopyLength(in, inOffset, out, outOffset, length);
        float[] result = Array1DUtil.allocIfNull(out, outOffset + len);
        System.arraycopy(in, inOffset, result, outOffset, len);
        return result;
    }

    public static long[] floatArrayToLongArray(float[] in, int inOffset, long[] out, int outOffset, int length) {
        int len = ArrayUtil.getCopyLength(in, inOffset, out, outOffset, length);
        long[] result = Array1DUtil.allocIfNull(out, outOffset + len);
        int i = 0;
        while (i < len) {
            result[i + outOffset] = TypeUtil.toLong(in[i + inOffset]);
            ++i;
        }
        return result;
    }

    public static int[] floatArrayToIntArray(float[] in, int inOffset, int[] out, int outOffset, int length) {
        int len = ArrayUtil.getCopyLength(in, inOffset, out, outOffset, length);
        int[] result = Array1DUtil.allocIfNull(out, outOffset + len);
        int i = 0;
        while (i < len) {
            result[i + outOffset] = TypeUtil.toInt(in[i + inOffset]);
            ++i;
        }
        return result;
    }

    public static short[] floatArrayToShortArray(float[] in, int inOffset, short[] out, int outOffset, int length) {
        int len = ArrayUtil.getCopyLength(in, inOffset, out, outOffset, length);
        short[] result = Array1DUtil.allocIfNull(out, outOffset + len);
        int i = 0;
        while (i < len) {
            result[i + outOffset] = (short)in[i + inOffset];
            ++i;
        }
        return result;
    }

    public static byte[] floatArrayToByteArray(float[] in, int inOffset, byte[] out, int outOffset, int length) {
        int len = ArrayUtil.getCopyLength(in, inOffset, out, outOffset, length);
        byte[] result = Array1DUtil.allocIfNull(out, outOffset + len);
        int i = 0;
        while (i < len) {
            result[i + outOffset] = (byte)in[i + inOffset];
            ++i;
        }
        return result;
    }

    public static double[] longArrayToDoubleArray(long[] in, int inOffset, double[] out, int outOffset, int length, boolean signed) {
        int len = ArrayUtil.getCopyLength(in, inOffset, out, outOffset, length);
        double[] result = Array1DUtil.allocIfNull(out, outOffset + len);
        if (signed) {
            int i = 0;
            while (i < len) {
                result[i + outOffset] = in[i + inOffset];
                ++i;
            }
        } else {
            int i = 0;
            while (i < len) {
                result[i + outOffset] = TypeUtil.unsign(in[i + inOffset]);
                ++i;
            }
        }
        return result;
    }

    public static float[] longArrayToFloatArray(long[] in, int inOffset, float[] out, int outOffset, int length, boolean signed) {
        int len = ArrayUtil.getCopyLength(in, inOffset, out, outOffset, length);
        float[] result = Array1DUtil.allocIfNull(out, outOffset + len);
        if (signed) {
            int i = 0;
            while (i < len) {
                result[i + outOffset] = in[i + inOffset];
                ++i;
            }
        } else {
            int i = 0;
            while (i < len) {
                result[i + outOffset] = TypeUtil.unsignF(in[i + inOffset]);
                ++i;
            }
        }
        return result;
    }

    public static long[] longArrayToLongArray(long[] in, int inOffset, long[] out, int outOffset, int length) {
        int len = ArrayUtil.getCopyLength(in, inOffset, out, outOffset, length);
        long[] result = Array1DUtil.allocIfNull(out, outOffset + len);
        System.arraycopy(in, inOffset, result, outOffset, len);
        return result;
    }

    public static int[] longArrayToIntArray(long[] in, int inOffset, int[] out, int outOffset, int length) {
        int len = ArrayUtil.getCopyLength(in, inOffset, out, outOffset, length);
        int[] result = Array1DUtil.allocIfNull(out, outOffset + len);
        int i = 0;
        while (i < len) {
            result[i + outOffset] = (int)in[i + inOffset];
            ++i;
        }
        return result;
    }

    public static short[] longArrayToShortArray(long[] in, int inOffset, short[] out, int outOffset, int length) {
        int len = ArrayUtil.getCopyLength(in, inOffset, out, outOffset, length);
        short[] result = Array1DUtil.allocIfNull(out, outOffset + len);
        int i = 0;
        while (i < len) {
            result[i + outOffset] = (short)in[i + inOffset];
            ++i;
        }
        return result;
    }

    public static byte[] longArrayToByteArray(long[] in, int inOffset, byte[] out, int outOffset, int length) {
        int len = ArrayUtil.getCopyLength(in, inOffset, out, outOffset, length);
        byte[] result = Array1DUtil.allocIfNull(out, outOffset + len);
        int i = 0;
        while (i < len) {
            result[i + outOffset] = (byte)in[i + inOffset];
            ++i;
        }
        return result;
    }

    public static double[] intArrayToDoubleArray(int[] in, int inOffset, double[] out, int outOffset, int length, boolean signed) {
        int len = ArrayUtil.getCopyLength(in, inOffset, out, outOffset, length);
        double[] result = Array1DUtil.allocIfNull(out, outOffset + len);
        if (signed) {
            int i = 0;
            while (i < len) {
                result[i + outOffset] = in[i + inOffset];
                ++i;
            }
        } else {
            int i = 0;
            while (i < len) {
                result[i + outOffset] = TypeUtil.unsign(in[i + inOffset]);
                ++i;
            }
        }
        return result;
    }

    public static float[] intArrayToFloatArray(int[] in, int inOffset, float[] out, int outOffset, int length, boolean signed) {
        int len = ArrayUtil.getCopyLength(in, inOffset, out, outOffset, length);
        float[] result = Array1DUtil.allocIfNull(out, outOffset + len);
        if (signed) {
            int i = 0;
            while (i < len) {
                result[i + outOffset] = in[i + inOffset];
                ++i;
            }
        } else {
            int i = 0;
            while (i < len) {
                result[i + outOffset] = TypeUtil.unsign(in[i + inOffset]);
                ++i;
            }
        }
        return result;
    }

    public static long[] intArrayToLongArray(int[] in, int inOffset, long[] out, int outOffset, int length, boolean signed) {
        int len = ArrayUtil.getCopyLength(in, inOffset, out, outOffset, length);
        long[] result = Array1DUtil.allocIfNull(out, outOffset + len);
        if (signed) {
            int i = 0;
            while (i < len) {
                result[i + outOffset] = in[i + inOffset];
                ++i;
            }
        } else {
            int i = 0;
            while (i < len) {
                result[i + outOffset] = TypeUtil.unsign(in[i + inOffset]);
                ++i;
            }
        }
        return result;
    }

    public static int[] intArrayToIntArray(int[] in, int inOffset, int[] out, int outOffset, int length) {
        int len = ArrayUtil.getCopyLength(in, inOffset, out, outOffset, length);
        int[] result = Array1DUtil.allocIfNull(out, outOffset + len);
        System.arraycopy(in, inOffset, result, outOffset, len);
        return result;
    }

    public static short[] intArrayToShortArray(int[] in, int inOffset, short[] out, int outOffset, int length) {
        int len = ArrayUtil.getCopyLength(in, inOffset, out, outOffset, length);
        short[] result = Array1DUtil.allocIfNull(out, outOffset + len);
        int i = 0;
        while (i < len) {
            result[i + outOffset] = (short)in[i + inOffset];
            ++i;
        }
        return result;
    }

    public static byte[] intArrayToByteArray(int[] in, int inOffset, byte[] out, int outOffset, int length) {
        int len = ArrayUtil.getCopyLength(in, inOffset, out, outOffset, length);
        byte[] result = Array1DUtil.allocIfNull(out, outOffset + len);
        int i = 0;
        while (i < len) {
            result[i + outOffset] = (byte)in[i + inOffset];
            ++i;
        }
        return result;
    }

    public static double[] shortArrayToDoubleArray(short[] in, int inOffset, double[] out, int outOffset, int length, boolean signed) {
        int len = ArrayUtil.getCopyLength(in, inOffset, out, outOffset, length);
        double[] result = Array1DUtil.allocIfNull(out, outOffset + len);
        if (signed) {
            int i = 0;
            while (i < len) {
                result[i + outOffset] = in[i + inOffset];
                ++i;
            }
        } else {
            int i = 0;
            while (i < len) {
                result[i + outOffset] = TypeUtil.unsign(in[i + inOffset]);
                ++i;
            }
        }
        return result;
    }

    public static float[] shortArrayToFloatArray(short[] in, int inOffset, float[] out, int outOffset, int length, boolean signed) {
        int len = ArrayUtil.getCopyLength(in, inOffset, out, outOffset, length);
        float[] result = Array1DUtil.allocIfNull(out, outOffset + len);
        if (signed) {
            int i = 0;
            while (i < len) {
                result[i + outOffset] = in[i + inOffset];
                ++i;
            }
        } else {
            int i = 0;
            while (i < len) {
                result[i + outOffset] = TypeUtil.unsign(in[i + inOffset]);
                ++i;
            }
        }
        return result;
    }

    public static long[] shortArrayToLongArray(short[] in, int inOffset, long[] out, int outOffset, int length, boolean signed) {
        int len = ArrayUtil.getCopyLength(in, inOffset, out, outOffset, length);
        long[] result = Array1DUtil.allocIfNull(out, outOffset + len);
        if (signed) {
            int i = 0;
            while (i < len) {
                result[i + outOffset] = in[i + inOffset];
                ++i;
            }
        } else {
            int i = 0;
            while (i < len) {
                result[i + outOffset] = TypeUtil.unsignL(in[i + inOffset]);
                ++i;
            }
        }
        return result;
    }

    public static int[] shortArrayToIntArray(short[] in, int inOffset, int[] out, int outOffset, int length, boolean signed) {
        int len = ArrayUtil.getCopyLength(in, inOffset, out, outOffset, length);
        int[] result = Array1DUtil.allocIfNull(out, outOffset + len);
        if (signed) {
            int i = 0;
            while (i < len) {
                result[i + outOffset] = in[i + inOffset];
                ++i;
            }
        } else {
            int i = 0;
            while (i < len) {
                result[i + outOffset] = TypeUtil.unsign(in[i + inOffset]);
                ++i;
            }
        }
        return result;
    }

    public static short[] shortArrayToShortArray(short[] in, int inOffset, short[] out, int outOffset, int length) {
        int len = ArrayUtil.getCopyLength(in, inOffset, out, outOffset, length);
        short[] result = Array1DUtil.allocIfNull(out, outOffset + len);
        System.arraycopy(in, inOffset, result, outOffset, len);
        return result;
    }

    public static byte[] shortArrayToByteArray(short[] in, int inOffset, byte[] out, int outOffset, int length) {
        int len = ArrayUtil.getCopyLength(in, inOffset, out, outOffset, length);
        byte[] result = Array1DUtil.allocIfNull(out, outOffset + len);
        int i = 0;
        while (i < len) {
            result[i + outOffset] = (byte)in[i + inOffset];
            ++i;
        }
        return result;
    }

    public static double[] byteArrayToDoubleArray(byte[] in, int inOffset, double[] out, int outOffset, int length, boolean signed) {
        int len = ArrayUtil.getCopyLength(in, inOffset, out, outOffset, length);
        double[] result = Array1DUtil.allocIfNull(out, outOffset + len);
        if (signed) {
            int i = 0;
            while (i < len) {
                result[i + outOffset] = in[i + inOffset];
                ++i;
            }
        } else {
            int i = 0;
            while (i < len) {
                result[i + outOffset] = TypeUtil.unsign(in[i + inOffset]);
                ++i;
            }
        }
        return result;
    }

    public static float[] byteArrayToFloatArray(byte[] in, int inOffset, float[] out, int outOffset, int length, boolean signed) {
        int len = ArrayUtil.getCopyLength(in, inOffset, out, outOffset, length);
        float[] result = Array1DUtil.allocIfNull(out, outOffset + len);
        if (signed) {
            int i = 0;
            while (i < len) {
                result[i + outOffset] = in[i + inOffset];
                ++i;
            }
        } else {
            int i = 0;
            while (i < len) {
                result[i + outOffset] = TypeUtil.unsign(in[i + inOffset]);
                ++i;
            }
        }
        return result;
    }

    public static long[] byteArrayToLongArray(byte[] in, int inOffset, long[] out, int outOffset, int length, boolean signed) {
        int len = ArrayUtil.getCopyLength(in, inOffset, out, outOffset, length);
        long[] result = Array1DUtil.allocIfNull(out, outOffset + len);
        if (signed) {
            int i = 0;
            while (i < len) {
                result[i + outOffset] = in[i + inOffset];
                ++i;
            }
        } else {
            int i = 0;
            while (i < len) {
                result[i + outOffset] = TypeUtil.unsignL(in[i + inOffset]);
                ++i;
            }
        }
        return result;
    }

    public static int[] byteArrayToIntArray(byte[] in, int inOffset, int[] out, int outOffset, int length, boolean signed) {
        int len = ArrayUtil.getCopyLength(in, inOffset, out, outOffset, length);
        int[] result = Array1DUtil.allocIfNull(out, outOffset + len);
        if (signed) {
            int i = 0;
            while (i < len) {
                result[i + outOffset] = in[i + inOffset];
                ++i;
            }
        } else {
            int i = 0;
            while (i < len) {
                result[i + outOffset] = TypeUtil.unsign(in[i + inOffset]);
                ++i;
            }
        }
        return result;
    }

    public static short[] byteArrayToShortArray(byte[] in, int inOffset, short[] out, int outOffset, int length, boolean signed) {
        int len = ArrayUtil.getCopyLength(in, inOffset, out, outOffset, length);
        short[] result = Array1DUtil.allocIfNull(out, outOffset + len);
        if (signed) {
            int i = 0;
            while (i < len) {
                result[i + outOffset] = in[i + inOffset];
                ++i;
            }
        } else {
            int i = 0;
            while (i < len) {
                result[i + outOffset] = (short)TypeUtil.unsign(in[i + inOffset]);
                ++i;
            }
        }
        return result;
    }

    public static byte[] byteArrayToByteArray(byte[] in, int inOffset, byte[] out, int outOffset, int length) {
        int len = ArrayUtil.getCopyLength(in, inOffset, out, outOffset, length);
        byte[] result = Array1DUtil.allocIfNull(out, outOffset + len);
        System.arraycopy(in, inOffset, result, outOffset, len);
        return result;
    }

    public static float[] doubleArrayToFloatArray(double[] array) {
        return Array1DUtil.doubleArrayToFloatArray(array, 0, null, 0, array.length);
    }

    public static long[] doubleArrayToLongArray(double[] array) {
        return Array1DUtil.doubleArrayToLongArray(array, 0, null, 0, array.length);
    }

    public static int[] doubleArrayToIntArray(double[] array) {
        return Array1DUtil.doubleArrayToIntArray(array, 0, null, 0, array.length);
    }

    public static short[] doubleArrayToShortArray(double[] array) {
        return Array1DUtil.doubleArrayToShortArray(array, 0, null, 0, array.length);
    }

    public static byte[] doubleArrayToByteArray(double[] array) {
        return Array1DUtil.doubleArrayToByteArray(array, 0, null, 0, array.length);
    }

    public static double[] floatArrayToDoubleArray(float[] array) {
        return Array1DUtil.floatArrayToDoubleArray(array, 0, null, 0, array.length);
    }

    public static long[] floatArrayToLongArray(float[] array) {
        return Array1DUtil.floatArrayToLongArray(array, 0, null, 0, array.length);
    }

    public static int[] floatArrayToIntArray(float[] array) {
        return Array1DUtil.floatArrayToIntArray(array, 0, null, 0, array.length);
    }

    public static short[] floatArrayToShortArray(float[] array) {
        return Array1DUtil.floatArrayToShortArray(array, 0, null, 0, array.length);
    }

    public static byte[] floatArrayToByteArray(float[] array) {
        return Array1DUtil.floatArrayToByteArray(array, 0, null, 0, array.length);
    }

    public static double[] longArrayToDoubleArray(long[] array, boolean signed) {
        return Array1DUtil.longArrayToDoubleArray(array, 0, null, 0, array.length, signed);
    }

    public static float[] longArrayToFloatArray(long[] array, boolean signed) {
        return Array1DUtil.longArrayToFloatArray(array, 0, null, 0, array.length, signed);
    }

    public static short[] longArrayToShortArray(long[] array) {
        return Array1DUtil.longArrayToShortArray(array, 0, null, 0, array.length);
    }

    public static byte[] longArrayToByteArray(long[] array) {
        return Array1DUtil.longArrayToByteArray(array, 0, null, 0, array.length);
    }

    public static double[] intArrayToDoubleArray(int[] array, boolean signed) {
        return Array1DUtil.intArrayToDoubleArray(array, 0, null, 0, array.length, signed);
    }

    public static float[] intArrayToFloatArray(int[] array, boolean signed) {
        return Array1DUtil.intArrayToFloatArray(array, 0, null, 0, array.length, signed);
    }

    public static long[] intArrayToLongArray(int[] array, boolean signed) {
        return Array1DUtil.intArrayToLongArray(array, 0, null, 0, array.length, signed);
    }

    public static short[] intArrayToShortArray(int[] array) {
        return Array1DUtil.intArrayToShortArray(array, 0, null, 0, array.length);
    }

    public static byte[] intArrayToByteArray(int[] array) {
        return Array1DUtil.intArrayToByteArray(array, 0, null, 0, array.length);
    }

    public static double[] shortArrayToDoubleArray(short[] array, boolean signed) {
        return Array1DUtil.shortArrayToDoubleArray(array, 0, null, 0, array.length, signed);
    }

    public static float[] shortArrayToFloatArray(short[] array, boolean signed) {
        return Array1DUtil.shortArrayToFloatArray(array, 0, null, 0, array.length, signed);
    }

    public static long[] shortArrayToLongArray(short[] array, boolean signed) {
        return Array1DUtil.shortArrayToLongArray(array, 0, null, 0, array.length, signed);
    }

    public static int[] shortArrayToIntArray(short[] array, boolean signed) {
        return Array1DUtil.shortArrayToIntArray(array, 0, null, 0, array.length, signed);
    }

    public static byte[] shortArrayToByteArray(short[] array) {
        return Array1DUtil.shortArrayToByteArray(array, 0, null, 0, array.length);
    }

    public static double[] byteArrayToDoubleArray(byte[] array, boolean signed) {
        return Array1DUtil.byteArrayToDoubleArray(array, 0, null, 0, array.length, signed);
    }

    public static float[] byteArrayToFloatArray(byte[] array, boolean signed) {
        return Array1DUtil.byteArrayToFloatArray(array, 0, null, 0, array.length, signed);
    }

    public static long[] byteArrayToLongArray(byte[] array, boolean signed) {
        return Array1DUtil.byteArrayToLongArray(array, 0, null, 0, array.length, signed);
    }

    public static int[] byteArrayToIntArray(byte[] array, boolean signed) {
        return Array1DUtil.byteArrayToIntArray(array, 0, null, 0, array.length, signed);
    }

    public static short[] byteArrayToShortArray(byte[] array, boolean signed) {
        return Array1DUtil.byteArrayToShortArray(array, 0, null, 0, array.length, signed);
    }

    public static Object doubleArrayToSafeArray(double[] in, int inOffset, Object out, int outOffset, int length, boolean signed) {
        switch (ArrayUtil.getDataType(out)) {
            case BYTE: {
                return Array1DUtil.doubleArrayToSafeByteArray(in, inOffset, (byte[])out, outOffset, length, signed);
            }
            case SHORT: {
                return Array1DUtil.doubleArrayToSafeShortArray(in, inOffset, (short[])out, outOffset, length, signed);
            }
            case INT: {
                return Array1DUtil.doubleArrayToSafeIntArray(in, inOffset, (int[])out, outOffset, length, signed);
            }
            case LONG: {
                return Array1DUtil.doubleArrayToSafeLongArray(in, inOffset, (long[])out, outOffset, length, signed);
            }
            case FLOAT: {
                return Array1DUtil.doubleArrayToFloatArray(in, inOffset, (float[])out, outOffset, length);
            }
            case DOUBLE: {
                return Array1DUtil.doubleArrayToDoubleArray(in, inOffset, (double[])out, outOffset, length);
            }
        }
        return out;
    }

    public static Object doubleArrayToSafeArray(double[] in, Object out, boolean signed) {
        return Array1DUtil.doubleArrayToSafeArray(in, 0, out, 0, -1, signed);
    }

    public static Object floatArrayToSafeArray(float[] in, int inOffset, Object out, int outOffset, int length, boolean signed) {
        switch (ArrayUtil.getDataType(out)) {
            case BYTE: {
                return Array1DUtil.floatArrayToSafeByteArray(in, inOffset, (byte[])out, outOffset, length, signed);
            }
            case SHORT: {
                return Array1DUtil.floatArrayToSafeShortArray(in, inOffset, (short[])out, outOffset, length, signed);
            }
            case INT: {
                return Array1DUtil.floatArrayToSafeIntArray(in, inOffset, (int[])out, outOffset, length, signed);
            }
            case LONG: {
                return Array1DUtil.floatArrayToSafeLongArray(in, inOffset, (long[])out, outOffset, length, signed);
            }
            case FLOAT: {
                return Array1DUtil.floatArrayToFloatArray(in, inOffset, (float[])out, outOffset, length);
            }
            case DOUBLE: {
                return Array1DUtil.floatArrayToDoubleArray(in, inOffset, (double[])out, outOffset, length);
            }
        }
        return out;
    }

    public static Object floatArrayToSafeArray(float[] in, Object out, boolean signed) {
        return Array1DUtil.floatArrayToSafeArray(in, 0, out, 0, -1, signed);
    }

    public static Object longArrayToSafeArray(long[] in, int inOffset, Object out, int outOffset, int length, boolean srcSigned, boolean dstSigned) {
        switch (ArrayUtil.getDataType(out)) {
            case BYTE: {
                return Array1DUtil.longArrayToSafeByteArray(in, inOffset, (byte[])out, outOffset, length, srcSigned, dstSigned);
            }
            case SHORT: {
                return Array1DUtil.longArrayToSafeShortArray(in, inOffset, (short[])out, outOffset, length, srcSigned, dstSigned);
            }
            case INT: {
                return Array1DUtil.longArrayToSafeIntArray(in, inOffset, (int[])out, outOffset, length, srcSigned, dstSigned);
            }
            case LONG: {
                return Array1DUtil.longArrayToSafeLongArray(in, inOffset, (long[])out, outOffset, length, srcSigned, dstSigned);
            }
            case FLOAT: {
                return Array1DUtil.longArrayToFloatArray(in, inOffset, (float[])out, outOffset, length, srcSigned);
            }
            case DOUBLE: {
                return Array1DUtil.longArrayToDoubleArray(in, inOffset, (double[])out, outOffset, length, srcSigned);
            }
        }
        return out;
    }

    public static Object longArrayToSafeArray(long[] in, Object out, boolean srcSigned, boolean dstSigned) {
        return Array1DUtil.longArrayToSafeArray(in, 0, out, 0, -1, srcSigned, dstSigned);
    }

    @Deprecated
    public static Object longArrayToSafeArray(long[] in, int inOffset, Object out, int outOffset, int length, boolean signed) {
        return Array1DUtil.longArrayToSafeArray(in, inOffset, out, outOffset, length, signed, signed);
    }

    @Deprecated
    public static Object longArrayToSafeArray(long[] in, Object out, boolean signed) {
        return Array1DUtil.longArrayToSafeArray(in, 0, out, 0, -1, signed, signed);
    }

    public static Object intArrayToSafeArray(int[] in, int inOffset, Object out, int outOffset, int length, boolean srcSigned, boolean dstSigned) {
        switch (ArrayUtil.getDataType(out)) {
            case BYTE: {
                return Array1DUtil.intArrayToSafeByteArray(in, inOffset, (byte[])out, outOffset, length, srcSigned, dstSigned);
            }
            case SHORT: {
                return Array1DUtil.intArrayToSafeShortArray(in, inOffset, (short[])out, outOffset, length, srcSigned, dstSigned);
            }
            case INT: {
                return Array1DUtil.intArrayToSafeIntArray(in, inOffset, (int[])out, outOffset, length, srcSigned, dstSigned);
            }
            case LONG: {
                return Array1DUtil.intArrayToLongArray(in, inOffset, (long[])out, outOffset, length, srcSigned);
            }
            case FLOAT: {
                return Array1DUtil.intArrayToFloatArray(in, inOffset, (float[])out, outOffset, length, srcSigned);
            }
            case DOUBLE: {
                return Array1DUtil.intArrayToDoubleArray(in, inOffset, (double[])out, outOffset, length, srcSigned);
            }
        }
        return out;
    }

    public static Object intArrayToSafeArray(int[] in, Object out, boolean srcSigned, boolean dstSigned) {
        return Array1DUtil.intArrayToSafeArray(in, 0, out, 0, -1, srcSigned, dstSigned);
    }

    @Deprecated
    public static Object intArrayToSafeArray(int[] in, int inOffset, Object out, int outOffset, int length, boolean signed) {
        return Array1DUtil.intArrayToSafeArray(in, inOffset, out, outOffset, length, signed, signed);
    }

    @Deprecated
    public static Object intArrayToSafeArray(int[] in, Object out, boolean signed) {
        return Array1DUtil.intArrayToSafeArray(in, 0, out, 0, -1, signed, signed);
    }

    public static Object shortArrayToSafeArray(short[] in, int inOffset, Object out, int outOffset, int length, boolean srcSigned, boolean dstSigned) {
        switch (ArrayUtil.getDataType(out)) {
            case BYTE: {
                return Array1DUtil.shortArrayToSafeByteArray(in, inOffset, (byte[])out, outOffset, length, srcSigned, dstSigned);
            }
            case SHORT: {
                return Array1DUtil.shortArrayToSafeShortArray(in, inOffset, (short[])out, outOffset, length, srcSigned, dstSigned);
            }
            case INT: {
                return Array1DUtil.shortArrayToIntArray(in, inOffset, (int[])out, outOffset, length, srcSigned);
            }
            case LONG: {
                return Array1DUtil.shortArrayToLongArray(in, inOffset, (long[])out, outOffset, length, srcSigned);
            }
            case FLOAT: {
                return Array1DUtil.shortArrayToFloatArray(in, inOffset, (float[])out, outOffset, length, srcSigned);
            }
            case DOUBLE: {
                return Array1DUtil.shortArrayToDoubleArray(in, inOffset, (double[])out, outOffset, length, srcSigned);
            }
        }
        return out;
    }

    public static Object shortArrayToSafeArray(short[] in, Object out, boolean srcSigned, boolean dstSigned) {
        return Array1DUtil.shortArrayToSafeArray(in, 0, out, 0, -1, srcSigned, dstSigned);
    }

    @Deprecated
    public static Object shortArrayToSafeArray(short[] in, int inOffset, Object out, int outOffset, int length, boolean signed) {
        return Array1DUtil.shortArrayToSafeArray(in, inOffset, out, outOffset, length, signed, signed);
    }

    @Deprecated
    public static Object shortArrayToSafeArray(short[] in, Object out, boolean signed) {
        return Array1DUtil.shortArrayToSafeArray(in, 0, out, 0, -1, signed, signed);
    }

    public static Object byteArrayToSafeArray(byte[] in, int inOffset, Object out, int outOffset, int length, boolean srcSigned, boolean dstSigned) {
        switch (ArrayUtil.getDataType(out)) {
            case BYTE: {
                return Array1DUtil.byteArrayToSafeByteArray(in, inOffset, (byte[])out, outOffset, length, srcSigned, dstSigned);
            }
            case SHORT: {
                return Array1DUtil.byteArrayToShortArray(in, inOffset, (short[])out, outOffset, length, srcSigned);
            }
            case INT: {
                return Array1DUtil.byteArrayToIntArray(in, inOffset, (int[])out, outOffset, length, srcSigned);
            }
            case LONG: {
                return Array1DUtil.byteArrayToLongArray(in, inOffset, (long[])out, outOffset, length, srcSigned);
            }
            case FLOAT: {
                return Array1DUtil.byteArrayToFloatArray(in, inOffset, (float[])out, outOffset, length, srcSigned);
            }
            case DOUBLE: {
                return Array1DUtil.byteArrayToDoubleArray(in, inOffset, (double[])out, outOffset, length, srcSigned);
            }
        }
        return out;
    }

    public static Object byteArrayToSafeArray(byte[] in, Object out, boolean srcSigned, boolean dstSigned) {
        return Array1DUtil.byteArrayToSafeArray(in, 0, out, 0, -1, srcSigned, dstSigned);
    }

    public static long[] arrayToSafeLongArray(Object in, int inOffset, long[] out, int outOffset, int length, boolean srcSigned, boolean dstSigned) {
        switch (ArrayUtil.getDataType(in)) {
            case BYTE: {
                return Array1DUtil.byteArrayToLongArray((byte[])in, inOffset, out, outOffset, length, srcSigned);
            }
            case SHORT: {
                return Array1DUtil.shortArrayToLongArray((short[])in, inOffset, out, outOffset, length, srcSigned);
            }
            case INT: {
                return Array1DUtil.intArrayToLongArray((int[])in, inOffset, out, outOffset, length, srcSigned);
            }
            case LONG: {
                return Array1DUtil.longArrayToSafeLongArray((long[])in, inOffset, out, outOffset, length, srcSigned, dstSigned);
            }
            case FLOAT: {
                return Array1DUtil.floatArrayToSafeLongArray((float[])in, inOffset, out, outOffset, length, dstSigned);
            }
            case DOUBLE: {
                return Array1DUtil.doubleArrayToSafeLongArray((double[])in, inOffset, out, outOffset, length, dstSigned);
            }
        }
        return out;
    }

    public static long[] arrayToSafeLongArray(Object in, long[] out, boolean srcSigned, boolean dstSigned) {
        return Array1DUtil.arrayToSafeLongArray(in, 0, out, 0, -1, srcSigned, dstSigned);
    }

    @Deprecated
    public static long[] arrayToSafeLongArray(Object in, int inOffset, long[] out, int outOffset, int length, boolean signed) {
        return Array1DUtil.arrayToSafeLongArray(in, inOffset, out, outOffset, length, signed, signed);
    }

    @Deprecated
    public static long[] arrayToSafeLongArray(Object in, long[] out, boolean signed) {
        return Array1DUtil.arrayToSafeLongArray(in, 0, out, 0, -1, signed, signed);
    }

    public static int[] arrayToSafeIntArray(Object in, int inOffset, int[] out, int outOffset, int length, boolean srcSigned, boolean dstSigned) {
        switch (ArrayUtil.getDataType(in)) {
            case BYTE: {
                return Array1DUtil.byteArrayToIntArray((byte[])in, inOffset, out, outOffset, length, srcSigned);
            }
            case SHORT: {
                return Array1DUtil.shortArrayToIntArray((short[])in, inOffset, out, outOffset, length, srcSigned);
            }
            case INT: {
                return Array1DUtil.intArrayToSafeIntArray((int[])in, inOffset, out, outOffset, length, srcSigned, dstSigned);
            }
            case LONG: {
                return Array1DUtil.longArrayToSafeIntArray((long[])in, inOffset, out, outOffset, length, srcSigned, dstSigned);
            }
            case FLOAT: {
                return Array1DUtil.floatArrayToSafeIntArray((float[])in, inOffset, out, outOffset, length, dstSigned);
            }
            case DOUBLE: {
                return Array1DUtil.doubleArrayToSafeIntArray((double[])in, inOffset, out, outOffset, length, dstSigned);
            }
        }
        return out;
    }

    public static int[] arrayToSafeIntArray(Object in, int[] out, boolean srcSigned, boolean dstSigned) {
        return Array1DUtil.arrayToSafeIntArray(in, 0, out, 0, -1, srcSigned, dstSigned);
    }

    @Deprecated
    public static int[] arrayToSafeIntArray(Object in, int inOffset, int[] out, int outOffset, int length, boolean signed) {
        return Array1DUtil.arrayToSafeIntArray(in, inOffset, out, outOffset, length, signed, signed);
    }

    @Deprecated
    public static int[] arrayToSafeIntArray(Object in, int[] out, boolean signed) {
        return Array1DUtil.arrayToSafeIntArray(in, 0, out, 0, -1, signed, signed);
    }

    public static short[] arrayToSafeShortArray(Object in, int inOffset, short[] out, int outOffset, int length, boolean srcSigned, boolean dstSigned) {
        switch (ArrayUtil.getDataType(in)) {
            case BYTE: {
                return Array1DUtil.byteArrayToShortArray((byte[])in, inOffset, out, outOffset, length, srcSigned);
            }
            case SHORT: {
                return Array1DUtil.shortArrayToSafeShortArray((short[])in, inOffset, out, outOffset, length, srcSigned, dstSigned);
            }
            case INT: {
                return Array1DUtil.intArrayToSafeShortArray((int[])in, inOffset, out, outOffset, length, srcSigned, dstSigned);
            }
            case LONG: {
                return Array1DUtil.longArrayToSafeShortArray((long[])in, inOffset, out, outOffset, length, srcSigned, dstSigned);
            }
            case FLOAT: {
                return Array1DUtil.floatArrayToSafeShortArray((float[])in, inOffset, out, outOffset, length, dstSigned);
            }
            case DOUBLE: {
                return Array1DUtil.doubleArrayToSafeShortArray((double[])in, inOffset, out, outOffset, length, dstSigned);
            }
        }
        return out;
    }

    public static short[] arrayToSafeShortArray(Object in, short[] out, boolean srcSigned, boolean dstSigned) {
        return Array1DUtil.arrayToSafeShortArray(in, 0, out, 0, -1, srcSigned, dstSigned);
    }

    @Deprecated
    public static short[] arrayToSafeShortArray(Object in, int inOffset, short[] out, int outOffset, int length, boolean signed) {
        return Array1DUtil.arrayToSafeShortArray(in, inOffset, out, outOffset, length, signed, signed);
    }

    @Deprecated
    public static short[] arrayToSafeShortArray(Object in, short[] out, boolean signed) {
        return Array1DUtil.arrayToSafeShortArray(in, 0, out, 0, -1, signed, signed);
    }

    public static byte[] arrayToSafeByteArray(Object in, int inOffset, byte[] out, int outOffset, int length, boolean srcSigned, boolean dstSigned) {
        switch (ArrayUtil.getDataType(in)) {
            case BYTE: {
                return Array1DUtil.byteArrayToSafeByteArray((byte[])in, inOffset, out, outOffset, length, srcSigned, dstSigned);
            }
            case SHORT: {
                return Array1DUtil.shortArrayToSafeByteArray((short[])in, inOffset, out, outOffset, length, srcSigned, dstSigned);
            }
            case INT: {
                return Array1DUtil.intArrayToSafeByteArray((int[])in, inOffset, out, outOffset, length, srcSigned, dstSigned);
            }
            case LONG: {
                return Array1DUtil.longArrayToSafeByteArray((long[])in, inOffset, out, outOffset, length, srcSigned, dstSigned);
            }
            case FLOAT: {
                return Array1DUtil.floatArrayToSafeByteArray((float[])in, inOffset, out, outOffset, length, dstSigned);
            }
            case DOUBLE: {
                return Array1DUtil.doubleArrayToSafeByteArray((double[])in, inOffset, out, outOffset, length, dstSigned);
            }
        }
        return out;
    }

    public static byte[] arrayToSafeByteArray(Object in, byte[] out, boolean srcSigned, boolean dstSigned) {
        return Array1DUtil.arrayToSafeByteArray(in, 0, out, 0, -1, srcSigned, dstSigned);
    }

    @Deprecated
    public static byte[] arrayToSafeByteArray(Object in, int inOffset, byte[] out, int outOffset, int length, boolean signed) {
        return Array1DUtil.arrayToSafeByteArray(in, inOffset, out, outOffset, length, signed, signed);
    }

    @Deprecated
    public static byte[] arrayToSafeByteArray(Object in, byte[] out, boolean signed) {
        return Array1DUtil.arrayToSafeByteArray(in, 0, out, 0, -1, signed, signed);
    }

    public static long[] doubleArrayToSafeLongArray(double[] in, int inOffset, long[] out, int outOffset, int length, boolean signed) {
        int len = ArrayUtil.getCopyLength(in, inOffset, out, outOffset, length);
        long[] outArray = Array1DUtil.allocIfNull(out, outOffset + len);
        if (signed) {
            int i = 0;
            while (i < len) {
                outArray[i + outOffset] = (long)in[i + inOffset];
                ++i;
            }
        } else {
            double minValue = 0.0;
            double maxValue = DataType.ULONG_MAX_VALUE;
            long minValueT = 0L;
            long maxValueT = -1L;
            int i = 0;
            while (i < len) {
                double value = in[i + inOffset];
                long result = value >= maxValue ? -1L : (value <= 0.0 ? 0L : TypeUtil.toLong(value));
                outArray[i + outOffset] = result;
                ++i;
            }
        }
        return outArray;
    }

    public static int[] doubleArrayToSafeIntArray(double[] in, int inOffset, int[] out, int outOffset, int length, boolean signed) {
        int len = ArrayUtil.getCopyLength(in, inOffset, out, outOffset, length);
        int[] outArray = Array1DUtil.allocIfNull(out, outOffset + len);
        if (signed) {
            int i = 0;
            while (i < len) {
                outArray[i + outOffset] = (int)in[i + inOffset];
                ++i;
            }
        } else {
            double minValue = 0.0;
            double maxValue = DataType.UINT_MAX_VALUE;
            boolean minValueT = false;
            int maxValueT = -1;
            int i = 0;
            while (i < len) {
                double value = in[i + inOffset];
                int result = value >= maxValue ? -1 : (value <= 0.0 ? 0 : TypeUtil.toInt(value));
                outArray[i + outOffset] = result;
                ++i;
            }
        }
        return outArray;
    }

    public static short[] doubleArrayToSafeShortArray(double[] in, int inOffset, short[] out, int outOffset, int length, boolean signed) {
        double maxValue;
        double minValue;
        int len = ArrayUtil.getCopyLength(in, inOffset, out, outOffset, length);
        short[] outArray = Array1DUtil.allocIfNull(out, outOffset + len);
        if (signed) {
            minValue = DataType.SHORT.getMinValue();
            maxValue = DataType.SHORT.getMaxValue();
        } else {
            minValue = DataType.USHORT.getMinValue();
            maxValue = DataType.USHORT.getMaxValue();
        }
        short minValueT = (short)minValue;
        short maxValueT = (short)maxValue;
        int i = 0;
        while (i < len) {
            double value = in[i + inOffset];
            short result = value >= maxValue ? maxValueT : (value <= minValue ? minValueT : (short)value);
            outArray[i + outOffset] = result;
            ++i;
        }
        return outArray;
    }

    public static byte[] doubleArrayToSafeByteArray(double[] in, int inOffset, byte[] out, int outOffset, int length, boolean signed) {
        double maxValue;
        double minValue;
        int len = ArrayUtil.getCopyLength(in, inOffset, out, outOffset, length);
        byte[] outArray = Array1DUtil.allocIfNull(out, outOffset + len);
        if (signed) {
            minValue = DataType.BYTE.getMinValue();
            maxValue = DataType.BYTE.getMaxValue();
        } else {
            minValue = DataType.UBYTE.getMinValue();
            maxValue = DataType.UBYTE.getMaxValue();
        }
        byte minValueT = (byte)minValue;
        byte maxValueT = (byte)maxValue;
        int i = 0;
        while (i < len) {
            double value = in[i + inOffset];
            byte result = value >= maxValue ? maxValueT : (value <= minValue ? minValueT : (byte)value);
            outArray[i + outOffset] = result;
            ++i;
        }
        return outArray;
    }

    public static long[] floatArrayToSafeLongArray(float[] in, int inOffset, long[] out, int outOffset, int length, boolean signed) {
        int len = ArrayUtil.getCopyLength(in, inOffset, out, outOffset, length);
        long[] outArray = Array1DUtil.allocIfNull(out, outOffset + len);
        if (signed) {
            int i = 0;
            while (i < len) {
                outArray[i + outOffset] = (long)in[i + inOffset];
                ++i;
            }
        } else {
            float minValue = 0.0f;
            float maxValue = DataType.ULONG_MAX_VALUE_F;
            long minValueT = 0L;
            long maxValueT = -1L;
            int i = 0;
            while (i < len) {
                float value = in[i + inOffset];
                long result = value >= maxValue ? -1L : (value <= 0.0f ? 0L : TypeUtil.toLong(value));
                outArray[i + outOffset] = result;
                ++i;
            }
        }
        return outArray;
    }

    public static int[] floatArrayToSafeIntArray(float[] in, int inOffset, int[] out, int outOffset, int length, boolean signed) {
        int len = ArrayUtil.getCopyLength(in, inOffset, out, outOffset, length);
        int[] outArray = Array1DUtil.allocIfNull(out, outOffset + len);
        if (signed) {
            int i = 0;
            while (i < len) {
                outArray[i + outOffset] = (int)in[i + inOffset];
                ++i;
            }
        } else {
            float minValue = 0.0f;
            float maxValue = DataType.UINT_MAX_VALUE_F;
            boolean minValueT = false;
            int maxValueT = -1;
            int i = 0;
            while (i < len) {
                float value = in[i + inOffset];
                int result = value >= maxValue ? -1 : (value <= 0.0f ? 0 : TypeUtil.toInt(value));
                outArray[i + outOffset] = result;
                ++i;
            }
        }
        return outArray;
    }

    public static short[] floatArrayToSafeShortArray(float[] in, int inOffset, short[] out, int outOffset, int length, boolean signed) {
        float maxValue;
        float minValue;
        int len = ArrayUtil.getCopyLength(in, inOffset, out, outOffset, length);
        short[] outArray = Array1DUtil.allocIfNull(out, outOffset + len);
        if (signed) {
            minValue = (float)DataType.SHORT.getMinValue();
            maxValue = (float)DataType.SHORT.getMaxValue();
        } else {
            minValue = (float)DataType.USHORT.getMinValue();
            maxValue = (float)DataType.USHORT.getMaxValue();
        }
        short minValueT = (short)minValue;
        short maxValueT = (short)maxValue;
        int i = 0;
        while (i < len) {
            float value = in[i + inOffset];
            short result = value >= maxValue ? maxValueT : (value <= minValue ? minValueT : (short)value);
            outArray[i + outOffset] = result;
            ++i;
        }
        return outArray;
    }

    public static byte[] floatArrayToSafeByteArray(float[] in, int inOffset, byte[] out, int outOffset, int length, boolean signed) {
        float maxValue;
        float minValue;
        int len = ArrayUtil.getCopyLength(in, inOffset, out, outOffset, length);
        byte[] outArray = Array1DUtil.allocIfNull(out, outOffset + len);
        if (signed) {
            minValue = (float)DataType.BYTE.getMinValue();
            maxValue = (float)DataType.BYTE.getMaxValue();
        } else {
            minValue = (float)DataType.UBYTE.getMinValue();
            maxValue = (float)DataType.UBYTE.getMaxValue();
        }
        byte minValueT = (byte)minValue;
        byte maxValueT = (byte)maxValue;
        int i = 0;
        while (i < len) {
            float value = in[i + inOffset];
            byte result = value >= maxValue ? maxValueT : (value <= minValue ? minValueT : (byte)value);
            outArray[i + outOffset] = result;
            ++i;
        }
        return outArray;
    }

    public static long[] longArrayToSafeLongArray(long[] in, int inOffset, long[] out, int outOffset, int length, boolean srcSigned, boolean dstSigned) {
        if (srcSigned == dstSigned) {
            return Array1DUtil.longArrayToLongArray(in, inOffset, out, outOffset, length);
        }
        int len = ArrayUtil.getCopyLength(in, inOffset, out, outOffset, length);
        long[] outArray = Array1DUtil.allocIfNull(out, outOffset + len);
        long maxValue = Long.MAX_VALUE;
        int i = 0;
        while (i < len) {
            long value = in[i + inOffset];
            if (value < 0L) {
                value = srcSigned ? 0L : Long.MAX_VALUE;
            }
            outArray[i + outOffset] = value;
            ++i;
        }
        return outArray;
    }

    public static int[] longArrayToSafeIntArray(long[] in, int inOffset, int[] out, int outOffset, int length, boolean srcSigned, boolean dstSigned) {
        long maxValue;
        long minValue;
        int len = ArrayUtil.getCopyLength(in, inOffset, out, outOffset, length);
        int[] outArray = Array1DUtil.allocIfNull(out, outOffset + len);
        if (dstSigned) {
            minValue = (long)DataType.INT.getMinValue();
            maxValue = (long)DataType.INT.getMaxValue();
        } else {
            minValue = (long)DataType.UINT.getMinValue();
            maxValue = (long)DataType.UINT.getMaxValue();
        }
        int minValueT = (int)minValue;
        int maxValueT = (int)maxValue;
        int i = 0;
        while (i < len) {
            long value = in[i + inOffset];
            int result = !srcSigned && value < 0L ? maxValueT : (value >= maxValue ? maxValueT : (value <= minValue ? minValueT : (int)value));
            outArray[i + outOffset] = result;
            ++i;
        }
        return outArray;
    }

    public static short[] longArrayToSafeShortArray(long[] in, int inOffset, short[] out, int outOffset, int length, boolean srcSigned, boolean dstSigned) {
        long maxValue;
        long minValue;
        int len = ArrayUtil.getCopyLength(in, inOffset, out, outOffset, length);
        short[] outArray = Array1DUtil.allocIfNull(out, outOffset + len);
        if (dstSigned) {
            minValue = (long)DataType.SHORT.getMinValue();
            maxValue = (long)DataType.SHORT.getMaxValue();
        } else {
            minValue = (long)DataType.USHORT.getMinValue();
            maxValue = (long)DataType.USHORT.getMaxValue();
        }
        short minValueT = (short)minValue;
        short maxValueT = (short)maxValue;
        int i = 0;
        while (i < len) {
            long value = in[i + inOffset];
            short result = !srcSigned && value < 0L ? maxValueT : (value >= maxValue ? maxValueT : (value <= minValue ? minValueT : (short)value));
            outArray[i + outOffset] = result;
            ++i;
        }
        return outArray;
    }

    public static byte[] longArrayToSafeByteArray(long[] in, int inOffset, byte[] out, int outOffset, int length, boolean srcSigned, boolean dstSigned) {
        long maxValue;
        long minValue;
        int len = ArrayUtil.getCopyLength(in, inOffset, out, outOffset, length);
        byte[] outArray = Array1DUtil.allocIfNull(out, outOffset + len);
        if (dstSigned) {
            minValue = (long)DataType.BYTE.getMinValue();
            maxValue = (long)DataType.BYTE.getMaxValue();
        } else {
            minValue = (long)DataType.UBYTE.getMinValue();
            maxValue = (long)DataType.UBYTE.getMaxValue();
        }
        byte minValueT = (byte)minValue;
        byte maxValueT = (byte)maxValue;
        int i = 0;
        while (i < len) {
            long value = in[i + inOffset];
            byte result = !srcSigned && value < 0L ? maxValueT : (value >= maxValue ? maxValueT : (value <= minValue ? minValueT : (byte)value));
            outArray[i + outOffset] = result;
            ++i;
        }
        return outArray;
    }

    @Deprecated
    public static int[] longArrayToSafeIntArray(long[] in, int inOffset, int[] out, int outOffset, int length, boolean signed) {
        return Array1DUtil.longArrayToSafeIntArray(in, inOffset, out, outOffset, length, signed, signed);
    }

    @Deprecated
    public static short[] longArrayToSafeShortArray(long[] in, int inOffset, short[] out, int outOffset, int length, boolean signed) {
        return Array1DUtil.longArrayToSafeShortArray(in, inOffset, out, outOffset, length, signed, signed);
    }

    @Deprecated
    public static byte[] longArrayToSafeByteArray(long[] in, int inOffset, byte[] out, int outOffset, int length, boolean signed) {
        return Array1DUtil.longArrayToSafeByteArray(in, inOffset, out, outOffset, length, signed, signed);
    }

    public static int[] intArrayToSafeIntArray(int[] in, int inOffset, int[] out, int outOffset, int length, boolean srcSigned, boolean dstSigned) {
        if (srcSigned == dstSigned) {
            return Array1DUtil.intArrayToIntArray(in, inOffset, out, outOffset, length);
        }
        int len = ArrayUtil.getCopyLength(in, inOffset, out, outOffset, length);
        int[] outArray = Array1DUtil.allocIfNull(out, outOffset + len);
        int maxValue = Integer.MAX_VALUE;
        int i = 0;
        while (i < len) {
            int value = in[i + inOffset];
            if (value < 0) {
                value = srcSigned ? 0 : Integer.MAX_VALUE;
            }
            outArray[i + outOffset] = value;
            ++i;
        }
        return outArray;
    }

    public static short[] intArrayToSafeShortArray(int[] in, int inOffset, short[] out, int outOffset, int length, boolean srcSigned, boolean dstSigned) {
        int maxValue;
        int minValue;
        int len = ArrayUtil.getCopyLength(in, inOffset, out, outOffset, length);
        short[] outArray = Array1DUtil.allocIfNull(out, outOffset + len);
        if (dstSigned) {
            minValue = (int)DataType.SHORT.getMinValue();
            maxValue = (int)DataType.SHORT.getMaxValue();
        } else {
            minValue = (int)DataType.USHORT.getMinValue();
            maxValue = (int)DataType.USHORT.getMaxValue();
        }
        short minValueT = (short)minValue;
        short maxValueT = (short)maxValue;
        int i = 0;
        while (i < len) {
            int value = in[i + inOffset];
            short result = !srcSigned && value < 0 ? maxValueT : (value >= maxValue ? maxValueT : (value <= minValue ? minValueT : (short)value));
            outArray[i + outOffset] = result;
            ++i;
        }
        return outArray;
    }

    public static byte[] intArrayToSafeByteArray(int[] in, int inOffset, byte[] out, int outOffset, int length, boolean srcSigned, boolean dstSigned) {
        int maxValue;
        int minValue;
        int len = ArrayUtil.getCopyLength(in, inOffset, out, outOffset, length);
        byte[] outArray = Array1DUtil.allocIfNull(out, outOffset + len);
        if (dstSigned) {
            minValue = (int)DataType.BYTE.getMinValue();
            maxValue = (int)DataType.BYTE.getMaxValue();
        } else {
            minValue = (int)DataType.UBYTE.getMinValue();
            maxValue = (int)DataType.UBYTE.getMaxValue();
        }
        byte minValueT = (byte)minValue;
        byte maxValueT = (byte)maxValue;
        int i = 0;
        while (i < len) {
            int value = in[i + inOffset];
            byte result = !srcSigned && value < 0 ? maxValueT : (value >= maxValue ? maxValueT : (value <= minValue ? minValueT : (byte)value));
            outArray[i + outOffset] = result;
            ++i;
        }
        return outArray;
    }

    @Deprecated
    public static short[] intArrayToSafeShortArray(int[] in, int inOffset, short[] out, int outOffset, int length, boolean signed) {
        return Array1DUtil.intArrayToSafeShortArray(in, inOffset, out, outOffset, length, signed, signed);
    }

    @Deprecated
    public static byte[] intArrayToSafeByteArray(int[] in, int inOffset, byte[] out, int outOffset, int length, boolean signed) {
        return Array1DUtil.intArrayToSafeByteArray(in, inOffset, out, outOffset, length, signed, signed);
    }

    public static short[] shortArrayToSafeShortArray(short[] in, int inOffset, short[] out, int outOffset, int length, boolean srcSigned, boolean dstSigned) {
        if (srcSigned == dstSigned) {
            return Array1DUtil.shortArrayToShortArray(in, inOffset, out, outOffset, length);
        }
        int len = ArrayUtil.getCopyLength(in, inOffset, out, outOffset, length);
        short[] outArray = Array1DUtil.allocIfNull(out, outOffset + len);
        int maxValue = Short.MAX_VALUE;
        int i = 0;
        while (i < len) {
            int value = in[i + inOffset];
            if (value < 0) {
                value = srcSigned ? 0 : Short.MAX_VALUE;
            }
            outArray[i + outOffset] = value;
            ++i;
        }
        return outArray;
    }

    public static byte[] shortArrayToSafeByteArray(short[] in, int inOffset, byte[] out, int outOffset, int length, boolean srcSigned, boolean dstSigned) {
        short maxValue;
        short minValue;
        int len = ArrayUtil.getCopyLength(in, inOffset, out, outOffset, length);
        byte[] outArray = Array1DUtil.allocIfNull(out, outOffset + len);
        if (dstSigned) {
            minValue = (short)DataType.BYTE.getMinValue();
            maxValue = (short)DataType.BYTE.getMaxValue();
        } else {
            minValue = (short)DataType.UBYTE.getMinValue();
            maxValue = (short)DataType.UBYTE.getMaxValue();
        }
        byte minValueT = (byte)minValue;
        byte maxValueT = (byte)maxValue;
        int i = 0;
        while (i < len) {
            short value = in[i + inOffset];
            byte result = !srcSigned && value < 0 ? maxValueT : (value >= maxValue ? maxValueT : (value <= minValue ? minValueT : (byte)value));
            outArray[i + outOffset] = result;
            ++i;
        }
        return outArray;
    }

    @Deprecated
    public static byte[] shortArrayToSafeByteArray(short[] in, int inOffset, byte[] out, int outOffset, int length, boolean signed) {
        return Array1DUtil.shortArrayToSafeByteArray(in, inOffset, out, outOffset, length, signed, signed);
    }

    public static byte[] byteArrayToSafeByteArray(byte[] in, int inOffset, byte[] out, int outOffset, int length, boolean srcSigned, boolean dstSigned) {
        if (srcSigned == dstSigned) {
            return Array1DUtil.byteArrayToByteArray(in, inOffset, out, outOffset, length);
        }
        int len = ArrayUtil.getCopyLength(in, inOffset, out, outOffset, length);
        byte[] outArray = Array1DUtil.allocIfNull(out, outOffset + len);
        int maxValue = 127;
        int i = 0;
        while (i < len) {
            int value = in[i + inOffset];
            if (value < 0) {
                value = srcSigned ? 0 : 127;
            }
            outArray[i + outOffset] = value;
            ++i;
        }
        return outArray;
    }

    public static long[] doubleArrayToSafeLongArray(double[] array, boolean signed) {
        return Array1DUtil.doubleArrayToSafeLongArray(array, 0, null, 0, array.length, signed);
    }

    public static int[] doubleArrayToSafeIntArray(double[] array, boolean signed) {
        return Array1DUtil.doubleArrayToSafeIntArray(array, 0, null, 0, array.length, signed);
    }

    public static short[] doubleArrayToSafeShortArray(double[] array, boolean signed) {
        return Array1DUtil.doubleArrayToSafeShortArray(array, 0, null, 0, array.length, signed);
    }

    public static byte[] doubleArrayToSafeByteArray(double[] array, boolean signed) {
        return Array1DUtil.doubleArrayToSafeByteArray(array, 0, null, 0, array.length, signed);
    }

    public static long[] floatArrayToSafeLongArray(float[] array, boolean signed) {
        return Array1DUtil.floatArrayToSafeLongArray(array, 0, null, 0, array.length, signed);
    }

    public static int[] floatArrayToSafeIntArray(float[] array, boolean signed) {
        return Array1DUtil.floatArrayToSafeIntArray(array, 0, null, 0, array.length, signed);
    }

    public static short[] floatArrayToSafeShortArray(float[] array, boolean signed) {
        return Array1DUtil.floatArrayToSafeShortArray(array, 0, null, 0, array.length, signed);
    }

    public static byte[] floatArrayToSafeByteArray(float[] array, boolean signed) {
        return Array1DUtil.floatArrayToSafeByteArray(array, 0, null, 0, array.length, signed);
    }

    public static int[] longArrayToSafeIntArray(long[] array, boolean signed) {
        return Array1DUtil.longArrayToSafeIntArray(array, 0, null, 0, array.length, signed, signed);
    }

    public static short[] longArrayToSafeShortArray(long[] array, boolean signed) {
        return Array1DUtil.longArrayToSafeShortArray(array, 0, null, 0, array.length, signed, signed);
    }

    public static byte[] longArrayToSafeByteArray(long[] array, boolean signed) {
        return Array1DUtil.longArrayToSafeByteArray(array, 0, null, 0, array.length, signed, signed);
    }

    public static short[] intArrayToSafeShortArray(int[] array, boolean signed) {
        return Array1DUtil.intArrayToSafeShortArray(array, 0, null, 0, array.length, signed, signed);
    }

    public static byte[] intArrayToSafeByteArray(int[] array, boolean signed) {
        return Array1DUtil.intArrayToSafeByteArray(array, 0, null, 0, array.length, signed, signed);
    }

    public static byte[] shortArrayToSafeByteArray(short[] array, boolean signed) {
        return Array1DUtil.shortArrayToSafeByteArray(array, 0, null, 0, array.length, signed, signed);
    }

    public static String arrayToString(Object array) {
        return Array1DUtil.arrayToString(array, false, false, ":", -1);
    }

    public static String arrayToString(Object array, boolean signed, boolean hexa, String separator, int size) {
        int len = ArrayUtil.getLength(array);
        DataType dataType = ArrayUtil.getDataType(array, signed);
        StringBuilder result = new StringBuilder();
        int base = hexa ? 16 : 10;
        switch (dataType) {
            case UBYTE: {
                byte[] data = (byte[])array;
                if (len > 0) {
                    result.append(Integer.toString(data[0] & 0xFF, base));
                }
                int i = 1;
                while (i < len) {
                    result.append(separator);
                    result.append(Integer.toString(data[i] & 0xFF, base));
                    ++i;
                }
                break;
            }
            case BYTE: {
                byte[] data = (byte[])array;
                if (len > 0) {
                    result.append(Integer.toString(data[0], base));
                }
                int i = 1;
                while (i < len) {
                    result.append(separator);
                    result.append(Integer.toString(data[i], base));
                    ++i;
                }
                break;
            }
            case USHORT: {
                short[] data = (short[])array;
                if (len > 0) {
                    result.append(Integer.toString(data[0] & 0xFFFF, base));
                }
                int i = 1;
                while (i < len) {
                    result.append(separator);
                    result.append(Integer.toString(data[i] & 0xFFFF, base));
                    ++i;
                }
                break;
            }
            case SHORT: {
                short[] data = (short[])array;
                if (len > 0) {
                    result.append(Integer.toString(data[0], base));
                }
                int i = 1;
                while (i < len) {
                    result.append(separator);
                    result.append(Integer.toString(data[i], base));
                    ++i;
                }
                break;
            }
            case UINT: {
                int[] data = (int[])array;
                if (len > 0) {
                    result.append(Long.toString((long)data[0] & 0xFFFFFFFFL, base));
                }
                int i = 1;
                while (i < len) {
                    result.append(separator);
                    result.append(Long.toString((long)data[i] & 0xFFFFFFFFL, base));
                    ++i;
                }
                break;
            }
            case INT: {
                int[] data = (int[])array;
                if (len > 0) {
                    result.append(Integer.toString(data[0], base));
                }
                int i = 1;
                while (i < len) {
                    result.append(separator);
                    result.append(Integer.toString(data[i], base));
                    ++i;
                }
                break;
            }
            case ULONG: {
                long[] data = (long[])array;
                if (len > 0) {
                    result.append(Long.toString(data[0] & Long.MAX_VALUE, base));
                }
                int i = 1;
                while (i < len) {
                    result.append(separator);
                    result.append(Long.toString(data[i] & Long.MAX_VALUE, base));
                    ++i;
                }
                break;
            }
            case LONG: {
                long[] data = (long[])array;
                if (len > 0) {
                    result.append(Long.toString(data[0], base));
                }
                int i = 1;
                while (i < len) {
                    result.append(separator);
                    result.append(Long.toString(data[i], base));
                    ++i;
                }
                break;
            }
            case FLOAT: {
                float[] data = (float[])array;
                if (size == -1) {
                    if (len > 0) {
                        result.append(data[0]);
                    }
                    int i = 1;
                    while (i < len) {
                        result.append(separator);
                        result.append(data[i]);
                        ++i;
                    }
                } else {
                    if (len > 0) {
                        result.append(Double.toString(MathUtil.roundSignificant(data[0], size, true)));
                    }
                    int i = 1;
                    while (i < len) {
                        result.append(separator);
                        result.append(Double.toString(MathUtil.roundSignificant(data[i], size, true)));
                        ++i;
                    }
                }
                break;
            }
            case DOUBLE: {
                double[] data = (double[])array;
                if (size == -1) {
                    if (len > 0) {
                        result.append(data[0]);
                    }
                    int i = 1;
                    while (i < len) {
                        result.append(separator);
                        result.append(data[i]);
                        ++i;
                    }
                } else {
                    if (len > 0) {
                        result.append(Double.toString(MathUtil.roundSignificant(data[0], size, true)));
                    }
                    int i = 1;
                    while (i < len) {
                        result.append(separator);
                        result.append(Double.toString(MathUtil.roundSignificant(data[i], size, true)));
                        ++i;
                    }
                }
                break;
            }
            default: {
                if (len > 0) {
                    result.append(Array.get(array, 0).toString());
                }
                int i = 1;
                while (i < len) {
                    result.append(separator);
                    result.append(Array.get(array, i).toString());
                    ++i;
                }
                break block0;
            }
        }
        return result.toString();
    }

    public static Object stringToArray(String value, DataType dataType) {
        return Array1DUtil.stringToArray(value, dataType, false, ":");
    }

    @Deprecated
    public static Object stringToArray(String value, int dataType) {
        return Array1DUtil.stringToArray(value, DataType.getDataType(dataType), false, ":");
    }

    public static Object stringToArray(String value, DataType dataType, boolean hexa, String separator) {
        if (StringUtil.isEmpty(value)) {
            return Array1DUtil.createArray(dataType, 0);
        }
        String[] values = value.split(separator);
        int len = values.length;
        int base = hexa ? 16 : 10;
        switch (dataType.getJavaType()) {
            case BYTE: {
                byte[] result = new byte[len];
                int i = 0;
                while (i < len) {
                    result[i] = (byte)Integer.parseInt(values[i], base);
                    ++i;
                }
                return result;
            }
            case SHORT: {
                short[] result = new short[len];
                int i = 0;
                while (i < len) {
                    result[i] = (short)Integer.parseInt(values[i], base);
                    ++i;
                }
                return result;
            }
            case INT: {
                int[] result = new int[len];
                int i = 0;
                while (i < len) {
                    result[i] = Integer.parseInt(values[i], base);
                    ++i;
                }
                return result;
            }
            case LONG: {
                long[] result = new long[len];
                int i = 0;
                while (i < len) {
                    result[i] = Long.parseLong(values[i], base);
                    ++i;
                }
                return result;
            }
            case FLOAT: {
                float[] result = new float[len];
                int i = 0;
                while (i < len) {
                    result[i] = Float.parseFloat(values[i]);
                    ++i;
                }
                return result;
            }
            case DOUBLE: {
                double[] result = new double[len];
                int i = 0;
                while (i < len) {
                    result[i] = Double.parseDouble(values[i]);
                    ++i;
                }
                return result;
            }
        }
        return null;
    }

    @Deprecated
    public static Object stringToArray(String value, int dataType, boolean hexa, String separator) {
        return Array1DUtil.stringToArray(value, DataType.getDataType(dataType, false), hexa, separator);
    }

    public static byte[] toByteArray(boolean[] array) {
        return Array1DUtil.toByteArray(array, null, 0);
    }

    public static byte[] toByteArray(boolean[] in, byte[] out, int offset) {
        if (in == null) {
            return new byte[0];
        }
        int len = in.length;
        byte[] result = Array1DUtil.allocIfNull(out, offset + len);
        int i = 0;
        while (i < len) {
            result[i] = (byte)(in[i] ? 1 : 0);
            ++i;
        }
        return result;
    }

    public static boolean[] toBooleanArray(byte[] array) {
        return Array1DUtil.toBooleanArray(array, null, 0);
    }

    public static boolean[] toBooleanArray(byte[] in, boolean[] out, int offset) {
        if (in == null) {
            return new boolean[0];
        }
        int len = in.length;
        boolean[] result = Array1DUtil.allocIfNull(out, offset + len);
        int i = 0;
        while (i < len) {
            result[i] = in[i] != 0;
            ++i;
        }
        return result;
    }

    public static byte[] getInterleavedData(byte[] in, int inOffset, int step, byte[] out, int outOffset, int size) {
        byte[] result = Array1DUtil.allocIfNull(out, outOffset + size);
        int inOff = inOffset;
        int outOff = outOffset;
        int i = 0;
        while (i < size) {
            result[outOff] = in[inOff];
            inOff += step;
            ++outOff;
            ++i;
        }
        return result;
    }

    public static byte[] deInterleave(byte[] in, int inOffset, int step, byte[] out, int outOffset, int size) {
        byte[] result = Array1DUtil.allocIfNull(out, outOffset + size * step);
        int inOff1 = inOffset;
        int outOff1 = outOffset;
        int j = 0;
        while (j < step) {
            int inOff2 = inOff1;
            int outOff2 = outOff1;
            int i = 0;
            while (i < size) {
                result[outOff2] = in[inOff2];
                inOff2 += step;
                ++outOff2;
                ++i;
            }
            ++inOff1;
            outOff1 += size;
            ++j;
        }
        return result;
    }
}

