/*
 * Decompiled with CFR 0.152.
 */
package io.bioimage.modelrunner.example;

import io.bioimage.modelrunner.engine.installation.EngineInstall;
import io.bioimage.modelrunner.versionmanagement.AvailableEngines;
import io.bioimage.modelrunner.versionmanagement.DeepLearningVersion;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.function.Consumer;

public class ExampleDownloadEngine {
    private static final String MODEL_ID = "10.5281/zenodo.5874741";
    private static final String CWD = System.getProperty("user.dir");
    private static final String ENGINES_DIR = new File(CWD, "engines").getAbsolutePath();

    public static void main(String[] args) throws IOException, InterruptedException {
        Consumer<Double> consumer = c -> System.out.println("TOTAL PROGRESS OF THE DOWNLOAD: " + c);
        System.out.println("start");
        EngineInstall.installEnginesForModelByIDInDir(MODEL_ID, ENGINES_DIR, consumer);
        System.out.println("start thread");
        Thread downloadThread = new Thread(() -> {
            try {
                Thread.sleep(5000L);
                String engine = "tensorflow";
                String version = "2.7.0";
                boolean gpu = true;
                boolean cpu = true;
                List<DeepLearningVersion> dlv = AvailableEngines.getEnginesForOsByParams(engine, version, cpu, gpu);
                if (dlv.size() == 0) {
                    throw new IOException("Engine defined is not supported by JDLL.");
                }
                EngineInstall.installEngineInDir(dlv.get(0), ENGINES_DIR, consumer);
            }
            catch (IOException | InterruptedException | ExecutionException e) {
                e.printStackTrace();
            }
        });
        downloadThread.start();
    }
}

