/*
 * Decompiled with CFR 0.152.
 */
package io.bioimage.modelrunner.gui;

import io.bioimage.modelrunner.bioimageio.BioimageioRepo;
import io.bioimage.modelrunner.bioimageio.description.ModelDescriptor;
import io.bioimage.modelrunner.bioimageio.description.ModelDescriptorFactory;
import io.bioimage.modelrunner.gui.DefaultIcon;
import io.bioimage.modelrunner.gui.Header;
import io.bioimage.modelrunner.gui.LogoPanel;
import io.bioimage.modelrunner.gui.adapter.GuiAdapter;
import java.awt.Color;
import java.awt.Desktop;
import java.awt.Font;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;

public class SearchBar
extends JPanel {
    private static final long serialVersionUID = -1741389221668683293L;
    protected JTextField searchField;
    protected LogoPanel bmzLogo;
    protected JButton searchButton;
    protected JButton switchButton;
    private List<ModelDescriptor> bmzModels;
    private int nModels;
    protected static final String SEARCH_ICON_PATH = "jdll_icons/search_logo.png";
    double BUTTONS_PERC = 0.4;

    protected SearchBar() {
        this((GuiAdapter)null);
    }

    protected SearchBar(GuiAdapter adapter) {
        this.setLayout(null);
        this.setBackground(Color.WHITE);
        this.setBorder(BorderFactory.createLineBorder(Color.LIGHT_GRAY, 1, true));
        URL iconPath = this.getClass().getClassLoader().getResource(SEARCH_ICON_PATH);
        this.bmzLogo = new LogoPanel();
        if (adapter != null) {
            DefaultIcon.drawImOrLogo(Header.class.getClassLoader().getResource(adapter.getIconPath()), iconPath, this.bmzLogo);
        } else {
            DefaultIcon.drawImOrLogo(iconPath, iconPath, this.bmzLogo);
        }
        this.bmzLogo.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                try {
                    Desktop.getDesktop().browse(new URL("https://www.bioimage.io").toURI());
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        });
        this.bmzLogo.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.searchField = new JTextField();
        this.searchField.setBorder(null);
        this.searchField.setFont(new Font("Arial", 0, 14));
        this.searchButton = new JButton("Search");
        this.searchButton.setBackground(new Color(0, 120, 215));
        this.searchButton.setForeground(Color.WHITE);
        this.searchButton.setFocusPainted(false);
        this.searchButton.setBorder(BorderFactory.createEmptyBorder(5, 10, 5, 10));
        this.switchButton = new JButton("Bioimage.io");
        this.switchButton.setBackground(new Color(255, 140, 0));
        this.switchButton.setForeground(Color.BLACK);
        this.switchButton.setFocusPainted(false);
        this.switchButton.setBorder(BorderFactory.createEmptyBorder(5, 10, 5, 10));
        this.add(this.bmzLogo);
        this.add(this.searchField);
        this.add(this.searchButton);
        this.add(this.switchButton);
        this.organiseComponents();
    }

    private void organiseComponents() {
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                SearchBar.this.layoutAll();
            }
        });
    }

    private void layoutAll() {
        int W = this.getWidth();
        int H = this.getHeight();
        this.bmzLogo.setBounds(0, 0, H, H);
        int searchW = (int)((double)(W - H) * (1.0 - this.BUTTONS_PERC));
        this.searchField.setBounds(H, 0, searchW, H);
        int buttonW = (int)(0.5 * (double)(W - H) * this.BUTTONS_PERC);
        this.searchButton.setBounds(H + searchW, 0, buttonW, H);
        this.switchButton.setBounds(W - buttonW, 0, buttonW, H);
    }

    protected List<ModelDescriptor> performSearch() {
        String searchText = this.searchField.getText().trim().toLowerCase();
        return this.bmzModels.stream().filter(mm -> {
            if (mm == null) {
                return false;
            }
            return mm.getName().toLowerCase().contains(searchText) || mm.getDescription().toLowerCase().contains(searchText) || mm.getNickname().toLowerCase().contains(searchText) || mm.getTags().contains(searchText);
        }).collect(Collectors.toList());
    }

    protected int countBMZModels() throws InterruptedException {
        return this.countBMZModels(false);
    }

    protected int countBMZModels(boolean recount) throws InterruptedException {
        if (!recount) {
            return this.nModels;
        }
        BioimageioRepo.connect();
        this.nModels = BioimageioRepo.getModelIDs().size();
        return this.nModels;
    }

    protected List<ModelDescriptor> findBMZModels() throws InterruptedException {
        this.bmzModels = new ArrayList<ModelDescriptor>();
        for (String url : BioimageioRepo.getModelIDs()) {
            ModelDescriptor descriptor = BioimageioRepo.retreiveDescriptorFromURL(BioimageioRepo.getModelURL(url) + "rdf.yaml");
            if (descriptor == null) continue;
            this.bmzModels.add(descriptor);
        }
        return this.bmzModels;
    }

    protected void findLocalModels(String dir) {
        this.bmzModels = ModelDescriptorFactory.getModelsAtLocalRepo(dir);
    }

    protected List<ModelDescriptor> getBMZModels() {
        return this.bmzModels;
    }

    protected void setModels(List<ModelDescriptor> models) {
        this.bmzModels = models;
    }

    protected boolean isBMZPArsingDone() {
        return this.nModels == this.bmzModels.size();
    }

    protected void changeButtonToLocal() {
        this.switchButton.setText("Local");
    }

    protected void changeButtonToBMZ() {
        this.switchButton.setText("Bioimage.io");
    }

    protected boolean isBarOnLocal() {
        return this.switchButton.getText().equals("Bioimage.io");
    }

    protected void setBarEnabled(boolean enabled) {
        this.searchButton.setEnabled(enabled);
        this.switchButton.setEnabled(enabled);
        this.searchField.setEnabled(enabled);
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JFrame frame = new JFrame("Modern Search Bar");
                frame.setDefaultCloseOperation(3);
                frame.getContentPane().add(new SearchBar());
                frame.pack();
                frame.setLocationRelativeTo(null);
                frame.setVisible(true);
            }
        });
    }
}

