/*
 * Decompiled with CFR 0.152.
 */
package plugins.adufour.blocks.util;

import icy.gui.menu.PluginMenuItem;
import icy.image.ImageUtil;
import icy.plugin.PluginDescriptor;
import icy.plugin.PluginLoader;
import icy.plugin.abstract_.Plugin;
import icy.resource.ResourceUtil;
import icy.resource.icon.IcyIcon;
import icy.system.SystemUtil;
import icy.util.ClassUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.TransferHandler;
import plugins.adufour.blocks.lang.Block;
import plugins.adufour.blocks.lang.BlockDescriptor;
import plugins.adufour.blocks.lang.Loop;
import plugins.adufour.blocks.lang.WorkFlow;
import plugins.adufour.blocks.tools.Display;
import plugins.adufour.blocks.tools.ReLoop;
import plugins.adufour.blocks.tools.ToolsBlock;
import plugins.adufour.blocks.tools.ij.IJBlock;
import plugins.adufour.blocks.tools.input.InputBlock;
import plugins.adufour.blocks.tools.io.IOBlock;
import plugins.adufour.blocks.tools.output.OutputBlock;
import plugins.adufour.blocks.tools.roi.ROIBlock;
import plugins.adufour.blocks.tools.sequence.SequenceBlock;
import plugins.adufour.blocks.util.MenuItemListener;
import plugins.adufour.protocols.gui.BlockSearchPanel;
import plugins.adufour.protocols.gui.block.WorkFlowContainer;

public class BlocksFinder {
    public final boolean parseAnnotations = false;

    public void createSearchMenu(BlockSearchPanel menuContainer, String searchText) {
        ArrayList<PluginDescriptor> plugins = PluginLoader.getPlugins(Block.class, true, false, false);
        if (plugins.size() == 0) {
            JMenuItem item = new JMenuItem("The plug-in list has been updated.\nPlease close and re-open the Protocols editor.");
            item.setFont(item.getFont().deriveFont(2));
            menuContainer.add(item);
            return;
        }
        for (PluginDescriptor descriptor : plugins) {
            Class<? extends Plugin> _class = descriptor.getPluginClass();
            Class<Block> blockClass = _class.asSubclass(Block.class);
            if (ClassUtil.isAbstract(blockClass) || ClassUtil.isPrivate(blockClass)) continue;
            String testString = "block";
            testString = testString + descriptor.getName();
            testString = testString + blockClass.getSimpleName();
            testString = testString + descriptor.getDescription();
            testString = testString + descriptor.getAuthor();
            testString = testString.toLowerCase();
            searchText = searchText.trim().toLowerCase();
            String searchTextNoSpaces = searchText.replace(" ", "");
            if (!testString.contains(searchText) && !testString.contains(searchTextNoSpaces)) continue;
            DND_MenuItem menuItem = new DND_MenuItem(descriptor);
            menuItem.addMenuItemListener(menuContainer);
            menuItem.setMaximumSize(new Dimension(Integer.MAX_VALUE, 35));
            menuItem.setAlignmentX(0.0f);
            String name = blockClass.getSimpleName();
            String string = name = descriptor.getName().equalsIgnoreCase(name) ? BlocksFinder.getFlattened(name) : descriptor.getName();
            if (name.toLowerCase().endsWith("block")) {
                name = name.substring(0, name.length() - 5);
            }
            if (blockClass.isAnnotationPresent(Deprecated.class)) {
                name = "(deprecated) " + name;
            }
            menuItem.setText(name);
            menuContainer.add(menuItem);
        }
    }

    public final void createJMenu(Container menuContainer, final WorkFlowContainer workFlowPane, final Point location) {
        JMenu mnBlocks = new JMenu("Blocks...");
        mnBlocks.setIcon((Icon)((Object)new IcyIcon(ResourceUtil.getAlphaIconAsImage("box.png"), 22)));
        JMenu mnInput = new JMenu("Read...");
        mnInput.setIcon((Icon)((Object)new IcyIcon(ResourceUtil.ICON_REDO, 22)));
        JMenu mnOutput = new JMenu("Out...");
        mnOutput.setIcon((Icon)((Object)new IcyIcon(ResourceUtil.ICON_UNDO, 22)));
        JMenu mnIO = new JMenu("I/O...");
        mnIO.setIcon((Icon)((Object)new IcyIcon(ResourceUtil.ICON_SAVE, 22)));
        JMenu mnSeq = new JMenu("Sequence...");
        mnSeq.setIcon((Icon)((Object)new IcyIcon(ResourceUtil.ICON_PHOTO, 22)));
        JMenu mnROI = new JMenu("ROI...");
        mnROI.setIcon((Icon)((Object)new IcyIcon(ResourceUtil.ICON_ROI_POLYGON, 22)));
        JMenu mnImageJ = new JMenu("ImageJ...");
        mnImageJ.setIcon((Icon)((Object)new IcyIcon(ResourceUtil.ICON_TOIJ, 22)));
        JMenu mnLoops = new JMenu("Loop / Batch...");
        mnLoops.setIcon((Icon)((Object)new IcyIcon(ResourceUtil.ICON_RELOAD, 22)));
        JMenu mnTools = new JMenu("Tools...");
        mnTools.setIcon((Icon)((Object)new IcyIcon(ResourceUtil.ICON_TOOLS, 22)));
        ArrayList<PluginDescriptor> plugins = PluginLoader.getPlugins(Block.class, true, false, false);
        if (plugins.size() == 0) {
            JMenuItem item = new JMenuItem("The plug-in list has been updated.\nPlease close and re-open the Protocols editor.");
            item.setFont(item.getFont().deriveFont(2));
            menuContainer.add(item);
            return;
        }
        for (PluginDescriptor descriptor : plugins) {
            Class<? extends Plugin> clazz = descriptor.getPluginClass();
            try {
                final Class<Block> blockClass = clazz.asSubclass(Block.class);
                if (ClassUtil.isAbstract(blockClass) || ClassUtil.isPrivate(blockClass) || blockClass.isAnnotationPresent(Deprecated.class)) continue;
                PluginMenuItem menuItem = new PluginMenuItem(descriptor);
                menuItem.removeActionListener(menuItem);
                String name = blockClass.getSimpleName();
                String string = name = descriptor.getName().equalsIgnoreCase(name) ? BlocksFinder.getFlattened(name) : descriptor.getName();
                if (name.toLowerCase().endsWith("block")) {
                    name = name.substring(0, name.length() - 5);
                }
                menuItem.setText(name);
                if (!descriptor.getDescription().isEmpty()) {
                    menuItem.setToolTipText("<html>" + descriptor.getDescription().replaceAll("\n", "<br/>") + "</html>");
                }
                menuItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent arg0) {
                        try {
                            BlocksFinder.addBlock(workFlowPane, (Block)blockClass.newInstance(), location);
                        }
                        catch (InstantiationException e1) {
                            e1.printStackTrace();
                        }
                        catch (IllegalAccessException e1) {
                            e1.printStackTrace();
                        }
                    }
                });
                if (blockClass == Display.class) continue;
                if (ClassUtil.isSubClass(blockClass, Loop.class) && !blockClass.isAnnotationPresent(Deprecated.class)) {
                    JMenuItem item = new JMenuItem(BlocksFinder.getFlattened(blockClass.getSimpleName()));
                    item.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent arg0) {
                            try {
                                BlocksFinder.addBlock(workFlowPane, (Block)blockClass.newInstance(), location);
                            }
                            catch (InstantiationException e1) {
                                e1.printStackTrace();
                            }
                            catch (IllegalAccessException e1) {
                                e1.printStackTrace();
                            }
                        }
                    });
                    mnLoops.add(item);
                    continue;
                }
                if (InputBlock.class.isAssignableFrom(blockClass)) {
                    mnInput.add(menuItem);
                    continue;
                }
                if (OutputBlock.class.isAssignableFrom(blockClass)) {
                    mnOutput.add(menuItem);
                    continue;
                }
                if (SequenceBlock.class.isAssignableFrom(blockClass)) {
                    mnSeq.add(menuItem);
                    continue;
                }
                if (IOBlock.class.isAssignableFrom(blockClass)) {
                    mnIO.add(menuItem);
                    continue;
                }
                if (ROIBlock.class.isAssignableFrom(blockClass)) {
                    mnROI.add(menuItem);
                    continue;
                }
                if (IJBlock.class.isAssignableFrom(blockClass)) {
                    mnImageJ.add(menuItem);
                    continue;
                }
                if (ToolsBlock.class.isAssignableFrom(blockClass)) {
                    if (blockClass == ReLoop.class) continue;
                    mnTools.add(menuItem);
                    continue;
                }
                mnBlocks.add(menuItem);
            }
            catch (ClassCastException classCastException) {}
        }
        this.splitLongMenus(mnBlocks, 15);
        this.splitLongMenus(mnInput, 15);
        this.splitLongMenus(mnOutput, 15);
        this.splitLongMenus(mnSeq, 15);
        this.splitLongMenus(mnROI, 15);
        this.splitLongMenus(mnIO, 15);
        this.splitLongMenus(mnImageJ, 15);
        this.splitLongMenus(mnLoops, 15);
        this.splitLongMenus(mnTools, 15);
        menuContainer.add(mnBlocks);
        menuContainer.add(mnInput);
        menuContainer.add(mnOutput);
        menuContainer.add(mnSeq);
        menuContainer.add(mnROI);
        menuContainer.add(mnIO);
        menuContainer.add(mnImageJ);
        menuContainer.add(mnLoops);
        menuContainer.add(mnTools);
        JMenuItem mnDisp = new JMenuItem("Display");
        mnDisp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                try {
                    BlocksFinder.addBlock(workFlowPane, (Block)Display.class.newInstance(), location);
                }
                catch (InstantiationException e1) {
                    e1.printStackTrace();
                }
                catch (IllegalAccessException e1) {
                    e1.printStackTrace();
                }
            }
        });
        mnDisp.setIcon((Icon)((Object)new IcyIcon(ImageUtil.scaleQuality(ResourceUtil.getAlphaIconAsImage("eye_open.png"), 22, 22))));
        menuContainer.add(mnDisp);
    }

    public static void createEmbedJMenu(Container menuContainer, final WorkFlowContainer workFlowPane) {
        for (PluginDescriptor plugin : PluginLoader.getPlugins(WorkFlow.class)) {
            JMenuItem menuItem = new JMenuItem(BlocksFinder.getFlattened(plugin.getName()));
            final PluginDescriptor pf = plugin;
            menuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    try {
                        workFlowPane.embedWorkFlow(pf.getPluginClass().asSubclass(WorkFlow.class));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            });
            menuContainer.add(menuItem);
        }
    }

    private static void addBlock(WorkFlowContainer workFlowPane, Block block, Point location) {
        BlockDescriptor blockDesc = block instanceof WorkFlow ? ((WorkFlow)block).getBlockDescriptor() : new BlockDescriptor(-1, block);
        blockDesc.setLocation(location.x, location.y);
        workFlowPane.getWorkFlow().addBlock(blockDesc);
    }

    private void splitLongMenus(JMenu menu, int maxItemsPerMenu) {
        ArrayList<Component> components = new ArrayList<Component>(Arrays.asList(menu.getPopupMenu().getComponents()));
        if (components.size() > maxItemsPerMenu) {
            menu.removeAll();
            JMenu currentMenu = menu;
            while (components.size() > 0) {
                int n = Math.min(components.size(), maxItemsPerMenu - 1);
                for (int i = 0; i < n; ++i) {
                    currentMenu.add(components.remove(0));
                }
                if (components.size() <= 0) continue;
                currentMenu = (JMenu)currentMenu.add(new JMenu("More..."));
            }
            if (components.size() > 0) {
                throw new RuntimeException("Error while splitting menus: " + components.size() + " are remaining.");
            }
        }
        for (Component component : menu.getPopupMenu().getComponents()) {
            if (!(component instanceof JMenu)) continue;
            this.splitLongMenus((JMenu)component, maxItemsPerMenu);
        }
    }

    public static String getFlattened(String string) {
        String[] words = string.split("(?=[A-Z])");
        String output = words[0];
        if (words.length > 1) {
            int nextWordIndex = 1;
            int javaVersion = (int)SystemUtil.getJavaVersionAsNumber();
            if (javaVersion < 8) {
                output = words[1];
                ++nextWordIndex;
            }
            for (int i = nextWordIndex; i < words.length; ++i) {
                String word = words[i];
                if (word.length() == 1) {
                    if (words[i - 1].length() == 1) {
                        output = output + word;
                        continue;
                    }
                    output = output + " " + word;
                    continue;
                }
                output = output + " " + word.toLowerCase();
            }
        }
        return output;
    }

    public class DND_MenuItem
    extends PluginMenuItem
    implements MouseListener,
    Transferable,
    DragSourceListener,
    DragGestureListener {
        private DragSource source;
        private TransferHandler handler;
        private PluginDescriptor descriptor;
        private List<MenuItemListener> menuItemListeners;

        public DND_MenuItem(PluginDescriptor d) {
            super(d);
            this.setOpaque(false);
            for (MouseListener listener : this.getMouseListeners()) {
                this.removeMouseListener(listener);
            }
            this.descriptor = d;
            this.menuItemListeners = new ArrayList<MenuItemListener>();
            this.handler = new TransferHandler(){

                @Override
                public Transferable createTransferable(JComponent c) {
                    return new DND_MenuItem(DND_MenuItem.this.descriptor);
                }
            };
            this.source = new DragSource();
            this.source.createDefaultDragGestureRecognizer(this, 1, this);
            this.setTransferHandler(this.handler);
            this.addMouseListener(this);
        }

        public PluginDescriptor getDescriptor() {
            return this.descriptor;
        }

        @Override
        public void dragGestureRecognized(DragGestureEvent dge) {
            this.source.startDrag(dge, DragSource.DefaultMoveDrop, new DND_MenuItem(this.descriptor), this);
        }

        @Override
        public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
            return this;
        }

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            try {
                return new DataFlavor[]{new DataFlavor("application/x-java-jvm-local-objectref;class=java.util.ArrayList")};
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
                return null;
            }
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor flavor) {
            return true;
        }

        @Override
        public void mouseClicked(MouseEvent arg0) {
            this.setBackground(Color.GRAY);
            this.notifyListeners();
        }

        public void addMenuItemListener(MenuItemListener l) {
            this.menuItemListeners.add(l);
        }

        private void notifyListeners() {
            for (MenuItemListener l : this.menuItemListeners) {
                l.displayDoc(this.descriptor);
            }
        }

        @Override
        public void dragDropEnd(DragSourceDropEvent dsde) {
            this.setBackground(Color.GRAY);
            this.notifyListeners();
        }

        @Override
        public void dragEnter(DragSourceDragEvent dsde) {
        }

        @Override
        public void dragExit(DragSourceEvent dse) {
        }

        @Override
        public void dragOver(DragSourceDragEvent dsde) {
        }

        @Override
        public void dropActionChanged(DragSourceDragEvent dsde) {
        }

        @Override
        public void mouseEntered(MouseEvent arg0) {
        }

        @Override
        public void mouseExited(MouseEvent arg0) {
        }

        @Override
        public void mousePressed(MouseEvent arg0) {
        }

        @Override
        public void mouseReleased(MouseEvent arg0) {
        }
    }
}

