/*
 * Decompiled with CFR 0.152.
 */
package io.bioimage.modelrunner.numpy;

import io.bioimage.modelrunner.tensor.Tensor;
import java.nio.ByteBuffer;
import net.imglib2.Cursor;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.img.Img;
import net.imglib2.type.NativeType;
import net.imglib2.type.numeric.RealType;
import net.imglib2.type.numeric.integer.ByteType;
import net.imglib2.type.numeric.integer.IntType;
import net.imglib2.type.numeric.real.DoubleType;
import net.imglib2.type.numeric.real.FloatType;
import net.imglib2.util.Cast;
import net.imglib2.util.Util;
import net.imglib2.view.IntervalView;

public class DecodeImgLib2 {
    public static <T extends RealType<T> & NativeType<T>> byte[] tensorDataToByteArray(Tensor<T> tensor) {
        return DecodeImgLib2.imglib2ToByteArray(tensor.getData());
    }

    public static <T extends RealType<T> & NativeType<T>> byte[] imglib2ToByteArray(RandomAccessibleInterval<T> rai) {
        if (Util.getTypeFromInterval(rai) instanceof ByteType) {
            return (byte[])Cast.unchecked((Object)DecodeImgLib2.buildByte((RandomAccessibleInterval<ByteType>)((RandomAccessibleInterval)Cast.unchecked(rai))));
        }
        if (Util.getTypeFromInterval(rai) instanceof IntType) {
            return (byte[])Cast.unchecked((Object)DecodeImgLib2.buildInt((RandomAccessibleInterval<IntType>)((RandomAccessibleInterval)Cast.unchecked(rai))));
        }
        if (Util.getTypeFromInterval(rai) instanceof FloatType) {
            return (byte[])Cast.unchecked((Object)DecodeImgLib2.buildFloat((RandomAccessibleInterval<FloatType>)((RandomAccessibleInterval)Cast.unchecked(rai))));
        }
        if (Util.getTypeFromInterval(rai) instanceof DoubleType) {
            return (byte[])Cast.unchecked((Object)DecodeImgLib2.buildDouble((RandomAccessibleInterval<DoubleType>)((RandomAccessibleInterval)Cast.unchecked(rai))));
        }
        throw new IllegalArgumentException("The image has an unsupported type: " + ((RealType)Util.getTypeFromInterval(rai)).getClass().toString());
    }

    private static byte[] buildByte(RandomAccessibleInterval<ByteType> imgTensor) {
        Cursor tensorCursor;
        if (imgTensor instanceof IntervalView) {
            tensorCursor = ((IntervalView)imgTensor).cursor();
        } else if (imgTensor instanceof Img) {
            tensorCursor = ((Img)imgTensor).cursor();
        } else {
            throw new IllegalArgumentException("The data of the " + Tensor.class + " has to be an instance of " + Img.class + " or " + IntervalView.class);
        }
        long flatSize = 1L;
        for (long ss : imgTensor.dimensionsAsLongArray()) {
            flatSize *= ss;
        }
        byte[] byteArr = new byte[(int)flatSize];
        int cc = 0;
        while (tensorCursor.hasNext()) {
            tensorCursor.fwd();
            byteArr[cc++] = ((ByteType)tensorCursor.get()).getByte();
        }
        return byteArr;
    }

    private static byte[] buildInt(RandomAccessibleInterval<IntType> imgTensor) {
        Cursor tensorCursor;
        if (imgTensor instanceof IntervalView) {
            tensorCursor = ((IntervalView)imgTensor).cursor();
        } else if (imgTensor instanceof Img) {
            tensorCursor = ((Img)imgTensor).cursor();
        } else {
            throw new IllegalArgumentException("The data of the " + Tensor.class + " has to be an instance of " + Img.class + " or " + IntervalView.class);
        }
        long flatSize = 4L;
        for (long ss : imgTensor.dimensionsAsLongArray()) {
            flatSize *= ss;
        }
        byte[] byteArr = new byte[(int)flatSize];
        int cc = 0;
        while (tensorCursor.hasNext()) {
            tensorCursor.fwd();
            int val = ((IntType)tensorCursor.get()).getInt();
            byte[] arr = ByteBuffer.allocate(4).putInt(val).array();
            System.arraycopy(arr, 0, byteArr, cc * 4, 4);
            ++cc;
        }
        return byteArr;
    }

    private static byte[] buildFloat(RandomAccessibleInterval<FloatType> imgTensor) {
        Cursor tensorCursor;
        if (imgTensor instanceof IntervalView) {
            tensorCursor = ((IntervalView)imgTensor).cursor();
        } else if (imgTensor instanceof Img) {
            tensorCursor = ((Img)imgTensor).cursor();
        } else {
            throw new IllegalArgumentException("The data of the " + Tensor.class + " has to be an instance of " + Img.class + " or " + IntervalView.class);
        }
        long flatSize = 4L;
        for (long ss : imgTensor.dimensionsAsLongArray()) {
            flatSize *= ss;
        }
        byte[] byteArr = new byte[(int)flatSize];
        int cc = 0;
        while (tensorCursor.hasNext()) {
            tensorCursor.fwd();
            float val = ((FloatType)tensorCursor.get()).getRealFloat();
            byte[] arr = ByteBuffer.allocate(4).putFloat(val).array();
            System.arraycopy(arr, 0, byteArr, cc * 4, 4);
            ++cc;
        }
        return byteArr;
    }

    private static byte[] buildDouble(RandomAccessibleInterval<DoubleType> imgTensor) {
        Cursor tensorCursor;
        if (imgTensor instanceof IntervalView) {
            tensorCursor = ((IntervalView)imgTensor).cursor();
        } else if (imgTensor instanceof Img) {
            tensorCursor = ((Img)imgTensor).cursor();
        } else {
            throw new IllegalArgumentException("The data of the " + Tensor.class + " has to be an instance of " + Img.class + " or " + IntervalView.class);
        }
        long flatSize = 8L;
        for (long ss : imgTensor.dimensionsAsLongArray()) {
            flatSize *= ss;
        }
        byte[] byteArr = new byte[(int)flatSize];
        int cc = 0;
        while (tensorCursor.hasNext()) {
            tensorCursor.fwd();
            double val = ((DoubleType)tensorCursor.get()).getRealDouble();
            byte[] arr = ByteBuffer.allocate(4).putDouble(val).array();
            System.arraycopy(arr, 0, byteArr, cc * 8, 8);
            ++cc;
        }
        return byteArr;
    }
}

