/*
 * Decompiled with CFR 0.152.
 */
package icy.type.collection.list;

import icy.preferences.XMLPreferences;
import icy.type.collection.list.RecentListEvent;
import icy.type.collection.list.RecentListListener;
import java.util.ArrayList;
import javax.swing.event.EventListenerList;

public abstract class RecentList {
    public static final String ID_ENTRY = "entry";
    protected final XMLPreferences preferences;
    protected final int nbMaxEntry;
    protected final ArrayList<Object> list;
    private final EventListenerList listeners;

    public RecentList(XMLPreferences preferences, int nbMaxEntry) {
        this.preferences = preferences;
        this.nbMaxEntry = nbMaxEntry;
        this.list = new ArrayList();
        this.listeners = new EventListenerList();
        this.load();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        ArrayList<Object> arrayList = this.list;
        synchronized (arrayList) {
            this.list.clear();
        }
        this.save();
        this.changed();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEntry(Object entry) {
        ArrayList<Object> arrayList = this.list;
        synchronized (arrayList) {
            this.list.remove(entry);
            this.list.add(0, entry);
            while (this.list.size() > this.nbMaxEntry) {
                this.list.remove(this.list.size() - 1);
            }
        }
        this.save();
        this.changed();
    }

    public int getSize() {
        return this.list.size();
    }

    public int getMaxSize() {
        return this.nbMaxEntry;
    }

    public Object getEntry(int index) {
        return this.list.get(index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void load() {
        ArrayList<Object> arrayList = this.list;
        synchronized (arrayList) {
            this.list.clear();
            int i = 0;
            while (i < this.nbMaxEntry) {
                Object value = this.loadEntry(ID_ENTRY + i);
                if (value != null) {
                    this.list.add(value);
                }
                ++i;
            }
        }
        this.changed();
    }

    protected abstract Object loadEntry(String var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void save() {
        this.preferences.clear();
        this.preferences.removeChildren();
        this.preferences.clean();
        ArrayList<Object> arrayList = this.list;
        synchronized (arrayList) {
            int i = 0;
            while (i < this.nbMaxEntry) {
                if (i < this.list.size()) {
                    this.saveEntry(ID_ENTRY + i, this.list.get(i));
                } else {
                    this.saveEntry(ID_ENTRY + i, null);
                }
                ++i;
            }
        }
    }

    protected abstract void saveEntry(String var1, Object var2);

    protected void changed() {
        RecentListEvent event = new RecentListEvent(this, RecentListEvent.RecentListEventType.CHANGED);
        this.fireEvent(event);
    }

    public void addListener(RecentListListener listener) {
        this.listeners.add(RecentListListener.class, listener);
    }

    public void removeListener(RecentListListener listener) {
        this.listeners.remove(RecentListListener.class, listener);
    }

    public void fireEvent(RecentListEvent e) {
        RecentListListener[] recentListListenerArray = (RecentListListener[])this.listeners.getListeners(RecentListListener.class);
        int n = recentListListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            RecentListListener listener = recentListListenerArray[n2];
            listener.RencentFileChanged(e);
            ++n2;
        }
    }
}

