/*
 * Decompiled with CFR 0.152.
 */
package icy.gui.component.button;

import icy.action.IcyAbstractAction;
import icy.resource.icon.IcyIcon;
import icy.util.StringUtil;
import java.awt.Image;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.pushingpixels.flamingo.api.common.JCommandButton;
import org.pushingpixels.flamingo.api.common.RichTooltip;
import org.pushingpixels.flamingo.api.common.icon.ResizableIcon;
import org.pushingpixels.flamingo.api.common.popup.PopupPanelCallback;

public class IcyCommandButton
extends JCommandButton {
    private static final long serialVersionUID = 6430339971361017326L;
    private boolean internalEnabled = this.isEnabled();
    private IcyAbstractAction action = null;
    private final PropertyChangeListener actionPropertyChangeListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (StringUtil.equals("enabled", evt.getPropertyName())) {
                IcyCommandButton.this.refreshEnabled();
            }
        }
    };

    public IcyCommandButton(String title, IcyIcon icon) {
        super(title, (ResizableIcon)icon);
    }

    @Deprecated
    public IcyCommandButton(String title, Image icon) {
        this(title, new IcyIcon(icon));
    }

    @Deprecated
    public IcyCommandButton(String title, String iconName) {
        this(title, new IcyIcon(iconName));
    }

    public IcyCommandButton(IcyIcon icon) {
        this(null, icon);
    }

    public IcyCommandButton(String title) {
        this(title, (IcyIcon)null);
    }

    public IcyCommandButton(IcyAbstractAction action) {
        this((String)null, (IcyIcon)null);
        this.setAction(action);
    }

    @Deprecated
    public IcyCommandButton(icy.common.IcyAbstractAction action) {
        this((String)null, (IcyIcon)null);
        this.setAction(action);
    }

    public IcyCommandButton() {
        this((String)null, (IcyIcon)null);
    }

    public IcyIcon getIcyIcon() {
        ResizableIcon icon = this.getIcon();
        if (icon instanceof IcyIcon) {
            return (IcyIcon)icon;
        }
        return null;
    }

    public String getIconName() {
        IcyIcon icon = this.getIcyIcon();
        if (icon != null) {
            return icon.getName();
        }
        return null;
    }

    public void setIconName(String iconName) {
        IcyIcon icon = this.getIcyIcon();
        if (icon != null) {
            icon.setName(iconName);
        }
    }

    public void setEnabled(boolean b) {
        this.internalEnabled = b;
        this.refreshEnabled();
    }

    protected void refreshEnabled() {
        super.setEnabled(this.internalEnabled && (this.action == null || this.action.isEnabled()));
    }

    public IcyAbstractAction getAction() {
        return this.action;
    }

    public void setAction(IcyAbstractAction value) {
        if (this.action != value) {
            if (this.action != null) {
                this.removeActionListener(this.action);
                this.action.removePropertyChangeListener(this.actionPropertyChangeListener);
            }
            this.action = value;
            this.setCommandButtonKind(JCommandButton.CommandButtonKind.ACTION_ONLY);
            if (value != null) {
                this.setText(this.action.getName());
                IcyIcon icon = this.action.getIcon();
                if (icon != null) {
                    this.setIcon(new IcyIcon(icon));
                } else {
                    this.setIcon(null);
                }
                this.setActionRichTooltip(this.action.getRichToolTip());
                this.addActionListener(value);
                value.addPropertyChangeListener(this.actionPropertyChangeListener);
            }
            this.refreshEnabled();
        }
    }

    public void setPopup(PopupPanelCallback cb, RichTooltip toolTip) {
        this.setAction(null);
        this.setCommandButtonKind(JCommandButton.CommandButtonKind.POPUP_ONLY);
        if (cb != null) {
            this.setPopupCallback(cb);
        }
        if (toolTip != null) {
            this.setPopupRichTooltip(toolTip);
        }
        this.refreshEnabled();
    }
}

