/*
 * Decompiled with CFR 0.152.
 */
package plugins.kernel.roi.descriptor.measure;

import icy.plugin.abstract_.Plugin;
import icy.plugin.interface_.PluginROIDescriptor;
import icy.roi.ROI;
import icy.roi.ROIDescriptor;
import icy.roi.ROIIterator;
import icy.sequence.Sequence;
import icy.type.point.Point5D;
import icy.type.rectangle.Rectangle5D;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import plugins.kernel.roi.descriptor.measure.ROIMassCenterCDescriptor;
import plugins.kernel.roi.descriptor.measure.ROIMassCenterTDescriptor;
import plugins.kernel.roi.descriptor.measure.ROIMassCenterXDescriptor;
import plugins.kernel.roi.descriptor.measure.ROIMassCenterYDescriptor;
import plugins.kernel.roi.descriptor.measure.ROIMassCenterZDescriptor;
import plugins.kernel.roi.roi2d.ROI2DPoint;
import plugins.kernel.roi.roi3d.ROI3DPoint;

public class ROIMassCenterDescriptorsPlugin
extends Plugin
implements PluginROIDescriptor {
    public static final String ID_MASS_CENTER_X = "Mass center X";
    public static final String ID_MASS_CENTER_Y = "Mass center Y";
    public static final String ID_MASS_CENTER_Z = "Mass center Z";
    public static final String ID_MASS_CENTER_T = "Mass center T";
    public static final String ID_MASS_CENTER_C = "Mass center C";
    public static final ROIMassCenterXDescriptor massCenterXDescriptor = new ROIMassCenterXDescriptor();
    public static final ROIMassCenterYDescriptor massCenterYDescriptor = new ROIMassCenterYDescriptor();
    public static final ROIMassCenterZDescriptor massCenterZDescriptor = new ROIMassCenterZDescriptor();
    public static final ROIMassCenterTDescriptor massCenterTDescriptor = new ROIMassCenterTDescriptor();
    public static final ROIMassCenterCDescriptor massCenterCDescriptor = new ROIMassCenterCDescriptor();

    public static Point5D computeMassCenter(ROI roi) throws InterruptedException {
        Rectangle5D bounds = roi.getBounds5D();
        if (bounds.isEmpty()) {
            return bounds.getPosition();
        }
        if (roi instanceof ROI2DPoint || roi instanceof ROI3DPoint) {
            return bounds.getPosition();
        }
        ROIIterator it = new ROIIterator(roi, true);
        double x = 0.0;
        double y = 0.0;
        double z = 0.0;
        double t = 0.0;
        double c = 0.0;
        long numPts = 0L;
        while (!it.done()) {
            if ((numPts & 0xFFFFL) == 0L && Thread.interrupted()) {
                throw new InterruptedException("ROI mass center descriptor computation interrupted.");
            }
            x += (double)it.getX();
            y += (double)it.getY();
            z += (double)it.getZ();
            t += (double)it.getT();
            c += (double)it.getC();
            it.next();
            ++numPts;
        }
        if (numPts == 0L) {
            return new Point5D.Double();
        }
        return new Point5D.Double(x / (double)numPts, y / (double)numPts, z / (double)numPts, t / (double)numPts, c / (double)numPts);
    }

    @Override
    public List<ROIDescriptor> getDescriptors() {
        ArrayList<ROIDescriptor> result = new ArrayList<ROIDescriptor>();
        result.add(massCenterXDescriptor);
        result.add(massCenterYDescriptor);
        result.add(massCenterZDescriptor);
        result.add(massCenterTDescriptor);
        result.add(massCenterCDescriptor);
        return result;
    }

    @Override
    public Map<ROIDescriptor, Object> compute(ROI roi, Sequence sequence) throws InterruptedException {
        HashMap<ROIDescriptor, Object> result = new HashMap<ROIDescriptor, Object>();
        Point5D massCenter = ROIMassCenterDescriptorsPlugin.computeMassCenter(roi);
        result.put(massCenterXDescriptor, ROIMassCenterXDescriptor.getMassCenterX(massCenter));
        result.put(massCenterYDescriptor, ROIMassCenterYDescriptor.getMassCenterY(massCenter));
        result.put(massCenterZDescriptor, ROIMassCenterZDescriptor.getMassCenterZ(massCenter));
        result.put(massCenterTDescriptor, ROIMassCenterTDescriptor.getMassCenterT(massCenter));
        result.put(massCenterCDescriptor, ROIMassCenterCDescriptor.getMassCenterC(massCenter));
        return result;
    }
}

