/*
 * Decompiled with CFR 0.152.
 */
package io.bioimage.modelrunner.model.java;

import io.bioimage.modelrunner.bioimageio.description.ModelDescriptor;
import io.bioimage.modelrunner.bioimageio.description.ModelDescriptorFactory;
import io.bioimage.modelrunner.bioimageio.description.TensorSpec;
import io.bioimage.modelrunner.bioimageio.description.weights.ModelWeight;
import io.bioimage.modelrunner.bioimageio.description.weights.WeightFormat;
import io.bioimage.modelrunner.bioimageio.tiling.ImageInfo;
import io.bioimage.modelrunner.bioimageio.tiling.TileCalculator;
import io.bioimage.modelrunner.bioimageio.tiling.TileInfo;
import io.bioimage.modelrunner.bioimageio.tiling.TileMaker;
import io.bioimage.modelrunner.engine.EngineInfo;
import io.bioimage.modelrunner.exceptions.LoadEngineException;
import io.bioimage.modelrunner.exceptions.LoadModelException;
import io.bioimage.modelrunner.exceptions.RunModelException;
import io.bioimage.modelrunner.model.java.DLModelJava;
import io.bioimage.modelrunner.model.processing.Processing;
import io.bioimage.modelrunner.tensor.Tensor;
import io.bioimage.modelrunner.utils.CommonUtils;
import io.bioimage.modelrunner.versionmanagement.InstalledEngines;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import net.imglib2.img.Img;
import net.imglib2.img.array.ArrayImgs;
import net.imglib2.type.NativeType;
import net.imglib2.type.numeric.RealType;
import net.imglib2.util.Cast;

public class BioimageIoModelJava
extends DLModelJava {
    private boolean bioengine = false;
    protected ModelDescriptor descriptor;
    protected TileCalculator tileCalculator;

    protected BioimageIoModelJava(EngineInfo engineInfo, String modelFolder, String modelSource, ClassLoader classLoader) throws LoadEngineException, MalformedURLException, IllegalStateException, IOException {
        super(engineInfo, modelFolder, modelSource, classLoader);
        this.tiling = true;
    }

    public static BioimageIoModelJava createBioimageioModel(String bmzModelFolder, ClassLoader classloader) throws LoadEngineException, IOException {
        return BioimageIoModelJava.createBioimageioModel(bmzModelFolder, InstalledEngines.getEnginesDir(), classloader);
    }

    public static BioimageIoModelJava createBioimageioModel(String bmzModelFolder) throws LoadEngineException, IOException {
        return BioimageIoModelJava.createBioimageioModel(bmzModelFolder, InstalledEngines.getEnginesDir());
    }

    public static BioimageIoModelJava createBioimageioModel(String bmzModelFolder, String enginesFolder) throws LoadEngineException, IOException {
        return BioimageIoModelJava.createBioimageioModel(bmzModelFolder, enginesFolder, null);
    }

    public static BioimageIoModelJava createBioimageioModel(String bmzModelFolder, String enginesFolder, ClassLoader classloader) throws LoadEngineException, IOException {
        Objects.requireNonNull(bmzModelFolder);
        Objects.requireNonNull(enginesFolder);
        if (!new File(bmzModelFolder, "rdf.yaml").isFile()) {
            throw new IOException("A Bioimage.io model folder should contain its corresponding rdf.yaml file.");
        }
        ModelDescriptor descriptor = ModelDescriptorFactory.readFromLocalFile(bmzModelFolder + File.separator + "rdf.yaml");
        String modelSource = null;
        List<WeightFormat> modelWeights = descriptor.getWeights().gettAllSupportedWeightObjects();
        EngineInfo info = null;
        for (WeightFormat ww : modelWeights) {
            String source = ww.getSourceFileName();
            if (!new File(bmzModelFolder, source).isFile() && !ww.getFramework().equals(ModelWeight.getTensorflowID()) || ww.getFramework().equals(ModelWeight.getTensorflowID()) && !new File(bmzModelFolder, source).isFile() && (!new File(bmzModelFolder, "saved_model.pb").isFile() || !new File(bmzModelFolder, "variables").isDirectory()) || (info = EngineInfo.defineCompatibleDLEngineWithRdfYamlWeights(ww, enginesFolder)) == null) continue;
            modelSource = new File(bmzModelFolder, source).getAbsolutePath();
            break;
        }
        if (info == null) {
            throw new IOException("Please install a compatible engine with the model weights. To be compatible the engine has to be of the same framework and the major version needs to be the same. The model weights are: " + descriptor.getWeights().getSupportedWeightNamesAndVersion());
        }
        BioimageIoModelJava model = new BioimageIoModelJava(info, bmzModelFolder, modelSource, classloader);
        model.descriptor = descriptor;
        model.tileCalculator = TileCalculator.init(descriptor);
        return model;
    }

    public static BioimageIoModelJava createBioimageioModelWithExactWeigths(String bmzModelFolder, String enginesFolder, ClassLoader classloader) throws IOException, IllegalStateException, LoadEngineException {
        Objects.requireNonNull(bmzModelFolder);
        Objects.requireNonNull(enginesFolder);
        if (!new File(bmzModelFolder, "rdf.yaml").isFile()) {
            throw new IOException("A Bioimage.io model folder should contain its corresponding rdf.yaml file.");
        }
        ModelDescriptor descriptor = ModelDescriptorFactory.readFromLocalFile(bmzModelFolder + File.separator + "rdf.yaml");
        String modelSource = null;
        List<WeightFormat> modelWeights = descriptor.getWeights().gettAllSupportedWeightObjects();
        EngineInfo info = null;
        for (WeightFormat ww : modelWeights) {
            String source = ww.getSourceFileName();
            if (!new File(bmzModelFolder, source).isFile() || (info = EngineInfo.defineExactDLEngineWithRdfYamlWeights(ww, enginesFolder)) == null) continue;
            modelSource = new File(bmzModelFolder, source).getAbsolutePath();
            break;
        }
        if (info == null) {
            throw new IOException("Please install the engines defined by the model weights. The model weights are: " + descriptor.getWeights().getSupportedWeightNamesAndVersion());
        }
        BioimageIoModelJava model = new BioimageIoModelJava(info, bmzModelFolder, modelSource, classloader);
        model.descriptor = descriptor;
        model.tileCalculator = TileCalculator.init(descriptor);
        return model;
    }

    @Override
    public <T extends RealType<T> & NativeType<T>, R extends RealType<R> & NativeType<R>> List<Tensor<T>> run(List<Tensor<R>> inputTensors) throws RunModelException {
        if (!this.isLoaded()) {
            throw new RunModelException("Please first load the model.");
        }
        if (!this.tiling) {
            List<Tensor<T>> outs = this.createOutputTensors();
            this.runNoTiles(inputTensors, outs);
            return outs;
        }
        List<ImageInfo> imageInfos = inputTensors.stream().map(tt -> new ImageInfo(tt.getName(), tt.getAxesOrderString(), tt.getData().dimensionsAsLongArray())).collect(Collectors.toList());
        List<TileInfo> inputTiles = this.tileCalculator.getOptimalTileSize(imageInfos);
        TileMaker maker = TileMaker.build(this.descriptor, inputTiles);
        List<Tensor<T>> outTensors = this.createOutputTensors(maker);
        return this.runBMZ(inputTensors, outTensors, maker);
    }

    private <T extends RealType<T> & NativeType<T>> List<Tensor<T>> createOutputTensors(TileMaker maker) {
        ArrayList<Tensor<T>> outputTensors = new ArrayList<Tensor<T>>();
        for (TensorSpec tt : this.descriptor.getOutputTensors()) {
            long[] dims = maker.getOutputImageSize(tt.getName());
            outputTensors.add(Tensor.buildBlankTensor(tt.getName(), tt.getAxesOrder(), dims, CommonUtils.getImgLib2DataType(tt.getDataType())));
        }
        return outputTensors;
    }

    private <T extends RealType<T> & NativeType<T>> List<Tensor<T>> createOutputTensors() {
        ArrayList<Tensor<T>> outputTensors = new ArrayList<Tensor<T>>();
        for (TensorSpec tt : this.descriptor.getOutputTensors()) {
            outputTensors.add(Tensor.buildEmptyTensor(tt.getName(), tt.getAxesOrder()));
        }
        return outputTensors;
    }

    private <T extends RealType<T> & NativeType<T>, R extends RealType<R> & NativeType<R>> List<Tensor<T>> runBMZ(List<Tensor<R>> inputTensors, List<Tensor<T>> outputTensors, TileMaker tiles) throws RunModelException {
        Processing processing = Processing.init(this.descriptor);
        inputTensors = processing.preprocess(inputTensors, false);
        this.runTiling(inputTensors, outputTensors, tiles);
        return processing.postprocess(outputTensors, true);
    }

    @Override
    public <T extends RealType<T> & NativeType<T>, R extends RealType<R> & NativeType<R>> void run(List<Tensor<T>> inputTensors, List<Tensor<R>> outputTensors) throws RunModelException {
        if (!this.isLoaded()) {
            throw new RunModelException("Please first load the model.");
        }
        if (!this.tiling) {
            this.runNoTiles(inputTensors, outputTensors);
            return;
        }
        List<ImageInfo> imageInfos = inputTensors.stream().map(tt -> new ImageInfo(tt.getName(), tt.getAxesOrderString(), tt.getData().dimensionsAsLongArray())).collect(Collectors.toList());
        List<TileInfo> inputTiles = this.tileCalculator.getOptimalTileSize(imageInfos);
        TileMaker maker = TileMaker.build(this.descriptor, inputTiles);
        for (int i = 0; i < maker.getNumberOfTiles(); ++i) {
            Tensor<R> tt2 = outputTensors.get(i);
            long[] expectedSize = maker.getOutputImageSize(tt2.getName());
            if (expectedSize == null) {
                throw new IllegalArgumentException("Tensor '" + tt2.getName() + "' is missing in the outputs.");
            }
            if (tt2.isEmpty() || !Arrays.equals(expectedSize, tt2.getData().dimensionsAsLongArray())) continue;
            throw new IllegalArgumentException("Tensor '" + tt2.getName() + "' size is different than the expected size as defined by the rdf.yaml: " + Arrays.toString(tt2.getData().dimensionsAsLongArray()) + " vs " + Arrays.toString(expectedSize) + ".");
        }
        this.runBMZ(inputTensors, outputTensors, maker);
    }

    public static <T extends NativeType<T> & RealType<T>> void main(String[] args) throws IOException, LoadEngineException, RunModelException, LoadModelException {
        String mm = "/home/carlos/git/JDLL/models/NucleiSegmentationBoundaryModel_17122023_143125";
        Img im = (Img)Cast.unchecked((Object)ArrayImgs.floats((long[])new long[]{1L, 1L, 512L, 512L}));
        ArrayList l = new ArrayList();
        l.add(Tensor.build("input0", "bcyx", im));
        BioimageIoModelJava model = BioimageIoModelJava.createBioimageioModel(mm);
        model.loadModel();
        TileInfo tile = TileInfo.build(((Tensor)l.get(0)).getName(), new long[]{1L, 1L, 512L, 512L}, ((Tensor)l.get(0)).getAxesOrderString(), new long[]{1L, 1L, 512L, 512L}, ((Tensor)l.get(0)).getAxesOrderString());
        ArrayList<TileInfo> tileList = new ArrayList<TileInfo>();
        tileList.add(tile);
        model.run(l);
        System.out.println(false);
    }

    public boolean isBioengine() {
        return this.bioengine;
    }

    public ModelDescriptor getBioimageioSpecs() throws FileNotFoundException, IOException {
        if (this.descriptor == null && new File(this.modelFolder + File.separator + "rdf.yaml").isFile()) {
            this.descriptor = ModelDescriptorFactory.readFromLocalFile(this.modelFolder + File.separator + "rdf.yaml");
        }
        return this.descriptor;
    }
}

