/*
 * Decompiled with CFR 0.152.
 */
package io.bioimage.modelrunner.model.python;

import io.bioimage.modelrunner.apposed.appose.MambaInstallException;
import io.bioimage.modelrunner.bioimageio.description.ModelDescriptor;
import io.bioimage.modelrunner.bioimageio.description.ModelDescriptorFactory;
import io.bioimage.modelrunner.bioimageio.description.weights.ModelWeight;
import io.bioimage.modelrunner.bioimageio.description.weights.WeightFormat;
import io.bioimage.modelrunner.bioimageio.tiling.TileInfo;
import io.bioimage.modelrunner.exceptions.LoadEngineException;
import io.bioimage.modelrunner.exceptions.LoadModelException;
import io.bioimage.modelrunner.exceptions.RunModelException;
import io.bioimage.modelrunner.model.python.BioimageIoModelPytorchProtected;
import io.bioimage.modelrunner.tensor.Tensor;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.imglib2.img.Img;
import net.imglib2.img.array.ArrayImgs;
import net.imglib2.type.NativeType;
import net.imglib2.type.numeric.RealType;
import net.imglib2.util.Cast;
import org.apache.commons.compress.archivers.ArchiveException;

public class BioimageIoModelPytorch
extends BioimageIoModelPytorchProtected {
    protected BioimageIoModelPytorch(String modelFile, String callable, String importModule, String weightsPath, Map<String, Object> kwargs, ModelDescriptor descriptor) throws IOException {
        super(modelFile, callable, importModule, weightsPath, kwargs, descriptor);
    }

    public static BioimageIoModelPytorch create(ModelDescriptor descriptor) throws IOException {
        if (descriptor.getWeights().getModelWeights(ModelWeight.getPytorchID()) == null) {
            throw new IllegalArgumentException("The model provided does not have weights in the required format, " + ModelWeight.getPytorchID() + ".");
        }
        WeightFormat pytorchWeights = descriptor.getWeights().getModelWeights(ModelWeight.getPytorchID());
        String modelFile = descriptor.getModelPath() + File.separator + pytorchWeights.getArchitecture().getSource();
        String callable = pytorchWeights.getArchitecture().getCallable();
        String importModule = pytorchWeights.getArchitecture().getImportModule();
        String weightsFile = descriptor.getModelPath() + File.separator + pytorchWeights.getSource();
        Map<String, Object> kwargs = pytorchWeights.getArchitecture().getKwargs();
        return new BioimageIoModelPytorch(modelFile, callable, importModule, weightsFile, kwargs, descriptor);
    }

    public static BioimageIoModelPytorch create(String modelPath) throws IOException {
        return BioimageIoModelPytorch.create(ModelDescriptorFactory.readFromLocalFile(modelPath + File.separator + "rdf.yaml"));
    }

    public static <T extends NativeType<T> & RealType<T>> void main(String[] args) throws IOException, LoadEngineException, RunModelException, LoadModelException, InterruptedException, RuntimeException, MambaInstallException, ArchiveException, URISyntaxException {
        String mm = "/home/carlos/git/deepimagej-plugin/models/OC1 Project 11 Cellpose_24022025_131039";
        Img im = (Img)Cast.unchecked((Object)ArrayImgs.floats((long[])new long[]{1L, 1L, 1024L, 1024L}));
        ArrayList l = new ArrayList();
        l.add(Tensor.build("input", "bcyx", im));
        BioimageIoModelPytorch model = BioimageIoModelPytorch.create(mm);
        List<String> missing = model.findMissingDependencies();
        model.loadModel();
        TileInfo tile = TileInfo.build(((Tensor)l.get(0)).getName(), new long[]{1L, 1L, 512L, 512L}, ((Tensor)l.get(0)).getAxesOrderString(), new long[]{1L, 1L, 512L, 512L}, ((Tensor)l.get(0)).getAxesOrderString());
        ArrayList<TileInfo> tileList = new ArrayList<TileInfo>();
        tileList.add(tile);
        model.run(l);
        System.out.println(false);
    }
}

