/*
 * Decompiled with CFR 0.152.
 */
package io.bioimage.modelrunner.tensor.shm;

import com.sun.jna.Pointer;
import com.sun.jna.platform.win32.BaseTSD;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.WinBase;
import com.sun.jna.platform.win32.WinNT;
import io.bioimage.modelrunner.numpy.DecodeNumpy;
import io.bioimage.modelrunner.tensor.Utils;
import io.bioimage.modelrunner.tensor.shm.SharedMemoryArray;
import io.bioimage.modelrunner.utils.CommonUtils;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileAlreadyExistsException;
import java.util.Arrays;
import java.util.Objects;
import java.util.regex.Matcher;
import net.imglib2.Cursor;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.img.array.ArrayImgs;
import net.imglib2.img.basictypeaccess.ByteAccess;
import net.imglib2.img.basictypeaccess.DoubleAccess;
import net.imglib2.img.basictypeaccess.FloatAccess;
import net.imglib2.img.basictypeaccess.IntAccess;
import net.imglib2.img.basictypeaccess.LongAccess;
import net.imglib2.img.basictypeaccess.ShortAccess;
import net.imglib2.img.basictypeaccess.nio.ByteBufferAccess;
import net.imglib2.img.basictypeaccess.nio.DoubleBufferAccess;
import net.imglib2.img.basictypeaccess.nio.FloatBufferAccess;
import net.imglib2.img.basictypeaccess.nio.IntBufferAccess;
import net.imglib2.img.basictypeaccess.nio.LongBufferAccess;
import net.imglib2.img.basictypeaccess.nio.ShortBufferAccess;
import net.imglib2.type.NativeType;
import net.imglib2.type.numeric.RealType;
import net.imglib2.type.numeric.integer.ByteType;
import net.imglib2.type.numeric.integer.IntType;
import net.imglib2.type.numeric.integer.LongType;
import net.imglib2.type.numeric.integer.ShortType;
import net.imglib2.type.numeric.integer.UnsignedByteType;
import net.imglib2.type.numeric.integer.UnsignedIntType;
import net.imglib2.type.numeric.integer.UnsignedShortType;
import net.imglib2.type.numeric.real.DoubleType;
import net.imglib2.type.numeric.real.FloatType;
import net.imglib2.util.Cast;
import net.imglib2.util.Util;
import net.imglib2.view.Views;

public class SharedMemoryArrayWin
implements SharedMemoryArray {
    private WinNT.HANDLE hMapFile;
    private Pointer mappedPointer;
    private Pointer writePointer;
    private final String memoryName;
    private int size;
    private String originalDataType;
    private long[] originalDims;
    private boolean unlinked = false;
    private Boolean isNumpyFormat = null;
    private boolean isFortran = false;
    private static final int SEC_RESERVE = 0x4000000;
    private static final int DEFAULT_RESERVED_MEMORY = Integer.MIN_VALUE;

    protected SharedMemoryArrayWin(int size, String dtype, long[] shape, Boolean isNumpy, boolean isFortran) throws FileAlreadyExistsException {
        this(SharedMemoryArray.createShmName(), size, dtype, shape, isNumpy, isFortran);
    }

    protected SharedMemoryArrayWin(String name, int size, String dtype, long[] shape, Boolean isNumpy, boolean isFortran) throws FileAlreadyExistsException {
        long prevSize;
        if (!name.startsWith("Local" + File.separator) && !name.startsWith("Global" + File.separator)) {
            name = "Local" + File.separator + name;
        }
        if (size < 0) {
            throw new IllegalArgumentException("The size of a shared memory segment cannot be negative.");
        }
        this.memoryName = name;
        this.originalDataType = dtype;
        this.originalDims = shape;
        this.size = size;
        this.isNumpyFormat = isNumpy;
        this.isFortran = isFortran;
        int flag = 4;
        boolean write = true;
        boolean alreadyExists = this.checkSHMExists(this.memoryName);
        if (alreadyExists && (prevSize = SharedMemoryArrayWin.getSHMSize(name)) != 0L && prevSize != Integer.MIN_VALUE && prevSize < (long)size) {
            throw new FileAlreadyExistsException("Shared memory segment already exists with different dimensions, data type or format. Size of existing shared memory segment: " + prevSize + ", size of proposed object: " + size);
        }
        if (size < 1) {
            flag = 0x4000004;
            size = Integer.MIN_VALUE;
            write = false;
        }
        this.hMapFile = Kernel32.INSTANCE.CreateFileMapping(WinBase.INVALID_HANDLE_VALUE, null, flag, 0, size, this.memoryName);
        if (this.hMapFile == null) {
            throw new RuntimeException("Error creating shared memory array. CreateFileMapping failed: " + Kernel32.INSTANCE.GetLastError());
        }
        this.mappedPointer = Kernel32.INSTANCE.MapViewOfFile(this.hMapFile, 2, 0, 0, size);
        if (this.mappedPointer == null) {
            Kernel32.INSTANCE.CloseHandle(this.hMapFile);
            throw new RuntimeException("Error creating shared memory array. Please check that a shared memory segment with another size has not previously been created on the same memory region with the same name: " + this.memoryName + ". MapViewOfFile failed: " + Kernel32.INSTANCE.GetLastError());
        }
        if (write) {
            this.writePointer = Kernel32.INSTANCE.VirtualAllocEx(Kernel32.INSTANCE.GetCurrentProcess(), this.mappedPointer, new BaseTSD.SIZE_T((long)size), 4096, 4);
            if (this.writePointer == null) {
                this.close();
                throw new RuntimeException("Error committing to the shared memory pages. Errno: " + Kernel32.INSTANCE.GetLastError());
            }
        }
        if (!alreadyExists && this.isNumpyFormat.booleanValue()) {
            byte[] header = SharedMemoryArrayWin.getNpyHeader(dtype, shape, this.isFortran);
            long offset = 0L;
            for (byte b : header) {
                this.mappedPointer.setByte(offset, b);
            }
        }
    }

    private boolean checkSHMExists(String memoryName) {
        WinNT.HANDLE hMapFile;
        SharedMemoryArray.checkMemorySegmentName(memoryName);
        if (!memoryName.startsWith("Local" + File.separator) && !memoryName.startsWith("Global" + File.separator)) {
            memoryName = "Local" + File.separator + memoryName;
        }
        if ((hMapFile = Kernel32.INSTANCE.OpenFileMapping(4, false, memoryName)) == null) {
            return false;
        }
        Kernel32.INSTANCE.CloseHandle(hMapFile);
        return true;
    }

    protected static long getSHMSize(String memoryName) {
        WinNT.HANDLE hMapFile;
        SharedMemoryArray.checkMemorySegmentName(memoryName);
        if (!memoryName.startsWith("Local" + File.separator) && !memoryName.startsWith("Global" + File.separator)) {
            memoryName = "Local" + File.separator + memoryName;
        }
        if ((hMapFile = Kernel32.INSTANCE.OpenFileMapping(4, false, memoryName)) == null) {
            throw new RuntimeException("Shared memory segment might not exist: " + memoryName + ". OpenFileMapping failed with error: " + Kernel32.INSTANCE.GetLastError());
        }
        Pointer pSharedMemory = Kernel32.INSTANCE.MapViewOfFile(hMapFile, 4, 0, 0, 0);
        if (pSharedMemory == null) {
            Kernel32.INSTANCE.CloseHandle(hMapFile);
            throw new RuntimeException("MapViewOfFile failed with error: " + Kernel32.INSTANCE.GetLastError());
        }
        WinNT.MEMORY_BASIC_INFORMATION mbi = new WinNT.MEMORY_BASIC_INFORMATION();
        if (Kernel32.INSTANCE.VirtualQueryEx(Kernel32.INSTANCE.GetCurrentProcess(), pSharedMemory, mbi, new BaseTSD.SIZE_T((long)mbi.size())).intValue() == 0) {
            throw new RuntimeException("Unable to retrieve the size of the shm segment located at ''. Errno: " + Kernel32.INSTANCE.GetLastError());
        }
        int size = mbi.regionSize.intValue();
        Kernel32.INSTANCE.UnmapViewOfFile(pSharedMemory);
        Kernel32.INSTANCE.CloseHandle(hMapFile);
        return size;
    }

    private SharedMemoryArrayWin(String name) {
        this.memoryName = name;
    }

    protected static <T extends RealType<T> & NativeType<T>> SharedMemoryArrayWin readOrCreate(String name, int size, long[] shape, String strDType, Boolean isNumpy, boolean isFortran) throws FileAlreadyExistsException {
        return new SharedMemoryArrayWin(name, size, strDType, shape, isNumpy, isFortran);
    }

    protected static <T extends RealType<T> & NativeType<T>> SharedMemoryArrayWin readOrCreate(String name, int size) throws FileAlreadyExistsException {
        return new SharedMemoryArrayWin(name, size, null, null, null, false);
    }

    protected static <T extends RealType<T> & NativeType<T>> SharedMemoryArrayWin create(int size, long[] shape, String strDType, Boolean isNumpy, boolean isFortran) {
        try {
            return new SharedMemoryArrayWin(size, strDType, shape, isNumpy, isFortran);
        }
        catch (FileAlreadyExistsException e) {
            throw new RuntimeException("Unexpected error.", e);
        }
    }

    protected static SharedMemoryArrayWin create(int size) {
        try {
            return new SharedMemoryArrayWin(size, null, null, null, false);
        }
        catch (FileAlreadyExistsException e) {
            throw new RuntimeException("Unexpected error.", e);
        }
    }

    protected static <T extends RealType<T> & NativeType<T>> SharedMemoryArrayWin createSHMAFromRAI(String name, RandomAccessibleInterval<T> rai, boolean isFortranOrder, boolean isNumpy) throws FileAlreadyExistsException {
        Objects.requireNonNull(rai, "Please provide a non-null RandomAccessibleInterval");
        SharedMemoryArray.checkMemorySegmentName(name);
        if (!name.startsWith("Local" + File.separator) && !name.startsWith("Global" + File.separator)) {
            name = "Local" + File.separator + name;
        }
        SharedMemoryArrayWin shma = null;
        if (Util.getTypeFromInterval(rai) instanceof ByteType) {
            int size = 1;
            for (long i : rai.dimensionsAsLongArray()) {
                size = (int)((long)size * i);
            }
            if (isNumpy) {
                size = (int)DecodeNumpy.calculateNpyStyleByteArrayLength(rai, isFortranOrder);
            }
            shma = new SharedMemoryArrayWin(name, size, CommonUtils.getDataTypeFromRAI(rai), rai.dimensionsAsLongArray(), isNumpy, isFortranOrder);
            shma.buildInt8((RandomAccessibleInterval<ByteType>)((RandomAccessibleInterval)Cast.unchecked(rai)), isFortranOrder, isNumpy);
        } else if (Util.getTypeFromInterval(rai) instanceof UnsignedByteType) {
            int size = 1;
            for (long i : rai.dimensionsAsLongArray()) {
                size = (int)((long)size * i);
            }
            if (isNumpy) {
                size = (int)DecodeNumpy.calculateNpyStyleByteArrayLength(rai, isFortranOrder);
            }
            shma = new SharedMemoryArrayWin(name, size, CommonUtils.getDataTypeFromRAI(rai), rai.dimensionsAsLongArray(), isNumpy, isFortranOrder);
            shma.buildUint8((RandomAccessibleInterval<UnsignedByteType>)((RandomAccessibleInterval)Cast.unchecked(rai)), isFortranOrder, isNumpy);
        } else if (Util.getTypeFromInterval(rai) instanceof ShortType) {
            int size = 2;
            for (long i : rai.dimensionsAsLongArray()) {
                size = (int)((long)size * i);
            }
            if (isNumpy) {
                size = (int)DecodeNumpy.calculateNpyStyleByteArrayLength(rai, isFortranOrder);
            }
            shma = new SharedMemoryArrayWin(name, size, CommonUtils.getDataTypeFromRAI(rai), rai.dimensionsAsLongArray(), isNumpy, isFortranOrder);
            shma.buildInt16((RandomAccessibleInterval<ShortType>)((RandomAccessibleInterval)Cast.unchecked(rai)), isFortranOrder, isNumpy);
        } else if (Util.getTypeFromInterval(rai) instanceof UnsignedShortType) {
            int size = 2;
            for (long i : rai.dimensionsAsLongArray()) {
                size = (int)((long)size * i);
            }
            if (isNumpy) {
                size = (int)DecodeNumpy.calculateNpyStyleByteArrayLength(rai, isFortranOrder);
            }
            shma = new SharedMemoryArrayWin(name, size, CommonUtils.getDataTypeFromRAI(rai), rai.dimensionsAsLongArray(), isNumpy, isFortranOrder);
            shma.buildUint16((RandomAccessibleInterval<UnsignedShortType>)((RandomAccessibleInterval)Cast.unchecked(rai)), isFortranOrder, isNumpy);
        } else if (Util.getTypeFromInterval(rai) instanceof IntType) {
            int size = 4;
            for (long i : rai.dimensionsAsLongArray()) {
                size = (int)((long)size * i);
            }
            if (isNumpy) {
                size = (int)DecodeNumpy.calculateNpyStyleByteArrayLength(rai, isFortranOrder);
            }
            shma = new SharedMemoryArrayWin(name, size, CommonUtils.getDataTypeFromRAI(rai), rai.dimensionsAsLongArray(), isNumpy, isFortranOrder);
            shma.buildInt32((RandomAccessibleInterval<IntType>)((RandomAccessibleInterval)Cast.unchecked(rai)), isFortranOrder, isNumpy);
        } else if (Util.getTypeFromInterval(rai) instanceof UnsignedIntType) {
            int size = 4;
            for (long i : rai.dimensionsAsLongArray()) {
                size = (int)((long)size * i);
            }
            if (isNumpy) {
                size = (int)DecodeNumpy.calculateNpyStyleByteArrayLength(rai, isFortranOrder);
            }
            shma = new SharedMemoryArrayWin(name, size, CommonUtils.getDataTypeFromRAI(rai), rai.dimensionsAsLongArray(), isNumpy, isFortranOrder);
            shma.buildUint32((RandomAccessibleInterval<UnsignedIntType>)((RandomAccessibleInterval)Cast.unchecked(rai)), isFortranOrder, isNumpy);
        } else if (Util.getTypeFromInterval(rai) instanceof LongType) {
            int size = 8;
            for (long i : rai.dimensionsAsLongArray()) {
                size = (int)((long)size * i);
            }
            if (isNumpy) {
                size = (int)DecodeNumpy.calculateNpyStyleByteArrayLength(rai, isFortranOrder);
            }
            shma = new SharedMemoryArrayWin(name, size, CommonUtils.getDataTypeFromRAI(rai), rai.dimensionsAsLongArray(), isNumpy, isFortranOrder);
            shma.buildInt64((RandomAccessibleInterval<LongType>)((RandomAccessibleInterval)Cast.unchecked(rai)), isFortranOrder, isNumpy);
        } else if (Util.getTypeFromInterval(rai) instanceof FloatType) {
            int size = 4;
            for (long i : rai.dimensionsAsLongArray()) {
                size = (int)((long)size * i);
            }
            if (isNumpy) {
                size = (int)DecodeNumpy.calculateNpyStyleByteArrayLength(rai, isFortranOrder);
            }
            shma = new SharedMemoryArrayWin(name, size, CommonUtils.getDataTypeFromRAI(rai), rai.dimensionsAsLongArray(), isNumpy, isFortranOrder);
            shma.buildFloat32((RandomAccessibleInterval<FloatType>)((RandomAccessibleInterval)Cast.unchecked(rai)), isFortranOrder, isNumpy);
        } else if (Util.getTypeFromInterval(rai) instanceof DoubleType) {
            int size = 8;
            for (long i : rai.dimensionsAsLongArray()) {
                size = (int)((long)size * i);
            }
            if (isNumpy) {
                size = (int)DecodeNumpy.calculateNpyStyleByteArrayLength(rai, isFortranOrder);
            }
            shma = new SharedMemoryArrayWin(name, size, CommonUtils.getDataTypeFromRAI(rai), rai.dimensionsAsLongArray(), isNumpy, isFortranOrder);
            shma.buildFloat64((RandomAccessibleInterval<DoubleType>)((RandomAccessibleInterval)Cast.unchecked(rai)), isFortranOrder, isNumpy);
        } else {
            throw new IllegalArgumentException("The image has an unsupported type: " + ((RealType)Util.getTypeFromInterval(rai)).getClass().toString());
        }
        return shma;
    }

    protected static SharedMemoryArrayWin read(String memoryName) {
        WinNT.HANDLE hMapFile;
        if (!memoryName.startsWith("Local" + File.separator) && !memoryName.startsWith("Global" + File.separator)) {
            memoryName = "Local" + File.separator + memoryName;
        }
        if ((hMapFile = Kernel32.INSTANCE.OpenFileMapping(983071, false, memoryName)) == null) {
            throw new RuntimeException("OpenFileMapping failed with error: " + Kernel32.INSTANCE.GetLastError());
        }
        Pointer pSharedMemory = Kernel32.INSTANCE.MapViewOfFile(hMapFile, 983071, 0, 0, 0);
        if (pSharedMemory == null) {
            Kernel32.INSTANCE.CloseHandle(hMapFile);
            throw new RuntimeException("MapViewOfFile failed with error: " + Kernel32.INSTANCE.GetLastError());
        }
        WinNT.MEMORY_BASIC_INFORMATION mbi = new WinNT.MEMORY_BASIC_INFORMATION();
        if (Kernel32.INSTANCE.VirtualQueryEx(Kernel32.INSTANCE.GetCurrentProcess(), pSharedMemory, mbi, new BaseTSD.SIZE_T((long)mbi.size())).intValue() == 0) {
            Kernel32.INSTANCE.UnmapViewOfFile(pSharedMemory);
            Kernel32.INSTANCE.CloseHandle(hMapFile);
            throw new RuntimeException("Unable to retrieve the size of the shm segment located at '" + memoryName + "'. Errno: " + Kernel32.INSTANCE.GetLastError());
        }
        int size = mbi.regionSize.intValue();
        Pointer writePointer = Kernel32.INSTANCE.VirtualAllocEx(Kernel32.INSTANCE.GetCurrentProcess(), pSharedMemory, new BaseTSD.SIZE_T((long)size), 4096, 4);
        if (writePointer == null) {
            Kernel32.INSTANCE.CloseHandle(hMapFile);
            Kernel32.INSTANCE.UnmapViewOfFile(pSharedMemory);
            throw new RuntimeException("Error committing to the shared memory pages. Errno: " + Kernel32.INSTANCE.GetLastError());
        }
        SharedMemoryArrayWin shm = new SharedMemoryArrayWin(memoryName);
        shm.hMapFile = hMapFile;
        shm.writePointer = writePointer;
        shm.size = size;
        shm.mappedPointer = pSharedMemory;
        shm.findNumpyFormat();
        return shm;
    }

    private void addByteArray(byte[] arr) {
        for (int i = 0; i < arr.length; ++i) {
            this.writePointer.setByte((long)i, arr[i]);
        }
    }

    private static <T extends RealType<T> & NativeType<T>> byte[] getNpyHeader(String dtype, long[] shape, boolean fortranOrder) {
        int i;
        String strHeader = "{'descr': '<";
        strHeader = strHeader + DecodeNumpy.getDataType(CommonUtils.getImgLib2DataType(dtype));
        strHeader = strHeader + "', 'fortran_order': " + (fortranOrder ? "True" : "False") + ", 'shape': (";
        for (long ll : shape) {
            strHeader = strHeader + ll + ", ";
        }
        strHeader = strHeader.substring(0, strHeader.length() - 2);
        strHeader = strHeader + "), }" + System.lineSeparator();
        byte[] bufInverse = strHeader.getBytes(StandardCharsets.UTF_8);
        byte[] major = new byte[]{1};
        byte[] minor = new byte[]{0};
        byte[] len = new byte[]{(byte)strHeader.length(), (byte)((short)strHeader.length() >> 8)};
        int totalLen = DecodeNumpy.NUMPY_PREFIX.length + 2 + 2 + bufInverse.length;
        byte[] total = new byte[totalLen];
        int c = 0;
        for (i = 0; i < DecodeNumpy.NUMPY_PREFIX.length; ++i) {
            total[c++] = DecodeNumpy.NUMPY_PREFIX[i];
        }
        total[c++] = major[0];
        total[c++] = minor[0];
        total[c++] = len[0];
        total[c++] = len[1];
        for (i = 0; i < bufInverse.length; ++i) {
            total[c++] = bufInverse[i];
        }
        return total;
    }

    private static <T extends RealType<T> & NativeType<T>> byte[] getNpyHeader(RandomAccessibleInterval<T> tensor, boolean isFortran) {
        int i;
        String strHeader = "{'descr': '<";
        strHeader = strHeader + DecodeNumpy.getDataType((RealType)tensor.getAt(tensor.minAsLongArray()));
        strHeader = strHeader + "', 'fortran_order': " + (isFortran ? "True" : "False") + ", 'shape': (";
        for (long ll : tensor.dimensionsAsLongArray()) {
            strHeader = strHeader + ll + ", ";
        }
        strHeader = strHeader.substring(0, strHeader.length() - 2);
        strHeader = strHeader + "), }" + System.lineSeparator();
        byte[] bufInverse = strHeader.getBytes(StandardCharsets.UTF_8);
        byte[] major = new byte[]{1};
        byte[] minor = new byte[]{0};
        byte[] len = new byte[]{(byte)strHeader.length(), (byte)((short)strHeader.length() >> 8)};
        int totalLen = DecodeNumpy.NUMPY_PREFIX.length + 2 + 2 + bufInverse.length;
        byte[] total = new byte[totalLen];
        int c = 0;
        for (i = 0; i < DecodeNumpy.NUMPY_PREFIX.length; ++i) {
            total[c++] = DecodeNumpy.NUMPY_PREFIX[i];
        }
        total[c++] = major[0];
        total[c++] = minor[0];
        total[c++] = len[0];
        total[c++] = len[1];
        for (i = 0; i < bufInverse.length; ++i) {
            total[c++] = bufInverse[i];
        }
        return total;
    }

    private void buildInt8(RandomAccessibleInterval<ByteType> tensor, boolean isFortranOrder, boolean isNumpy) {
        byte[] header = new byte[]{};
        if (isNumpy) {
            header = SharedMemoryArrayWin.getNpyHeader(tensor, isFortranOrder);
        }
        long offset = 0L;
        for (byte b : header) {
            this.mappedPointer.setByte(offset, b);
            ++offset;
        }
        if (!isFortranOrder) {
            tensor = Utils.transpose(tensor);
        }
        Cursor cursor = Views.flatIterable(tensor).cursor();
        long i = 0L;
        while (cursor.hasNext()) {
            cursor.fwd();
            this.mappedPointer.setByte(offset + i++, ((ByteType)cursor.get()).get());
        }
    }

    private void buildUint8(RandomAccessibleInterval<UnsignedByteType> tensor, boolean isFortranOrder, boolean isNumpy) {
        byte[] header = new byte[]{};
        if (isNumpy) {
            header = SharedMemoryArrayWin.getNpyHeader(tensor, isFortranOrder);
        }
        long offset = 0L;
        for (byte b : header) {
            this.mappedPointer.setByte(offset, b);
            ++offset;
        }
        if (!isFortranOrder) {
            tensor = Utils.transpose(tensor);
        }
        Cursor cursor = Views.flatIterable(tensor).cursor();
        long i = 0L;
        while (cursor.hasNext()) {
            cursor.fwd();
            this.mappedPointer.setByte(offset + i++, ((UnsignedByteType)cursor.get()).getByte());
        }
    }

    private void buildInt16(RandomAccessibleInterval<ShortType> tensor, boolean isFortranOrder, boolean isNumpy) {
        byte[] header = new byte[]{};
        if (isNumpy) {
            header = SharedMemoryArrayWin.getNpyHeader(tensor, isFortranOrder);
        }
        long offset = 0L;
        for (byte b : header) {
            this.mappedPointer.setByte(offset, b);
            ++offset;
        }
        if (!isFortranOrder) {
            tensor = Utils.transpose(tensor);
        }
        Cursor cursor = Views.flatIterable(tensor).cursor();
        long i = 0L;
        while (cursor.hasNext()) {
            cursor.fwd();
            this.mappedPointer.setShort(offset + i * 2L, ((ShortType)cursor.get()).get());
            ++i;
        }
    }

    private void buildUint16(RandomAccessibleInterval<UnsignedShortType> tensor, boolean isFortranOrder, boolean isNumpy) {
        byte[] header = new byte[]{};
        if (isNumpy) {
            header = SharedMemoryArrayWin.getNpyHeader(tensor, isFortranOrder);
        }
        long offset = 0L;
        for (byte b : header) {
            this.mappedPointer.setByte(offset, b);
            ++offset;
        }
        if (!isFortranOrder) {
            tensor = Utils.transpose(tensor);
        }
        Cursor cursor = Views.flatIterable(tensor).cursor();
        long i = 0L;
        while (cursor.hasNext()) {
            cursor.fwd();
            this.mappedPointer.setShort(offset + i * 2L, ((UnsignedShortType)cursor.get()).getShort());
            ++i;
        }
    }

    private void buildInt32(RandomAccessibleInterval<IntType> tensor, boolean isFortranOrder, boolean isNumpy) {
        byte[] header = new byte[]{};
        if (isNumpy) {
            header = SharedMemoryArrayWin.getNpyHeader(tensor, isFortranOrder);
        }
        long offset = 0L;
        for (byte b : header) {
            this.mappedPointer.setByte(offset, b);
            ++offset;
        }
        if (!isFortranOrder) {
            tensor = Utils.transpose(tensor);
        }
        Cursor cursor = Views.flatIterable(tensor).cursor();
        long i = 0L;
        while (cursor.hasNext()) {
            cursor.fwd();
            this.mappedPointer.setInt(offset + i * 4L, ((IntType)cursor.get()).get());
            ++i;
        }
    }

    private void buildUint32(RandomAccessibleInterval<UnsignedIntType> tensor, boolean isFortranOrder, boolean isNumpy) {
        byte[] header = new byte[]{};
        if (isNumpy) {
            header = SharedMemoryArrayWin.getNpyHeader(tensor, isFortranOrder);
        }
        long offset = 0L;
        for (byte b : header) {
            this.mappedPointer.setByte(offset, b);
            ++offset;
        }
        if (!isFortranOrder) {
            tensor = Utils.transpose(tensor);
        }
        Cursor cursor = Views.flatIterable(tensor).cursor();
        long i = 0L;
        while (cursor.hasNext()) {
            cursor.fwd();
            this.mappedPointer.setInt(offset + i * 4L, ((UnsignedIntType)cursor.get()).getInt());
            ++i;
        }
    }

    private void buildInt64(RandomAccessibleInterval<LongType> tensor, boolean isFortranOrder, boolean isNumpy) {
        byte[] header = new byte[]{};
        if (isNumpy) {
            header = SharedMemoryArrayWin.getNpyHeader(tensor, isFortranOrder);
        }
        long offset = 0L;
        for (byte b : header) {
            this.mappedPointer.setByte(offset, b);
            ++offset;
        }
        if (!isFortranOrder) {
            tensor = Utils.transpose(tensor);
        }
        Cursor cursor = Views.flatIterable(tensor).cursor();
        long i = 0L;
        while (cursor.hasNext()) {
            cursor.fwd();
            this.mappedPointer.setLong(offset + i * 8L, ((LongType)cursor.get()).get());
            ++i;
        }
    }

    private void buildFloat32(RandomAccessibleInterval<FloatType> tensor, boolean isFortranOrder, boolean isNumpy) {
        byte[] header = new byte[]{};
        if (isNumpy) {
            header = SharedMemoryArrayWin.getNpyHeader(tensor, isFortranOrder);
        }
        long offset = 0L;
        for (byte b : header) {
            this.mappedPointer.setByte(offset, b);
            ++offset;
        }
        if (!isFortranOrder) {
            tensor = Utils.transpose(tensor);
        }
        Cursor cursor = Views.flatIterable(tensor).cursor();
        long i = 0L;
        while (cursor.hasNext()) {
            cursor.fwd();
            this.mappedPointer.setFloat(offset + i * 4L, ((FloatType)cursor.get()).get());
            ++i;
        }
    }

    private void buildFloat64(RandomAccessibleInterval<DoubleType> tensor, boolean isFortranOrder, boolean isNumpy) {
        byte[] header = new byte[]{};
        if (isNumpy) {
            header = SharedMemoryArrayWin.getNpyHeader(tensor, isFortranOrder);
        }
        long offset = 0L;
        for (byte b : header) {
            this.mappedPointer.setByte(offset, b);
            ++offset;
        }
        if (!isFortranOrder) {
            tensor = Utils.transpose(tensor);
        }
        Cursor cursor = Views.flatIterable(tensor).cursor();
        long i = 0L;
        while (cursor.hasNext()) {
            cursor.fwd();
            this.mappedPointer.setDouble(offset + i * 8L, ((DoubleType)cursor.get()).get());
            ++i;
        }
    }

    @Override
    public String getName() {
        return this.memoryName;
    }

    @Override
    public String getNameForPython() {
        return this.memoryName.substring(("Local" + File.separator).length());
    }

    @Override
    public Pointer getPointer() {
        return this.mappedPointer;
    }

    public WinNT.HANDLE getSharedMemoryBlockID() {
        return this.hMapFile;
    }

    @Override
    public int getSize() {
        return this.size;
    }

    @Override
    public String getOriginalDataType() {
        return this.originalDataType;
    }

    @Override
    public long[] getOriginalShape() {
        return this.originalDims;
    }

    @Override
    public boolean isNumpyFormat() {
        if (this.isNumpyFormat == null) {
            this.findNumpyFormat();
        }
        return this.isNumpyFormat;
    }

    @Override
    public void close() {
        if (this.unlinked) {
            return;
        }
        if (this.writePointer != null) {
            Kernel32.INSTANCE.UnmapViewOfFile(this.writePointer);
        }
        Kernel32.INSTANCE.UnmapViewOfFile(this.mappedPointer);
        Kernel32.INSTANCE.CloseHandle(this.hMapFile);
        this.unlinked = true;
    }

    private void findNumpyFormat() {
        this.isNumpyFormat = true;
        try {
            char order;
            int offset = 0;
            byte[] buf = new byte[DecodeNumpy.NUMPY_PREFIX.length];
            this.mappedPointer.getByteBuffer((long)offset, (long)DecodeNumpy.NUMPY_PREFIX.length).get(buf, 0, DecodeNumpy.NUMPY_PREFIX.length);
            if (!Arrays.equals(buf, DecodeNumpy.NUMPY_PREFIX)) {
                throw new IllegalArgumentException("Malformed  or unsopported Numpy array");
            }
            offset = DecodeNumpy.NUMPY_PREFIX.length;
            byte major = this.mappedPointer.getByteBuffer((long)offset, 1L).get();
            byte minor = this.mappedPointer.getByteBuffer((long)(++offset), 1L).get();
            ++offset;
            if (major < 1 || major > 3 || minor != 0) {
                throw new IllegalArgumentException("Unknown numpy version: " + major + '.' + minor);
            }
            int len = major == 1 ? 2 : 4;
            ByteBuffer bb = this.mappedPointer.getByteBuffer((long)offset, (long)len);
            offset += len;
            bb.order(ByteOrder.LITTLE_ENDIAN);
            len = major == 1 ? (int)bb.getShort() : bb.getInt();
            buf = new byte[len];
            this.mappedPointer.getByteBuffer((long)offset, (long)len).get(buf, 0, len);
            offset += len;
            String header = new String(buf, StandardCharsets.UTF_8);
            Matcher m = DecodeNumpy.HEADER_PATTERN.matcher(header);
            if (!m.find()) {
                throw new IllegalArgumentException("Invalid numpy header: " + header);
            }
            String typeStr = m.group(1);
            String fortranOrder = m.group(2).trim();
            String shapeStr = m.group(3);
            long[] shape = new long[]{};
            if (!shapeStr.isEmpty()) {
                String[] tokens = shapeStr.split(", ?");
                shape = Arrays.stream(tokens).mapToLong(Long::parseLong).toArray();
            }
            if ((order = typeStr.charAt(0)) != '>' && order != '<' && order != '|') {
                new IllegalArgumentException("Not supported ByteOrder for the provided .npy array.");
            }
            String dtype = DecodeNumpy.getDataType(typeStr.substring(1));
            this.originalDims = shape;
            this.originalDataType = dtype;
            this.isFortran = fortranOrder.equals("True");
        }
        catch (Exception ex) {
            this.isNumpyFormat = false;
        }
    }

    @Override
    public <T extends RealType<T> & NativeType<T>> RandomAccessibleInterval<T> getSharedRAI() {
        if (!(this.originalDims != null && this.originalDataType != null || this.isNumpyFormat())) {
            throw new IllegalArgumentException("The shared memory segment is not stored in Numpy format and the shape and/or data type are not known. Please provide information about them and use the method 'getSharedRAI(long[] shape, boolean isFortran, T dataType)'.");
        }
        if (this.isNumpyFormat()) {
            return this.buildImgLib2FromNumpyLikeSHMA();
        }
        return SharedMemoryArrayWin.buildFromSharedMemoryBlock(this.mappedPointer, this.originalDims, this.originalDataType, this.isFortran);
    }

    @Override
    public <T extends RealType<T> & NativeType<T>> RandomAccessibleInterval<T> getSharedRAI(long[] shape, T dataType) {
        return SharedMemoryArrayWin.buildFromSharedMemoryBlock(this.mappedPointer, shape, dataType, this.isFortran, 0, ByteOrder.LITTLE_ENDIAN);
    }

    @Override
    public <T extends RealType<T> & NativeType<T>> RandomAccessibleInterval<T> getSharedRAI(long[] shape, T dataType, boolean isFortran) {
        return SharedMemoryArrayWin.buildFromSharedMemoryBlock(this.mappedPointer, shape, dataType, isFortran, 0, ByteOrder.LITTLE_ENDIAN);
    }

    @Override
    public void setBuffer(ByteBuffer buffer) {
        byte[] array;
        if (buffer.capacity() > this.size) {
            throw new IllegalArgumentException("The buffer capacity has to be smaller or equal than the size of the shared memory segment.");
        }
        if (buffer.hasArray()) {
            array = buffer.array();
        } else {
            array = new byte[buffer.remaining()];
            buffer.get(array);
        }
        this.mappedPointer.write(0L, array, 0, buffer.capacity());
    }

    @Override
    public ByteBuffer getDataBuffer() {
        int len = this.size;
        if (this.isNumpyFormat() || this.originalDataType != null && this.originalDims != null) {
            len = SharedMemoryArray.getArrayByteSize(this.originalDims, (RealType)Cast.unchecked(CommonUtils.getImgLib2DataType(this.originalDataType)), false, this.isFortran);
        }
        return this.mappedPointer.getByteBuffer(0L, (long)len);
    }

    @Override
    public ByteBuffer getDataBufferNoHeader() {
        int offset = 0;
        long totSize = 1L;
        for (long l : this.originalDims) {
            totSize *= l;
        }
        if (this.isNumpyFormat()) {
            long npSize = DecodeNumpy.calculateNpyStyleByteArrayLength(this.originalDims, (RealType)Cast.unchecked(CommonUtils.getImgLib2DataType(this.originalDataType)), this.isFortran);
            offset = (int)(npSize - (long)DecodeNumpy.DATA_TYPES_MAP.get(this.originalDataType).intValue() * totSize);
            totSize = npSize;
        }
        return this.mappedPointer.getByteBuffer((long)offset, totSize - (long)offset);
    }

    private static <T extends RealType<T> & NativeType<T>> RandomAccessibleInterval<T> buildFromSharedMemoryBlock(Pointer pSharedMemory, long[] shape, String type, boolean isFortran) {
        Object dataType = CommonUtils.getImgLib2DataType(type);
        return SharedMemoryArrayWin.buildFromSharedMemoryBlock(pSharedMemory, shape, dataType, isFortran, 0, ByteOrder.LITTLE_ENDIAN);
    }

    protected <T extends RealType<T> & NativeType<T>> RandomAccessibleInterval<T> buildImgLib2FromNumpyLikeSHMA() {
        int offset = 0;
        byte[] buf = new byte[DecodeNumpy.NUMPY_PREFIX.length];
        this.mappedPointer.getByteBuffer((long)offset, (long)DecodeNumpy.NUMPY_PREFIX.length).get(buf, 0, DecodeNumpy.NUMPY_PREFIX.length);
        if (!Arrays.equals(buf, DecodeNumpy.NUMPY_PREFIX)) {
            throw new IllegalArgumentException("Malformed  or unsopported Numpy array");
        }
        offset = DecodeNumpy.NUMPY_PREFIX.length;
        byte major = this.mappedPointer.getByteBuffer((long)offset, 1L).get();
        byte minor = this.mappedPointer.getByteBuffer((long)(++offset), 1L).get();
        ++offset;
        if (major < 1 || major > 3 || minor != 0) {
            throw new IllegalArgumentException("Unknown numpy version: " + major + '.' + minor);
        }
        int len = major == 1 ? 2 : 4;
        ByteBuffer bb = this.mappedPointer.getByteBuffer((long)offset, (long)len);
        offset += len;
        bb.order(ByteOrder.LITTLE_ENDIAN);
        len = major == 1 ? (int)bb.getShort() : bb.getInt();
        buf = new byte[len];
        this.mappedPointer.getByteBuffer((long)offset, (long)len).get(buf, 0, len);
        offset += len;
        String header = new String(buf, StandardCharsets.UTF_8);
        Matcher m = DecodeNumpy.HEADER_PATTERN.matcher(header);
        if (!m.find()) {
            throw new IllegalArgumentException("Invalid numpy header: " + header);
        }
        String typeStr = m.group(1);
        String fortranOrder = m.group(2).trim();
        String shapeStr = m.group(3);
        long[] shape = new long[]{};
        if (!shapeStr.isEmpty()) {
            String[] tokens = shapeStr.split(", ?");
            shape = Arrays.stream(tokens).mapToLong(Long::parseLong).toArray();
        }
        char order = typeStr.charAt(0);
        ByteOrder byteOrder = null;
        if (order == '>') {
            byteOrder = ByteOrder.BIG_ENDIAN;
        } else if (order == '<') {
            byteOrder = ByteOrder.LITTLE_ENDIAN;
        } else if (order == '|') {
            byteOrder = ByteOrder.LITTLE_ENDIAN;
            new IOException("Numpy .npy file did not specify the byte order of the array. It was automatically opened as little endian but this does not guarantee the that the file is open correctly. Caution is advised.").printStackTrace();
        } else {
            new IllegalArgumentException("Not supported ByteOrder for the provided .npy array.");
        }
        String dtype = DecodeNumpy.getDataType(typeStr.substring(1));
        long numBytes = DecodeNumpy.DATA_TYPES_MAP.get(dtype).intValue();
        long count = shape.length == 0 ? 1L : Arrays.stream(shape).reduce(Math::multiplyExact).getAsLong();
        len = Math.toIntExact(count * numBytes);
        return SharedMemoryArrayWin.buildFromSharedMemoryBlock(this.mappedPointer, shape, (RealType)Cast.unchecked(CommonUtils.getImgLib2DataType(dtype)), fortranOrder.equals("True"), offset, byteOrder);
    }

    private static <T extends RealType<T> & NativeType<T>> RandomAccessibleInterval<T> buildFromSharedMemoryBlock(Pointer pSharedMemory, long[] shape, T dataType, boolean isFortran, int offset, ByteOrder order) {
        int arrSize;
        long[] transposedShape = new long[shape.length];
        for (int i = 0; i < shape.length; ++i) {
            transposedShape[i] = shape[shape.length - i - 1];
        }
        if (dataType instanceof ByteType) {
            arrSize = 1;
            for (long l : shape) {
                arrSize = (int)((long)arrSize * l);
            }
            ByteBufferAccess byteBufferAccess = new ByteBufferAccess(pSharedMemory.getByteBuffer((long)offset, (long)arrSize).order(order), true);
            return (RandomAccessibleInterval)Cast.unchecked(Utils.transpose(ArrayImgs.bytes((ByteAccess)byteBufferAccess, (long[])transposedShape)));
        }
        if (dataType instanceof ByteType && isFortran) {
            arrSize = 1;
            for (long l : shape) {
                arrSize = (int)((long)arrSize * l);
            }
            ByteBufferAccess byteBufferAccess = new ByteBufferAccess(pSharedMemory.getByteBuffer((long)offset, (long)arrSize).order(order), true);
            return (RandomAccessibleInterval)Cast.unchecked((Object)ArrayImgs.bytes((ByteAccess)byteBufferAccess, (long[])shape));
        }
        if (dataType instanceof UnsignedByteType && isFortran) {
            arrSize = 1;
            for (long l : shape) {
                arrSize = (int)((long)arrSize * l);
            }
            ByteBufferAccess byteBufferAccess = new ByteBufferAccess(pSharedMemory.getByteBuffer((long)offset, (long)arrSize).order(order), true);
            return (RandomAccessibleInterval)Cast.unchecked((Object)ArrayImgs.unsignedBytes((ByteAccess)byteBufferAccess, (long[])shape));
        }
        if (dataType instanceof UnsignedByteType) {
            arrSize = 1;
            for (long l : shape) {
                arrSize = (int)((long)arrSize * l);
            }
            ByteBufferAccess byteBufferAccess = new ByteBufferAccess(pSharedMemory.getByteBuffer((long)offset, (long)arrSize).order(order), true);
            return (RandomAccessibleInterval)Cast.unchecked(Utils.transpose(ArrayImgs.unsignedBytes((ByteAccess)byteBufferAccess, (long[])transposedShape)));
        }
        if (dataType instanceof ShortType && isFortran) {
            arrSize = 2;
            for (long l : shape) {
                arrSize = (int)((long)arrSize * l);
            }
            ShortBufferAccess shortBufferAccess = new ShortBufferAccess(pSharedMemory.getByteBuffer((long)offset, (long)arrSize).order(order), true);
            return (RandomAccessibleInterval)Cast.unchecked((Object)ArrayImgs.shorts((ShortAccess)shortBufferAccess, (long[])shape));
        }
        if (dataType instanceof ShortType) {
            arrSize = 2;
            for (long l : shape) {
                arrSize = (int)((long)arrSize * l);
            }
            ShortBufferAccess shortBufferAccess = new ShortBufferAccess(pSharedMemory.getByteBuffer((long)offset, (long)arrSize).order(order), true);
            return (RandomAccessibleInterval)Cast.unchecked(Utils.transpose(ArrayImgs.shorts((ShortAccess)shortBufferAccess, (long[])transposedShape)));
        }
        if (dataType instanceof UnsignedShortType && isFortran) {
            arrSize = 2;
            for (long l : shape) {
                arrSize = (int)((long)arrSize * l);
            }
            ShortBufferAccess shortBufferAccess = new ShortBufferAccess(pSharedMemory.getByteBuffer((long)offset, (long)arrSize).order(order), true);
            return (RandomAccessibleInterval)Cast.unchecked((Object)ArrayImgs.unsignedShorts((ShortAccess)shortBufferAccess, (long[])shape));
        }
        if (dataType instanceof UnsignedShortType) {
            arrSize = 2;
            for (long l : shape) {
                arrSize = (int)((long)arrSize * l);
            }
            ShortBufferAccess shortBufferAccess = new ShortBufferAccess(pSharedMemory.getByteBuffer((long)offset, (long)arrSize).order(order), true);
            return (RandomAccessibleInterval)Cast.unchecked(Utils.transpose(ArrayImgs.unsignedShorts((ShortAccess)shortBufferAccess, (long[])transposedShape)));
        }
        if (dataType instanceof IntType && isFortran) {
            arrSize = 4;
            for (long l : shape) {
                arrSize = (int)((long)arrSize * l);
            }
            IntBufferAccess intBufferAccess = new IntBufferAccess(pSharedMemory.getByteBuffer((long)offset, (long)arrSize).order(order), true);
            return (RandomAccessibleInterval)Cast.unchecked((Object)ArrayImgs.ints((IntAccess)intBufferAccess, (long[])shape));
        }
        if (dataType instanceof IntType) {
            arrSize = 4;
            for (long l : shape) {
                arrSize = (int)((long)arrSize * l);
            }
            IntBufferAccess intBufferAccess = new IntBufferAccess(pSharedMemory.getByteBuffer((long)offset, (long)arrSize).order(order), true);
            return (RandomAccessibleInterval)Cast.unchecked(Utils.transpose(ArrayImgs.ints((IntAccess)intBufferAccess, (long[])transposedShape)));
        }
        if (dataType instanceof UnsignedIntType && isFortran) {
            arrSize = 4;
            for (long l : shape) {
                arrSize = (int)((long)arrSize * l);
            }
            IntBufferAccess intBufferAccess = new IntBufferAccess(pSharedMemory.getByteBuffer((long)offset, (long)arrSize).order(order), true);
            return (RandomAccessibleInterval)Cast.unchecked((Object)ArrayImgs.unsignedInts((IntAccess)intBufferAccess, (long[])shape));
        }
        if (dataType instanceof UnsignedIntType) {
            arrSize = 4;
            for (long l : shape) {
                arrSize = (int)((long)arrSize * l);
            }
            IntBufferAccess intBufferAccess = new IntBufferAccess(pSharedMemory.getByteBuffer((long)offset, (long)arrSize).order(order), true);
            return (RandomAccessibleInterval)Cast.unchecked(Utils.transpose(ArrayImgs.unsignedInts((IntAccess)intBufferAccess, (long[])transposedShape)));
        }
        if (dataType instanceof LongType && isFortran) {
            arrSize = 8;
            for (long l : shape) {
                arrSize = (int)((long)arrSize * l);
            }
            LongBufferAccess longBufferAccess = new LongBufferAccess(pSharedMemory.getByteBuffer((long)offset, (long)arrSize).order(order), true);
            return (RandomAccessibleInterval)Cast.unchecked((Object)ArrayImgs.longs((LongAccess)longBufferAccess, (long[])shape));
        }
        if (dataType instanceof LongType) {
            arrSize = 8;
            for (long l : shape) {
                arrSize = (int)((long)arrSize * l);
            }
            LongBufferAccess longBufferAccess = new LongBufferAccess(pSharedMemory.getByteBuffer((long)offset, (long)arrSize).order(order), true);
            return (RandomAccessibleInterval)Cast.unchecked(Utils.transpose(ArrayImgs.longs((LongAccess)longBufferAccess, (long[])transposedShape)));
        }
        if (dataType instanceof FloatType && isFortran) {
            arrSize = 4;
            for (long l : shape) {
                arrSize = (int)((long)arrSize * l);
            }
            FloatBufferAccess floatBufferAccess = new FloatBufferAccess(pSharedMemory.getByteBuffer((long)offset, (long)arrSize).order(order), true);
            return (RandomAccessibleInterval)Cast.unchecked((Object)ArrayImgs.floats((FloatAccess)floatBufferAccess, (long[])shape));
        }
        if (dataType instanceof FloatType) {
            arrSize = 4;
            for (long l : shape) {
                arrSize = (int)((long)arrSize * l);
            }
            FloatBufferAccess floatBufferAccess = new FloatBufferAccess(pSharedMemory.getByteBuffer((long)offset, (long)arrSize).order(order), true);
            return (RandomAccessibleInterval)Cast.unchecked(Utils.transpose(ArrayImgs.floats((FloatAccess)floatBufferAccess, (long[])transposedShape)));
        }
        if (dataType instanceof DoubleType && isFortran) {
            arrSize = 8;
            for (long l : shape) {
                arrSize = (int)((long)arrSize * l);
            }
            DoubleBufferAccess doubleBufferAccess = new DoubleBufferAccess(pSharedMemory.getByteBuffer((long)offset, (long)arrSize).order(order), true);
            return (RandomAccessibleInterval)Cast.unchecked((Object)ArrayImgs.doubles((DoubleAccess)doubleBufferAccess, (long[])shape));
        }
        if (dataType instanceof DoubleType) {
            arrSize = 8;
            for (long l : shape) {
                arrSize = (int)((long)arrSize * l);
            }
            DoubleBufferAccess doubleBufferAccess = new DoubleBufferAccess(pSharedMemory.getByteBuffer((long)offset, (long)arrSize).order(order), true);
            return (RandomAccessibleInterval)Cast.unchecked(Utils.transpose(ArrayImgs.doubles((DoubleAccess)doubleBufferAccess, (long[])transposedShape)));
        }
        throw new IllegalArgumentException("Type not supported: " + dataType.getClass().toString());
    }

    public static void main(String[] args) {
        WinNT.HANDLE hMapFile = Kernel32.INSTANCE.OpenFileMapping(4, false, "Local\\wnsm_89f5c80c");
        if (hMapFile == null) {
            throw new RuntimeException("OpenFileMapping failed with error: " + Kernel32.INSTANCE.GetLastError());
        }
        Pointer pSharedMemory = Kernel32.INSTANCE.MapViewOfFile(hMapFile, 4, 0, 0, 0);
        if (pSharedMemory == null) {
            Kernel32.INSTANCE.CloseHandle(hMapFile);
            throw new RuntimeException("MapViewOfFile failed with error: " + Kernel32.INSTANCE.GetLastError());
        }
        WinNT.MEMORY_BASIC_INFORMATION mbi = new WinNT.MEMORY_BASIC_INFORMATION();
        if (Kernel32.INSTANCE.VirtualQueryEx(Kernel32.INSTANCE.GetCurrentProcess(), pSharedMemory, mbi, new BaseTSD.SIZE_T((long)mbi.size())).intValue() == 0) {
            throw new RuntimeException("Unable to retrieve the size of the shm segment located at ''. Errno: " + Kernel32.INSTANCE.GetLastError());
        }
        int size = mbi.regionSize.intValue();
        Kernel32.INSTANCE.UnmapViewOfFile(pSharedMemory);
        Kernel32.INSTANCE.CloseHandle(hMapFile);
    }
}

