/*
 * Decompiled with CFR 0.152.
 */
package icy.gui.frame.progress;

import icy.gui.frame.IcyExternalFrame;
import icy.gui.frame.IcyFrame;
import icy.gui.frame.IcyInternalFrame;
import icy.gui.main.MainFrame;
import icy.gui.main.TaskFrameManager;
import icy.main.Icy;
import icy.system.thread.ThreadUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.BorderFactory;
import javax.swing.JPanel;

public abstract class TaskFrame
extends IcyFrame {
    protected JPanel mainPanel;
    private boolean remove = false;

    public TaskFrame() {
        this("Task in progress", false, false, false, false);
    }

    public TaskFrame(String title) {
        this(title, false, false, false, false);
    }

    public TaskFrame(String title, boolean resizable) {
        this(title, resizable, false, false, false);
    }

    public TaskFrame(String title, boolean resizable, boolean closable) {
        this(title, resizable, closable, false, false);
    }

    public TaskFrame(String title, boolean resizable, boolean closable, boolean maximizable) {
        this(title, resizable, closable, maximizable, false);
    }

    public TaskFrame(String title, boolean resizable, boolean closable, boolean maximizable, boolean iconifiable) {
        super(title, resizable, closable, maximizable, iconifiable, true);
        if (this.headless) {
            return;
        }
        ThreadUtil.invokeLater(new Runnable(){

            @Override
            public void run() {
                Dimension desktopSize;
                IcyInternalFrame iFrame = TaskFrame.this.getIcyInternalFrame();
                IcyExternalFrame eFrame = TaskFrame.this.getIcyExternalFrame();
                TaskFrame.this.mainPanel = new JPanel();
                TaskFrame.this.mainPanel.setBorder(BorderFactory.createTitledBorder(""));
                iFrame.setBorder(BorderFactory.createEmptyBorder());
                iFrame.setFocusable(false);
                eFrame.setFocusable(false);
                eFrame.setFocusableWindowState(false);
                iFrame.setTitleBarVisible(false);
                eFrame.setTitleBarVisible(false);
                Dimension maxDim = new Dimension(800, 600);
                MainFrame mf = Icy.getMainInterface().getMainFrame();
                if (mf != null && (desktopSize = mf.getDesktopSize()) != null) {
                    maxDim = desktopSize;
                }
                iFrame.setMaximumSize(maxDim);
                eFrame.setMaximumSize(maxDim);
                if (TaskFrame.this.isInternalized()) {
                    iFrame.setLayout(new BorderLayout());
                    iFrame.add((Component)TaskFrame.this.mainPanel, "Center");
                } else {
                    eFrame.setLayout(new BorderLayout());
                    eFrame.add((Component)TaskFrame.this.mainPanel, "Center");
                }
                TaskFrameManager tfm = Icy.getMainInterface().getTaskWindowManager();
                if (tfm != null) {
                    tfm.addTaskWindow(TaskFrame.this);
                }
            }
        });
    }

    @Override
    public void stateChanged() {
        super.stateChanged();
        this.pack();
    }

    @Override
    public void close() {
        this.remove = true;
    }

    public void internalClose() {
        if (this.headless) {
            return;
        }
        super.close();
    }

    public boolean canRemove() {
        return this.remove;
    }

    @Deprecated
    public boolean isCanBeRemoved() {
        return this.canRemove();
    }
}

