/*
 * Decompiled with CFR 0.152.
 */
package icy.gui.main;

import icy.action.FileActions;
import icy.action.GeneralActions;
import icy.action.SequenceOperationActions;
import icy.file.FileUtil;
import icy.file.Loader;
import icy.gui.component.ExternalizablePanel;
import icy.gui.frame.IcyExternalFrame;
import icy.gui.inspector.InspectorPanel;
import icy.gui.main.IcyDesktopPane;
import icy.gui.menu.ApplicationMenu;
import icy.gui.menu.MainRibbon;
import icy.gui.menu.search.SearchBar;
import icy.gui.util.ComponentUtil;
import icy.gui.util.WindowPositionSaver;
import icy.gui.viewer.Viewer;
import icy.image.cache.ImageCache;
import icy.imagej.ImageJWrapper;
import icy.main.Icy;
import icy.math.HungarianAlgorithm;
import icy.preferences.GeneralPreferences;
import icy.resource.ResourceUtil;
import icy.resource.icon.IcyApplicationIcon;
import icy.system.FileDrop;
import icy.system.SystemUtil;
import icy.system.thread.ThreadUtil;
import icy.type.collection.CollectionUtil;
import icy.util.StringUtil;
import ij.IJ;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.ArrayList;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.InputMap;
import javax.swing.JInternalFrame;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import org.pushingpixels.flamingo.api.ribbon.JRibbonFrame;

public class MainFrame
extends JRibbonFrame {
    private static final long serialVersionUID = 1113003570969611614L;
    public static final String TITLE = "Icy";
    public static final String PROPERTY_DETACHEDMODE = "detachedMode";
    public static final int TILE_HORIZONTAL = 0;
    public static final int TILE_VERTICAL = 1;
    public static final int TILE_GRID = 2;
    public static final String ID_PREVIOUS_STATE = "previousState";
    final MainRibbon mainRibbon;
    JSplitPane mainPane;
    private final JPanel centerPanel;
    private final IcyDesktopPane desktopPane;
    InspectorPanel inspector;
    boolean detachedMode;
    int lastInspectorWidth;
    boolean inspectorWidthSet;
    private int previousHeight;
    private boolean previousMaximized;
    private boolean previousInspectorInternalized;
    final WindowPositionSaver positionSaver;

    private static Rectangle getDefaultBounds() {
        Rectangle r = SystemUtil.getMaximumWindowBounds();
        r.width -= 100;
        r.height -= 100;
        r.x += 50;
        r.y += 50;
        return r;
    }

    public static Viewer[] getExternalViewers(Rectangle bounds, boolean wantNotVisible, boolean wantIconized) {
        ArrayList<Viewer> result = new ArrayList<Viewer>();
        for (Viewer viewer : Icy.getMainInterface().getViewers()) {
            if (!viewer.isExternalized()) continue;
            IcyExternalFrame externalFrame = viewer.getIcyExternalFrame();
            if (!wantNotVisible && !externalFrame.isVisible() || !wantIconized && ComponentUtil.isMinimized(externalFrame) || bounds != null && !bounds.contains(ComponentUtil.getCenter(externalFrame))) continue;
            result.add(viewer);
        }
        return result.toArray(new Viewer[result.size()]);
    }

    public static Viewer[] getExternalViewers(boolean wantNotVisible, boolean wantIconized) {
        return MainFrame.getExternalViewers(null, wantNotVisible, wantIconized);
    }

    public MainFrame() throws HeadlessException {
        super(TITLE);
        this.getRootPane().getLayeredPane().getComponent(0).setVisible(false);
        Rectangle defaultBounds = MainFrame.getDefaultBounds();
        this.positionSaver = new WindowPositionSaver(this, "frame/main", defaultBounds.getLocation(), defaultBounds.getSize());
        this.previousInspectorInternalized = this.positionSaver.getPreferences().getBoolean(ID_PREVIOUS_STATE, true);
        this.setAlwaysOnTop(GeneralPreferences.getAlwaysOnTop());
        this.setDefaultCloseOperation(0);
        this.mainRibbon = new MainRibbon(this.getRibbon());
        this.setIconImages(ResourceUtil.getIcyIconImages());
        this.setApplicationIcon(new IcyApplicationIcon());
        this.getRibbon().setMinimized(GeneralPreferences.getRibbonMinimized());
        this.centerPanel = new JPanel();
        this.centerPanel.setLayout(new BorderLayout());
        this.desktopPane = new IcyDesktopPane();
        this.desktopPane.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    int maxLoc;
                    Insets insets = MainFrame.this.mainPane.getInsets();
                    int lastLoc = MainFrame.this.mainPane.getLastDividerLocation();
                    int currentLoc = MainFrame.this.mainPane.getDividerLocation();
                    if (currentLoc != (maxLoc = MainFrame.this.mainPane.getWidth() - (MainFrame.this.mainPane.getDividerSize() + insets.left))) {
                        MainFrame.this.mainPane.setDividerLocation(maxLoc);
                    } else {
                        MainFrame.this.mainPane.setDividerLocation(lastLoc);
                    }
                }
            }
        });
        this.centerPanel.add((Component)this.desktopPane, "Center");
        FileDrop.FileDropListener desktopFileDropListener = new FileDrop.FileDropListener(){

            @Override
            public void filesDropped(File[] files) {
                Loader.load(CollectionUtil.asList(FileUtil.toPaths(files)), files.length <= 1 && !files[0].isDirectory(), true, true);
            }
        };
        FileDrop.FileDropExtListener bandFileDropListener = new FileDrop.FileDropExtListener(){

            @Override
            public void filesDropped(DropTargetDropEvent evt, File[] files) {
                ImageJWrapper imageJ;
                JPanel imageJPanel;
                if (MainFrame.this.getRibbon().getSelectedTask() == MainFrame.this.mainRibbon.getImageJTask() && (imageJPanel = (imageJ = MainFrame.this.mainRibbon.getImageJTask().getImageJ()).getSwingPanel()).contains(ComponentUtil.convertPoint((Component)MainFrame.this.getRibbon(), evt.getLocation(), imageJPanel))) {
                    if (files.length > 0) {
                        final String file = files[0].getAbsolutePath();
                        ThreadUtil.bgRun(new Runnable(){

                            @Override
                            public void run() {
                                IJ.open((String)file);
                            }
                        });
                    }
                    return;
                }
                Loader.load(CollectionUtil.asList(FileUtil.toPaths(files)), false, true, true);
            }
        };
        new FileDrop((Component)this.desktopPane, BorderFactory.createLineBorder(Color.blue.brighter(), 2), false, desktopFileDropListener);
        new FileDrop((Component)this.getRibbon(), BorderFactory.createLineBorder(Color.blue.brighter(), 1), false, bandFileDropListener);
        this.getRibbon().addPropertyChangeListener("minimized", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                boolean value = (Boolean)evt.getNewValue();
                if (MainFrame.this.detachedMode) {
                    MainFrame.this.pack();
                }
                GeneralPreferences.setRibbonMinimized(value);
            }
        });
    }

    public void init() {
        this.inspector = new InspectorPanel();
        this.inspectorWidthSet = false;
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                if (!MainFrame.this.inspectorWidthSet) {
                    if (MainFrame.this.inspector.isInternalized()) {
                        MainFrame.this.mainPane.setDividerLocation(MainFrame.this.getWidth() - MainFrame.this.lastInspectorWidth);
                    }
                    MainFrame.this.inspectorWidthSet = true;
                }
                if (MainFrame.this.detachedMode) {
                    int prefH = MainFrame.this.getPreferredSize().height;
                    if (MainFrame.this.getHeight() > prefH) {
                        MainFrame.this.setSize(MainFrame.this.getWidth(), prefH);
                    }
                }
            }
        });
        this.mainPane = new JSplitPane(1, this.centerPanel, null);
        this.mainPane.setContinuousLayout(true);
        this.mainPane.setOneTouchExpandable(true);
        this.lastInspectorWidth = this.inspector.getPreferredSize().width;
        this.lastInspectorWidth = this.lastInspectorWidth > 16 ? (this.lastInspectorWidth += 14) : 10;
        if (this.inspector.isInternalized()) {
            this.mainPane.setRightComponent(this.inspector);
            this.mainPane.setDividerSize(6);
        } else {
            this.mainPane.setDividerSize(0);
            this.inspector.setParent(this.mainPane);
        }
        this.mainPane.setResizeWeight(1.0);
        this.inspector.addStateListener(new ExternalizablePanel.StateListener(){

            @Override
            public void stateChanged(ExternalizablePanel source, boolean externalized) {
                if (externalized) {
                    MainFrame.this.mainPane.setDividerSize(0);
                } else {
                    MainFrame.this.mainPane.setDividerSize(6);
                    MainFrame.this.mainPane.setDividerLocation(MainFrame.this.getWidth() - MainFrame.this.lastInspectorWidth);
                }
            }
        });
        this.previousHeight = this.getHeight();
        this.previousMaximized = ComponentUtil.isMaximized((Frame)((Object)this));
        this.detachedMode = GeneralPreferences.getMultiWindowMode();
        if (this.detachedMode) {
            if (this.previousMaximized) {
                ComponentUtil.setMaximized((Frame)((Object)this), false);
            }
            this.setSize(this.getWidth(), this.getMinimumSize().height);
        } else {
            this.add(this.mainPane, "Center");
        }
        this.validate();
        this.mainRibbon.init();
        this.refreshTitle();
        this.setVisible(true);
        this.buildActionMap();
    }

    void buildActionMap() {
        this.buildActionMap(this.mainPane.getInputMap(2), this.mainPane.getActionMap());
    }

    private void buildActionMap(InputMap imap, ActionMap amap) {
        imap.put(GeneralActions.searchAction.getKeyStroke(), GeneralActions.searchAction.getName());
        imap.put(FileActions.openSequenceAction.getKeyStroke(), FileActions.openSequenceAction.getName());
        imap.put(FileActions.saveAsSequenceAction.getKeyStroke(), FileActions.saveAsSequenceAction.getName());
        imap.put(GeneralActions.onlineHelpAction.getKeyStroke(), GeneralActions.onlineHelpAction.getName());
        imap.put(SequenceOperationActions.undoAction.getKeyStroke(), SequenceOperationActions.undoAction.getName());
        imap.put(SequenceOperationActions.redoAction.getKeyStroke(), SequenceOperationActions.redoAction.getName());
        amap.put(GeneralActions.searchAction.getName(), GeneralActions.searchAction);
        amap.put(FileActions.openSequenceAction.getName(), FileActions.openSequenceAction);
        amap.put(FileActions.saveAsSequenceAction.getName(), FileActions.saveAsSequenceAction);
        amap.put(GeneralActions.onlineHelpAction.getName(), GeneralActions.onlineHelpAction);
        amap.put(SequenceOperationActions.undoAction.getName(), SequenceOperationActions.undoAction);
        amap.put(SequenceOperationActions.redoAction.getName(), SequenceOperationActions.redoAction);
    }

    public ApplicationMenu getApplicationMenu() {
        return (ApplicationMenu)this.getRibbon().getApplicationMenu();
    }

    public JPanel getCenterPanel() {
        return this.centerPanel;
    }

    public SearchBar getSearchBar() {
        if (this.mainRibbon != null) {
            return this.mainRibbon.getSearchBar();
        }
        return null;
    }

    public IcyDesktopPane getDesktopPane() {
        return this.desktopPane;
    }

    public ArrayList<JInternalFrame> getInternalFrames() {
        if (this.desktopPane != null) {
            return CollectionUtil.asArrayList(this.desktopPane.getAllFrames());
        }
        return new ArrayList<JInternalFrame>();
    }

    public InspectorPanel getInspector() {
        return this.inspector;
    }

    public MainRibbon getMainRibbon() {
        return this.mainRibbon;
    }

    public boolean isDetachedMode() {
        return this.detachedMode;
    }

    public Dimension getDesktopSize() {
        if (this.detachedMode) {
            return SystemUtil.getMaximumWindowBounds().getSize();
        }
        return this.desktopPane.getSize();
    }

    public int getDesktopWidth() {
        return this.getDesktopSize().width;
    }

    public int getDesktopHeight() {
        return this.getDesktopSize().height;
    }

    public int getPreviousHeight() {
        return this.previousHeight;
    }

    public boolean getPreviousMaximized() {
        return this.previousMaximized;
    }

    public boolean isInpectorInternalized() {
        return this.inspector.isInternalized();
    }

    public boolean internalizeInspector() {
        if (this.inspector.isExternalized() && this.inspector.isInternalizationAutorized()) {
            this.inspector.internalize();
            return true;
        }
        return false;
    }

    public boolean externalizeInspector() {
        if (this.inspector.isInternalized() && this.inspector.isExternalizationAutorized()) {
            this.lastInspectorWidth = this.getWidth() - this.mainPane.getDividerLocation();
            this.inspector.externalize();
            return true;
        }
        return false;
    }

    public void organizeCascade() {
        GraphicsDevice dev2;
        int n;
        int n2;
        GraphicsDevice[] graphicsDeviceArray;
        GraphicsDevice[] screenDevices = SystemUtil.getLocalGraphicsEnvironment().getScreenDevices();
        ArrayList<GraphicsDevice> devices = new ArrayList<GraphicsDevice>();
        if (this.isDetachedMode()) {
            graphicsDeviceArray = screenDevices;
            n2 = screenDevices.length;
            n = 0;
            while (n < n2) {
                dev2 = graphicsDeviceArray[n];
                if (dev2.getType() == 0) {
                    devices.add(dev2);
                }
                ++n;
            }
        } else {
            this.desktopPane.organizeCascade();
            graphicsDeviceArray = screenDevices;
            n2 = screenDevices.length;
            n = 0;
            while (n < n2) {
                dev2 = graphicsDeviceArray[n];
                if (dev2.getType() == 0 && !dev2.getDefaultConfiguration().getBounds().contains(this.getLocation())) {
                    devices.add(dev2);
                }
                ++n;
            }
        }
        for (GraphicsDevice dev2 : devices) {
            this.organizeCascade(dev2);
        }
    }

    protected void organizeCascade(GraphicsDevice graphicsDevice) {
        GraphicsConfiguration graphicsConfiguration = graphicsDevice.getDefaultConfiguration();
        Rectangle bounds = graphicsConfiguration.getBounds();
        Insets inset = this.getToolkit().getScreenInsets(graphicsConfiguration);
        bounds.x += inset.left;
        bounds.y += inset.top;
        bounds.width -= inset.left + inset.right;
        bounds.height -= inset.top + inset.bottom;
        Viewer[] viewers = MainFrame.getExternalViewers(bounds, false, false);
        if (bounds.contains(this.getLocation())) {
            this.setLocation(bounds.x, bounds.y);
            int mainFrameW = this.getWidth();
            int mainFrameH = this.getHeight();
            if (mainFrameW > mainFrameH) {
                bounds.y += mainFrameH;
                bounds.height -= mainFrameH;
            } else {
                bounds.x += mainFrameW;
                bounds.width -= mainFrameW;
            }
        }
        int w = bounds.width;
        int h = bounds.height;
        int xMax = bounds.x + w;
        int yMax = bounds.y + h;
        int fw = (int)((float)w * 0.6f);
        int fh = (int)((float)h * 0.6f);
        int x = bounds.x + 32;
        int y = bounds.y + 32;
        Viewer[] viewerArray = viewers;
        int n = viewers.length;
        int n2 = 0;
        while (n2 < n) {
            Viewer v = viewerArray[n2];
            IcyExternalFrame externalFrame = v.getIcyExternalFrame();
            if (externalFrame.isMaximized()) {
                externalFrame.setMaximized(false);
            }
            externalFrame.setBounds(x, y, fw, fh);
            externalFrame.toFront();
            y += 20;
            if ((x += 30) + fw > xMax) {
                x = bounds.x + 32;
            }
            if (y + fh > yMax) {
                y = bounds.y + 32;
            }
            ++n2;
        }
    }

    public void organizeTile(int type) {
        GraphicsDevice dev2;
        int n;
        int n2;
        GraphicsDevice[] graphicsDeviceArray;
        GraphicsDevice[] screenDevices = SystemUtil.getLocalGraphicsEnvironment().getScreenDevices();
        ArrayList<GraphicsDevice> devices = new ArrayList<GraphicsDevice>();
        if (this.isDetachedMode()) {
            graphicsDeviceArray = screenDevices;
            n2 = screenDevices.length;
            n = 0;
            while (n < n2) {
                dev2 = graphicsDeviceArray[n];
                if (dev2.getType() == 0) {
                    devices.add(dev2);
                }
                ++n;
            }
        } else {
            this.desktopPane.organizeTile(type);
            graphicsDeviceArray = screenDevices;
            n2 = screenDevices.length;
            n = 0;
            while (n < n2) {
                dev2 = graphicsDeviceArray[n];
                if (dev2.getType() == 0 && !dev2.getDefaultConfiguration().getBounds().contains(this.getLocation())) {
                    devices.add(dev2);
                }
                ++n;
            }
        }
        for (GraphicsDevice dev2 : devices) {
            this.organizeTile(dev2, type);
        }
    }

    protected void organizeTile(GraphicsDevice graphicsDevice, int type) {
        int numLine;
        int numCol;
        int numFrames;
        GraphicsConfiguration graphicsConfiguration = graphicsDevice.getDefaultConfiguration();
        Rectangle bounds = graphicsConfiguration.getBounds();
        Insets inset = Toolkit.getDefaultToolkit().getScreenInsets(graphicsConfiguration);
        bounds.x += inset.left;
        bounds.y += inset.top;
        bounds.width -= inset.left + inset.right;
        bounds.height -= inset.top + inset.bottom;
        Viewer[] viewers = MainFrame.getExternalViewers(bounds, false, false);
        if (bounds.contains(this.getLocation())) {
            this.setLocation(bounds.x, bounds.y);
            int mainFrameW = this.getWidth();
            int mainFrameH = this.getHeight();
            if (mainFrameW > mainFrameH) {
                bounds.y += mainFrameH;
                bounds.height -= mainFrameH;
            } else {
                bounds.x += mainFrameW;
                bounds.width -= mainFrameW;
            }
        }
        if ((numFrames = viewers.length) == 0) {
            return;
        }
        int w = bounds.width;
        int h = bounds.height;
        int x = bounds.x;
        int y = bounds.y;
        switch (type) {
            case 0: {
                numCol = 1;
                numLine = numFrames;
                break;
            }
            case 1: {
                numCol = numFrames;
                numLine = 1;
                break;
            }
            default: {
                numCol = (int)Math.sqrt(numFrames);
                if (numFrames != numCol * numCol) {
                    ++numCol;
                }
                if (numFrames <= numCol * (numLine = numFrames / numCol)) break;
                ++numLine;
            }
        }
        double[][] framesDistances = new double[numCol * numLine][numFrames];
        int dx = w / numCol;
        int dy = h / numLine;
        int k = 0;
        int i = 0;
        while (i < numLine) {
            int j = 0;
            while (j < numCol) {
                double[] distances = framesDistances[k];
                double fx = (double)(x + j * dx) + (double)dx / 2.0;
                double fy = (double)(y + i * dy) + (double)dy / 2.0;
                int f = 0;
                while (f < numFrames) {
                    Point2D.Double center = ComponentUtil.getCenter(viewers[f].getExternalFrame());
                    distances[f] = Point2D.distanceSq(center.x, center.y, fx, fy);
                    ++f;
                }
                ++j;
                ++k;
            }
            ++i;
        }
        int[] framePos = new HungarianAlgorithm(framesDistances).resolve();
        k = 0;
        int i2 = 0;
        while (i2 < numLine) {
            int j = 0;
            while (j < numCol) {
                int f = framePos[k];
                if (f < numFrames) {
                    IcyExternalFrame externalFrame = viewers[f].getIcyExternalFrame();
                    if (externalFrame.isMaximized()) {
                        externalFrame.setMaximized(false);
                    }
                    externalFrame.setBounds(x + j * dx, y + i2 * dy, dx, dy);
                    externalFrame.toFront();
                }
                ++j;
                ++k;
            }
            ++i2;
        }
    }

    public void setDetachedMode(boolean value) {
        if (this.detachedMode != value) {
            if (value) {
                this.previousInspectorInternalized = this.inspector.isInternalized();
                this.positionSaver.getPreferences().putBoolean(ID_PREVIOUS_STATE, this.previousInspectorInternalized);
                this.externalizeInspector();
                this.inspector.setInternalizationAutorized(false);
                this.previousHeight = this.getHeight();
                this.previousMaximized = ComponentUtil.isMaximized((Frame)((Object)this));
                this.remove(this.mainPane);
                ComponentUtil.setMaximized((Frame)((Object)this), false);
                this.pack();
            } else {
                this.add(this.mainPane, "Center");
                this.setSize(this.getWidth(), this.previousHeight);
                if (this.previousMaximized) {
                    ComponentUtil.setMaximized((Frame)((Object)this), true);
                }
                this.validate();
                this.inspector.setInternalizationAutorized(true);
                if (this.previousInspectorInternalized) {
                    this.internalizeInspector();
                }
            }
            this.detachedMode = value;
            this.firePropertyChange(PROPERTY_DETACHEDMODE, !value, value);
        }
    }

    public void refreshTitle() {
        String virtual;
        String login = GeneralPreferences.getUserLogin();
        String userName = GeneralPreferences.getUserName();
        String string = virtual = ImageCache.isEnabled() && GeneralPreferences.getVirtualMode() ? " (virtual mode)" : "";
        if (!StringUtil.isEmpty(userName)) {
            this.setTitle(TITLE + virtual + " - " + userName);
        } else if (!StringUtil.isEmpty(login)) {
            this.setTitle(TITLE + virtual + " - " + login);
        } else {
            this.setTitle(TITLE + virtual);
        }
    }

    public void reshape(int x, int y, int width, int height) {
        int prefH;
        boolean detached;
        Rectangle r = new Rectangle(x, y, width, height);
        if (this.mainPane == null) {
            detached = this.detachedMode;
        } else {
            boolean bl = detached = this.mainPane.getParent() == null;
        }
        if (detached && r.height > (prefH = this.getPreferredSize().height)) {
            r.height = prefH;
        }
        ComponentUtil.fixPosition((Component)((Object)this), r);
        super.reshape(r.x, r.y, r.width, r.height);
    }
}

