/*
 * Decompiled with CFR 0.152.
 */
package icy.resource.icon;

import icy.gui.util.LookAndFeelUtil;
import icy.image.ImageUtil;
import icy.resource.ResourceUtil;
import icy.util.StringUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.BufferedImage;
import org.pushingpixels.flamingo.api.common.icon.ResizableIcon;

public class IcyIcon
implements ResizableIcon {
    public static final int DEFAULT_SIZE = 20;
    protected Image image;
    protected String name;
    protected Color color;
    protected boolean alpha;
    protected final Dimension dim;
    private BufferedImage cache;
    private BufferedImage alphaImage;

    private IcyIcon(String name, Image image, int size, boolean alpha) {
        this.image = image;
        this.name = name;
        this.color = null;
        this.alpha = alpha;
        this.dim = new Dimension(size, size);
        this.updateImage();
    }

    public IcyIcon(String name, int size, boolean alpha) {
        this(name, null, size, alpha);
    }

    public IcyIcon(String name, int size) {
        this(name, null, size, true);
    }

    public IcyIcon(String name, boolean alpha) {
        this(name, null, 20, alpha);
    }

    public IcyIcon(String name) {
        this(name, null, 20, true);
    }

    public IcyIcon(Image image, int size, boolean alpha) {
        this(null, image, size, alpha);
    }

    public IcyIcon(Image image, int size) {
        this(null, image, size, true);
    }

    public IcyIcon(Image image, boolean alpha) {
        this(null, image, 20, alpha);
    }

    public IcyIcon(Image image) {
        this(null, image, 20, true);
    }

    public IcyIcon(IcyIcon icon) {
        this(icon.getName(), icon.getImage(), icon.getIconWidth(), icon.getAlpha());
    }

    public int getSize() {
        return this.dim.width;
    }

    public void setSize(int size) {
        this.setDimension(new Dimension(size, size));
    }

    public String getName() {
        return this.name;
    }

    public void setName(String value) {
        if (this.name != value) {
            this.name = value;
            this.image = null;
            this.updateImage();
        }
    }

    public Image getImage() {
        return this.image;
    }

    public void setImage(Image value) {
        if (this.image != value) {
            this.image = value;
            this.name = null;
            this.updateImage();
        }
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        if (this.color != color) {
            this.color = color;
            this.update();
        }
    }

    @Deprecated
    public boolean isAlpha() {
        return this.getAlpha();
    }

    public boolean getAlpha() {
        return this.alpha;
    }

    public void setAlpha(boolean alpha) {
        if (this.alpha != alpha) {
            this.alpha = alpha;
            this.updateImage();
        }
    }

    private void updateImage() {
        if (!StringUtil.isEmpty(this.name)) {
            this.image = this.alpha ? ResourceUtil.getAlphaIconAsImage(this.name) : ResourceUtil.getColorIconAsImage(this.name);
        }
        this.update();
    }

    private void update() {
        if (this.image != null) {
            this.cache = ImageUtil.scaleQuality(this.image, this.dim.width, this.dim.height);
            this.alphaImage = new BufferedImage(this.dim.width, this.dim.height, 2);
        } else {
            this.cache = null;
            this.alphaImage = null;
        }
    }

    public Dimension getDimension() {
        return new Dimension(this.dim);
    }

    public void setDimension(Dimension newDim) {
        if (!this.dim.equals(newDim)) {
            this.dim.setSize(newDim);
            this.update();
        }
    }

    public void paintIcon(Component c, Graphics g, int x, int y) {
        if (this.alpha) {
            if (this.alphaImage != null) {
                if (this.color == null) {
                    LookAndFeelUtil.paintForegroundImageFromAlphaImage(c, this.cache, this.alphaImage);
                } else {
                    ImageUtil.paintColorImageFromAlphaImage(this.cache, this.alphaImage, this.color);
                }
            }
            g.drawImage(this.alphaImage, x, y, null);
        } else {
            g.drawImage(this.cache, x, y, null);
        }
    }

    public int getIconWidth() {
        return this.dim.width;
    }

    public int getIconHeight() {
        return this.dim.height;
    }
}

