/*
 * Decompiled with CFR 0.152.
 */
package org.jtransforms.dht;

import java.util.Arrays;
import org.jtransforms.dht.FloatDHT_1D;
import org.jtransforms.dht.FloatDHT_2D;
import org.jtransforms.dht.FloatDHT_3D;
import org.jtransforms.utils.ConcurrencyUtils;
import org.jtransforms.utils.IOUtils;
import pl.edu.icm.jlargearrays.FloatLargeArray;

public class BenchmarkFloatDHT {
    private static int nthread = 8;
    private static int niter = 200;
    private static int nsize = 16;
    private static int threadsBegin2D = 65636;
    private static int threadsBegin3D = 65636;
    private static boolean doWarmup = true;
    private static long[] sizes1D = new long[]{262144L, 524288L, 0x100000L, 0x200000L, 0x400000L, 0x800000L, 0x1000000L, 0x2000000L, 10368L, 27000L, 75600L, 165375L, 362880L, 1562500L, 0x310000L, 6250000L};
    private static long[] sizes2D = new long[]{256L, 512L, 1024L, 2048L, 4096L, 8192L, 16384L, 32768L, 260L, 520L, 1050L, 1458L, 1960L, 2916L, 4116L, 5832L};
    private static long[] sizes3D = new long[]{16L, 32L, 64L, 128L, 256L, 512L, 1024L, 2048L, 5L, 17L, 30L, 95L, 180L, 270L, 324L, 420L};
    private static boolean doScaling = false;

    private BenchmarkFloatDHT() {
    }

    public static void parseArguments(String[] stringArray) {
        if (stringArray.length > 0) {
            int n;
            nthread = Integer.parseInt(stringArray[0]);
            threadsBegin2D = Integer.parseInt(stringArray[1]);
            threadsBegin3D = Integer.parseInt(stringArray[2]);
            niter = Integer.parseInt(stringArray[3]);
            doWarmup = Boolean.parseBoolean(stringArray[4]);
            doScaling = Boolean.parseBoolean(stringArray[5]);
            nsize = Integer.parseInt(stringArray[6]);
            sizes1D = new long[nsize];
            sizes2D = new long[nsize];
            sizes3D = new long[nsize];
            for (n = 0; n < nsize; ++n) {
                BenchmarkFloatDHT.sizes1D[n] = Integer.parseInt(stringArray[7 + n]);
            }
            for (n = 0; n < nsize; ++n) {
                BenchmarkFloatDHT.sizes2D[n] = Integer.parseInt(stringArray[7 + nsize + n]);
            }
            for (n = 0; n < nsize; ++n) {
                BenchmarkFloatDHT.sizes3D[n] = Integer.parseInt(stringArray[7 + nsize + nsize + n]);
            }
        } else {
            System.out.println("Default settings are used.");
        }
        ConcurrencyUtils.setNumberOfThreads(nthread);
        ConcurrencyUtils.setThreadsBeginN_2D(threadsBegin2D);
        ConcurrencyUtils.setThreadsBeginN_3D(threadsBegin3D);
        System.out.println("nthred = " + nthread);
        System.out.println("threadsBegin2D = " + threadsBegin2D);
        System.out.println("threadsBegin3D = " + threadsBegin3D);
        System.out.println("niter = " + niter);
        System.out.println("doWarmup = " + doWarmup);
        System.out.println("doScaling = " + doScaling);
        System.out.println("nsize = " + nsize);
        System.out.println("sizes1D[] = " + Arrays.toString(sizes1D));
        System.out.println("sizes2D[] = " + Arrays.toString(sizes2D));
        System.out.println("sizes3D[] = " + Arrays.toString(sizes3D));
    }

    public static void benchmarkForward_1D() {
        double[] dArray = new double[nsize];
        double[] dArray2 = new double[nsize];
        for (int i = 0; i < nsize; ++i) {
            float[] fArray;
            System.out.println("Forward DHT 1D of size " + sizes1D[i]);
            if (doWarmup) {
                FloatDHT_1D floatDHT_1D = new FloatDHT_1D(sizes1D[i]);
                fArray = new float[(int)sizes1D[i]];
                IOUtils.fillMatrix_1D(sizes1D[i], fArray);
                floatDHT_1D.forward(fArray);
                IOUtils.fillMatrix_1D(sizes1D[i], fArray);
                floatDHT_1D.forward(fArray);
            }
            long l = System.nanoTime();
            FloatDHT_1D floatDHT_1D = new FloatDHT_1D(sizes1D[i]);
            dArray2[i] = (double)(System.nanoTime() - l) / 1000000.0;
            fArray = new float[(int)sizes1D[i]];
            double d = 0.0;
            for (int j = 0; j < niter; ++j) {
                IOUtils.fillMatrix_1D(sizes1D[i], fArray);
                l = System.nanoTime();
                floatDHT_1D.forward(fArray);
                l = System.nanoTime() - l;
                if (!((double)l < d)) continue;
                d = l;
            }
            dArray[i] = d / 1000000.0;
            int n = i;
            dArray2[n] = dArray2[n] + dArray[i];
            System.out.println("\tBest execution time without constructor: " + String.format("%.2f", dArray[i]) + " msec");
            System.out.println("\tBest execution time with constructor: " + String.format("%.2f", dArray2[i]) + " msec");
            fArray = null;
            floatDHT_1D = null;
            System.gc();
            ConcurrencyUtils.sleep(5000L);
        }
        IOUtils.writeFFTBenchmarkResultsToFile("benchmarkFloatForwardDHT_1D.txt", nthread, niter, doWarmup, doScaling, sizes1D, dArray, dArray2);
    }

    public static void benchmarkForward_2D_input_1D() {
        double[] dArray = new double[nsize];
        double[] dArray2 = new double[nsize];
        for (int i = 0; i < nsize; ++i) {
            FloatLargeArray floatLargeArray;
            System.out.println("Forward DHT 2D (input 1D) of size " + sizes2D[i] + " x " + sizes2D[i]);
            if (doWarmup) {
                FloatDHT_2D floatDHT_2D = new FloatDHT_2D(sizes2D[i], sizes2D[i]);
                floatLargeArray = new FloatLargeArray(sizes2D[i] * sizes2D[i], false);
                IOUtils.fillMatrix_2D(sizes2D[i], sizes2D[i], floatLargeArray);
                floatDHT_2D.forward(floatLargeArray);
                IOUtils.fillMatrix_2D(sizes2D[i], sizes2D[i], floatLargeArray);
                floatDHT_2D.forward(floatLargeArray);
            }
            long l = System.nanoTime();
            FloatDHT_2D floatDHT_2D = new FloatDHT_2D(sizes2D[i], sizes2D[i]);
            dArray2[i] = (double)(System.nanoTime() - l) / 1000000.0;
            floatLargeArray = new FloatLargeArray(sizes2D[i] * sizes2D[i], false);
            double d = 0.0;
            for (int j = 0; j < niter; ++j) {
                IOUtils.fillMatrix_2D(sizes2D[i], sizes2D[i], floatLargeArray);
                l = System.nanoTime();
                floatDHT_2D.forward(floatLargeArray);
                l = System.nanoTime() - l;
                if (!((double)l < d)) continue;
                d = l;
            }
            dArray[i] = d / 1000000.0;
            int n = i;
            dArray2[n] = dArray2[n] + dArray[i];
            System.out.println("\tBest execution time without constructor: " + String.format("%.2f", dArray[i]) + " msec");
            System.out.println("\tBest execution time with constructor: " + String.format("%.2f", dArray2[i]) + " msec");
            floatLargeArray = null;
            floatDHT_2D = null;
            System.gc();
            ConcurrencyUtils.sleep(5000L);
        }
        IOUtils.writeFFTBenchmarkResultsToFile("benchmarkFloatForwardDHT_2D_input_1D.txt", nthread, niter, doWarmup, doScaling, sizes2D, dArray, dArray2);
    }

    public static void benchmarkForward_2D_input_2D() {
        double[] dArray = new double[nsize];
        double[] dArray2 = new double[nsize];
        for (int i = 0; i < nsize; ++i) {
            float[][] fArray;
            System.out.println("Forward DHT 2D (input 2D) of size " + sizes2D[i] + " x " + sizes2D[i]);
            if (doWarmup) {
                FloatDHT_2D floatDHT_2D = new FloatDHT_2D(sizes2D[i], sizes2D[i]);
                fArray = new float[(int)sizes2D[i]][(int)sizes2D[i]];
                IOUtils.fillMatrix_2D(sizes2D[i], sizes2D[i], fArray);
                floatDHT_2D.forward(fArray);
                IOUtils.fillMatrix_2D(sizes2D[i], sizes2D[i], fArray);
                floatDHT_2D.forward(fArray);
            }
            long l = System.nanoTime();
            FloatDHT_2D floatDHT_2D = new FloatDHT_2D(sizes2D[i], sizes2D[i]);
            dArray2[i] = (double)(System.nanoTime() - l) / 1000000.0;
            fArray = new float[(int)sizes2D[i]][(int)sizes2D[i]];
            double d = 0.0;
            for (int j = 0; j < niter; ++j) {
                IOUtils.fillMatrix_2D(sizes2D[i], sizes2D[i], fArray);
                l = System.nanoTime();
                floatDHT_2D.forward(fArray);
                l = System.nanoTime() - l;
                if (!((double)l < d)) continue;
                d = l;
            }
            dArray[i] = d / 1000000.0;
            int n = i;
            dArray2[n] = dArray2[n] + dArray[i];
            System.out.println("\tBest execution time without constructor: " + String.format("%.2f", dArray[i]) + " msec");
            System.out.println("\tBest execution time with constructor: " + String.format("%.2f", dArray2[i]) + " msec");
            fArray = null;
            floatDHT_2D = null;
            System.gc();
            ConcurrencyUtils.sleep(5000L);
        }
        IOUtils.writeFFTBenchmarkResultsToFile("benchmarkFloatForwardDHT_2D_input_2D.txt", nthread, niter, doWarmup, doScaling, sizes2D, dArray, dArray2);
    }

    public static void benchmarkForward_3D_input_1D() {
        double[] dArray = new double[nsize];
        double[] dArray2 = new double[nsize];
        for (int i = 0; i < nsize; ++i) {
            FloatLargeArray floatLargeArray;
            System.out.println("Forward DHT 3D (input 1D) of size " + sizes3D[i] + " x " + sizes3D[i] + " x " + sizes3D[i]);
            if (doWarmup) {
                FloatDHT_3D floatDHT_3D = new FloatDHT_3D(sizes3D[i], sizes3D[i], sizes3D[i]);
                floatLargeArray = new FloatLargeArray(sizes3D[i] * sizes3D[i] * sizes3D[i], false);
                IOUtils.fillMatrix_3D(sizes3D[i], sizes3D[i], sizes3D[i], floatLargeArray);
                floatDHT_3D.forward(floatLargeArray);
                IOUtils.fillMatrix_3D(sizes3D[i], sizes3D[i], sizes3D[i], floatLargeArray);
                floatDHT_3D.forward(floatLargeArray);
            }
            long l = System.nanoTime();
            FloatDHT_3D floatDHT_3D = new FloatDHT_3D(sizes3D[i], sizes3D[i], sizes3D[i]);
            dArray2[i] = (double)(System.nanoTime() - l) / 1000000.0;
            floatLargeArray = new FloatLargeArray(sizes3D[i] * sizes3D[i] * sizes3D[i], false);
            double d = 0.0;
            for (int j = 0; j < niter; ++j) {
                IOUtils.fillMatrix_3D(sizes3D[i], sizes3D[i], sizes3D[i], floatLargeArray);
                l = System.nanoTime();
                floatDHT_3D.forward(floatLargeArray);
                l = System.nanoTime() - l;
                if (!((double)l < d)) continue;
                d = l;
            }
            dArray[i] = d / 1000000.0;
            int n = i;
            dArray2[n] = dArray2[n] + dArray[i];
            System.out.println("\tBest execution time without constructor: " + String.format("%.2f", dArray[i]) + " msec");
            System.out.println("\tBest execution time with constructor: " + String.format("%.2f", dArray2[i]) + " msec");
            floatLargeArray = null;
            floatDHT_3D = null;
            System.gc();
            ConcurrencyUtils.sleep(5000L);
        }
        IOUtils.writeFFTBenchmarkResultsToFile("benchmarkFloatForwardDHT_3D_input_1D.txt", nthread, niter, doWarmup, doScaling, sizes3D, dArray, dArray2);
    }

    public static void benchmarkForward_3D_input_3D() {
        double[] dArray = new double[nsize];
        double[] dArray2 = new double[nsize];
        for (int i = 0; i < nsize; ++i) {
            float[][][] fArray;
            System.out.println("Forward DHT 3D (input 3D) of size " + sizes3D[i] + " x " + sizes3D[i] + " x " + sizes3D[i]);
            if (doWarmup) {
                FloatDHT_3D floatDHT_3D = new FloatDHT_3D(sizes3D[i], sizes3D[i], sizes3D[i]);
                fArray = new float[(int)sizes3D[i]][(int)sizes3D[i]][(int)sizes3D[i]];
                IOUtils.fillMatrix_3D(sizes3D[i], sizes3D[i], sizes3D[i], fArray);
                floatDHT_3D.forward(fArray);
                IOUtils.fillMatrix_3D(sizes3D[i], sizes3D[i], sizes3D[i], fArray);
                floatDHT_3D.forward(fArray);
            }
            long l = System.nanoTime();
            FloatDHT_3D floatDHT_3D = new FloatDHT_3D(sizes3D[i], sizes3D[i], sizes3D[i]);
            dArray2[i] = (double)(System.nanoTime() - l) / 1000000.0;
            fArray = new float[(int)sizes3D[i]][(int)sizes3D[i]][(int)sizes3D[i]];
            double d = 0.0;
            for (int j = 0; j < niter; ++j) {
                IOUtils.fillMatrix_3D(sizes3D[i], sizes3D[i], sizes3D[i], fArray);
                l = System.nanoTime();
                floatDHT_3D.forward(fArray);
                l = System.nanoTime() - l;
                if (!((double)l < d)) continue;
                d = l;
            }
            dArray[i] = d / 1000000.0;
            int n = i;
            dArray2[n] = dArray2[n] + dArray[i];
            System.out.println("\tBest execution time without constructor: " + String.format("%.2f", dArray[i]) + " msec");
            System.out.println("\tBest execution time with constructor: " + String.format("%.2f", dArray2[i]) + " msec");
            fArray = null;
            floatDHT_3D = null;
            System.gc();
            ConcurrencyUtils.sleep(5000L);
        }
        IOUtils.writeFFTBenchmarkResultsToFile("benchmarkFloatForwardDHT_3D_input_3D.txt", nthread, niter, doWarmup, doScaling, sizes3D, dArray, dArray2);
    }

    public static void main(String[] stringArray) {
        BenchmarkFloatDHT.parseArguments(stringArray);
        BenchmarkFloatDHT.benchmarkForward_1D();
        BenchmarkFloatDHT.benchmarkForward_2D_input_1D();
        BenchmarkFloatDHT.benchmarkForward_2D_input_2D();
        BenchmarkFloatDHT.benchmarkForward_3D_input_1D();
        BenchmarkFloatDHT.benchmarkForward_3D_input_3D();
        System.exit(0);
    }
}

