/*
 * Decompiled with CFR 0.152.
 */
package org.jtransforms.dht;

import java.util.concurrent.Future;
import org.jtransforms.fft.DoubleFFT_1D;
import org.jtransforms.utils.CommonUtils;
import org.jtransforms.utils.ConcurrencyUtils;
import pl.edu.icm.jlargearrays.DoubleLargeArray;
import pl.edu.icm.jlargearrays.Utilities;

public class DoubleDHT_1D {
    private final int n;
    private final long nl;
    private final DoubleFFT_1D fft;
    private final boolean useLargeArrays;

    public DoubleDHT_1D(long l) {
        this.n = (int)l;
        this.nl = l;
        this.useLargeArrays = l >= ConcurrencyUtils.getLargeArraysBeginN();
        this.fft = new DoubleFFT_1D(l);
    }

    public void forward(double[] dArray) {
        this.forward(dArray, 0);
    }

    public void forward(DoubleLargeArray doubleLargeArray) {
        this.forward(doubleLargeArray, 0L);
    }

    public void forward(final double[] dArray, final int n) {
        if (this.n == 1) {
            return;
        }
        if (this.useLargeArrays) {
            this.forward(new DoubleLargeArray(dArray), (long)n);
        } else {
            this.fft.realForward(dArray, n);
            final double[] dArray2 = new double[this.n];
            System.arraycopy(dArray, n, dArray2, 0, this.n);
            int n2 = this.n / 2;
            int n3 = ConcurrencyUtils.getNumberOfThreads();
            if (n3 > 1 && (long)n2 > ConcurrencyUtils.getThreadsBeginN_1D_FFT_2Threads()) {
                n3 = 2;
                int n4 = n2 / n3;
                Future[] futureArray = new Future[n3];
                for (int i = 0; i < n3; ++i) {
                    final int n5 = 1 + i * n4;
                    final int n6 = i == n3 - 1 ? n2 : n5 + n4;
                    futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            for (int i = n5; i < n6; ++i) {
                                int n3 = 2 * i;
                                int n2 = n3 + 1;
                                dArray[n + i] = dArray2[n3] - dArray2[n2];
                                dArray[n + ((DoubleDHT_1D)DoubleDHT_1D.this).n - i] = dArray2[n3] + dArray2[n2];
                            }
                        }
                    });
                }
                ConcurrencyUtils.waitForCompletion(futureArray);
            } else {
                for (int i = 1; i < n2; ++i) {
                    int n7 = 2 * i;
                    int n8 = n7 + 1;
                    dArray[n + i] = dArray2[n7] - dArray2[n8];
                    dArray[n + this.n - i] = dArray2[n7] + dArray2[n8];
                }
            }
            if (this.n % 2 == 0) {
                dArray[n + n2] = dArray2[1];
            } else {
                dArray[n + n2] = dArray2[this.n - 1] - dArray2[1];
                dArray[n + n2 + 1] = dArray2[this.n - 1] + dArray2[1];
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void forward(final DoubleLargeArray doubleLargeArray, final long l) {
        if (this.nl == 1L) {
            return;
        }
        if (!this.useLargeArrays) {
            if (doubleLargeArray.getData() == null || l >= Integer.MAX_VALUE) throw new IllegalArgumentException("The data array is too big.");
            this.forward(doubleLargeArray.getData(), (int)l);
            return;
        } else {
            this.fft.realForward(doubleLargeArray, l);
            final DoubleLargeArray doubleLargeArray2 = new DoubleLargeArray(this.nl, false);
            Utilities.arraycopy(doubleLargeArray, l, doubleLargeArray2, 0L, this.nl);
            long l2 = this.nl / 2L;
            int n = ConcurrencyUtils.getNumberOfThreads();
            if (n > 1 && l2 > ConcurrencyUtils.getThreadsBeginN_1D_FFT_2Threads()) {
                n = 2;
                long l3 = l2 / (long)n;
                Future[] futureArray = new Future[n];
                for (int i = 0; i < n; ++i) {
                    final long l4 = 1L + (long)i * l3;
                    final long l5 = i == n - 1 ? l2 : l4 + l3;
                    futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            for (long i = l4; i < l5; ++i) {
                                long l3 = 2L * i;
                                long l2 = l3 + 1L;
                                doubleLargeArray.setDouble(l + i, doubleLargeArray2.getDouble(l3) - doubleLargeArray2.getDouble(l2));
                                doubleLargeArray.setDouble(l + DoubleDHT_1D.this.nl - i, doubleLargeArray2.getDouble(l3) + doubleLargeArray2.getDouble(l2));
                            }
                        }
                    });
                }
                ConcurrencyUtils.waitForCompletion(futureArray);
            } else {
                for (long i = 1L; i < l2; ++i) {
                    long l6 = 2L * i;
                    long l7 = l6 + 1L;
                    doubleLargeArray.setDouble(l + i, doubleLargeArray2.getDouble(l6) - doubleLargeArray2.getDouble(l7));
                    doubleLargeArray.setDouble(l + this.nl - i, doubleLargeArray2.getDouble(l6) + doubleLargeArray2.getDouble(l7));
                }
            }
            if (this.nl % 2L == 0L) {
                doubleLargeArray.setDouble(l + l2, doubleLargeArray2.getDouble(1L));
                return;
            } else {
                doubleLargeArray.setDouble(l + l2, doubleLargeArray2.getDouble(this.nl - 1L) - doubleLargeArray2.getDouble(1L));
                doubleLargeArray.setDouble(l + l2 + 1L, doubleLargeArray2.getDouble(this.nl - 1L) + doubleLargeArray2.getDouble(1L));
            }
        }
    }

    public void inverse(double[] dArray, boolean bl) {
        this.inverse(dArray, 0, bl);
    }

    public void inverse(DoubleLargeArray doubleLargeArray, boolean bl) {
        this.inverse(doubleLargeArray, 0L, bl);
    }

    public void inverse(double[] dArray, int n, boolean bl) {
        if (this.n == 1) {
            return;
        }
        if (this.useLargeArrays) {
            this.inverse(new DoubleLargeArray(dArray), (long)n, bl);
        } else {
            this.forward(dArray, n);
            if (bl) {
                CommonUtils.scale(this.n, 1.0 / (double)this.n, dArray, n, false);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void inverse(DoubleLargeArray doubleLargeArray, long l, boolean bl) {
        if (this.n == 1) {
            return;
        }
        if (!this.useLargeArrays) {
            if (doubleLargeArray.getData() == null || l >= Integer.MAX_VALUE) throw new IllegalArgumentException("The data array is too big.");
            this.inverse(doubleLargeArray.getData(), (int)l, bl);
            return;
        } else {
            this.forward(doubleLargeArray, l);
            if (!bl) return;
            CommonUtils.scale((long)this.n, 1.0 / (double)this.n, doubleLargeArray, l, false);
        }
    }
}

