/*
 * Decompiled with CFR 0.152.
 */
package vtk.rendering;

import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.lang.reflect.Field;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import vtk.rendering.vtkComponent;
import vtk.rendering.vtkEventInterceptor;

public class vtkInteractorForwarder
implements MouseListener,
MouseMotionListener,
MouseWheelListener,
KeyListener {
    public static final int MOUSE_BUTTON_1 = 1;
    public static final int MOUSE_BUTTON_2 = 2;
    public static final int MOUSE_BUTTON_3 = 4;
    public static final int MOUSE_MODIFIER_SHIFT = 1;
    public static final int MOUSE_MODIFIER_CTRL = 2;
    public static final int MOUSE_MODIFIER_ALT = 4;
    private int lastX;
    private int lastY;
    private int ctrlPressed;
    private int shiftPressed;
    private vtkComponent<?> component;
    private double updateRate;
    private double updateRateRelease;
    private double scaleFactor = 1.0;
    private ScheduledExecutorService scheduler;
    private Runnable eventTick;
    private vtkEventInterceptor eventInterceptor;

    public vtkInteractorForwarder(vtkComponent<?> component) {
        this.component = component;
        this.ctrlPressed = 0;
        this.lastY = 0;
        this.lastX = 0;
        this.updateRate = 5.0;
        this.updateRateRelease = 0.01;
        this.scaleFactor = vtkInteractorForwarder.getDisplayScale();
        this.eventTick = new Runnable(){

            @Override
            public void run() {
                vtkInteractorForwarder.this.component.getVTKLock().lock();
                vtkInteractorForwarder.this.component.getRenderWindowInteractor().TimerEvent();
                vtkInteractorForwarder.this.component.getVTKLock().unlock();
            }
        };
        this.scheduler = Executors.newSingleThreadScheduledExecutor();
    }

    public void setEventInterceptor(vtkEventInterceptor eventInterceptor) {
        this.eventInterceptor = eventInterceptor;
    }

    public vtkEventInterceptor getEventInterceptor() {
        return this.eventInterceptor;
    }

    public void StartTimer() {
        this.scheduler.scheduleAtFixedRate(this.eventTick, 10L, 10L, TimeUnit.MILLISECONDS);
    }

    public void DestroyTimer() {
        this.scheduler.shutdown();
    }

    public void setUpdateRate(double updateRate, double updateRateRelease) {
        this.updateRate = updateRate;
        this.updateRateRelease = updateRateRelease;
    }

    public double getUpdateRate() {
        return this.updateRate;
    }

    public double getUpdateRateRelease() {
        return this.updateRateRelease;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void mousePressed(MouseEvent e) {
        if (this.component == null || this.component.getRenderer() == null) {
            return;
        }
        if (this.eventInterceptor != null && this.eventInterceptor.mousePressed(e)) {
            return;
        }
        this.scaleFactor = 1.0;
        if (e.getComponent().getGraphicsConfiguration() != null) {
            this.scaleFactor = vtkInteractorForwarder.getGraphicDeviceScale(e.getComponent().getGraphicsConfiguration().getDevice());
        }
        try {
            this.component.getVTKLock().lockInterruptibly();
            this.component.getRenderWindow().SetDesiredUpdateRate(this.updateRate);
            this.lastX = (int)((double)e.getX() * this.scaleFactor);
            this.lastY = (int)((double)e.getY() * this.scaleFactor);
            this.ctrlPressed = (e.getModifiersEx() & 0x80) == 128 ? 1 : 0;
            this.shiftPressed = (e.getModifiersEx() & 0x40) == 64 ? 1 : 0;
            this.component.getRenderWindowInteractor().SetEventInformationFlipY(this.lastX, this.lastY, this.ctrlPressed, this.shiftPressed, '0', 0, "0");
            switch (e.getButton()) {
                case 3: {
                    this.component.getRenderWindowInteractor().RightButtonPressEvent();
                    return;
                }
                case 2: {
                    this.component.getRenderWindowInteractor().MiddleButtonPressEvent();
                    return;
                }
                default: {
                    this.component.getRenderWindowInteractor().LeftButtonPressEvent();
                    return;
                }
            }
        }
        catch (InterruptedException interruptedException) {
            return;
        }
        finally {
            this.component.getVTKLock().unlock();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void mouseReleased(MouseEvent e) {
        if (this.component == null || this.component.getRenderer() == null) {
            return;
        }
        if (this.eventInterceptor != null && this.eventInterceptor.mouseReleased(e)) {
            return;
        }
        try {
            this.component.getVTKLock().lockInterruptibly();
            this.component.getRenderWindow().SetDesiredUpdateRate(this.updateRateRelease);
            this.lastX = (int)((double)e.getX() * this.scaleFactor);
            this.lastY = (int)((double)e.getY() * this.scaleFactor);
            this.ctrlPressed = (e.getModifiersEx() & 0x80) == 128 ? 1 : 0;
            this.shiftPressed = (e.getModifiersEx() & 0x40) == 64 ? 1 : 0;
            this.component.getRenderWindowInteractor().SetEventInformationFlipY(this.lastX, this.lastY, this.ctrlPressed, this.shiftPressed, '0', 0, "0");
            switch (e.getButton()) {
                case 3: {
                    this.component.getRenderWindowInteractor().RightButtonReleaseEvent();
                    return;
                }
                case 2: {
                    this.component.getRenderWindowInteractor().MiddleButtonReleaseEvent();
                    return;
                }
                default: {
                    this.component.getRenderWindowInteractor().LeftButtonReleaseEvent();
                    return;
                }
            }
        }
        catch (InterruptedException interruptedException) {
            return;
        }
        finally {
            this.component.getVTKLock().unlock();
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        if (this.component == null || this.component.getRenderer() == null) {
            return;
        }
        if (this.eventInterceptor != null && this.eventInterceptor.mouseMoved(e)) {
            return;
        }
        try {
            this.component.getVTKLock().lockInterruptibly();
            this.component.getRenderWindow().SetDesiredUpdateRate(this.updateRateRelease);
            this.lastX = (int)((double)e.getX() * this.scaleFactor);
            this.lastY = (int)((double)e.getY() * this.scaleFactor);
            this.ctrlPressed = (e.getModifiersEx() & 0x80) == 128 ? 1 : 0;
            this.shiftPressed = (e.getModifiersEx() & 0x40) == 64 ? 1 : 0;
            this.component.getRenderWindowInteractor().SetEventInformationFlipY(this.lastX, this.lastY, this.ctrlPressed, this.shiftPressed, '0', 0, "0");
            this.component.getRenderWindowInteractor().MouseMoveEvent();
        }
        catch (InterruptedException interruptedException) {
        }
        finally {
            this.component.getVTKLock().unlock();
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (this.eventInterceptor != null && this.eventInterceptor.mouseDragged(e)) {
            return;
        }
        this.mouseMoved(e);
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        if (this.component == null || this.component.getRenderer() == null) {
            return;
        }
        if (this.eventInterceptor != null && this.eventInterceptor.mouseEntered(e)) {
            return;
        }
        try {
            this.component.getVTKLock().lockInterruptibly();
            this.component.getRenderWindow().SetDesiredUpdateRate(this.updateRateRelease);
            this.lastX = (int)((double)e.getX() * this.scaleFactor);
            this.lastY = (int)((double)e.getY() * this.scaleFactor);
            this.ctrlPressed = (e.getModifiersEx() & 0x80) == 128 ? 1 : 0;
            this.shiftPressed = (e.getModifiersEx() & 0x40) == 64 ? 1 : 0;
            this.component.getRenderWindowInteractor().SetEventInformationFlipY(this.lastX, this.lastY, this.ctrlPressed, this.shiftPressed, '0', 0, "0");
            this.component.getRenderWindowInteractor().EnterEvent();
        }
        catch (InterruptedException interruptedException) {
        }
        finally {
            this.component.getVTKLock().unlock();
        }
    }

    @Override
    public void mouseExited(MouseEvent e) {
        if (this.component == null || this.component.getRenderer() == null) {
            return;
        }
        if (this.eventInterceptor != null && this.eventInterceptor.mouseExited(e)) {
            return;
        }
        try {
            this.component.getVTKLock().lockInterruptibly();
            this.component.getRenderWindow().SetDesiredUpdateRate(this.updateRateRelease);
            this.lastX = (int)((double)e.getX() * this.scaleFactor);
            this.lastY = (int)((double)e.getY() * this.scaleFactor);
            this.ctrlPressed = (e.getModifiersEx() & 0x80) == 128 ? 1 : 0;
            this.shiftPressed = (e.getModifiersEx() & 0x40) == 64 ? 1 : 0;
            this.component.getRenderWindowInteractor().SetEventInformationFlipY(this.lastX, this.lastY, this.ctrlPressed, this.shiftPressed, '0', 0, "0");
            this.component.getRenderWindowInteractor().LeaveEvent();
        }
        catch (InterruptedException interruptedException) {
        }
        finally {
            this.component.getVTKLock().unlock();
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (this.eventInterceptor != null && this.eventInterceptor.mouseClicked(e)) {
            return;
        }
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
        if (this.component == null || this.component.getRenderer() == null) {
            return;
        }
        if (this.eventInterceptor != null && this.eventInterceptor.mouseWheelMoved(e)) {
            return;
        }
        try {
            this.component.getVTKLock().lockInterruptibly();
            this.component.getRenderWindow().SetDesiredUpdateRate(this.updateRateRelease);
            this.lastX = (int)((double)e.getX() * this.scaleFactor);
            this.lastY = (int)((double)e.getY() * this.scaleFactor);
            this.ctrlPressed = (e.getModifiersEx() & 0x80) == 128 ? 1 : 0;
            int n = this.shiftPressed = (e.getModifiersEx() & 0x40) == 64 ? 1 : 0;
            if (e.getWheelRotation() > 0) {
                this.component.getRenderWindowInteractor().SetEventInformationFlipY(this.lastX, this.lastY, this.ctrlPressed, this.shiftPressed, '0', 0, "0");
                this.component.getRenderWindowInteractor().MouseWheelBackwardEvent();
            } else if (e.getWheelRotation() < 0) {
                this.component.getRenderWindowInteractor().SetEventInformationFlipY(this.lastX, this.lastY, this.ctrlPressed, this.shiftPressed, '0', 0, "0");
                this.component.getRenderWindowInteractor().MouseWheelForwardEvent();
            }
        }
        catch (InterruptedException interruptedException) {
        }
        finally {
            this.component.getVTKLock().unlock();
        }
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (this.component == null || this.component.getRenderer() == null) {
            return;
        }
        if (this.eventInterceptor != null && this.eventInterceptor.keyPressed(e)) {
            return;
        }
        try {
            this.component.getVTKLock().lockInterruptibly();
            this.component.getRenderWindow().SetDesiredUpdateRate(this.updateRateRelease);
            this.ctrlPressed = (e.getModifiersEx() & 0x80) == 128 ? 1 : 0;
            this.shiftPressed = (e.getModifiersEx() & 0x40) == 64 ? 1 : 0;
            char keyChar = e.getKeyChar();
            this.component.getRenderWindowInteractor().SetEventInformationFlipY(this.lastX, this.lastY, this.ctrlPressed, this.shiftPressed, keyChar, 0, String.valueOf(keyChar));
            this.component.getRenderWindowInteractor().KeyPressEvent();
            this.component.getRenderWindowInteractor().CharEvent();
        }
        catch (InterruptedException interruptedException) {
        }
        finally {
            this.component.getVTKLock().unlock();
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
        if (this.eventInterceptor != null && this.eventInterceptor.keyReleased(e)) {
            return;
        }
    }

    @Override
    public void keyTyped(KeyEvent e) {
        if (this.eventInterceptor != null && this.eventInterceptor.keyTyped(e)) {
            return;
        }
    }

    public static int getDisplayScale() {
        GraphicsDevice graphicsDevice = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice();
        return vtkInteractorForwarder.getGraphicDeviceScale(graphicsDevice);
    }

    public static int getGraphicDeviceScale(GraphicsDevice device) {
        try {
            Field field = device.getClass().getDeclaredField("scale");
            if (field != null) {
                field.setAccessible(true);
                Object scale = field.get(device);
                if (scale instanceof Integer) {
                    return (Integer)scale;
                }
                System.out.println("Invalid scale type: " + scale);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return 1;
    }
}

