/*
 * Decompiled with CFR 0.152.
 */
package vtk.sample;

import java.awt.BorderLayout;
import java.awt.Component;
import java.io.File;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import vtk.vtkActor;
import vtk.vtkAlgorithmOutput;
import vtk.vtkCanvas;
import vtk.vtkCellPicker;
import vtk.vtkImageData;
import vtk.vtkImagePlaneWidget;
import vtk.vtkNativeLibrary;
import vtk.vtkOutlineFilter;
import vtk.vtkPolyDataMapper;
import vtk.vtkVolume16Reader;

public class ImagePlaneWidget
extends vtkCanvas {
    private static final long serialVersionUID = 1L;
    private int width = 512;
    private int height = 512;

    public ImagePlaneWidget(String path) {
        vtkVolume16Reader v16 = new vtkVolume16Reader();
        v16.SetDataDimensions(64, 64);
        v16.SetDataByteOrderToLittleEndian();
        v16.SetFilePrefix(path);
        v16.SetImageRange(1, 93);
        v16.SetDataSpacing(3.2, 3.2, 1.5);
        v16.Update();
        this.setImageData(v16.GetOutput(), v16.GetOutputPort());
        JPanel p = new JPanel();
        p.setLayout(new BorderLayout());
        p.add((Component)this, "Center");
        JFrame frame = new JFrame("ImagePlaneWidget Test");
        frame.setBounds(10, 10, this.width, this.height);
        frame.getContentPane().add((Component)p, "Center");
        frame.setVisible(true);
        frame.pack();
        frame.setDefaultCloseOperation(3);
    }

    public void setImageData(vtkImageData id, vtkAlgorithmOutput out) {
        vtkCellPicker picker = new vtkCellPicker();
        picker.SetTolerance(0.005);
        vtkImagePlaneWidget planeWidgetX = new vtkImagePlaneWidget();
        planeWidgetX.DisplayTextOn();
        planeWidgetX.SetInputData(id);
        planeWidgetX.SetInteractor(this.getRenderWindowInteractor());
        planeWidgetX.SetPlaneOrientationToXAxes();
        planeWidgetX.SetSliceIndex(32);
        planeWidgetX.SetPicker(picker);
        planeWidgetX.SetKeyPressActivationValue('x');
        planeWidgetX.GetPlaneProperty().SetColor(1.0, 0.0, 0.0);
        planeWidgetX.On();
        vtkImagePlaneWidget planeWidgetY = new vtkImagePlaneWidget();
        planeWidgetY.DisplayTextOn();
        planeWidgetY.SetInputData(id);
        planeWidgetY.SetInteractor(this.getRenderWindowInteractor());
        planeWidgetY.SetPlaneOrientationToYAxes();
        planeWidgetY.SetSliceIndex(32);
        planeWidgetY.SetPicker(picker);
        planeWidgetY.SetKeyPressActivationValue('y');
        planeWidgetY.GetPlaneProperty().SetColor(1.0, 1.0, 0.0);
        planeWidgetY.SetLookupTable(planeWidgetX.GetLookupTable());
        planeWidgetY.On();
        vtkImagePlaneWidget planeWidgetZ = new vtkImagePlaneWidget();
        planeWidgetZ.DisplayTextOn();
        planeWidgetZ.SetInputData(id);
        planeWidgetZ.TextureInterpolateOff();
        planeWidgetZ.SetInteractor(this.getRenderWindowInteractor());
        planeWidgetZ.SetPlaneOrientationToZAxes();
        planeWidgetZ.SetSliceIndex(46);
        planeWidgetZ.SetPicker(picker);
        planeWidgetZ.SetKeyPressActivationValue('z');
        planeWidgetZ.GetPlaneProperty().SetColor(0.0, 0.0, 1.0);
        planeWidgetZ.SetLookupTable(planeWidgetX.GetLookupTable());
        planeWidgetZ.On();
        vtkOutlineFilter outline = new vtkOutlineFilter();
        outline.SetInputConnection(out);
        vtkPolyDataMapper outlineMapper = new vtkPolyDataMapper();
        outlineMapper.SetInputConnection(outline.GetOutputPort());
        vtkActor outlineActor = new vtkActor();
        outlineActor.SetMapper(outlineMapper);
        this.GetRenderer().AddActor(outlineActor);
        this.GetRenderer().GetCullers().RemoveAllItems();
        this.GetRenderer().SetBackground(0.1, 0.1, 0.2);
    }

    public static void printUsage(String err) {
        if (!err.equals("")) {
            System.err.println("Error: " + err);
        }
        System.err.println("Usage: java ImagePlaneWidget [-D path]");
        System.err.println("Where:");
        System.err.println("      path is location of your VTKData directory");
        System.exit(-1);
    }

    public static void main(String[] argv) {
        File f;
        int argSize = argv.length;
        String pathToVTKData = "";
        int argCurrent = 0;
        try {
            while (argSize > argCurrent) {
                if (argv[argCurrent].equals("-D")) {
                    pathToVTKData = argv[++argCurrent];
                    ++argCurrent;
                    continue;
                }
                ImagePlaneWidget.printUsage("");
            }
        }
        catch (Exception e) {
            ImagePlaneWidget.printUsage("");
        }
        if (pathToVTKData.equals("")) {
            ImagePlaneWidget.printUsage("");
        }
        if (!((f = new File(pathToVTKData + "/Data/headsq")).exists() && f.canRead() && f.isDirectory())) {
            ImagePlaneWidget.printUsage(f.getAbsolutePath() + " does not exist or cannot be read.");
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                new ImagePlaneWidget(f.getAbsolutePath() + "/quarter");
            }
        });
    }

    static {
        if (!vtkNativeLibrary.LoadAllNativeLibraries()) {
            for (vtkNativeLibrary lib : vtkNativeLibrary.values()) {
                if (lib.IsLoaded()) continue;
                System.out.println(lib.GetLibraryName() + " not loaded");
            }
        }
        vtkNativeLibrary.DisableOutputWindow(null);
    }
}

