/*
 * Decompiled with CFR 0.152.
 */
package vtk.sample;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.concurrent.TimeUnit;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import vtk.vtkActor;
import vtk.vtkConeSource;
import vtk.vtkNativeLibrary;
import vtk.vtkObject;
import vtk.vtkPanel;
import vtk.vtkPolyDataMapper;

public class ReleaseVtkPanel {
    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                vtkObject.JAVA_OBJECT_MANAGER.getAutoGarbageCollector().SetScheduleTime(5L, TimeUnit.SECONDS);
                vtkObject.JAVA_OBJECT_MANAGER.getAutoGarbageCollector().SetDebug(true);
                vtkObject.JAVA_OBJECT_MANAGER.getAutoGarbageCollector().Start();
                JButton startVTKApp = new JButton("Start VTK application");
                startVTKApp.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        final VtkApplication app = new VtkApplication();
                        JFrame f = ReleaseVtkPanel.buildFrame("VtkApp", app, 400, 200);
                        f.addWindowListener(new WindowAdapter(){

                            @Override
                            public void windowClosing(WindowEvent e) {
                                app.Delete();
                            }
                        });
                        f.setVisible(true);
                    }
                });
                JFrame mainFrame = ReleaseVtkPanel.buildFrame("Launcher", startVTKApp, 200, 200);
                mainFrame.setDefaultCloseOperation(3);
                mainFrame.setVisible(true);
            }
        });
    }

    public static JFrame buildFrame(String title, JComponent content, int width, int height) {
        JFrame f = new JFrame(title);
        f.getContentPane().setLayout(new BorderLayout());
        f.getContentPane().add((Component)content, "Center");
        f.setDefaultCloseOperation(2);
        f.setSize(width, height);
        f.setLocationRelativeTo(null);
        return f;
    }

    static {
        if (!vtkNativeLibrary.LoadAllNativeLibraries()) {
            for (vtkNativeLibrary lib : vtkNativeLibrary.values()) {
                if (lib.IsLoaded()) continue;
                System.out.println(lib.GetLibraryName() + " not loaded");
            }
        }
        vtkNativeLibrary.DisableOutputWindow(null);
    }

    private static class VtkApplication
    extends JPanel {
        private static final long serialVersionUID = -6486953735097088917L;
        private vtkPanel panel3dA = new vtkPanel();
        private vtkPanel panel3dB = new vtkPanel();

        public VtkApplication() {
            super(new GridLayout(1, 2));
            vtkConeSource cone = new vtkConeSource();
            vtkPolyDataMapper mapper = new vtkPolyDataMapper();
            vtkActor actor = new vtkActor();
            mapper.SetInputConnection(cone.GetOutputPort());
            actor.SetMapper(mapper);
            this.panel3dA.GetRenderer().AddActor(actor);
            this.add(this.panel3dA);
            this.panel3dB.GetRenderer().AddActor(actor);
            this.add(this.panel3dB);
        }

        public void Delete() {
            this.panel3dA.Delete();
            this.panel3dB.Delete();
        }
    }
}

