/*
 * Decompiled with CFR 0.152.
 */
package vtk.sample.rendering;

import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import vtk.rendering.awt.vtkAwtComponent;
import vtk.vtkActor;
import vtk.vtkConeSource;
import vtk.vtkNativeLibrary;
import vtk.vtkPolyDataMapper;

public class AwtConeRendering {
    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                vtkConeSource cone = new vtkConeSource();
                cone.SetResolution(8);
                vtkPolyDataMapper coneMapper = new vtkPolyDataMapper();
                coneMapper.SetInputConnection(cone.GetOutputPort());
                vtkActor coneActor = new vtkActor();
                coneActor.SetMapper(coneMapper);
                vtkAwtComponent awtWidget = new vtkAwtComponent();
                awtWidget.getRenderer().AddActor(coneActor);
                JFrame frame = new JFrame("SimpleVTK");
                frame.setDefaultCloseOperation(3);
                frame.getContentPane().setLayout(new BorderLayout());
                frame.getContentPane().add((Component)awtWidget.getComponent(), "Center");
                frame.setSize(400, 400);
                frame.setLocationRelativeTo(null);
                frame.setVisible(true);
            }
        });
    }

    static {
        if (!vtkNativeLibrary.LoadAllNativeLibraries()) {
            for (vtkNativeLibrary lib : vtkNativeLibrary.values()) {
                if (lib.IsLoaded()) continue;
                System.out.println(lib.GetLibraryName() + " not loaded");
            }
        }
        vtkNativeLibrary.DisableOutputWindow(null);
    }
}

