/*
 * Decompiled with CFR 0.152.
 */
package vtk;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import javax.swing.Timer;
import vtk.vtkBoxWidget;
import vtk.vtkGenericRenderWindowInteractor;
import vtk.vtkInteractorStyle;
import vtk.vtkInteractorStyleTrackballCamera;
import vtk.vtkPanel;
import vtk.vtkPlaneWidget;
import vtk.vtkProp3D;
import vtk.vtkRenderWindow;

public class vtkCanvas
extends vtkPanel
implements MouseListener,
MouseMotionListener,
MouseWheelListener,
KeyListener {
    private static final long serialVersionUID = 1L;
    protected vtkGenericRenderWindowInteractor iren = new vtkGenericRenderWindowInteractor();
    protected Timer timer = new Timer(10, new DelayAction());
    protected int ctrlPressed = 0;
    protected int shiftPressed = 0;
    protected vtkPlaneWidget pw = new vtkPlaneWidget();
    protected vtkBoxWidget bw = new vtkBoxWidget();

    @Override
    public void Delete() {
        this.iren = null;
        this.pw = null;
        this.bw = null;
        super.Delete();
    }

    public vtkCanvas() {
        this.Initialize();
    }

    public vtkCanvas(vtkRenderWindow renwin) {
        super(renwin);
        this.Initialize();
    }

    protected void Initialize() {
        this.iren.SetRenderWindow(this.rw);
        this.iren.TimerEventResetsTimerOff();
        this.iren.AddObserver("CreateTimerEvent", this, "StartTimer");
        this.iren.AddObserver("DestroyTimerEvent", this, "DestroyTimer");
        this.iren.SetSize(200, 200);
        this.iren.ConfigureEvent();
        this.pw.AddObserver("EnableEvent", this, "BeginPlaneInteraction");
        this.bw.AddObserver("EnableEvent", this, "BeginBoxInteraction");
        this.pw.SetKeyPressActivationValue('l');
        this.bw.SetKeyPressActivationValue('b');
        this.pw.SetInteractor(this.iren);
        this.bw.SetInteractor(this.iren);
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent event) {
                int width = vtkCanvas.this.getWidth();
                int height = vtkCanvas.this.getHeight();
                vtkCanvas.this.setSize(width, height);
            }
        });
        this.ren.SetBackground(0.0, 0.0, 0.0);
        vtkInteractorStyleTrackballCamera style = new vtkInteractorStyleTrackballCamera();
        this.iren.SetInteractorStyle(style);
    }

    public void StartTimer() {
        if (this.timer.isRunning()) {
            this.timer.stop();
        }
        this.timer.setRepeats(true);
        this.timer.start();
    }

    public void DestroyTimer() {
        if (this.timer.isRunning()) {
            this.timer.stop();
        }
    }

    @Deprecated
    public vtkGenericRenderWindowInteractor getIren() {
        return this.iren;
    }

    public vtkGenericRenderWindowInteractor getRenderWindowInteractor() {
        return this.iren;
    }

    public void setInteractorStyle(vtkInteractorStyle style) {
        this.iren.SetInteractorStyle(style);
    }

    public void addToPlaneWidget(vtkProp3D prop) {
        this.pw.SetProp3D(prop);
        this.pw.PlaceWidget();
    }

    public void addToBoxWidget(vtkProp3D prop) {
        this.bw.SetProp3D(prop);
        this.bw.PlaceWidget();
    }

    public void BeginPlaneInteraction() {
        System.out.println("Plane widget begin interaction");
    }

    public void BeginBoxInteraction() {
        System.out.println("Box widget begin interaction");
    }

    @Override
    public void setSize(int x, int y) {
        super.setSize(x, y);
        if (this.windowset == 1) {
            this.Lock();
            this.rw.SetSize(x, y);
            this.iren.SetSize(x, y);
            this.iren.ConfigureEvent();
            this.UnLock();
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (this.ren.VisibleActorCount() == 0) {
            return;
        }
        this.Lock();
        this.rw.SetDesiredUpdateRate(5.0);
        this.lastX = e.getX();
        this.lastY = e.getY();
        this.ctrlPressed = (e.getModifiersEx() & 0x80) == 128 ? 1 : 0;
        this.shiftPressed = (e.getModifiersEx() & 0x40) == 64 ? 1 : 0;
        this.iren.SetEventInformationFlipY(e.getX(), e.getY(), this.ctrlPressed, this.shiftPressed, '0', 0, "0");
        if ((e.getModifiersEx() & 0x400) == 1024) {
            this.iren.LeftButtonPressEvent();
        } else if ((e.getModifiersEx() & 0x800) == 2048) {
            this.iren.MiddleButtonPressEvent();
        } else if ((e.getModifiersEx() & 0x1000) == 4096) {
            this.iren.RightButtonPressEvent();
        }
        this.UnLock();
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.Lock();
        this.rw.SetDesiredUpdateRate(0.01);
        this.ctrlPressed = (e.getModifiersEx() & 0x80) == 128 ? 1 : 0;
        this.shiftPressed = (e.getModifiersEx() & 0x40) == 64 ? 1 : 0;
        this.iren.SetEventInformationFlipY(e.getX(), e.getY(), this.ctrlPressed, this.shiftPressed, '0', 0, "0");
        switch (e.getButton()) {
            case 1: {
                this.iren.LeftButtonReleaseEvent();
                break;
            }
            case 2: {
                this.iren.MiddleButtonReleaseEvent();
                break;
            }
            case 3: {
                this.iren.RightButtonReleaseEvent();
            }
        }
        this.UnLock();
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        this.requestFocus();
        this.iren.SetEventInformationFlipY(e.getX(), e.getY(), 0, 0, '0', 0, "0");
        this.iren.EnterEvent();
    }

    @Override
    public void mouseExited(MouseEvent e) {
        this.iren.SetEventInformationFlipY(e.getX(), e.getY(), 0, 0, '0', 0, "0");
        this.iren.LeaveEvent();
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        this.lastX = e.getX();
        this.lastY = e.getY();
        this.ctrlPressed = (e.getModifiersEx() & 0x80) == 128 ? 1 : 0;
        this.shiftPressed = (e.getModifiersEx() & 0x40) == 64 ? 1 : 0;
        this.iren.SetEventInformationFlipY(e.getX(), e.getY(), this.ctrlPressed, this.shiftPressed, '0', 0, "0");
        this.Lock();
        this.iren.MouseMoveEvent();
        this.UnLock();
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (this.ren.VisibleActorCount() == 0) {
            return;
        }
        this.ctrlPressed = (e.getModifiersEx() & 0x80) == 128 ? 1 : 0;
        this.shiftPressed = (e.getModifiersEx() & 0x40) == 64 ? 1 : 0;
        this.iren.SetEventInformationFlipY(e.getX(), e.getY(), this.ctrlPressed, this.shiftPressed, '0', 0, "0");
        this.Lock();
        this.iren.MouseMoveEvent();
        this.UnLock();
        this.UpdateLight();
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
        if (this.ren.VisibleActorCount() == 0) {
            return;
        }
        this.ctrlPressed = (e.getModifiersEx() & 0x80) == 128 ? 1 : 0;
        this.shiftPressed = (e.getModifiersEx() & 0x40) == 64 ? 1 : 0;
        this.Lock();
        if (e.getWheelRotation() > 0) {
            this.iren.SetEventInformationFlipY(e.getX(), e.getY(), this.ctrlPressed, this.shiftPressed, '0', 0, "0");
            this.iren.MouseWheelBackwardEvent();
        } else if (e.getWheelRotation() < 0) {
            this.iren.SetEventInformationFlipY(e.getX(), e.getY(), this.ctrlPressed, this.shiftPressed, '0', 0, "0");
            this.iren.MouseWheelForwardEvent();
        }
        this.UnLock();
        this.UpdateLight();
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (this.ren.VisibleActorCount() == 0) {
            return;
        }
        char keyChar = e.getKeyChar();
        this.ctrlPressed = (e.getModifiersEx() & 0x80) == 128 ? 1 : 0;
        this.shiftPressed = (e.getModifiersEx() & 0x40) == 64 ? 1 : 0;
        this.iren.SetEventInformationFlipY(this.lastX, this.lastY, this.ctrlPressed, this.shiftPressed, keyChar, 0, String.valueOf(keyChar));
        this.Lock();
        this.iren.KeyPressEvent();
        this.iren.CharEvent();
        this.UnLock();
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    private class DelayAction
    implements ActionListener {
        private DelayAction() {
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            vtkCanvas.this.Lock();
            vtkCanvas.this.iren.TimerEvent();
            vtkCanvas.this.UpdateLight();
            vtkCanvas.this.UnLock();
        }
    }
}

