/*
 * Decompiled with CFR 0.152.
 */
package vtk;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;

public class vtkReferenceInformation {
    private int numberOfObjectsToFree;
    private int numberOfObjectsStillReferenced;
    private HashMap<String, AtomicInteger> classesKept;
    private HashMap<String, AtomicInteger> classesRemoved;
    private boolean keepTrackOfClassNames;

    public vtkReferenceInformation(int nbToFree, int nbToKeep, int totalSize) {
        this.numberOfObjectsToFree = nbToFree;
        this.numberOfObjectsStillReferenced = nbToKeep;
        this.keepTrackOfClassNames = false;
    }

    public vtkReferenceInformation(boolean keepTrackOfClassNames) {
        this.numberOfObjectsToFree = 0;
        this.numberOfObjectsStillReferenced = 0;
        this.keepTrackOfClassNames = keepTrackOfClassNames;
    }

    public int getTotalNumberOfObjects() {
        return this.numberOfObjectsStillReferenced + this.numberOfObjectsToFree;
    }

    public int getNumberOfObjectsToFree() {
        return this.numberOfObjectsToFree;
    }

    public int getTotalNumberOfObjectsStillReferenced() {
        return this.numberOfObjectsStillReferenced;
    }

    public void setNumberOfObjectsStillReferenced(int numberOfObjectsStillReferenced) {
        this.numberOfObjectsStillReferenced = numberOfObjectsStillReferenced;
    }

    public void setNumberOfObjectsToFree(int numberOfObjectsToFree) {
        this.numberOfObjectsToFree = numberOfObjectsToFree;
    }

    public void addFreeObject(String className) {
        ++this.numberOfObjectsToFree;
        if (this.keepTrackOfClassNames) {
            AtomicInteger counter;
            if (this.classesRemoved == null && className != null) {
                this.classesRemoved = new HashMap();
            }
            if ((counter = this.classesRemoved.get(className)) == null) {
                this.classesRemoved.put(className, new AtomicInteger(1));
            } else {
                counter.incrementAndGet();
            }
        }
    }

    public void addKeptObject(String className) {
        ++this.numberOfObjectsStillReferenced;
        if (this.keepTrackOfClassNames && className != null) {
            AtomicInteger counter;
            if (this.classesKept == null) {
                this.classesKept = new HashMap();
            }
            if ((counter = this.classesKept.get(className)) == null) {
                this.classesKept.put(className, new AtomicInteger(1));
            } else {
                counter.incrementAndGet();
            }
        }
    }

    public String listKeptReferenceToString() {
        if (this.classesKept == null) {
            return "";
        }
        StringBuilder builder = new StringBuilder(500);
        builder.append("List of classes kept in Java layer:\n");
        for (Map.Entry<String, AtomicInteger> entry : this.classesKept.entrySet()) {
            builder.append(" - ").append(entry.getKey()).append(": ").append(entry.getValue().toString()).append("\n");
        }
        return builder.toString();
    }

    public String listRemovedReferenceToString() {
        if (this.classesRemoved == null) {
            return "";
        }
        StringBuilder builder = new StringBuilder(500);
        builder.append("List of classes removed in Java layer:\n");
        for (Map.Entry<String, AtomicInteger> entry : this.classesRemoved.entrySet()) {
            builder.append(" - ").append(entry.getKey()).append(": ").append(entry.getValue().toString()).append("\n");
        }
        return builder.toString();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(50);
        builder.append("VTK Gabage Collection: free(");
        builder.append(this.numberOfObjectsToFree);
        builder.append(") - keep(");
        builder.append(this.numberOfObjectsStillReferenced);
        builder.append(") - total(");
        builder.append(this.getTotalNumberOfObjects());
        builder.append(")");
        return builder.toString();
    }
}

