/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.hdf5;

import ch.systemsx.cisd.base.convert.NativeData;
import ch.systemsx.cisd.base.mdarray.MDAbstractArray;
import ch.systemsx.cisd.base.mdarray.MDByteArray;
import ch.systemsx.cisd.base.mdarray.MDIntArray;
import ch.systemsx.cisd.base.mdarray.MDShortArray;
import ch.systemsx.cisd.hdf5.HDF5EnumerationType;
import ch.systemsx.cisd.hdf5.ReflectionUtils;
import hdf.hdf5lib.HDFNativeData;
import hdf.hdf5lib.exceptions.HDF5JavaException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class EnumerationType
implements Iterable<String> {
    private final String nameOrNull;
    private final String[] values;
    private final List<String> unmodifiableValues;
    private Map<String, Integer> nameToIndexMap;

    public EnumerationType(String nameOrNull, String[] values2) {
        assert (values2 != null);
        this.nameOrNull = nameOrNull;
        this.values = values2;
        this.unmodifiableValues = Collections.unmodifiableList(Arrays.asList(values2));
    }

    public EnumerationType(Class<? extends Enum<?>> enumClass) {
        this(enumClass.getName(), enumClass);
    }

    public EnumerationType(String nameOrNull, Class<? extends Enum<?>> enumClass) {
        this(nameOrNull, ReflectionUtils.getEnumOptions(enumClass));
    }

    private Map<String, Integer> getMap() {
        if (this.nameToIndexMap == null) {
            this.nameToIndexMap = new HashMap<String, Integer>(this.values.length);
            int i = 0;
            while (i < this.values.length) {
                this.nameToIndexMap.put(this.values[i], i);
                ++i;
            }
        }
        return this.nameToIndexMap;
    }

    String[] getValueArray() {
        return this.values;
    }

    Object createArray(int length) {
        if (this.values.length < 127) {
            return new byte[length];
        }
        if (this.values.length < Short.MAX_VALUE) {
            return new short[length];
        }
        return new int[length];
    }

    public Integer tryGetIndexForValue(String value) {
        return this.getMap().get(value);
    }

    public String getName() {
        if (this.nameOrNull == null) {
            return "NONAME";
        }
        return this.nameOrNull;
    }

    public String tryGetName() {
        return this.nameOrNull;
    }

    public List<String> getValues() {
        return this.unmodifiableValues;
    }

    public HDF5EnumerationType.EnumStorageForm getStorageForm() {
        int len = this.values.length;
        if (len < 127) {
            return HDF5EnumerationType.EnumStorageForm.BYTE;
        }
        if (len < Short.MAX_VALUE) {
            return HDF5EnumerationType.EnumStorageForm.SHORT;
        }
        return HDF5EnumerationType.EnumStorageForm.INT;
    }

    byte getNumberOfBits() {
        int n;
        int n2 = n = this.values.length > 0 ? this.values.length - 1 : 0;
        return (byte)(n < 32768 ? (n < 128 ? (n < 8 ? (n < 2 ? (n < 1 ? (n < 0 ? 32 : 0) : 1) : (n < 4 ? 2 : 3)) : (n < 32 ? (n < 16 ? 4 : 5) : (n < 64 ? 6 : 7))) : (n < 2048 ? (n < 512 ? (n < 256 ? 8 : 9) : (n < 1024 ? 10 : 11)) : (n < 8192 ? (n < 4096 ? 12 : 13) : (n < 16384 ? 14 : 15)))) : (n < 0x800000 ? (n < 524288 ? (n < 131072 ? (n < 65536 ? 16 : 17) : (n < 262144 ? 18 : 19)) : (n < 0x200000 ? (n < 0x100000 ? 20 : 21) : (n < 0x400000 ? 22 : 23))) : (n < 0x8000000 ? (n < 0x2000000 ? (n < 0x1000000 ? 24 : 25) : (n < 0x4000000 ? 26 : 27)) : (n < 0x20000000 ? (n < 0x10000000 ? 28 : 29) : (n < 0x40000000 ? 30 : 31)))));
    }

    byte[] toStorageForm(int ordinal) {
        switch (this.getStorageForm()) {
            case BYTE: {
                return HDFNativeData.byteToByte((byte)ordinal);
            }
            case SHORT: {
                return HDFNativeData.shortToByte((short)ordinal);
            }
            case INT: {
                return HDFNativeData.intToByte(ordinal);
            }
        }
        throw new Error("Illegal storage size.");
    }

    static int fromStorageForm(byte[] data) {
        if (data.length == 1) {
            return data[0];
        }
        if (data.length == 2) {
            return NativeData.byteToShort(data, NativeData.ByteOrder.NATIVE)[0];
        }
        if (data.length == 4) {
            return NativeData.byteToInt(data, NativeData.ByteOrder.NATIVE)[0];
        }
        throw new HDF5JavaException("Unexpected size for Enum data type (" + data.length + ")");
    }

    static int fromStorageForm(byte[] data, int index, int size) {
        if (size == 1) {
            return data[index];
        }
        if (size == 2) {
            return NativeData.byteToShort(data, NativeData.ByteOrder.NATIVE, size * index, 1)[0];
        }
        if (size == 4) {
            return NativeData.byteToInt(data, NativeData.ByteOrder.NATIVE, index, 1)[0];
        }
        throw new HDF5JavaException("Unexpected size for Enum data type (" + size + ")");
    }

    static Object fromStorageForm(byte[] data, HDF5EnumerationType.EnumStorageForm storageForm) {
        switch (storageForm) {
            case BYTE: {
                return data;
            }
            case SHORT: {
                return NativeData.byteToShort(data, NativeData.ByteOrder.NATIVE);
            }
            case INT: {
                return NativeData.byteToInt(data, NativeData.ByteOrder.NATIVE);
            }
        }
        throw new Error("Illegal storage size.");
    }

    static MDAbstractArray<?> fromStorageForm(byte[] data, long[] dimensions, HDF5EnumerationType.EnumStorageForm storageForm) {
        switch (storageForm) {
            case BYTE: {
                return new MDByteArray(data, dimensions);
            }
            case SHORT: {
                return new MDShortArray(NativeData.byteToShort(data, NativeData.ByteOrder.NATIVE), dimensions);
            }
            case INT: {
                return new MDIntArray(NativeData.byteToInt(data, NativeData.ByteOrder.NATIVE), dimensions);
            }
        }
        throw new Error("Illegal storage size.");
    }

    static MDAbstractArray<?> fromStorageForm(byte[] data, int[] dimensions, HDF5EnumerationType.EnumStorageForm storageForm) {
        switch (storageForm) {
            case BYTE: {
                return new MDByteArray(data, dimensions);
            }
            case SHORT: {
                return new MDShortArray(NativeData.byteToShort(data, NativeData.ByteOrder.NATIVE), dimensions);
            }
            case INT: {
                return new MDIntArray(NativeData.byteToInt(data, NativeData.ByteOrder.NATIVE), dimensions);
            }
        }
        throw new Error("Illegal storage size.");
    }

    String createStringFromStorageForm(byte[] data, int offset) {
        return this.values[this.getOrdinalFromStorageForm(data, offset)];
    }

    int getOrdinalFromStorageForm(byte[] data, int offset) {
        switch (this.getStorageForm()) {
            case BYTE: {
                return data[offset];
            }
            case SHORT: {
                return HDFNativeData.byteToShort(data, offset);
            }
            case INT: {
                return HDFNativeData.byteToInt(data, offset);
            }
        }
        throw new Error("Illegal storage form (" + (Object)((Object)this.getStorageForm()) + ".)");
    }

    @Override
    public Iterator<String> iterator() {
        return new Iterator<String>(){
            private int index = 0;

            @Override
            public boolean hasNext() {
                return this.index < EnumerationType.this.values.length;
            }

            @Override
            public String next() {
                return EnumerationType.this.values[this.index++];
            }

            @Override
            public void remove() throws UnsupportedOperationException {
                throw new UnsupportedOperationException();
            }
        };
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + Arrays.hashCode(this.values);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        EnumerationType other = (EnumerationType)obj;
        return Arrays.equals(this.values, other.values);
    }
}

