/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.hdf5;

import ch.systemsx.cisd.base.convert.NativeData;
import ch.systemsx.cisd.base.mdarray.MDAbstractArray;
import ch.systemsx.cisd.hdf5.CharacterEncoding;
import ch.systemsx.cisd.hdf5.HDF5AbstractStorageFeatures;
import ch.systemsx.cisd.hdf5.HDF5BaseWriter;
import ch.systemsx.cisd.hdf5.HDF5CommonInformation;
import ch.systemsx.cisd.hdf5.HDF5CompoundType;
import ch.systemsx.cisd.hdf5.HDF5DataSet;
import ch.systemsx.cisd.hdf5.HDF5DataSetInformation;
import ch.systemsx.cisd.hdf5.HDF5DataSetTemplate;
import ch.systemsx.cisd.hdf5.HDF5LinkInformation;
import ch.systemsx.cisd.hdf5.HDF5ObjectInformation;
import ch.systemsx.cisd.hdf5.HDF5ObjectType;
import ch.systemsx.cisd.hdf5.HDF5StorageLayout;
import ch.systemsx.cisd.hdf5.HDF5Utils;
import ch.systemsx.cisd.hdf5.IHDF5WriterConfigurator;
import ch.systemsx.cisd.hdf5.cleanup.CleanUpCallable;
import ch.systemsx.cisd.hdf5.cleanup.CleanUpRegistry;
import ch.systemsx.cisd.hdf5.cleanup.ICallableWithCleanUp;
import ch.systemsx.cisd.hdf5.cleanup.ICleanUpRegistry;
import ch.systemsx.cisd.hdf5.exceptions.HDF5SpaceRankMismatch;
import ch.systemsx.cisd.hdf5.hdf5lib.HDFHelper;
import hdf.hdf5lib.H5;
import hdf.hdf5lib.HDF5Constants;
import hdf.hdf5lib.HDFNativeData;
import hdf.hdf5lib.exceptions.HDF5Exception;
import hdf.hdf5lib.exceptions.HDF5JavaException;
import hdf.hdf5lib.structs.H5O_info_t;
import java.io.File;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;

class HDF5 {
    private static final int MAX_PATH_LENGTH = 16384;
    private final CleanUpCallable runner;
    private final long dataSetCreationPropertyListCompactStorageLayoutFileTimeAlloc;
    private final long dataSetCreationPropertyListFillTimeAlloc;
    private final long numericConversionXferPropertyListID;
    private final long lcplCreateIntermediateGroups;
    private final boolean useUTF8CharEncoding;
    private final boolean autoDereference;
    private final int BUFLEN = 128;

    public HDF5(CleanUpRegistry fileRegistry, CleanUpCallable runner, boolean performNumericConversions, boolean useUTF8CharEncoding, boolean autoDereference) {
        this.runner = runner;
        this.useUTF8CharEncoding = useUTF8CharEncoding;
        this.autoDereference = autoDereference;
        this.dataSetCreationPropertyListCompactStorageLayoutFileTimeAlloc = this.createDataSetCreationPropertyList(fileRegistry);
        H5.H5Pset_layout(this.dataSetCreationPropertyListCompactStorageLayoutFileTimeAlloc, HDF5Constants.H5D_COMPACT);
        this.dataSetCreationPropertyListFillTimeAlloc = this.createDataSetCreationPropertyList(fileRegistry);
        this.numericConversionXferPropertyListID = performNumericConversions ? this.createDataSetXferPropertyListAbortOverflow(fileRegistry) : this.createDataSetXferPropertyListAbort(fileRegistry);
        this.lcplCreateIntermediateGroups = this.createLinkCreationPropertyList(true, fileRegistry);
    }

    private static void checkMaxLength(String path) throws HDF5JavaException {
        if (path.length() > 16384) {
            throw new HDF5JavaException("Path too long (length=" + path.length() + ")");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void resetLibrary() {
        Class<H5> clazz = H5.class;
        synchronized (H5.class) {
            H5.H5close();
            H5.H5open();
            H5.H5error_off();
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    public long createFile(String fileName, IHDF5WriterConfigurator.FileFormatVersionBounds fileFormatVersionBounds, Boolean mdcGenerateImage, ICleanUpRegistry registry) {
        long fileAccessPropertyListId = this.createFileAccessPropertyListId(fileFormatVersionBounds, mdcGenerateImage, registry);
        final long fileId = H5.H5Fcreate(fileName, HDF5Constants.H5F_ACC_TRUNC, HDF5Constants.H5P_DEFAULT, fileAccessPropertyListId);
        registry.registerCleanUp(new Runnable(){

            @Override
            public void run() {
                H5.H5Fclose(fileId);
            }
        });
        return fileId;
    }

    private long createFileAccessPropertyListId(IHDF5WriterConfigurator.FileFormatVersionBounds fileFormatVersionBounds, boolean mdcGenerateImage, ICleanUpRegistry registry) {
        long fileAccessPropertyListId = HDF5Constants.H5P_DEFAULT;
        if (mdcGenerateImage && fileFormatVersionBounds.getLowBound() == IHDF5WriterConfigurator.FileFormatVersion.EARLIEST) {
            switch (fileFormatVersionBounds) {
                case EARLIEST_LATEST: {
                    fileFormatVersionBounds = IHDF5WriterConfigurator.FileFormatVersionBounds.V1_8_LATEST;
                    break;
                }
                case EARLIEST_V1_10: {
                    fileFormatVersionBounds = IHDF5WriterConfigurator.FileFormatVersionBounds.V1_8_V1_10;
                    break;
                }
                case EARLIEST_V1_8: {
                    throw new HDF5JavaException("Upper file version bound V1_8 is incompatible with MDC image generation.");
                }
                default: {
                    throw new IllegalStateException("Unhandled case switch");
                }
            }
        }
        if (fileFormatVersionBounds != IHDF5WriterConfigurator.FileFormatVersionBounds.getDefault() || mdcGenerateImage) {
            final long fapl = H5.H5Pcreate(HDF5Constants.H5P_FILE_ACCESS);
            registry.registerCleanUp(new Runnable(){

                @Override
                public void run() {
                    H5.H5Pclose(fapl);
                }
            });
            fileAccessPropertyListId = fapl;
            if (fileFormatVersionBounds != IHDF5WriterConfigurator.FileFormatVersionBounds.getDefault()) {
                H5.H5Pset_libver_bounds(fileAccessPropertyListId, fileFormatVersionBounds.getLowBound().getHdf5Constant(), fileFormatVersionBounds.getHighBound().getHdf5Constant());
            }
            if (mdcGenerateImage) {
                HDFHelper.H5Pset_mdc_image_config(fileAccessPropertyListId, mdcGenerateImage);
            }
        }
        return fileAccessPropertyListId;
    }

    public boolean isMDCImageGenerationEnabled(long fileId) {
        long fapl = H5.H5Fget_access_plist(fileId);
        return HDFHelper.H5Pget_mdc_image_enabled(fapl);
    }

    public long openFileReadOnly(String fileName, ICleanUpRegistry registry) {
        final long fileId = H5.H5Fopen(fileName, HDF5Constants.H5F_ACC_RDONLY, HDF5Constants.H5P_DEFAULT);
        registry.registerCleanUp(new Runnable(){

            @Override
            public void run() {
                H5.H5Fclose(fileId);
            }
        });
        return fileId;
    }

    public long openFileReadWrite(String fileName, IHDF5WriterConfigurator.FileFormatVersionBounds fileFormatVersionBounds, Boolean mdcGenerateImage, ICleanUpRegistry registry) {
        long fileAccessPropertyListId = this.createFileAccessPropertyListId(fileFormatVersionBounds, mdcGenerateImage, registry);
        File f = new File(fileName);
        if (f.exists() && !f.isFile()) {
            throw new HDF5Exception("An entry with name '" + fileName + "' exists but is not a file.");
        }
        final long fileId = H5.H5Fopen(fileName, HDF5Constants.H5F_ACC_RDWR, fileAccessPropertyListId);
        registry.registerCleanUp(new Runnable(){

            @Override
            public void run() {
                H5.H5Fclose(fileId);
            }
        });
        return fileId;
    }

    public void flushFile(long fileId) {
        H5.H5Fflush(fileId, HDF5Constants.H5F_SCOPE_GLOBAL);
    }

    public long openObject(long fileId, String path, ICleanUpRegistry registry) {
        HDF5.checkMaxLength(path);
        final long objectId = this.isReference(path) ? H5.H5Oopen_by_addr(fileId, Long.parseLong(path.substring(1))) : H5.H5Oopen(fileId, path, HDF5Constants.H5P_DEFAULT);
        registry.registerCleanUp(new Runnable(){

            @Override
            public void run() {
                H5.H5Oclose(objectId);
            }
        });
        return objectId;
    }

    public int deleteObject(long fileId, String path) {
        HDF5.checkMaxLength(path);
        H5.H5Ldelete(fileId, path, HDF5Constants.H5P_DEFAULT);
        return 0;
    }

    public int copyObject(long srcFileId, String srcPath, long dstFileId, String dstPath) {
        HDF5.checkMaxLength(srcPath);
        HDF5.checkMaxLength(dstPath);
        H5.H5Ocopy(srcFileId, srcPath, dstFileId, dstPath, HDF5Constants.H5P_DEFAULT, this.lcplCreateIntermediateGroups);
        return 0;
    }

    public int moveLink(long fileId, String srcLinkPath, String dstLinkPath) {
        HDF5.checkMaxLength(srcLinkPath);
        HDF5.checkMaxLength(dstLinkPath);
        H5.H5Lmove(fileId, srcLinkPath, fileId, dstLinkPath, this.lcplCreateIntermediateGroups, HDF5Constants.H5P_DEFAULT);
        return 0;
    }

    public void createGroup(long fileId, String groupName) {
        HDF5.checkMaxLength(groupName);
        long groupId = H5.H5Gcreate(fileId, groupName, this.lcplCreateIntermediateGroups, HDF5Constants.H5P_DEFAULT, HDF5Constants.H5P_DEFAULT);
        H5.H5Gclose(groupId);
    }

    public void createOldStyleGroup(long fileId, String groupName, int sizeHint, ICleanUpRegistry registry) {
        HDF5.checkMaxLength(groupName);
        final long gcplId = H5.H5Pcreate(HDF5Constants.H5P_GROUP_CREATE);
        registry.registerCleanUp(new Runnable(){

            @Override
            public void run() {
                H5.H5Pclose(gcplId);
            }
        });
        H5.H5Pset_local_heap_size_hint(gcplId, sizeHint);
        long groupId = H5.H5Gcreate(fileId, groupName, this.lcplCreateIntermediateGroups, gcplId, HDF5Constants.H5P_DEFAULT);
        H5.H5Gclose(groupId);
    }

    public void createNewStyleGroup(long fileId, String groupName, int maxCompact, int minDense, ICleanUpRegistry registry) {
        HDF5.checkMaxLength(groupName);
        final long gcplId = H5.H5Pcreate(HDF5Constants.H5P_GROUP_CREATE);
        registry.registerCleanUp(new Runnable(){

            @Override
            public void run() {
                H5.H5Pclose(gcplId);
            }
        });
        H5.H5Pset_link_phase_change(gcplId, maxCompact, minDense);
        long groupId = H5.H5Gcreate(fileId, groupName, this.lcplCreateIntermediateGroups, gcplId, HDF5Constants.H5P_DEFAULT);
        H5.H5Gclose(groupId);
    }

    public long openGroup(long fileId, String path, ICleanUpRegistry registry) {
        HDF5.checkMaxLength(path);
        final long groupId = this.isReference(path) ? H5.H5Oopen_by_addr(fileId, Long.parseLong(path.substring(1))) : H5.H5Gopen(fileId, path, HDF5Constants.H5P_DEFAULT);
        registry.registerCleanUp(new Runnable(){

            @Override
            public void run() {
                H5.H5Gclose(groupId);
            }
        });
        return groupId;
    }

    public long getNumberOfGroupMembers(long fileId, String path, ICleanUpRegistry registry) {
        HDF5.checkMaxLength(path);
        final long groupId = H5.H5Gopen(fileId, path, HDF5Constants.H5P_DEFAULT);
        registry.registerCleanUp(new Runnable(){

            @Override
            public void run() {
                H5.H5Gclose(groupId);
            }
        });
        return H5.H5Gget_info((long)groupId).nlinks;
    }

    public boolean existsAttribute(long objectId, String attributeName) {
        HDF5.checkMaxLength(attributeName);
        return H5.H5Aexists(objectId, attributeName);
    }

    public boolean exists(long fileId, String linkName) {
        HDF5.checkMaxLength(linkName);
        return HDFHelper.H5Lexists(fileId, linkName, HDF5Constants.H5P_DEFAULT);
    }

    public HDF5LinkInformation getLinkInfo(long fileId, String objectName, boolean exceptionIfNonExistent) {
        HDF5.checkMaxLength(objectName);
        if ("/".equals(objectName)) {
            return HDF5LinkInformation.ROOT_LINK_INFO;
        }
        String[] lname = new String[2];
        int typeId = HDFHelper.H5Lget_link_info(fileId, objectName, lname, exceptionIfNonExistent);
        return HDF5LinkInformation.create(objectName, typeId, lname[1], lname[0]);
    }

    public HDF5ObjectType getLinkTypeInfo(long fileId, String objectName, boolean exceptionWhenNonExistent) {
        HDF5.checkMaxLength(objectName);
        if ("/".equals(objectName)) {
            return HDF5ObjectType.GROUP;
        }
        int typeId = HDFHelper.H5Lget_link_info(fileId, objectName, null, exceptionWhenNonExistent);
        return HDF5CommonInformation.objectTypeIdToObjectType(typeId);
    }

    public HDF5ObjectInformation getObjectInfo(long fileId, String objectName, boolean exceptionWhenNonExistent) {
        HDF5.checkMaxLength(objectName);
        H5O_info_t info = HDFHelper.H5Oget_info_by_name(fileId, objectName, exceptionWhenNonExistent);
        return new HDF5ObjectInformation(objectName, HDF5CommonInformation.objectTypeIdToObjectType(info.type), info);
    }

    public int getObjectTypeId(long fileId, String objectName, boolean exceptionWhenNonExistent) {
        HDF5.checkMaxLength(objectName);
        if ("/".equals(objectName)) {
            return HDF5Constants.H5O_TYPE_GROUP;
        }
        return HDFHelper.H5Oget_info_by_name((long)fileId, (String)objectName, (boolean)exceptionWhenNonExistent).type;
    }

    public HDF5ObjectType getObjectTypeInfo(long fileId, String objectName, boolean exceptionWhenNonExistent) {
        return HDF5CommonInformation.objectTypeIdToObjectType(this.getObjectTypeId(fileId, objectName, exceptionWhenNonExistent));
    }

    public String[] getGroupMembers(final long fileId, final String groupName) {
        HDF5.checkMaxLength(groupName);
        ICallableWithCleanUp<String[]> dataDimensionRunnable = new ICallableWithCleanUp<String[]>(){

            @Override
            public String[] call(ICleanUpRegistry registry) {
                long groupId = HDF5.this.openGroup(fileId, groupName, registry);
                long nLong = H5.H5Gget_info((long)groupId).nlinks;
                int n = (int)nLong;
                if ((long)n != nLong) {
                    throw new HDF5JavaException("Number of group members is too large (n=" + nLong + ")");
                }
                String[] names = new String[n];
                HDFHelper.H5Lget_link_names_all(groupId, ".", names);
                return names;
            }
        };
        return this.runner.call(dataDimensionRunnable);
    }

    public List<HDF5LinkInformation> getGroupMemberLinkInfo(final long fileId, final String groupName, final boolean includeInternal, final String houseKeepingNameSuffix) {
        HDF5.checkMaxLength(groupName);
        ICallableWithCleanUp<List<HDF5LinkInformation>> dataDimensionRunnable = new ICallableWithCleanUp<List<HDF5LinkInformation>>(){

            @Override
            public List<HDF5LinkInformation> call(ICleanUpRegistry registry) {
                long groupId = HDF5.this.openGroup(fileId, groupName, registry);
                long nLong = H5.H5Gget_info((long)groupId).nlinks;
                int n = (int)nLong;
                if ((long)n != nLong) {
                    throw new HDF5JavaException("Number of group members is too large (n=" + nLong + ")");
                }
                String[] names = new String[n];
                String[] linkFilenames = new String[n];
                String[] linkTargets = new String[n];
                int[] types = new int[n];
                HDFHelper.H5Lget_link_info_all(groupId, ".", names, types, linkFilenames, linkTargets);
                String superGroupName = groupName.equals("/") ? "/" : String.valueOf(groupName) + "/";
                LinkedList<HDF5LinkInformation> info = new LinkedList<HDF5LinkInformation>();
                int i = 0;
                while (i < n) {
                    if (includeInternal || !HDF5Utils.isInternalName(names[i], houseKeepingNameSuffix)) {
                        info.add(HDF5LinkInformation.create(String.valueOf(superGroupName) + names[i], types[i], linkFilenames[i], linkTargets[i]));
                    }
                    ++i;
                }
                return info;
            }
        };
        return this.runner.call(dataDimensionRunnable);
    }

    public List<HDF5LinkInformation> getGroupMemberTypeInfo(final long fileId, final String groupName, final boolean includeInternal, final String houseKeepingNameSuffix) {
        HDF5.checkMaxLength(groupName);
        ICallableWithCleanUp<List<HDF5LinkInformation>> dataDimensionRunnable = new ICallableWithCleanUp<List<HDF5LinkInformation>>(){

            @Override
            public List<HDF5LinkInformation> call(ICleanUpRegistry registry) {
                long groupId = HDF5.this.openGroup(fileId, groupName, registry);
                long nLong = H5.H5Gget_info((long)groupId).nlinks;
                int n = (int)nLong;
                if ((long)n != nLong) {
                    throw new HDF5JavaException("Number of group members is too large (n=" + nLong + ")");
                }
                String[] names = new String[n];
                int[] types = new int[n];
                HDFHelper.H5Lget_link_info_all(groupId, ".", names, types, null, null);
                String superGroupName = groupName.equals("/") ? "/" : String.valueOf(groupName) + "/";
                LinkedList<HDF5LinkInformation> info = new LinkedList<HDF5LinkInformation>();
                int i = 0;
                while (i < n) {
                    if (includeInternal || !HDF5Utils.isInternalName(names[i], houseKeepingNameSuffix)) {
                        info.add(HDF5LinkInformation.create(String.valueOf(superGroupName) + names[i], types[i], null, null));
                    }
                    ++i;
                }
                return info;
            }
        };
        return this.runner.call(dataDimensionRunnable);
    }

    public void createHardLink(long fileId, String objectName, String linkName) {
        HDF5.checkMaxLength(objectName);
        HDF5.checkMaxLength(linkName);
        H5.H5Lcreate_hard(fileId, objectName, fileId, linkName, this.lcplCreateIntermediateGroups, HDF5Constants.H5P_DEFAULT);
    }

    public void createSoftLink(long fileId, String linkName, String targetPath) {
        HDF5.checkMaxLength(linkName);
        HDF5.checkMaxLength(targetPath);
        H5.H5Lcreate_soft(targetPath, fileId, linkName, this.lcplCreateIntermediateGroups, HDF5Constants.H5P_DEFAULT);
    }

    public void createExternalLink(long fileId, String linkName, String targetFileName, String targetPath) {
        HDF5.checkMaxLength(linkName);
        HDF5.checkMaxLength(targetFileName);
        HDF5.checkMaxLength(targetPath);
        H5.H5Lcreate_external(targetFileName, targetPath, fileId, linkName, this.lcplCreateIntermediateGroups, HDF5Constants.H5P_DEFAULT);
    }

    public void writeStringVL(long dataSetId, long dataTypeId, String[] value) {
        H5.H5DwriteVL(dataSetId, dataTypeId, HDF5Constants.H5S_ALL, HDF5Constants.H5S_ALL, HDF5Constants.H5P_DEFAULT, value);
    }

    public void writeStringVL(long dataSetId, long dataTypeId, long memorySpaceId, long fileSpaceId, String[] value) {
        H5.H5DwriteVL(dataSetId, dataTypeId, memorySpaceId, fileSpaceId, HDF5Constants.H5P_DEFAULT, value);
    }

    public long createDataSet(long fileId, long[] dimensions, long[] chunkSizeOrNull, long dataTypeId, HDF5AbstractStorageFeatures compression, String dataSetName, HDF5StorageLayout layout, ICleanUpRegistry registry) {
        long dataSetCreationPropertyListId;
        HDF5.checkMaxLength(dataSetName);
        final long dataSpaceId = H5.H5Screate_simple(dimensions.length, dimensions, HDF5.createMaxDimensions(dimensions, layout == HDF5StorageLayout.CHUNKED));
        registry.registerCleanUp(new Runnable(){

            @Override
            public void run() {
                H5.H5Sclose(dataSpaceId);
            }
        });
        if (layout == HDF5StorageLayout.CHUNKED && chunkSizeOrNull != null) {
            dataSetCreationPropertyListId = this.createDataSetCreationPropertyList(registry);
            this.setChunkedLayout(dataSetCreationPropertyListId, chunkSizeOrNull);
            if (compression.isScaling()) {
                int classTypeId = this.getClassType(dataTypeId);
                assert (compression.isCompatibleWithDataClass(classTypeId));
                if (classTypeId == HDF5Constants.H5T_INTEGER) {
                    H5.H5Pset_scaleoffset(dataSetCreationPropertyListId, HDF5Constants.H5Z_SO_INT, compression.getScalingFactor());
                } else if (classTypeId == HDF5Constants.H5T_FLOAT) {
                    H5.H5Pset_scaleoffset(dataSetCreationPropertyListId, HDF5Constants.H5Z_SO_FLOAT_DSCALE, compression.getScalingFactor());
                }
            }
            if (compression.isShuffleBeforeDeflate()) {
                this.setShuffle(dataSetCreationPropertyListId);
            }
            if (compression.isDeflating()) {
                this.setDeflate(dataSetCreationPropertyListId, compression.getDeflateLevel());
            }
        } else {
            dataSetCreationPropertyListId = layout == HDF5StorageLayout.COMPACT ? this.dataSetCreationPropertyListCompactStorageLayoutFileTimeAlloc : this.dataSetCreationPropertyListFillTimeAlloc;
        }
        final long dataSetId = H5.H5Dcreate(fileId, dataSetName, dataTypeId, dataSpaceId, this.lcplCreateIntermediateGroups, dataSetCreationPropertyListId, HDF5Constants.H5P_DEFAULT);
        registry.registerCleanUp(new Runnable(){

            @Override
            public void run() {
                H5.H5Dclose(dataSetId);
            }
        });
        return dataSetId;
    }

    public HDF5DataSet createDataSetDetached(HDF5BaseWriter baseWriter, long[] dimensions, long[] chunkSizeOrNull, long dataTypeId, HDF5AbstractStorageFeatures compression, String dataSetName, HDF5StorageLayout layout, ICleanUpRegistry registry) {
        long dataSetCreationPropertyListId;
        HDF5.checkMaxLength(dataSetName);
        long[] maxDimensions = HDF5.createMaxDimensions(dimensions, layout == HDF5StorageLayout.CHUNKED);
        long dataSpaceId = H5.H5Screate_simple(dimensions.length, dimensions, maxDimensions);
        if (layout == HDF5StorageLayout.CHUNKED && chunkSizeOrNull != null) {
            dataSetCreationPropertyListId = this.createDataSetCreationPropertyList(registry);
            this.setChunkedLayout(dataSetCreationPropertyListId, chunkSizeOrNull);
            if (compression.isScaling()) {
                int classTypeId = this.getClassType(dataTypeId);
                assert (compression.isCompatibleWithDataClass(classTypeId));
                if (classTypeId == HDF5Constants.H5T_INTEGER) {
                    H5.H5Pset_scaleoffset(dataSetCreationPropertyListId, HDF5Constants.H5Z_SO_INT, compression.getScalingFactor());
                } else if (classTypeId == HDF5Constants.H5T_FLOAT) {
                    H5.H5Pset_scaleoffset(dataSetCreationPropertyListId, HDF5Constants.H5Z_SO_FLOAT_DSCALE, compression.getScalingFactor());
                }
            }
            if (compression.isShuffleBeforeDeflate()) {
                this.setShuffle(dataSetCreationPropertyListId);
            }
            if (compression.isDeflating()) {
                this.setDeflate(dataSetCreationPropertyListId, compression.getDeflateLevel());
            }
        } else {
            dataSetCreationPropertyListId = layout == HDF5StorageLayout.COMPACT ? this.dataSetCreationPropertyListCompactStorageLayoutFileTimeAlloc : this.dataSetCreationPropertyListFillTimeAlloc;
        }
        long dataSetId = H5.H5Dcreate(baseWriter.fileId, dataSetName, dataTypeId, dataSpaceId, this.lcplCreateIntermediateGroups, dataSetCreationPropertyListId, HDF5Constants.H5P_DEFAULT);
        return new HDF5DataSet(baseWriter, dataSetName, dataSetId, dataSpaceId, dimensions, maxDimensions, layout, true);
    }

    public HDF5DataSetTemplate createDataSetTemplateLowLevel(long fileId, long[] dimensions, long[] chunkSizeOrNull, long dataTypeId, HDF5AbstractStorageFeatures compression, HDF5StorageLayout layout, IHDF5WriterConfigurator.FileFormatVersionBounds fileFormat) {
        boolean closeCreationPropertyListId;
        long dataSetCreationPropertyListId;
        long[] maxDimensions = HDF5.createMaxDimensions(dimensions, layout == HDF5StorageLayout.CHUNKED);
        long dataSpaceId = H5.H5Screate_simple(dimensions.length, dimensions, maxDimensions);
        if (layout == HDF5StorageLayout.CHUNKED && chunkSizeOrNull != null) {
            dataSetCreationPropertyListId = this.createDataSetCreationPropertyList(null);
            closeCreationPropertyListId = true;
            this.setChunkedLayout(dataSetCreationPropertyListId, chunkSizeOrNull);
            if (compression.isScaling()) {
                int classTypeId = this.getClassType(dataTypeId);
                assert (compression.isCompatibleWithDataClass(classTypeId));
                if (classTypeId == HDF5Constants.H5T_INTEGER) {
                    H5.H5Pset_scaleoffset(dataSetCreationPropertyListId, HDF5Constants.H5Z_SO_INT, compression.getScalingFactor());
                } else if (classTypeId == HDF5Constants.H5T_FLOAT) {
                    H5.H5Pset_scaleoffset(dataSetCreationPropertyListId, HDF5Constants.H5Z_SO_FLOAT_DSCALE, compression.getScalingFactor());
                }
            }
            if (compression.isShuffleBeforeDeflate()) {
                this.setShuffle(dataSetCreationPropertyListId);
            }
            if (compression.isDeflating()) {
                this.setDeflate(dataSetCreationPropertyListId, compression.getDeflateLevel());
            }
        } else if (layout == HDF5StorageLayout.COMPACT) {
            dataSetCreationPropertyListId = this.dataSetCreationPropertyListCompactStorageLayoutFileTimeAlloc;
            closeCreationPropertyListId = false;
        } else {
            dataSetCreationPropertyListId = this.dataSetCreationPropertyListFillTimeAlloc;
            closeCreationPropertyListId = false;
        }
        return new HDF5DataSetTemplate(dataSpaceId, dataSetCreationPropertyListId, closeCreationPropertyListId, dataTypeId, dimensions, maxDimensions, layout);
    }

    public long createDataSetSimple(long fileId, long dataTypeId, long dataSpaceId, long dataSetCreationPropertyListId, String dataSetName, ICleanUpRegistry registryOrNull) {
        final long dataSetId = H5.H5Dcreate(fileId, dataSetName, dataTypeId, dataSpaceId, this.lcplCreateIntermediateGroups, dataSetCreationPropertyListId, HDF5Constants.H5P_DEFAULT);
        if (registryOrNull != null) {
            registryOrNull.registerCleanUp(new Runnable(){

                @Override
                public void run() {
                    H5.H5Dclose(dataSetId);
                }
            });
        }
        return dataSetId;
    }

    private long createDataSetCreationPropertyList(ICleanUpRegistry registry) {
        final long dataSetCreationPropertyListId = H5.H5Pcreate(HDF5Constants.H5P_DATASET_CREATE);
        if (registry != null) {
            registry.registerCleanUp(new Runnable(){

                @Override
                public void run() {
                    H5.H5Pclose(dataSetCreationPropertyListId);
                }
            });
        }
        H5.H5Pset_fill_time(dataSetCreationPropertyListId, HDF5Constants.H5D_FILL_TIME_ALLOC);
        return dataSetCreationPropertyListId;
    }

    public HDF5StorageLayout getLayout(long dataSetId, ICleanUpRegistry registry) {
        long dataSetCreationPropertyListId = this.getCreationPropertyList(dataSetId, registry);
        int layoutId = H5.H5Pget_layout(dataSetCreationPropertyListId);
        if (layoutId == HDF5Constants.H5D_COMPACT) {
            return HDF5StorageLayout.COMPACT;
        }
        if (layoutId == HDF5Constants.H5D_CHUNKED) {
            return HDF5StorageLayout.CHUNKED;
        }
        return HDF5StorageLayout.CONTIGUOUS;
    }

    private long getCreationPropertyList(long dataSetId, ICleanUpRegistry registry) {
        final long dataSetCreationPropertyListId = H5.H5Dget_create_plist(dataSetId);
        registry.registerCleanUp(new Runnable(){

            @Override
            public void run() {
                H5.H5Pclose(dataSetCreationPropertyListId);
            }
        });
        return dataSetCreationPropertyListId;
    }

    private static final long[] createMaxDimensions(long[] dimensions, boolean unlimited) {
        if (!unlimited) {
            return dimensions;
        }
        long[] maxDimensions = new long[dimensions.length];
        Arrays.fill(maxDimensions, (long)HDF5Constants.H5S_UNLIMITED);
        return maxDimensions;
    }

    private void setChunkedLayout(long dscpId, long[] chunkSize) {
        assert (dscpId >= 0L);
        H5.H5Pset_layout(dscpId, HDF5Constants.H5D_CHUNKED);
        H5.H5Pset_chunk(dscpId, chunkSize.length, chunkSize);
    }

    private void setShuffle(long dscpId) {
        assert (dscpId >= 0L);
        H5.H5Pset_shuffle(dscpId);
    }

    private void setDeflate(long dscpId, int deflateLevel) {
        assert (dscpId >= 0L);
        assert (deflateLevel >= 0);
        H5.H5Pset_deflate(dscpId, deflateLevel);
    }

    public long createScalarDataSet(long fileId, long dataTypeId, String dataSetName, boolean compactLayout, ICleanUpRegistry registry) {
        HDF5.checkMaxLength(dataSetName);
        final long dataSpaceId = H5.H5Screate(HDF5Constants.H5S_SCALAR);
        registry.registerCleanUp(new Runnable(){

            @Override
            public void run() {
                H5.H5Sclose(dataSpaceId);
            }
        });
        final long dataSetId = H5.H5Dcreate(fileId, dataSetName, dataTypeId, dataSpaceId, this.lcplCreateIntermediateGroups, compactLayout ? this.dataSetCreationPropertyListCompactStorageLayoutFileTimeAlloc : this.dataSetCreationPropertyListFillTimeAlloc, HDF5Constants.H5P_DEFAULT);
        registry.registerCleanUp(new Runnable(){

            @Override
            public void run() {
                H5.H5Dclose(dataSetId);
            }
        });
        return dataSetId;
    }

    public long openDataSet(long fileId, String path, ICleanUpRegistry registry) {
        long dataSetId;
        HDF5.checkMaxLength(path);
        long l = dataSetId = this.isReference(path) ? H5.H5Oopen_by_addr(fileId, Long.parseLong(path.substring(1))) : H5.H5Dopen(fileId, path, HDF5Constants.H5P_DEFAULT);
        if (registry != null) {
            registry.registerCleanUp(new Runnable(){

                @Override
                public void run() {
                    H5.H5Dclose(dataSetId);
                }
            });
        }
        return dataSetId;
    }

    boolean isReference(String path) {
        return this.autoDereference && path.charAt(0) == '\u0000';
    }

    public long openAndExtendDataSet(long fileId, String path, IHDF5WriterConfigurator.FileFormatVersionBounds fileFormat, long[] newDimensions, boolean overwriteMode, ICleanUpRegistry registry) throws HDF5JavaException {
        HDF5.checkMaxLength(path);
        final long dataSetId = this.isReference(path) ? H5.H5Rdereference(fileId, HDF5Constants.H5P_DEFAULT, HDF5Constants.H5R_OBJECT, HDFNativeData.longToByte(Long.parseLong(path.substring(1)))) : H5.H5Dopen(fileId, path, HDF5Constants.H5P_DEFAULT);
        registry.registerCleanUp(new Runnable(){

            @Override
            public void run() {
                H5.H5Dclose(dataSetId);
            }
        });
        long dataSpaceId = this.getDataSpaceForDataSet(dataSetId, registry);
        int rank = this.getDataSpaceRank(dataSpaceId);
        long[][] dimsMaxDims = this.getDataSpaceDimensionsAndMaxDimensions(dataSpaceId, rank);
        long[] dataDimensions = dimsMaxDims[0];
        long[] maxDimensions = dimsMaxDims[1];
        HDF5StorageLayout layout = this.getLayout(dataSetId, registry);
        this.extendDataSet(dataSetId, dataSpaceId, rank, layout, dataDimensions, newDimensions, maxDimensions, overwriteMode, registry);
        return dataSetId;
    }

    public boolean extendDataSet(HDF5DataSet dataSet, long[] newDimensions, boolean overwriteMode, ICleanUpRegistry registry) throws HDF5SpaceRankMismatch, HDF5JavaException {
        return this.extendDataSet(dataSet.getDataSetId(), dataSet.getDataSpaceId(), dataSet.getRank(), dataSet.getLayout(), dataSet.getDimensions(), newDimensions, dataSet.getMaxDimensions(), overwriteMode, registry);
    }

    public boolean extendDataSet(long dataSetId, long dataSpaceId, int rank, HDF5StorageLayout layout, long[] oldDimensions, long[] newDimensions, long[] maxDimensions, boolean overwriteMode, ICleanUpRegistry registry) throws HDF5SpaceRankMismatch, HDF5JavaException {
        this.checkRank(rank, newDimensions.length);
        if (!Arrays.equals(oldDimensions, newDimensions)) {
            if (layout == HDF5StorageLayout.CHUNKED) {
                if (this.areDimensionsInBounds(newDimensions, maxDimensions)) {
                    this.setDataSetExtentChunked(dataSetId, this.computeNewDimensions(oldDimensions, newDimensions, overwriteMode));
                    return true;
                }
                throw new HDF5JavaException("New data set dimensions are out of bounds.");
            }
            if (overwriteMode) {
                throw new HDF5JavaException("Cannot change dimensions on non-extendable data set.");
            }
            long dataTypeId = this.getDataTypeForDataSet(dataSetId, registry);
            if (this.getClassType(dataTypeId) == HDF5Constants.H5T_ARRAY) {
                throw new HDF5JavaException("Cannot partially overwrite array type.");
            }
            if (!HDF5Utils.isInBounds(oldDimensions, newDimensions)) {
                throw new HDF5JavaException("New data set dimensions are out of bounds.");
            }
        }
        return false;
    }

    public boolean extendDataSet(HDF5DataSet dataSet, long[] newDimensions, boolean overwriteMode) throws HDF5JavaException {
        long dataSetId = dataSet.getDataSetId();
        long[] oldDimensions = dataSet.getDimensions();
        if (!Arrays.equals(oldDimensions, newDimensions)) {
            HDF5StorageLayout layout = dataSet.getLayout();
            long[] maxDimensions = dataSet.getMaxDimensions();
            if (layout == HDF5StorageLayout.CHUNKED) {
                if (this.areDimensionsInBounds(newDimensions, maxDimensions)) {
                    this.setDataSetExtentChunked(dataSetId, this.computeNewDimensions(oldDimensions, newDimensions, overwriteMode));
                    return true;
                }
                throw new HDF5JavaException("New data set dimensions are out of bounds.");
            }
            if (overwriteMode) {
                throw new HDF5JavaException("Cannot change dimensions on non-extendable data set.");
            }
            long dataTypeId = dataSet.getDataTypeId();
            if (this.getClassType(dataTypeId) == HDF5Constants.H5T_ARRAY) {
                throw new HDF5JavaException("Cannot partially overwrite array type.");
            }
            if (!HDF5Utils.isInBounds(oldDimensions, newDimensions)) {
                throw new HDF5JavaException("New data set dimensions are out of bounds.");
            }
        }
        return false;
    }

    long[] computeNewDimensions(long[] oldDimensions, long[] newDimensions, boolean cutDownExtendIfNecessary) {
        if (cutDownExtendIfNecessary) {
            return newDimensions;
        }
        long[] newUncutDimensions = new long[oldDimensions.length];
        int i = 0;
        while (i < newUncutDimensions.length) {
            newUncutDimensions[i] = Math.max(oldDimensions[i], newDimensions[i]);
            ++i;
        }
        return newUncutDimensions;
    }

    void checkRank(int rankExpected, int rankFound) throws HDF5SpaceRankMismatch {
        assert (rankExpected >= 0);
        assert (rankFound >= 0);
        if (rankExpected != rankFound) {
            throw new HDF5SpaceRankMismatch(rankExpected, rankFound);
        }
    }

    private boolean areDimensionsInBounds(long[] dimensions, long[] maxDimensions) {
        if (dimensions.length != maxDimensions.length) {
            return false;
        }
        int i = 0;
        while (i < dimensions.length) {
            if (maxDimensions[i] != (long)HDF5Constants.H5S_UNLIMITED && dimensions[i] > maxDimensions[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public void setDataSetExtentChunked(long dataSetId, long[] dimensions) {
        assert (dataSetId >= 0L);
        assert (dimensions != null);
        H5.H5Dset_extent(dataSetId, dimensions);
    }

    public void readDataSetNonNumeric(long dataSetId, long nativeDataTypeId, byte[] data) {
        H5.H5Dread(dataSetId, nativeDataTypeId, (long)HDF5Constants.H5S_ALL, (long)HDF5Constants.H5S_ALL, HDF5Constants.H5P_DEFAULT, data);
    }

    public void readDataSetNonNumeric(long dataSetId, long nativeDataTypeId, long memorySpaceId, long fileSpaceId, byte[] data) {
        H5.H5Dread(dataSetId, nativeDataTypeId, memorySpaceId, fileSpaceId, HDF5Constants.H5P_DEFAULT, data);
    }

    public void readDataSetString(long dataSetId, long nativeDataTypeId, String[] data) {
        H5.H5Dread_string(dataSetId, nativeDataTypeId, HDF5Constants.H5S_ALL, HDF5Constants.H5S_ALL, HDF5Constants.H5P_DEFAULT, data);
    }

    public void readDataSetString(long dataSetId, long nativeDataTypeId, long memorySpaceId, long fileSpaceId, String[] data) {
        H5.H5Dread_string(dataSetId, nativeDataTypeId, memorySpaceId, fileSpaceId, HDF5Constants.H5P_DEFAULT, data);
    }

    public void readDataSet(long dataSetId, long nativeDataTypeId, byte[] data) {
        H5.H5Dread(dataSetId, nativeDataTypeId, (long)HDF5Constants.H5S_ALL, (long)HDF5Constants.H5S_ALL, this.numericConversionXferPropertyListID, data);
    }

    public void readDataSet(long dataSetId, long nativeDataTypeId, short[] data) {
        H5.H5Dread(dataSetId, nativeDataTypeId, (long)HDF5Constants.H5S_ALL, (long)HDF5Constants.H5S_ALL, this.numericConversionXferPropertyListID, data);
    }

    public void readDataSet(long dataSetId, long nativeDataTypeId, int[] data) {
        H5.H5Dread(dataSetId, nativeDataTypeId, (long)HDF5Constants.H5S_ALL, (long)HDF5Constants.H5S_ALL, this.numericConversionXferPropertyListID, data);
    }

    public void readDataSet(long dataSetId, long nativeDataTypeId, long[] data) {
        H5.H5Dread(dataSetId, nativeDataTypeId, (long)HDF5Constants.H5S_ALL, (long)HDF5Constants.H5S_ALL, this.numericConversionXferPropertyListID, data);
    }

    public void readDataSet(long dataSetId, long nativeDataTypeId, float[] data) {
        H5.H5Dread(dataSetId, nativeDataTypeId, (long)HDF5Constants.H5S_ALL, (long)HDF5Constants.H5S_ALL, this.numericConversionXferPropertyListID, data);
    }

    public void readDataSet(long dataSetId, long nativeDataTypeId, double[] data) {
        H5.H5Dread(dataSetId, nativeDataTypeId, (long)HDF5Constants.H5S_ALL, (long)HDF5Constants.H5S_ALL, this.numericConversionXferPropertyListID, data);
    }

    public void readDataSet(long dataSetId, long nativeDataTypeId, long memorySpaceId, long fileSpaceId, byte[] data) {
        H5.H5Dread(dataSetId, nativeDataTypeId, memorySpaceId, fileSpaceId, this.numericConversionXferPropertyListID, data);
    }

    public void readDataSet(long dataSetId, long nativeDataTypeId, long memorySpaceId, long fileSpaceId, short[] data) {
        H5.H5Dread(dataSetId, nativeDataTypeId, memorySpaceId, fileSpaceId, this.numericConversionXferPropertyListID, data);
    }

    public void readDataSet(long dataSetId, long nativeDataTypeId, long memorySpaceId, long fileSpaceId, int[] data) {
        H5.H5Dread(dataSetId, nativeDataTypeId, memorySpaceId, fileSpaceId, this.numericConversionXferPropertyListID, data);
    }

    public void readDataSet(long dataSetId, long nativeDataTypeId, long memorySpaceId, long fileSpaceId, long[] data) {
        H5.H5Dread(dataSetId, nativeDataTypeId, memorySpaceId, fileSpaceId, this.numericConversionXferPropertyListID, data);
    }

    public void readDataSet(long dataSetId, long nativeDataTypeId, long memorySpaceId, long fileSpaceId, float[] data) {
        H5.H5Dread(dataSetId, nativeDataTypeId, memorySpaceId, fileSpaceId, this.numericConversionXferPropertyListID, data);
    }

    public void readDataSet(long dataSetId, long nativeDataTypeId, long memorySpaceId, long fileSpaceId, double[] data) {
        H5.H5Dread(dataSetId, nativeDataTypeId, memorySpaceId, fileSpaceId, this.numericConversionXferPropertyListID, data);
    }

    public void readDataSetVL(long dataSetId, long dataTypeId, String[] data) {
        H5.H5DreadVL(dataSetId, dataTypeId, HDF5Constants.H5S_ALL, HDF5Constants.H5S_ALL, HDF5Constants.H5P_DEFAULT, data);
        this.replaceNullWithEmptyString(data);
    }

    public void readDataSetVL(long dataSetId, long dataTypeId, long memorySpaceId, long fileSpaceId, String[] data) {
        H5.H5DreadVL(dataSetId, dataTypeId, memorySpaceId, fileSpaceId, HDF5Constants.H5P_DEFAULT, data);
        this.replaceNullWithEmptyString(data);
    }

    private void replaceNullWithEmptyString(String[] data) {
        int i = 0;
        while (i < data.length) {
            if (data[i] == null) {
                data[i] = "";
            }
            ++i;
        }
    }

    public long createAttribute(long locationId, String attributeName, long dataTypeId, long dataSpaceIdOrMinusOne, ICleanUpRegistry registry) {
        long attCreationPlistId;
        long dataSpaceId;
        HDF5.checkMaxLength(attributeName);
        long l = dataSpaceId = dataSpaceIdOrMinusOne == -1L ? H5.H5Screate(HDF5Constants.H5S_SCALAR) : dataSpaceIdOrMinusOne;
        if (dataSpaceIdOrMinusOne == -1L) {
            registry.registerCleanUp(new Runnable(){

                @Override
                public void run() {
                    H5.H5Sclose(dataSpaceId);
                }
            });
        }
        if (this.useUTF8CharEncoding) {
            attCreationPlistId = H5.H5Pcreate(HDF5Constants.H5P_ATTRIBUTE_CREATE);
            this.setCharacterEncodingCreationPropertyList(attCreationPlistId, CharacterEncoding.UTF8);
        } else {
            attCreationPlistId = HDF5Constants.H5P_DEFAULT;
        }
        final long attributeId = H5.H5Acreate(locationId, attributeName, dataTypeId, dataSpaceId, attCreationPlistId, HDF5Constants.H5P_DEFAULT);
        registry.registerCleanUp(new Runnable(){

            @Override
            public void run() {
                H5.H5Aclose(attributeId);
            }
        });
        return attributeId;
    }

    public int deleteAttribute(long locationId, String attributeName) {
        HDF5.checkMaxLength(attributeName);
        int success = H5.H5Adelete(locationId, attributeName);
        return success;
    }

    public long openAttribute(long locationId, String attributeName, ICleanUpRegistry registry) {
        HDF5.checkMaxLength(attributeName);
        final long attributeId = H5.H5Aopen(locationId, attributeName, HDF5Constants.H5P_DEFAULT);
        registry.registerCleanUp(new Runnable(){

            @Override
            public void run() {
                H5.H5Aclose(attributeId);
            }
        });
        return attributeId;
    }

    public List<String> getAttributeNames(long locationId, ICleanUpRegistry registry) {
        H5O_info_t info = H5.H5Oget_info(locationId);
        int numberOfAttributes = (int)info.num_attrs;
        LinkedList<String> attributeNames = new LinkedList<String>();
        int i = 0;
        while (i < numberOfAttributes) {
            final long attributeId = H5.H5Aopen_by_idx(locationId, ".", HDF5Constants.H5_INDEX_NAME, HDF5Constants.H5_ITER_NATIVE, i, HDF5Constants.H5P_DEFAULT, HDF5Constants.H5P_DEFAULT);
            registry.registerCleanUp(new Runnable(){

                @Override
                public void run() {
                    H5.H5Aclose(attributeId);
                }
            });
            attributeNames.add(H5.H5Aget_name(attributeId));
            ++i;
        }
        return attributeNames;
    }

    public byte[] readAttributeAsByteArray(long attributeId, long dataTypeId, int length) {
        byte[] data = new byte[length];
        H5.H5Aread(attributeId, dataTypeId, data);
        return data;
    }

    public short[] readAttributeAsShortArray(long attributeId, long dataTypeId, int length) {
        short[] data = new short[length];
        H5.H5Aread(attributeId, dataTypeId, data);
        return data;
    }

    public int[] readAttributeAsIntArray(long attributeId, long dataTypeId, int length) {
        int[] data = new int[length];
        H5.H5Aread(attributeId, dataTypeId, data);
        return data;
    }

    public long[] readAttributeAsLongArray(long attributeId, long dataTypeId, int length) {
        long[] data = new long[length];
        H5.H5Aread(attributeId, dataTypeId, data);
        return data;
    }

    public float[] readAttributeAsFloatArray(long attributeId, long dataTypeId, int length) {
        float[] data = new float[length];
        H5.H5Aread(attributeId, dataTypeId, data);
        return data;
    }

    public double[] readAttributeAsDoubleArray(long attributeId, long dataTypeId, int length) {
        double[] data = new double[length];
        H5.H5Aread(attributeId, dataTypeId, data);
        return data;
    }

    public void readAttributeVL(long attributeId, long dataTypeId, String[] data) {
        H5.H5AreadVL(attributeId, dataTypeId, data);
    }

    public void writeAttribute(long attributeId, long dataTypeId, byte[] value) {
        H5.H5Awrite(attributeId, dataTypeId, value);
    }

    public void writeAttribute(long attributeId, long dataTypeId, short[] value) {
        H5.H5Awrite(attributeId, dataTypeId, value);
    }

    public void writeAttribute(long attributeId, long dataTypeId, int[] value) {
        H5.H5Awrite(attributeId, dataTypeId, value);
    }

    public void writeAttribute(long attributeId, long dataTypeId, long[] value) {
        H5.H5Awrite(attributeId, dataTypeId, value);
    }

    public void writeAttribute(long attributeId, long dataTypeId, float[] value) {
        H5.H5Awrite(attributeId, dataTypeId, value);
    }

    public void writeAttribute(long attributeId, long dataTypeId, double[] value) {
        H5.H5Awrite(attributeId, dataTypeId, value);
    }

    public void writeAttributeStringVL(long attributeId, long dataTypeId, String[] value) {
        H5.H5AwriteVL(attributeId, dataTypeId, value);
    }

    public long copyDataType(long dataTypeId, ICleanUpRegistry registry) {
        final long copiedDataTypeId = H5.H5Tcopy(dataTypeId);
        registry.registerCleanUp(new Runnable(){

            @Override
            public void run() {
                H5.H5Tclose(copiedDataTypeId);
            }
        });
        return copiedDataTypeId;
    }

    public long createDataTypeVariableString(ICleanUpRegistry registry) {
        final long dataTypeId = this.createDataTypeStringVariableLength();
        registry.registerCleanUp(new Runnable(){

            @Override
            public void run() {
                H5.H5Tclose(dataTypeId);
            }
        });
        if (this.useUTF8CharEncoding) {
            this.setCharacterEncodingDataType(dataTypeId, CharacterEncoding.UTF8);
        }
        return dataTypeId;
    }

    private long createDataTypeStringVariableLength() {
        long dataTypeId = H5.H5Tcopy(HDF5Constants.H5T_C_S1);
        H5.H5Tset_size(dataTypeId, HDF5Constants.H5T_VARIABLE);
        return dataTypeId;
    }

    public long createDataTypeString(int length, ICleanUpRegistry registry) {
        assert (length > 0);
        final long dataTypeId = H5.H5Tcopy(HDF5Constants.H5T_C_S1);
        registry.registerCleanUp(new Runnable(){

            @Override
            public void run() {
                H5.H5Tclose(dataTypeId);
            }
        });
        H5.H5Tset_size(dataTypeId, length);
        H5.H5Tset_strpad(dataTypeId, HDF5Constants.H5T_STR_NULLPAD);
        if (this.useUTF8CharEncoding) {
            this.setCharacterEncodingDataType(dataTypeId, CharacterEncoding.UTF8);
        }
        return dataTypeId;
    }

    private void setCharacterEncodingDataType(long dataTypeId, CharacterEncoding encoding) {
        H5.H5Tset_cset(dataTypeId, encoding.getCValue());
    }

    public long createArrayType(long baseTypeId, int length, ICleanUpRegistry registry) {
        final long dataTypeId = H5.H5Tarray_create(baseTypeId, 1, new long[]{length});
        registry.registerCleanUp(new Runnable(){

            @Override
            public void run() {
                H5.H5Tclose(dataTypeId);
            }
        });
        return dataTypeId;
    }

    public long createArrayType(long baseTypeId, int[] dimensions, ICleanUpRegistry registry) {
        long[] ldims = new long[dimensions.length];
        int i = 0;
        while (i < ldims.length) {
            ldims[i] = dimensions[i];
            ++i;
        }
        final long dataTypeId = H5.H5Tarray_create(baseTypeId, ldims.length, ldims);
        registry.registerCleanUp(new Runnable(){

            @Override
            public void run() {
                H5.H5Tclose(dataTypeId);
            }
        });
        return dataTypeId;
    }

    public long createDataTypeEnum(String[] names, ICleanUpRegistry registry) {
        long baseDataTypeId;
        String[] stringArray = names;
        int n = names.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            HDF5.checkMaxLength(name);
            ++n2;
        }
        EnumSize size = names.length < 127 ? EnumSize.BYTE8 : (names.length < Short.MAX_VALUE ? EnumSize.SHORT16 : EnumSize.INT32);
        switch (size) {
            case BYTE8: {
                baseDataTypeId = HDF5Constants.H5T_STD_I8LE;
                break;
            }
            case SHORT16: {
                baseDataTypeId = HDF5Constants.H5T_STD_I16LE;
                break;
            }
            case INT32: {
                baseDataTypeId = HDF5Constants.H5T_STD_I32LE;
                break;
            }
            default: {
                throw new InternalError();
            }
        }
        final long dataTypeId = H5.H5Tenum_create(baseDataTypeId);
        registry.registerCleanUp(new Runnable(){

            @Override
            public void run() {
                H5.H5Tclose(dataTypeId);
            }
        });
        switch (size) {
            case BYTE8: {
                byte i = 0;
                while (i < names.length) {
                    this.insertMemberEnum(dataTypeId, names[i], i);
                    i = (byte)(i + 1);
                }
                break;
            }
            case SHORT16: {
                short[] values2 = this.getLittleEndianSuccessiveShortValues(names);
                int i = 0;
                while (i < names.length) {
                    this.insertMemberEnum(dataTypeId, names[i], values2[i]);
                    i = (short)(i + 1);
                }
                break;
            }
            case INT32: {
                int[] values3 = this.getLittleEndianSuccessiveIntValues(names);
                int i = 0;
                while (i < names.length) {
                    this.insertMemberEnum(dataTypeId, names[i], values3[i]);
                    ++i;
                }
                break;
            }
        }
        return dataTypeId;
    }

    private short[] getLittleEndianSuccessiveShortValues(String[] names) {
        short[] values2 = new short[names.length];
        boolean swap = NativeData.getNativeByteOrder() == NativeData.ByteOrder.BIG_ENDIAN;
        short i = 0;
        while (i < names.length) {
            values2[i] = swap ? NativeData.changeByteOrder(i) : i;
            i = (short)(i + 1);
        }
        return values2;
    }

    private int[] getLittleEndianSuccessiveIntValues(String[] names) {
        int[] values2 = new int[names.length];
        boolean swap = NativeData.getNativeByteOrder() == NativeData.ByteOrder.BIG_ENDIAN;
        int i = 0;
        while (i < names.length) {
            values2[i] = swap ? NativeData.changeByteOrder(i) : i;
            ++i;
        }
        return values2;
    }

    private void insertMemberEnum(long dataTypeId, String name, byte value) {
        assert (dataTypeId >= 0L);
        assert (name != null);
        H5.H5Tenum_insert(dataTypeId, name, value);
    }

    private void insertMemberEnum(long dataTypeId, String name, short value) {
        assert (dataTypeId >= 0L);
        assert (name != null);
        H5.H5Tenum_insert(dataTypeId, name, value);
    }

    private void insertMemberEnum(long dataTypeId, String name, int value) {
        assert (dataTypeId >= 0L);
        assert (name != null);
        H5.H5Tenum_insert(dataTypeId, name, value);
    }

    public int getNumberOfMembers(long dataTypeId) {
        return H5.H5Tget_nmembers(dataTypeId);
    }

    public String getNameForEnumOrCompoundMemberIndex(long dataTypeId, int index) {
        return H5.H5Tget_member_name(dataTypeId, index);
    }

    public int getOffsetForCompoundMemberIndex(long dataTypeId, int index) {
        return (int)H5.H5Tget_member_offset(dataTypeId, index);
    }

    public String[] getNamesForEnumOrCompoundMembers(long dataTypeId) {
        int len = this.getNumberOfMembers(dataTypeId);
        String[] values2 = new String[len];
        int i = 0;
        while (i < len) {
            values2[i] = H5.H5Tget_member_name(dataTypeId, i);
            ++i;
        }
        return values2;
    }

    public int getIndexForMemberName(long dataTypeId, String name) {
        HDF5.checkMaxLength(name);
        return H5.H5Tget_member_index(dataTypeId, name);
    }

    public long getDataTypeForIndex(long compoundDataTypeId, int index, ICleanUpRegistry registry) {
        final long memberTypeId = H5.H5Tget_member_type(compoundDataTypeId, index);
        registry.registerCleanUp(new Runnable(){

            @Override
            public void run() {
                H5.H5Tclose(memberTypeId);
            }
        });
        return memberTypeId;
    }

    public long getDataTypeForMemberName(long compoundDataTypeId, String memberName) {
        HDF5.checkMaxLength(memberName);
        int index = H5.H5Tget_member_index(compoundDataTypeId, memberName);
        return H5.H5Tget_member_type(compoundDataTypeId, index);
    }

    public Boolean tryGetBooleanValue(long dataTypeId, int intValue) {
        if (this.getClassType(dataTypeId) != HDF5Constants.H5T_ENUM) {
            return null;
        }
        String value = this.getNameForEnumOrCompoundMemberIndex(dataTypeId, intValue);
        if ("TRUE".equalsIgnoreCase(value)) {
            return true;
        }
        if ("FALSE".equalsIgnoreCase(value)) {
            return false;
        }
        return null;
    }

    public long createDataTypeCompound(int lengthInBytes, ICleanUpRegistry registry) {
        final long dataTypeId = H5.H5Tcreate(HDF5Constants.H5T_COMPOUND, lengthInBytes);
        registry.registerCleanUp(new Runnable(){

            @Override
            public void run() {
                H5.H5Tclose(dataTypeId);
            }
        });
        return dataTypeId;
    }

    public long createDataTypeOpaque(int lengthInBytes, String tag, ICleanUpRegistry registry) {
        HDF5.checkMaxLength(tag);
        final long dataTypeId = H5.H5Tcreate(HDF5Constants.H5T_OPAQUE, lengthInBytes);
        registry.registerCleanUp(new Runnable(){

            @Override
            public void run() {
                H5.H5Tclose(dataTypeId);
            }
        });
        H5.H5Tset_tag(dataTypeId, tag.length() > HDF5Constants.H5T_OPAQUE_TAG_MAX ? tag.substring(0, HDF5Constants.H5T_OPAQUE_TAG_MAX) : tag);
        return dataTypeId;
    }

    public void commitDataType(long fileId, String name, long dataTypeId) {
        HDF5.checkMaxLength(name);
        H5.H5Tcommit(fileId, name, dataTypeId, this.lcplCreateIntermediateGroups, HDF5Constants.H5P_DEFAULT, HDF5Constants.H5P_DEFAULT);
    }

    public long openDataType(long fileId, String name, ICleanUpRegistry registry) {
        HDF5.checkMaxLength(name);
        final long dataTypeId = this.isReference(name) ? H5.H5Oopen_by_addr(fileId, Long.parseLong(name.substring(1))) : H5.H5Topen(fileId, name, HDF5Constants.H5P_DEFAULT);
        registry.registerCleanUp(new Runnable(){

            @Override
            public void run() {
                H5.H5Tclose(dataTypeId);
            }
        });
        return dataTypeId;
    }

    public boolean dataTypesAreEqual(long dataTypeId1, long dataTypeId2) {
        return H5.H5Tequal(dataTypeId1, dataTypeId2);
    }

    public long getDataTypeForDataSet(long dataSetId, ICleanUpRegistry registry) {
        final long dataTypeId = H5.H5Dget_type(dataSetId);
        registry.registerCleanUp(new Runnable(){

            @Override
            public void run() {
                H5.H5Tclose(dataTypeId);
            }
        });
        return dataTypeId;
    }

    public long getDataTypeForAttribute(long attributeId, ICleanUpRegistry registry) {
        final long dataTypeId = H5.H5Aget_type(attributeId);
        registry.registerCleanUp(new Runnable(){

            @Override
            public void run() {
                H5.H5Tclose(dataTypeId);
            }
        });
        return dataTypeId;
    }

    public String tryGetOpaqueTag(long dataTypeId) {
        return H5.H5Tget_tag(dataTypeId);
    }

    public long getNativeDataType(long dataTypeId, ICleanUpRegistry registry) {
        final long nativeDataTypeId = H5.H5Tget_native_type(dataTypeId);
        registry.registerCleanUp(new Runnable(){

            @Override
            public void run() {
                H5.H5Tclose(nativeDataTypeId);
            }
        });
        return nativeDataTypeId;
    }

    public long getNativeDataTypeForDataSet(long dataSetId, ICleanUpRegistry registry) {
        final long dataTypeId = H5.H5Dget_type(dataSetId);
        registry.registerCleanUp(new Runnable(){

            @Override
            public void run() {
                H5.H5Tclose(dataTypeId);
            }
        });
        return this.getNativeDataType(dataTypeId, registry);
    }

    public long getNativeDataTypeForAttribute(long attributeId, ICleanUpRegistry registry) {
        final long dataTypeId = H5.H5Aget_type(attributeId);
        registry.registerCleanUp(new Runnable(){

            @Override
            public void run() {
                H5.H5Tclose(dataTypeId);
            }
        });
        return this.getNativeDataType(dataTypeId, registry);
    }

    public int getDataTypeSize(long dataTypeId) {
        return (int)H5.H5Tget_size(dataTypeId);
    }

    public long getDataTypeSizeLong(long dataTypeId) throws HDF5JavaException {
        return H5.H5Tget_size(dataTypeId);
    }

    public boolean isVariableLengthString(long dataTypeId) {
        return H5.H5Tis_variable_str(dataTypeId);
    }

    public int getClassType(long dataTypeId) {
        return H5.H5Tget_class(dataTypeId);
    }

    public CharacterEncoding getCharacterEncoding(long dataTypeId) {
        int cValue = H5.H5Tget_cset(dataTypeId);
        if (cValue == CharacterEncoding.ASCII.getCValue()) {
            return CharacterEncoding.ASCII;
        }
        if (cValue == CharacterEncoding.UTF8.getCValue()) {
            return CharacterEncoding.UTF8;
        }
        throw new HDF5JavaException("Unknown character encoding cValue " + cValue);
    }

    public boolean hasClassType(long dataTypeId, int classTypeId) {
        return H5.H5Tdetect_class(dataTypeId, classTypeId);
    }

    public long getBaseDataType(long dataTypeId, ICleanUpRegistry registry) {
        final long baseDataTypeId = H5.H5Tget_super(dataTypeId);
        registry.registerCleanUp(new Runnable(){

            @Override
            public void run() {
                H5.H5Tclose(baseDataTypeId);
            }
        });
        return baseDataTypeId;
    }

    public boolean getSigned(long dataTypeId) {
        return H5.H5Tget_sign(dataTypeId) != HDF5Constants.H5T_SGN_NONE;
    }

    public String tryGetDataTypePath(long dataTypeId) {
        if (dataTypeId < 0L || !H5.H5Tcommitted(dataTypeId)) {
            return null;
        }
        return H5.H5Iget_name(dataTypeId);
    }

    public void reclaimCompoundVL(HDF5CompoundType<?> type, byte[] buf) {
        int[] vlMemberIndices = type.getObjectByteifyer().getVLMemberIndices();
        if (vlMemberIndices.length > 0) {
            HDFHelper.freeCompoundVLStr(buf, type.getRecordSizeInMemory(), vlMemberIndices);
        }
    }

    public long getDataSpaceForDataSet(long dataSetId, ICleanUpRegistry registry) {
        final long dataSpaceId = H5.H5Dget_space(dataSetId);
        if (registry != null) {
            registry.registerCleanUp(new Runnable(){

                @Override
                public void run() {
                    H5.H5Sclose(dataSpaceId);
                }
            });
        }
        return dataSpaceId;
    }

    public long[] getDataDimensionsForAttribute(long attributeId, ICleanUpRegistry registry) {
        final long dataSpaceId = H5.H5Aget_space(attributeId);
        registry.registerCleanUp(new Runnable(){

            @Override
            public void run() {
                H5.H5Sclose(dataSpaceId);
            }
        });
        long[] dimensions = this.getDataSpaceDimensions(dataSpaceId);
        return dimensions;
    }

    public long[] getDataDimensions(long dataSetId, ICleanUpRegistry registry) {
        final long dataSpaceId = H5.H5Dget_space(dataSetId);
        registry.registerCleanUp(new Runnable(){

            @Override
            public void run() {
                H5.H5Sclose(dataSpaceId);
            }
        });
        long[] dimensions = this.getDataSpaceDimensions(dataSpaceId);
        if (HDF5Utils.mightBeEmptyInStorage(dimensions) && this.existsAttribute(dataSetId, "__EMPTY__")) {
            dimensions = new long[dimensions.length];
        }
        return dimensions;
    }

    public int getDataSpaceRank(long dataSpaceId) {
        return H5.H5Sget_simple_extent_ndims(dataSpaceId);
    }

    public long[] getDataSpaceDimensions(long dataSpaceId) {
        int rank = H5.H5Sget_simple_extent_ndims(dataSpaceId);
        return this.getDataSpaceDimensions(dataSpaceId, rank);
    }

    public long[] getDataSpaceDimensions(long dataSpaceId, int rank) {
        assert (dataSpaceId >= 0L);
        assert (rank >= 0);
        long[] dimensions = new long[rank];
        H5.H5Sget_simple_extent_dims(dataSpaceId, dimensions, null);
        return dimensions;
    }

    public long[] getDataSpaceMaxDimensions(long dataSpaceId) {
        int rank = H5.H5Sget_simple_extent_ndims(dataSpaceId);
        return this.getDataSpaceMaxDimensions(dataSpaceId, rank);
    }

    public long[] getDataSpaceMaxDimensions(long dataSpaceId, int rank) {
        assert (dataSpaceId >= 0L);
        assert (rank >= 0);
        long[] maxDimensions = new long[rank];
        H5.H5Sget_simple_extent_dims(dataSpaceId, null, maxDimensions);
        return maxDimensions;
    }

    public long[][] getDataSpaceDimensionsAndMaxDimensions(long dataSpaceId, int rank) {
        long[][] dimsMaxDims = new long[2][rank];
        H5.H5Sget_simple_extent_dims(dataSpaceId, dimsMaxDims[0], dimsMaxDims[1]);
        return dimsMaxDims;
    }

    public int getRank(long dataSetOrAttributeId, boolean isAttribute, ICleanUpRegistry registry) {
        final long dataSpaceId = isAttribute ? H5.H5Aget_space(dataSetOrAttributeId) : H5.H5Dget_space(dataSetOrAttributeId);
        registry.registerCleanUp(new Runnable(){

            @Override
            public void run() {
                H5.H5Sclose(dataSpaceId);
            }
        });
        return H5.H5Sget_simple_extent_ndims(dataSpaceId);
    }

    public long[] getDimensions(long dataSetOrAttributeId, boolean isAttribute, ICleanUpRegistry registry) {
        final long dataSpaceId = isAttribute ? H5.H5Aget_space(dataSetOrAttributeId) : H5.H5Dget_space(dataSetOrAttributeId);
        registry.registerCleanUp(new Runnable(){

            @Override
            public void run() {
                H5.H5Sclose(dataSpaceId);
            }
        });
        long[] dimensions = new long[HDF5Constants.H5S_MAX_RANK];
        int rank = H5.H5Sget_simple_extent_dims(dataSpaceId, dimensions, null);
        long[] realDimensions = new long[rank];
        System.arraycopy(dimensions, 0, realDimensions, 0, rank);
        return realDimensions;
    }

    public void fillDataDimensions(long dataSetOrAttributeId, boolean isAttribute, HDF5DataSetInformation dataSetInfo, ICleanUpRegistry registry) {
        final long dataSpaceId = isAttribute ? H5.H5Aget_space(dataSetOrAttributeId) : H5.H5Dget_space(dataSetOrAttributeId);
        registry.registerCleanUp(new Runnable(){

            @Override
            public void run() {
                H5.H5Sclose(dataSpaceId);
            }
        });
        long[] dimensions = new long[HDF5Constants.H5S_MAX_RANK];
        long[] maxDimensions = new long[HDF5Constants.H5S_MAX_RANK];
        int rank = H5.H5Sget_simple_extent_dims(dataSpaceId, dimensions, maxDimensions);
        long[] realDimensions = new long[rank];
        System.arraycopy(dimensions, 0, realDimensions, 0, rank);
        long[] realMaxDimensions = new long[rank];
        System.arraycopy(maxDimensions, 0, realMaxDimensions, 0, rank);
        dataSetInfo.setDimensions(realDimensions);
        dataSetInfo.setMaxDimensions(realMaxDimensions);
        if (!isAttribute) {
            long[] chunkSizes = new long[rank];
            long creationPropertyList = this.getCreationPropertyList(dataSetOrAttributeId, registry);
            HDF5StorageLayout layout = HDF5StorageLayout.fromId(H5.H5Pget_layout(creationPropertyList));
            dataSetInfo.setStorageLayout(layout);
            if (layout == HDF5StorageLayout.CHUNKED) {
                H5.H5Pget_chunk(creationPropertyList, rank, chunkSizes);
                dataSetInfo.setChunkSizes(MDAbstractArray.toInt(chunkSizes));
            }
        }
    }

    public int[] getArrayDimensions(long arrayTypeId) {
        int rank = H5.H5Tget_array_ndims(arrayTypeId);
        long[] dims = new long[rank];
        H5.H5Tget_array_dims(arrayTypeId, dims);
        int[] result = new int[rank];
        int i = 0;
        while (i < rank) {
            result[i] = (int)dims[i];
            ++i;
        }
        return result;
    }

    public long createScalarDataSpace() {
        return H5.H5Screate(HDF5Constants.H5S_SCALAR);
    }

    public long createSimpleDataSpace(long[] dimensions, ICleanUpRegistry registry) {
        final long dataSpaceId = H5.H5Screate_simple(dimensions.length, dimensions, null);
        registry.registerCleanUp(new Runnable(){

            @Override
            public void run() {
                H5.H5Sclose(dataSpaceId);
            }
        });
        return dataSpaceId;
    }

    public void setHyperslabBlock(long dataSpaceId, long[] start, long[] count) {
        assert (dataSpaceId >= 0L);
        assert (start != null);
        assert (count != null);
        H5.H5Sselect_hyperslab(dataSpaceId, HDF5Constants.H5S_SELECT_SET, start, null, count, null);
    }

    private long createLinkCreationPropertyList(boolean createIntermediateGroups, ICleanUpRegistry registry) {
        final long linkCreationPropertyList = H5.H5Pcreate(HDF5Constants.H5P_LINK_CREATE);
        registry.registerCleanUp(new Runnable(){

            @Override
            public void run() {
                H5.H5Pclose(linkCreationPropertyList);
            }
        });
        if (createIntermediateGroups) {
            H5.H5Pset_create_intermediate_group(linkCreationPropertyList, true);
        }
        if (this.useUTF8CharEncoding) {
            this.setCharacterEncodingCreationPropertyList(linkCreationPropertyList, CharacterEncoding.UTF8);
        }
        return linkCreationPropertyList;
    }

    private void setCharacterEncodingCreationPropertyList(long creationPropertyList, CharacterEncoding encoding) {
        H5.H5Pset_char_encoding(creationPropertyList, encoding.getCValue());
    }

    private long createDataSetXferPropertyListAbortOverflow(ICleanUpRegistry registry) {
        final long datasetXferPropertyList = HDFHelper.H5Pcreate_xfer_abort_overflow();
        registry.registerCleanUp(new Runnable(){

            @Override
            public void run() {
                H5.H5Pclose(datasetXferPropertyList);
            }
        });
        return datasetXferPropertyList;
    }

    private long createDataSetXferPropertyListAbort(ICleanUpRegistry registry) {
        final long datasetXferPropertyList = HDFHelper.H5Pcreate_xfer_abort();
        registry.registerCleanUp(new Runnable(){

            @Override
            public void run() {
                H5.H5Pclose(datasetXferPropertyList);
            }
        });
        return datasetXferPropertyList;
    }

    String getReferencedObjectName(long objectId, byte[] reference) {
        String[] objectName = new String[1];
        H5.H5Rget_name(objectId, HDF5Constants.H5R_OBJECT, reference, objectName, 128L);
        return objectName[0];
    }

    String getReferencedObjectName(long objectId, long reference) {
        String[] objectName = new String[1];
        H5.H5Rget_name(objectId, HDF5Constants.H5R_OBJECT, HDFHelper.longToByte(new long[]{reference}), objectName, 128L);
        return objectName[0];
    }

    String[] getReferencedObjectNames(long objectId, long[] reference) {
        String[] objectNames = new String[reference.length];
        int i = 0;
        while (i < reference.length) {
            objectNames[i] = this.getReferencedObjectName(objectId, reference[i]);
            ++i;
        }
        return objectNames;
    }

    String getReferencedObjectName(long objectId, byte[] references, int ofs) {
        byte[] reference = new byte[8];
        System.arraycopy(references, ofs, reference, 0, 8);
        return this.getReferencedObjectName(objectId, reference);
    }

    byte[] createObjectReference(long fileId, String objectPath) {
        return H5.H5Rcreate(fileId, objectPath, HDF5Constants.H5R_OBJECT, -1L);
    }

    long[] createObjectReferences(long fileId, String[] objectPaths) {
        long[] references = new long[objectPaths.length];
        int i = 0;
        while (i < objectPaths.length) {
            references[i] = HDFNativeData.byteToLong(this.createObjectReference(fileId, objectPaths[i]), 0);
            ++i;
        }
        return references;
    }

    private static enum EnumSize {
        BYTE8,
        SHORT16,
        INT32;

    }
}

