/*
 * Decompiled with CFR 0.152.
 */
package com.drew.imaging;

import com.drew.imaging.FileType;
import com.drew.imaging.FileTypeDetector;
import com.drew.imaging.ImageProcessingException;
import com.drew.imaging.avi.AviMetadataReader;
import com.drew.imaging.bmp.BmpMetadataReader;
import com.drew.imaging.eps.EpsMetadataReader;
import com.drew.imaging.gif.GifMetadataReader;
import com.drew.imaging.heif.HeifMetadataReader;
import com.drew.imaging.ico.IcoMetadataReader;
import com.drew.imaging.jpeg.JpegMetadataReader;
import com.drew.imaging.mp3.Mp3MetadataReader;
import com.drew.imaging.mp4.Mp4MetadataReader;
import com.drew.imaging.pcx.PcxMetadataReader;
import com.drew.imaging.png.PngMetadataReader;
import com.drew.imaging.psd.PsdMetadataReader;
import com.drew.imaging.quicktime.QuickTimeMetadataReader;
import com.drew.imaging.raf.RafMetadataReader;
import com.drew.imaging.tiff.TiffMetadataReader;
import com.drew.imaging.wav.WavMetadataReader;
import com.drew.imaging.webp.WebpMetadataReader;
import com.drew.lang.RandomAccessStreamReader;
import com.drew.lang.StringUtil;
import com.drew.lang.annotations.NotNull;
import com.drew.metadata.Directory;
import com.drew.metadata.Metadata;
import com.drew.metadata.Tag;
import com.drew.metadata.exif.ExifIFD0Directory;
import com.drew.metadata.file.FileSystemMetadataReader;
import com.drew.metadata.file.FileTypeDirectory;
import com.drew.metadata.xmp.XmpDirectory;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;

public class ImageMetadataReader {
    @NotNull
    public static Metadata readMetadata(@NotNull InputStream inputStream2) throws ImageProcessingException, IOException {
        return ImageMetadataReader.readMetadata(inputStream2, -1L);
    }

    @NotNull
    public static Metadata readMetadata(@NotNull InputStream inputStream2, long streamLength) throws ImageProcessingException, IOException {
        BufferedInputStream bufferedInputStream = inputStream2 instanceof BufferedInputStream ? (BufferedInputStream)inputStream2 : new BufferedInputStream(inputStream2);
        FileType fileType = FileTypeDetector.detectFileType(bufferedInputStream);
        Metadata metadata = ImageMetadataReader.readMetadata(bufferedInputStream, streamLength, fileType);
        metadata.addDirectory(new FileTypeDirectory(fileType));
        return metadata;
    }

    @NotNull
    public static Metadata readMetadata(@NotNull InputStream inputStream2, long streamLength, FileType fileType) throws IOException, ImageProcessingException {
        switch (fileType) {
            case Jpeg: {
                return JpegMetadataReader.readMetadata(inputStream2);
            }
            case Tiff: 
            case Arw: 
            case Cr2: 
            case Nef: 
            case Orf: 
            case Rw2: {
                return TiffMetadataReader.readMetadata(new RandomAccessStreamReader(inputStream2, 2048, streamLength));
            }
            case Psd: {
                return PsdMetadataReader.readMetadata(inputStream2);
            }
            case Png: {
                return PngMetadataReader.readMetadata(inputStream2);
            }
            case Bmp: {
                return BmpMetadataReader.readMetadata(inputStream2);
            }
            case Gif: {
                return GifMetadataReader.readMetadata(inputStream2);
            }
            case Ico: {
                return IcoMetadataReader.readMetadata(inputStream2);
            }
            case Pcx: {
                return PcxMetadataReader.readMetadata(inputStream2);
            }
            case WebP: {
                return WebpMetadataReader.readMetadata(inputStream2);
            }
            case Raf: {
                return RafMetadataReader.readMetadata(inputStream2);
            }
            case Avi: {
                return AviMetadataReader.readMetadata(inputStream2);
            }
            case Wav: {
                return WavMetadataReader.readMetadata(inputStream2);
            }
            case QuickTime: {
                return QuickTimeMetadataReader.readMetadata(inputStream2);
            }
            case Mp4: {
                return Mp4MetadataReader.readMetadata(inputStream2);
            }
            case Mp3: {
                return Mp3MetadataReader.readMetadata(inputStream2);
            }
            case Eps: {
                return EpsMetadataReader.readMetadata(inputStream2);
            }
            case Heif: {
                return HeifMetadataReader.readMetadata(inputStream2);
            }
            case Unknown: {
                throw new ImageProcessingException("File format could not be determined");
            }
        }
        return new Metadata();
    }

    @NotNull
    public static Metadata readMetadata(@NotNull File file2) throws ImageProcessingException, IOException {
        Metadata metadata;
        FileInputStream inputStream2 = new FileInputStream(file2);
        try {
            metadata = ImageMetadataReader.readMetadata(inputStream2, file2.length());
        }
        finally {
            ((InputStream)inputStream2).close();
        }
        new FileSystemMetadataReader().read(file2, metadata);
        return metadata;
    }

    private ImageMetadataReader() throws Exception {
        throw new Exception("Not intended for instantiation");
    }

    public static void main(@NotNull String[] args2) {
        ArrayList<String> argList = new ArrayList<String>(Arrays.asList(args2));
        boolean markdownFormat = argList.remove("-markdown");
        boolean showHex = argList.remove("-hex");
        if (argList.size() < 1) {
            String version = ImageMetadataReader.class.getPackage().getImplementationVersion();
            System.out.println("metadata-extractor version " + version);
            System.out.println();
            System.out.println(String.format("Usage: java -jar metadata-extractor-%s.jar <filename> [<filename>] [-thumb] [-markdown] [-hex]", version == null ? "a.b.c" : version));
            System.exit(1);
        }
        for (String filePath : argList) {
            long startTime = System.nanoTime();
            File file2 = new File(filePath);
            if (!markdownFormat && argList.size() > 1) {
                System.out.printf("%n***** PROCESSING: %s%n%n", filePath);
            }
            Metadata metadata = null;
            try {
                metadata = ImageMetadataReader.readMetadata(file2);
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
                System.exit(1);
            }
            long took = System.nanoTime() - startTime;
            if (!markdownFormat) {
                System.out.printf("Processed %.3f MB file in %.2f ms%n%n", (double)file2.length() / 1048576.0, (double)took / 1000000.0);
            }
            if (markdownFormat) {
                String fileName = file2.getName();
                String urlName = StringUtil.urlEncode(filePath);
                ExifIFD0Directory exifIFD0Directory = metadata.getFirstDirectoryOfType(ExifIFD0Directory.class);
                String make = exifIFD0Directory == null ? "" : exifIFD0Directory.getString(271);
                String string = exifIFD0Directory == null ? "" : exifIFD0Directory.getString(272);
                System.out.println();
                System.out.println("---");
                System.out.println();
                System.out.printf("# %s - %s%n", make, string);
                System.out.println();
                System.out.printf("<a href=\"https://raw.githubusercontent.com/drewnoakes/metadata-extractor-images/master/%s\">%n", urlName);
                System.out.printf("<img src=\"https://raw.githubusercontent.com/drewnoakes/metadata-extractor-images/master/%s\" width=\"300\"/><br/>%n", urlName);
                System.out.println(fileName);
                System.out.println("</a>");
                System.out.println();
                System.out.println("Directory | Tag Id | Tag Name | Extracted Value");
                System.out.println(":--------:|-------:|----------|----------------");
            }
            for (Directory directory : metadata.getDirectories()) {
                String directoryName = directory.getName();
                for (Tag tag : directory.getTags()) {
                    String tagName = tag.getTagName();
                    String description = tag.getDescription();
                    if (description != null && description.length() > 1024) {
                        description = description.substring(0, 1024) + "...";
                    }
                    if (markdownFormat) {
                        System.out.printf("%s|0x%s|%s|%s%n", directoryName, Integer.toHexString(tag.getTagType()), tagName, description);
                        continue;
                    }
                    if (showHex) {
                        System.out.printf("[%s - %s] %s = %s%n", directoryName, tag.getTagTypeHex(), tagName, description);
                        continue;
                    }
                    System.out.printf("[%s] %s = %s%n", directoryName, tagName, description);
                }
                if (directory instanceof XmpDirectory) {
                    Map<String, String> xmpProperties = ((XmpDirectory)directory).getXmpProperties();
                    for (Map.Entry<String, String> property : xmpProperties.entrySet()) {
                        String key = property.getKey();
                        String value = property.getValue();
                        if (value != null && value.length() > 1024) {
                            value = value.substring(0, 1024) + "...";
                        }
                        if (markdownFormat) {
                            System.out.printf("%s||%s|%s%n", directoryName, key, value);
                            continue;
                        }
                        System.out.printf("[%s] %s = %s%n", directoryName, key, value);
                    }
                }
                for (String string : directory.getErrors()) {
                    System.err.println("ERROR: " + string);
                }
            }
        }
    }
}

