/*
 * Decompiled with CFR 0.152.
 */
package com.drew.metadata.exif;

import com.drew.lang.GeoLocation;
import com.drew.lang.Rational;
import com.drew.lang.annotations.NotNull;
import com.drew.lang.annotations.Nullable;
import com.drew.metadata.TagDescriptor;
import com.drew.metadata.exif.GpsDirectory;
import java.text.DecimalFormat;

public class GpsDescriptor
extends TagDescriptor<GpsDirectory> {
    public GpsDescriptor(@NotNull GpsDirectory directory) {
        super(directory);
    }

    @Override
    @Nullable
    public String getDescription(int tagType) {
        switch (tagType) {
            case 0: {
                return this.getGpsVersionIdDescription();
            }
            case 6: {
                return this.getGpsAltitudeDescription();
            }
            case 5: {
                return this.getGpsAltitudeRefDescription();
            }
            case 9: {
                return this.getGpsStatusDescription();
            }
            case 10: {
                return this.getGpsMeasureModeDescription();
            }
            case 11: {
                return this.getGpsDopDescription();
            }
            case 12: {
                return this.getGpsSpeedRefDescription();
            }
            case 13: {
                return this.getGpsSpeedDescription();
            }
            case 14: 
            case 16: 
            case 23: {
                return this.getGpsDirectionReferenceDescription(tagType);
            }
            case 15: 
            case 17: 
            case 24: {
                return this.getGpsDirectionDescription(tagType);
            }
            case 20: {
                return this.getGpsDestLatitudeDescription();
            }
            case 22: {
                return this.getGpsDestLongitudeDescription();
            }
            case 25: {
                return this.getGpsDestinationReferenceDescription();
            }
            case 26: {
                return this.getGpsDestDistanceDescription();
            }
            case 7: {
                return this.getGpsTimeStampDescription();
            }
            case 4: {
                return this.getGpsLongitudeDescription();
            }
            case 2: {
                return this.getGpsLatitudeDescription();
            }
            case 27: {
                return this.getGpsProcessingMethodDescription();
            }
            case 28: {
                return this.getGpsAreaInformationDescription();
            }
            case 30: {
                return this.getGpsDifferentialDescription();
            }
            case 31: {
                return this.getGpsHPositioningErrorDescription();
            }
        }
        return super.getDescription(tagType);
    }

    @Nullable
    private String getGpsVersionIdDescription() {
        return this.getVersionBytesDescription(0, 1);
    }

    @Nullable
    public String getGpsLatitudeDescription() {
        GeoLocation location = ((GpsDirectory)this._directory).getGeoLocation();
        return location == null ? null : GeoLocation.decimalToDegreesMinutesSecondsString(location.getLatitude());
    }

    @Nullable
    public String getGpsLongitudeDescription() {
        GeoLocation location = ((GpsDirectory)this._directory).getGeoLocation();
        return location == null ? null : GeoLocation.decimalToDegreesMinutesSecondsString(location.getLongitude());
    }

    @Nullable
    public String getGpsTimeStampDescription() {
        Rational[] timeComponents = ((GpsDirectory)this._directory).getRationalArray(7);
        DecimalFormat df = new DecimalFormat("00.000");
        return timeComponents == null ? null : String.format("%02d:%02d:%s UTC", timeComponents[0].intValue(), timeComponents[1].intValue(), df.format(timeComponents[2].doubleValue()));
    }

    @Nullable
    public String getGpsDestLatitudeDescription() {
        return this.getGeoLocationDimension(20, 19, "S");
    }

    @Nullable
    public String getGpsDestLongitudeDescription() {
        return this.getGeoLocationDimension(22, 21, "W");
    }

    @Nullable
    private String getGeoLocationDimension(int tagValue, int tagRef, String positiveRef) {
        Rational[] values2 = ((GpsDirectory)this._directory).getRationalArray(tagValue);
        String ref = ((GpsDirectory)this._directory).getString(tagRef);
        if (values2 == null || values2.length != 3 || ref == null) {
            return null;
        }
        Double dec = GeoLocation.degreesMinutesSecondsToDecimal(values2[0], values2[1], values2[2], ref.equalsIgnoreCase(positiveRef));
        return dec == null ? null : GeoLocation.decimalToDegreesMinutesSecondsString(dec);
    }

    @Nullable
    public String getGpsDestinationReferenceDescription() {
        String value = ((GpsDirectory)this._directory).getString(25);
        if (value == null) {
            return null;
        }
        String distanceRef = value.trim();
        if ("K".equalsIgnoreCase(distanceRef)) {
            return "kilometers";
        }
        if ("M".equalsIgnoreCase(distanceRef)) {
            return "miles";
        }
        if ("N".equalsIgnoreCase(distanceRef)) {
            return "knots";
        }
        return "Unknown (" + distanceRef + ")";
    }

    @Nullable
    public String getGpsDestDistanceDescription() {
        Rational value = ((GpsDirectory)this._directory).getRational(26);
        if (value == null) {
            return null;
        }
        String unit = this.getGpsDestinationReferenceDescription();
        return String.format("%s %s", new DecimalFormat("0.##").format(value.doubleValue()), unit == null ? "unit" : unit.toLowerCase());
    }

    @Nullable
    public String getGpsDirectionDescription(int tagType) {
        Rational angle = ((GpsDirectory)this._directory).getRational(tagType);
        String value = angle != null ? new DecimalFormat("0.##").format(angle.doubleValue()) : ((GpsDirectory)this._directory).getString(tagType);
        return value == null || value.trim().length() == 0 ? null : value.trim() + " degrees";
    }

    @Nullable
    public String getGpsDirectionReferenceDescription(int tagType) {
        String value = ((GpsDirectory)this._directory).getString(tagType);
        if (value == null) {
            return null;
        }
        String gpsDistRef = value.trim();
        if ("T".equalsIgnoreCase(gpsDistRef)) {
            return "True direction";
        }
        if ("M".equalsIgnoreCase(gpsDistRef)) {
            return "Magnetic direction";
        }
        return "Unknown (" + gpsDistRef + ")";
    }

    @Nullable
    public String getGpsDopDescription() {
        Rational value = ((GpsDirectory)this._directory).getRational(11);
        return value == null ? null : new DecimalFormat("0.##").format(value.doubleValue());
    }

    @Nullable
    public String getGpsSpeedRefDescription() {
        String value = ((GpsDirectory)this._directory).getString(12);
        if (value == null) {
            return null;
        }
        String gpsSpeedRef = value.trim();
        if ("K".equalsIgnoreCase(gpsSpeedRef)) {
            return "km/h";
        }
        if ("M".equalsIgnoreCase(gpsSpeedRef)) {
            return "mph";
        }
        if ("N".equalsIgnoreCase(gpsSpeedRef)) {
            return "knots";
        }
        return "Unknown (" + gpsSpeedRef + ")";
    }

    @Nullable
    public String getGpsSpeedDescription() {
        Rational value = ((GpsDirectory)this._directory).getRational(13);
        if (value == null) {
            return null;
        }
        String unit = this.getGpsSpeedRefDescription();
        return String.format("%s %s", new DecimalFormat("0.##").format(value.doubleValue()), unit == null ? "unit" : unit.toLowerCase());
    }

    @Nullable
    public String getGpsMeasureModeDescription() {
        String value = ((GpsDirectory)this._directory).getString(10);
        if (value == null) {
            return null;
        }
        String gpsSpeedMeasureMode = value.trim();
        if ("2".equalsIgnoreCase(gpsSpeedMeasureMode)) {
            return "2-dimensional measurement";
        }
        if ("3".equalsIgnoreCase(gpsSpeedMeasureMode)) {
            return "3-dimensional measurement";
        }
        return "Unknown (" + gpsSpeedMeasureMode + ")";
    }

    @Nullable
    public String getGpsStatusDescription() {
        String value = ((GpsDirectory)this._directory).getString(9);
        if (value == null) {
            return null;
        }
        String gpsStatus = value.trim();
        if ("A".equalsIgnoreCase(gpsStatus)) {
            return "Active (Measurement in progress)";
        }
        if ("V".equalsIgnoreCase(gpsStatus)) {
            return "Void (Measurement Interoperability)";
        }
        return "Unknown (" + gpsStatus + ")";
    }

    @Nullable
    public String getGpsAltitudeRefDescription() {
        return this.getIndexedDescription(5, "Sea level", "Below sea level");
    }

    @Nullable
    public String getGpsAltitudeDescription() {
        Rational value = ((GpsDirectory)this._directory).getRational(6);
        return value == null ? null : new DecimalFormat("0.##").format(value.doubleValue()) + " metres";
    }

    @Nullable
    public String getGpsProcessingMethodDescription() {
        return this.getEncodedTextDescription(27);
    }

    @Nullable
    public String getGpsAreaInformationDescription() {
        return this.getEncodedTextDescription(28);
    }

    @Nullable
    public String getGpsDifferentialDescription() {
        return this.getIndexedDescription(30, "No Correction", "Differential Corrected");
    }

    @Nullable
    public String getGpsHPositioningErrorDescription() {
        Rational value = ((GpsDirectory)this._directory).getRational(31);
        return value == null ? null : new DecimalFormat("0.##").format(value.doubleValue()) + " metres";
    }

    @Nullable
    public String getDegreesMinutesSecondsDescription() {
        GeoLocation location = ((GpsDirectory)this._directory).getGeoLocation();
        return location == null ? null : location.toDMSString();
    }
}

