/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.util;

import com.google.api.client.util.ByteCountingOutputStream;
import com.google.api.client.util.ByteStreams;
import com.google.api.client.util.StreamingContent;
import com.google.api.client.util.Throwables;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IOUtils {
    public static void copy(InputStream inputStream2, OutputStream outputStream2) throws IOException {
        IOUtils.copy(inputStream2, outputStream2, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(InputStream inputStream2, OutputStream outputStream2, boolean closeInputStream) throws IOException {
        try {
            ByteStreams.copy(inputStream2, outputStream2);
        }
        finally {
            if (closeInputStream) {
                inputStream2.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long computeLength(StreamingContent content) throws IOException {
        ByteCountingOutputStream countingStream = new ByteCountingOutputStream();
        try {
            content.writeTo(countingStream);
        }
        finally {
            countingStream.close();
        }
        return countingStream.count;
    }

    public static byte[] serialize(Object value) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        IOUtils.serialize(value, out);
        return out.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void serialize(Object value, OutputStream outputStream2) throws IOException {
        try {
            new ObjectOutputStream(outputStream2).writeObject(value);
        }
        finally {
            outputStream2.close();
        }
    }

    public static <S extends Serializable> S deserialize(byte[] bytes) throws IOException {
        if (bytes == null) {
            return null;
        }
        return IOUtils.deserialize(new ByteArrayInputStream(bytes));
    }

    public static <S extends Serializable> S deserialize(InputStream inputStream2) throws IOException {
        try {
            Serializable serializable = (Serializable)new ObjectInputStream(inputStream2).readObject();
            return (S)serializable;
        }
        catch (ClassNotFoundException exception) {
            IOException ioe = new IOException("Failed to deserialize object");
            ioe.initCause(exception);
            throw ioe;
        }
        finally {
            inputStream2.close();
        }
    }

    public static boolean isSymbolicLink(File file2) throws IOException {
        try {
            Class<?> filesClass = Class.forName("java.nio.file.Files");
            Class<?> pathClass = Class.forName("java.nio.file.Path");
            Object path = File.class.getMethod("toPath", new Class[0]).invoke((Object)file2, new Object[0]);
            return (Boolean)filesClass.getMethod("isSymbolicLink", pathClass).invoke(null, path);
        }
        catch (InvocationTargetException exception) {
            Throwable cause = exception.getCause();
            Throwables.propagateIfPossible(cause, IOException.class);
            throw new RuntimeException(cause);
        }
        catch (ClassNotFoundException exception) {
        }
        catch (IllegalArgumentException exception) {
        }
        catch (SecurityException exception) {
        }
        catch (IllegalAccessException exception) {
        }
        catch (NoSuchMethodException exception) {
            // empty catch block
        }
        if (File.separatorChar == '\\') {
            return false;
        }
        File canonical = file2;
        if (file2.getParent() != null) {
            canonical = new File(file2.getParentFile().getCanonicalFile(), file2.getName());
        }
        return !canonical.getCanonicalFile().equals(canonical.getAbsoluteFile());
    }
}

