/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.imageio.stream;

import com.sun.media.imageio.stream.FileChannelImageInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.CharBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;
import java.nio.channels.FileChannel;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.ImageOutputStreamImpl;

public class FileChannelImageOutputStream
extends ImageOutputStreamImpl {
    private static final int DEFAULT_WRITE_BUFFER_SIZE = 0x100000;
    private FileChannel channel;
    private ByteBuffer byteBuffer;
    private ImageInputStream readStream = null;

    public FileChannelImageOutputStream(FileChannel channel) throws IOException {
        if (channel == null) {
            throw new IllegalArgumentException("channel == null");
        }
        if (!channel.isOpen()) {
            throw new IllegalArgumentException("channel.isOpen() == false");
        }
        this.channel = channel;
        this.streamPos = this.flushedPos = channel.position();
        this.byteBuffer = ByteBuffer.allocateDirect(0x100000);
        this.readStream = new FileChannelImageInputStream(channel);
    }

    private ImageInputStream getImageInputStream() throws IOException {
        this.flushBuffer();
        this.readStream.setByteOrder(this.byteOrder);
        this.readStream.seek(this.streamPos);
        this.readStream.flushBefore(this.flushedPos);
        this.readStream.setBitOffset(this.bitOffset);
        return this.readStream;
    }

    private void flushBuffer() throws IOException {
        if (this.byteBuffer.position() != 0) {
            this.byteBuffer.limit(this.byteBuffer.position());
            this.byteBuffer.position(0);
            this.channel.write(this.byteBuffer);
            this.byteBuffer.clear();
        }
    }

    @Override
    public int read() throws IOException {
        this.checkClosed();
        this.bitOffset = 0;
        ImageInputStream inputStream2 = this.getImageInputStream();
        ++this.streamPos;
        return inputStream2.read();
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (off < 0 || len < 0 || off + len > b.length) {
            throw new IndexOutOfBoundsException("off < 0 || len < 0 || off + len > b.length");
        }
        if (len == 0) {
            return 0;
        }
        this.checkClosed();
        this.bitOffset = 0;
        ImageInputStream inputStream2 = this.getImageInputStream();
        int numBytesRead = inputStream2.read(b, off, len);
        this.streamPos += (long)numBytesRead;
        return numBytesRead;
    }

    @Override
    public void write(int b) throws IOException {
        this.write(new byte[]{(byte)(b & 0xFF)}, 0, 1);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (off < 0 || len < 0 || off + len > b.length) {
            throw new IndexOutOfBoundsException("off < 0 || len < 0 || off + len > b.length");
        }
        if (len == 0) {
            return;
        }
        this.flushBits();
        int numPut = 0;
        do {
            int numToPut;
            if ((numToPut = Math.min(len - numPut, this.byteBuffer.remaining())) == 0) {
                this.flushBuffer();
                continue;
            }
            this.byteBuffer.put(b, off + numPut, numToPut);
            numPut += numToPut;
        } while (numPut < len);
        this.streamPos += (long)len;
    }

    @Override
    public void readFully(char[] c, int off, int len) throws IOException {
        this.getImageInputStream().readFully(c, off, len);
        this.streamPos += (long)(2 * len);
    }

    @Override
    public void readFully(short[] s2, int off, int len) throws IOException {
        this.getImageInputStream().readFully(s2, off, len);
        this.streamPos += (long)(2 * len);
    }

    @Override
    public void readFully(int[] i, int off, int len) throws IOException {
        this.getImageInputStream().readFully(i, off, len);
        this.streamPos += (long)(4 * len);
    }

    @Override
    public void readFully(long[] l, int off, int len) throws IOException {
        this.getImageInputStream().readFully(l, off, len);
        this.streamPos += (long)(8 * len);
    }

    @Override
    public void readFully(float[] f, int off, int len) throws IOException {
        this.getImageInputStream().readFully(f, off, len);
        this.streamPos += (long)(4 * len);
    }

    @Override
    public void readFully(double[] d, int off, int len) throws IOException {
        this.getImageInputStream().readFully(d, off, len);
        this.streamPos += (long)(8 * len);
    }

    @Override
    public void writeChars(char[] c, int off, int len) throws IOException {
        if (off < 0 || len < 0 || off + len > c.length) {
            throw new IndexOutOfBoundsException("off < 0 || len < 0 || off + len > c.length");
        }
        if (len == 0) {
            return;
        }
        this.flushBits();
        int numPut = 0;
        CharBuffer viewBuffer = this.byteBuffer.asCharBuffer();
        do {
            int numToPut;
            if ((numToPut = Math.min(len - numPut, viewBuffer.remaining())) == 0) {
                this.flushBuffer();
                continue;
            }
            viewBuffer.put(c, off + numPut, numToPut);
            this.byteBuffer.position(this.byteBuffer.position() + 2 * numToPut);
            numPut += numToPut;
        } while (numPut < len);
        this.streamPos += (long)(2 * len);
    }

    @Override
    public void writeShorts(short[] s2, int off, int len) throws IOException {
        if (off < 0 || len < 0 || off + len > s2.length) {
            throw new IndexOutOfBoundsException("off < 0 || len < 0 || off + len > c.length");
        }
        if (len == 0) {
            return;
        }
        this.flushBits();
        int numPut = 0;
        ShortBuffer viewBuffer = this.byteBuffer.asShortBuffer();
        do {
            int numToPut;
            if ((numToPut = Math.min(len - numPut, viewBuffer.remaining())) == 0) {
                this.flushBuffer();
                continue;
            }
            viewBuffer.put(s2, off + numPut, numToPut);
            this.byteBuffer.position(this.byteBuffer.position() + 2 * numToPut);
            numPut += numToPut;
        } while (numPut < len);
        this.streamPos += (long)(2 * len);
    }

    @Override
    public void writeInts(int[] i, int off, int len) throws IOException {
        if (off < 0 || len < 0 || off + len > i.length) {
            throw new IndexOutOfBoundsException("off < 0 || len < 0 || off + len > c.length");
        }
        if (len == 0) {
            return;
        }
        this.flushBits();
        int numPut = 0;
        IntBuffer viewBuffer = this.byteBuffer.asIntBuffer();
        do {
            int numToPut;
            if ((numToPut = Math.min(len - numPut, viewBuffer.remaining())) == 0) {
                this.flushBuffer();
                continue;
            }
            viewBuffer.put(i, off + numPut, numToPut);
            this.byteBuffer.position(this.byteBuffer.position() + 4 * numToPut);
            numPut += numToPut;
        } while (numPut < len);
        this.streamPos += (long)(4 * len);
    }

    @Override
    public void writeLongs(long[] l, int off, int len) throws IOException {
        if (off < 0 || len < 0 || off + len > l.length) {
            throw new IndexOutOfBoundsException("off < 0 || len < 0 || off + len > c.length");
        }
        if (len == 0) {
            return;
        }
        this.flushBits();
        int numPut = 0;
        LongBuffer viewBuffer = this.byteBuffer.asLongBuffer();
        do {
            int numToPut;
            if ((numToPut = Math.min(len - numPut, viewBuffer.remaining())) == 0) {
                this.flushBuffer();
                continue;
            }
            viewBuffer.put(l, off + numPut, numToPut);
            this.byteBuffer.position(this.byteBuffer.position() + 8 * numToPut);
            numPut += numToPut;
        } while (numPut < len);
        this.streamPos += (long)(8 * len);
    }

    @Override
    public void writeFloats(float[] f, int off, int len) throws IOException {
        if (off < 0 || len < 0 || off + len > f.length) {
            throw new IndexOutOfBoundsException("off < 0 || len < 0 || off + len > f.length");
        }
        if (len == 0) {
            return;
        }
        this.flushBits();
        int numPut = 0;
        FloatBuffer viewBuffer = this.byteBuffer.asFloatBuffer();
        do {
            int numToPut;
            if ((numToPut = Math.min(len - numPut, viewBuffer.remaining())) == 0) {
                this.flushBuffer();
                continue;
            }
            viewBuffer.put(f, off + numPut, numToPut);
            this.byteBuffer.position(this.byteBuffer.position() + 4 * numToPut);
            numPut += numToPut;
        } while (numPut < len);
        this.streamPos += (long)(4 * len);
    }

    @Override
    public void writeDoubles(double[] d, int off, int len) throws IOException {
        if (off < 0 || len < 0 || off + len > d.length) {
            throw new IndexOutOfBoundsException("off < 0 || len < 0 || off + len > d.length");
        }
        if (len == 0) {
            return;
        }
        this.flushBits();
        int numPut = 0;
        DoubleBuffer viewBuffer = this.byteBuffer.asDoubleBuffer();
        do {
            int numToPut;
            if ((numToPut = Math.min(len - numPut, viewBuffer.remaining())) == 0) {
                this.flushBuffer();
                continue;
            }
            viewBuffer.put(d, off + numPut, numToPut);
            this.byteBuffer.position(this.byteBuffer.position() + 8 * numToPut);
            numPut += numToPut;
        } while (numPut < len);
        this.streamPos += (long)(8 * len);
    }

    @Override
    public void close() throws IOException {
        this.flushBuffer();
        this.readStream.close();
        this.readStream = null;
        this.channel = null;
        this.byteBuffer = null;
        super.close();
    }

    @Override
    public long length() {
        long length = -1L;
        try {
            length = this.channel.size();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return length;
    }

    @Override
    public void seek(long pos) throws IOException {
        super.seek(pos);
        this.flushBuffer();
        this.channel.position(pos);
    }

    @Override
    public void setByteOrder(ByteOrder networkByteOrder) {
        super.setByteOrder(networkByteOrder);
        this.byteBuffer.order(networkByteOrder);
    }
}

