/*
 * Decompiled with CFR 0.152.
 */
package ij.gui;

import ij.plugin.Colors;
import ij.util.Java2;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Panel;

class ColorPanel
extends Panel {
    private int width = 150;
    private int height = 50;
    private Font font;
    private Color c;

    ColorPanel(Color c, double scale) {
        this.c = c;
        this.width = (int)((double)this.width * scale);
        this.height = (int)((double)this.height * scale);
        this.font = new Font("Monospaced", 0, (int)(18.0 * scale));
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(this.width, this.height);
    }

    void setColor(Color c) {
        this.c = c;
    }

    @Override
    public Dimension getMinimumSize() {
        return new Dimension(this.width, this.height);
    }

    @Override
    public void paint(Graphics g2) {
        g2.setColor(this.c);
        g2.fillRect(0, 0, this.width, this.height);
        int intensity = (this.c.getRed() + this.c.getGreen() + this.c.getBlue()) / 3;
        Color c2 = intensity < 128 ? Color.white : Color.black;
        g2.setColor(c2);
        g2.setFont(this.font);
        Java2.setAntialiasedText(g2, true);
        String s2 = Colors.colorToString(this.c);
        g2.drawString(s2, 5, this.height - 5);
        g2.setColor(Color.black);
        g2.drawRect(0, 0, this.width - 1, this.height - 1);
    }
}

