/*
 * Decompiled with CFR 0.152.
 */
package ij.gui;

import ij.gui.ImageCanvas;
import ij.gui.ScrollbarWithLabel;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Scrollbar;

public class ImageLayout
implements LayoutManager {
    int hgap = 5;
    int vgap = 5;
    ImageCanvas ic;
    boolean ignoreNonImageWidths;

    public ImageLayout(ImageCanvas ic) {
        this.ic = ic;
    }

    @Override
    public void addLayoutComponent(String name, Component comp) {
    }

    @Override
    public void removeLayoutComponent(Component comp) {
    }

    @Override
    public Dimension preferredLayoutSize(Container target) {
        Dimension dim = new Dimension(0, 0);
        int nmembers = target.getComponentCount();
        for (int i = 0; i < nmembers; ++i) {
            Component m4 = target.getComponent(i);
            Dimension d = m4.getPreferredSize();
            if (i == 0 || !this.ignoreNonImageWidths) {
                dim.width = Math.max(dim.width, d.width);
            }
            if (i > 0) {
                dim.height += this.vgap;
            }
            dim.height += d.height;
        }
        Insets insets = target.getInsets();
        dim.width += insets.left + insets.right + this.hgap * 2;
        dim.height += insets.top + insets.bottom + this.vgap * 2;
        return dim;
    }

    @Override
    public Dimension minimumLayoutSize(Container target) {
        return this.preferredLayoutSize(target);
    }

    public void ignoreNonImageWidths(boolean ignoreNonImageWidths) {
        this.ignoreNonImageWidths = ignoreNonImageWidths;
    }

    private void moveComponents(Container target, int x, int y, int width, int height, int nmembers) {
        int x2 = 0;
        y += height / 2;
        for (int i = 0; i < nmembers; ++i) {
            Component m4 = target.getComponent(i);
            Dimension d = m4.getSize();
            if (i == 0 || d.height > 60) {
                x2 = x + (width - d.width) / 2;
            }
            m4.setLocation(x2, y);
            y += this.vgap + d.height;
        }
    }

    @Override
    public void layoutContainer(Container target) {
        Dimension d;
        Insets insets = target.getInsets();
        int nmembers = target.getComponentCount();
        int extraHeight = 0;
        for (int i = 1; i < nmembers; ++i) {
            Component m4 = target.getComponent(i);
            d = m4.getPreferredSize();
            extraHeight += d.height + this.vgap;
        }
        d = target.getSize();
        int preferredImageWidth = d.width - (insets.left + insets.right + this.hgap * 2);
        int preferredImageHeight = d.height - (insets.top + insets.bottom + this.vgap * 2 + extraHeight);
        this.ic.resizeCanvas(preferredImageWidth, preferredImageHeight);
        int maxwidth = d.width - (insets.left + insets.right + this.hgap * 2);
        int maxheight = d.height - (insets.top + insets.bottom + this.vgap * 2);
        Dimension psize = this.preferredLayoutSize(target);
        int x = insets.left + this.hgap + (d.width - psize.width) / 2;
        int y = 0;
        int colw = 0;
        for (int i = 0; i < nmembers; ++i) {
            Component m5 = target.getComponent(i);
            d = m5.getPreferredSize();
            if (m5 instanceof ScrollbarWithLabel || m5 instanceof Scrollbar) {
                int scrollbarWidth = target.getComponent((int)0).getPreferredSize().width;
                Dimension minSize = m5.getMinimumSize();
                if (scrollbarWidth < minSize.width) {
                    scrollbarWidth = minSize.width;
                }
                m5.setSize(scrollbarWidth, d.height);
            } else {
                m5.setSize(d.width, d.height);
            }
            if (y > 0) {
                y += this.vgap;
            }
            y += d.height;
            if (i != 0 && this.ignoreNonImageWidths) continue;
            colw = Math.max(colw, d.width);
        }
        this.moveComponents(target, x, insets.top + this.vgap, colw, maxheight - y, nmembers);
    }
}

