/*
 * Decompiled with CFR 0.152.
 */
package ij.gui;

import ij.ImagePlus;
import ij.gui.Roi;
import ij.io.FileSaver;
import ij.process.ColorProcessor;
import ij.process.ImageProcessor;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.DirectColorModel;

public class ImageRoi
extends Roi {
    private Image img;
    private Composite composite;
    private double opacity = 1.0;
    private double angle = 0.0;
    private boolean zeroTransparent;
    private ImageProcessor ip;

    public ImageRoi(int x, int y, BufferedImage bi) {
        super(x, y, bi.getWidth(), bi.getHeight());
        this.img = bi;
        this.setStrokeColor(Color.black);
    }

    public ImageRoi(int x, int y, ImageProcessor ip) {
        super(x, y, ip.getWidth(), ip.getHeight());
        this.img = ip.createImage();
        this.ip = ip;
        this.setStrokeColor(Color.black);
    }

    @Override
    public void draw(Graphics g2) {
        Graphics2D g2d = (Graphics2D)g2;
        double mag = this.getMagnification();
        int sx2 = this.screenX(this.x + this.width);
        int sy2 = this.screenY(this.y + this.height);
        Composite saveComposite = null;
        if (this.composite != null) {
            saveComposite = g2d.getComposite();
            g2d.setComposite(this.composite);
        }
        Image img2 = this.img;
        if (this.angle != 0.0) {
            ImageProcessor ip = new ColorProcessor(this.img);
            ip.setInterpolate(true);
            ((ImageProcessor)ip).setBackgroundValue(0.0);
            ((ImageProcessor)ip).rotate(this.angle);
            if (this.zeroTransparent) {
                ip = this.makeZeroTransparent(ip, true);
            }
            img2 = ((ImageProcessor)ip).createImage();
        }
        g2.drawImage(img2, this.screenX(this.x), this.screenY(this.y), sx2, sy2, 0, 0, this.img.getWidth(null), this.img.getHeight(null), null);
        if (this.composite != null) {
            g2d.setComposite(saveComposite);
        }
        if (this.isActiveOverlayRoi() && !this.overlay) {
            super.draw(g2);
        }
    }

    public void setComposite(Composite composite) {
        this.composite = composite;
    }

    public void setOpacity(double opacity) {
        if (opacity < 0.0) {
            opacity = 0.0;
        }
        if (opacity > 1.0) {
            opacity = 1.0;
        }
        this.opacity = opacity;
        this.composite = opacity != 1.0 ? AlphaComposite.getInstance(3, (float)opacity) : null;
    }

    public byte[] getSerializedImage() {
        ImagePlus imp = new ImagePlus("", this.img);
        return new FileSaver(imp).serialize();
    }

    public double getOpacity() {
        return this.opacity;
    }

    public void rotate(double angle) {
        this.angle += angle;
    }

    public void setAngle(double angle) {
        this.angle = angle;
    }

    public void setZeroTransparent(boolean zeroTransparent) {
        if (this.zeroTransparent != zeroTransparent) {
            this.ip = this.makeZeroTransparent(new ColorProcessor(this.img), zeroTransparent);
            this.img = this.ip.createImage();
        }
        this.zeroTransparent = zeroTransparent;
    }

    public boolean getZeroTransparent() {
        return this.zeroTransparent;
    }

    private ImageProcessor makeZeroTransparent(ImageProcessor ip, boolean transparent) {
        if (transparent) {
            ip.setColorModel(new DirectColorModel(32, 0xFF0000, 65280, 255, -16777216));
            for (int x = 0; x < this.width; ++x) {
                for (int y = 0; y < this.height; ++y) {
                    double v = ip.getPixelValue(x, y);
                    if (v > 1.0) {
                        ip.set(x, y, ip.get(x, y) | 0xFF000000);
                        continue;
                    }
                    ip.set(x, y, ip.get(x, y) & 0xFFFFFF);
                }
            }
        }
        return ip;
    }

    @Override
    public synchronized Object clone() {
        ImageRoi roi2 = (ImageRoi)super.clone();
        ImagePlus imp = new ImagePlus("", this.img);
        roi2.setProcessor(imp.getProcessor());
        roi2.setOpacity(this.getOpacity());
        roi2.zeroTransparent = !this.zeroTransparent;
        roi2.setZeroTransparent(this.zeroTransparent);
        return roi2;
    }

    public ImageProcessor getProcessor() {
        if (this.ip != null) {
            return this.ip;
        }
        this.ip = new ColorProcessor(this.img);
        return this.ip;
    }

    public void setProcessor(ImageProcessor ip) {
        this.img = ip.createImage();
        this.ip = ip;
        this.width = ip.getWidth();
        this.height = ip.getHeight();
    }
}

