/*
 * Decompiled with CFR 0.152.
 */
package ij.gui;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.Prefs;
import ij.WindowManager;
import ij.gui.GenericDialog;
import ij.process.ByteProcessor;
import ij.process.ColorProcessor;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import ij.process.IntProcessor;
import ij.process.ShortProcessor;
import java.util.Properties;
import java.util.Random;

public class NewImage {
    public static final int GRAY8 = 0;
    public static final int GRAY16 = 1;
    public static final int GRAY32 = 2;
    public static final int RGB = 3;
    public static final int FILL_BLACK = 1;
    public static final int FILL_RAMP = 2;
    public static final int FILL_NOISE = 3;
    public static final int FILL_RANDOM = 3;
    public static final int FILL_WHITE = 4;
    public static final int CHECK_AVAILABLE_MEMORY = 8;
    public static final int SIGNED_INT = 16;
    private static final int OLD_FILL_WHITE = 0;
    static final String TYPE = "new.type";
    static final String FILL = "new.fill";
    static final String WIDTH = "new.width";
    static final String HEIGHT = "new.height";
    static final String SLICES = "new.slices";
    private static String name = "Untitled";
    private static int staticWidth = Prefs.getInt("new.width", 512);
    private static int staticHeight = Prefs.getInt("new.height", 512);
    private static int staticSlices = Prefs.getInt("new.slices", 1);
    private static int staticType = Prefs.getInt("new.type", 0);
    private static int staticFillWith = Prefs.getInt("new.fill", 1);
    private static String[] types = new String[]{"8-bit", "16-bit", "32-bit", "RGB"};
    private static String[] fill = new String[]{"White", "Black", "Ramp", "Noise"};
    private int gwidth;
    private int gheight;
    private int gslices;
    private int gtype;
    private int gfill;

    public NewImage() {
        this.openImage();
    }

    static boolean createStack(ImagePlus imp, ImageProcessor ip, int nSlices, int type, int options) {
        int inc;
        boolean signedInt;
        long max;
        int fill = NewImage.getFill(options);
        int width = imp.getWidth();
        int height = imp.getHeight();
        long bytesPerPixel = 1L;
        if (type == 1) {
            bytesPerPixel = 2L;
        } else if (type == 2 || type == 3) {
            bytesPerPixel = 4L;
        }
        long size = (long)width * (long)height * (long)nSlices * bytesPerPixel;
        int sizeThreshold = fill == 3 ? 10 : 250;
        boolean bigStack = size / 0x100000L >= (long)sizeThreshold;
        String size2 = size / 0x100000L + "MB (" + width + "x" + height + "x" + nSlices + ")";
        if ((options & 8) != 0 && (max = IJ.maxMemory()) > 0L) {
            long inUse = IJ.currentMemory();
            long available = max - inUse;
            if (size > available) {
                System.gc();
            }
            if (size > (available = max - (inUse = IJ.currentMemory()))) {
                IJ.error("Insufficient Memory", "There is not enough free memory to allocate a \n" + size2 + " stack.\n \nMemory available: " + available / 0x100000L + "MB\nMemory in use: " + IJ.freeMemory() + "\n \nMore information can be found in the \"Memory\"\nsections of the ImageJ installation notes at\n\"" + "http://imagej.nih.gov/ij" + "/docs/install/\".");
                return false;
            }
        }
        ImageStack stack = imp.createEmptyStack();
        boolean bl = signedInt = (options & 0x10) != 0;
        if (type == 3 && signedInt) {
            stack.setOptions("32-bit int");
        }
        if ((inc = nSlices / 40) < 1) {
            inc = 1;
        }
        if (bigStack) {
            IJ.showStatus("Allocating " + size2 + ". Press 'Esc' to abort.");
        }
        IJ.resetEscape();
        try {
            stack.addSlice(null, ip);
            for (int i = 2; i <= nSlices; ++i) {
                if (i % inc == 0 && bigStack) {
                    IJ.showProgress(i, nSlices);
                }
                Object[] pixels2 = null;
                switch (type) {
                    case 0: {
                        pixels2 = new byte[width * height];
                        if (fill != 3) break;
                        NewImage.fillNoiseByte(new ByteProcessor(width, height, (byte[])pixels2));
                        break;
                    }
                    case 1: {
                        pixels2 = new short[width * height];
                        if (fill != 3) break;
                        NewImage.fillNoiseShort(new ShortProcessor(width, height, (short[])pixels2, null));
                        break;
                    }
                    case 2: {
                        pixels2 = new float[width * height];
                        if (fill != 3) break;
                        NewImage.fillNoiseFloat(new FloatProcessor(width, height, (float[])pixels2, null));
                        break;
                    }
                    case 3: {
                        pixels2 = new int[width * height];
                        if (fill != 3) break;
                        if (signedInt) {
                            NewImage.fillNoiseInt(new IntProcessor(width, height, (int[])pixels2));
                            break;
                        }
                        NewImage.fillNoiseRGB(new ColorProcessor(width, height, (int[])pixels2), false);
                    }
                }
                if (fill == 4 || fill == 2) {
                    System.arraycopy(ip.getPixels(), 0, pixels2, 0, width * height);
                }
                stack.addSlice(null, pixels2);
                if (!IJ.escapePressed()) continue;
                IJ.beep();
                break;
            }
        }
        catch (OutOfMemoryError e) {
            IJ.outOfMemory(imp.getTitle());
            stack.trim();
        }
        IJ.showStatus("");
        if (bigStack) {
            IJ.showProgress(nSlices, nSlices);
        }
        if (stack.size() > 1) {
            imp.setStack(null, stack);
        }
        return true;
    }

    static int getFill(int options) {
        int fill = options & 7;
        if (fill == 0) {
            fill = 4;
        }
        if (fill == 7 || fill == 6 || fill == 5) {
            fill = 1;
        }
        return fill;
    }

    public static ImagePlus createByteImage(String title, int width, int height, int slices, int options) {
        boolean ok;
        int fill = NewImage.getFill(options);
        int size = NewImage.getSize(width, height);
        if (size < 0) {
            return null;
        }
        byte[] pixels = new byte[size];
        ByteProcessor ip = new ByteProcessor(width, height, pixels, null);
        switch (fill) {
            case 4: {
                for (int i = 0; i < width * height; ++i) {
                    pixels[i] = -1;
                }
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                byte[] ramp = new byte[width];
                for (int i = 0; i < width; ++i) {
                    ramp[i] = (byte)((double)i * 256.0 / (double)width);
                }
                for (int y = 0; y < height; ++y) {
                    int offset = y * width;
                    for (int x = 0; x < width; ++x) {
                        pixels[offset++] = ramp[x];
                    }
                }
                break;
            }
            case 3: {
                NewImage.fillNoiseByte(ip);
            }
        }
        ImagePlus imp = new ImagePlus(title, ip);
        if (slices > 1 && !(ok = NewImage.createStack(imp, ip, slices, 0, options))) {
            imp = null;
        }
        return imp;
    }

    private static void fillNoiseByte(ImageProcessor ip) {
        ip.add(127);
        ip.noise(31.0);
    }

    public static ImagePlus createRGBImage(String title, int width, int height, int slices, int options) {
        boolean ok;
        int fill = NewImage.getFill(options);
        int size = NewImage.getSize(width, height);
        if (size < 0) {
            return null;
        }
        int[] pixels = new int[size];
        ColorProcessor ip = new ColorProcessor(width, height, pixels);
        switch (fill) {
            case 4: {
                int i;
                for (i = 0; i < width * height; ++i) {
                    pixels[i] = -1;
                }
                break;
            }
            case 1: {
                int i;
                for (i = 0; i < width * height; ++i) {
                    pixels[i] = -16777216;
                }
                break;
            }
            case 2: {
                int[] ramp = new int[width];
                for (int i = 0; i < width; ++i) {
                    byte b;
                    byte g2 = b = (byte)((double)i * 256.0 / (double)width);
                    byte r = b;
                    ramp[i] = 0xFF000000 | r << 16 & 0xFF0000 | g2 << 8 & 0xFF00 | b & 0xFF;
                }
                for (int y = 0; y < height; ++y) {
                    int offset = y * width;
                    for (int x = 0; x < width; ++x) {
                        pixels[offset++] = ramp[x];
                    }
                }
                break;
            }
            case 3: {
                NewImage.fillNoiseRGB(ip, true);
            }
        }
        ImagePlus imp = new ImagePlus(title, ip);
        if (slices > 1 && !(ok = NewImage.createStack(imp, ip, slices, 3, options))) {
            imp = null;
        }
        return imp;
    }

    public static ImagePlus createIntImage(String title, int width, int height, int slices, int options) {
        boolean ok;
        int fill = NewImage.getFill(options);
        int size = NewImage.getSize(width, height);
        if (size < 0) {
            return null;
        }
        int[] pixels = new int[size];
        IntProcessor ip = new IntProcessor(width, height, pixels);
        switch (fill) {
            case 2: {
                int[] ramp = new int[width];
                double inc = 4.294967295E9 / (double)width;
                for (int i = 0; i < width; ++i) {
                    ramp[i] = (int)(-2.147483648E9 + (double)i * inc);
                }
                for (int y = 0; y < height; ++y) {
                    int offset = y * width;
                    for (int x = 0; x < width; ++x) {
                        pixels[offset++] = ramp[x];
                    }
                }
                break;
            }
            case 3: {
                NewImage.fillNoiseInt(new IntProcessor(width, height, pixels));
            }
        }
        ImagePlus imp = new ImagePlus(title, ip);
        if (slices > 1 && !(ok = NewImage.createStack(imp, ip, slices, 3, options))) {
            imp = null;
        }
        return imp;
    }

    private static void fillNoiseRGB(ColorProcessor ip, boolean sp) {
        int width = ip.getWidth();
        int height = ip.getHeight();
        ByteProcessor rr = new ByteProcessor(width, height);
        ByteProcessor gg = new ByteProcessor(width, height);
        ByteProcessor bb = new ByteProcessor(width, height);
        if (sp) {
            IJ.showProgress(0.0);
        }
        rr.add(127);
        if (sp) {
            IJ.showProgress(0.05);
        }
        gg.add(127);
        if (sp) {
            IJ.showProgress(0.1);
        }
        bb.add(127);
        if (sp) {
            IJ.showProgress(0.15);
        }
        rr.noise(31.0);
        if (sp) {
            IJ.showProgress(0.4);
        }
        gg.noise(31.0);
        if (sp) {
            IJ.showProgress(0.65);
        }
        bb.noise(31.0);
        if (sp) {
            IJ.showProgress(0.9);
        }
        if (sp) {
            IJ.showProgress(1.0);
        }
        ip.setChannel(1, rr);
        ip.setChannel(2, gg);
        ip.setChannel(3, bb);
    }

    private static void fillNoiseInt(ImageProcessor ip) {
        Random rnd = new Random();
        int n = ip.getPixelCount();
        double std = 5.153960754E8;
        for (int i = 0; i < n; ++i) {
            ip.set(i, (int)(rnd.nextGaussian() * std));
        }
    }

    public static ImagePlus createShortImage(String title, int width, int height, int slices, int options) {
        boolean ok;
        int fill = NewImage.getFill(options);
        int size = NewImage.getSize(width, height);
        if (size < 0) {
            return null;
        }
        short[] pixels = new short[size];
        ShortProcessor ip = new ShortProcessor(width, height, pixels, null);
        switch (fill) {
            case 1: 
            case 4: {
                break;
            }
            case 2: {
                short[] ramp = new short[width];
                for (int i = 0; i < width; ++i) {
                    ramp[i] = (short)((double)i * 65536.0 / (double)width + 0.5);
                }
                for (int y = 0; y < height; ++y) {
                    int offset = y * width;
                    for (int x = 0; x < width; ++x) {
                        pixels[offset++] = ramp[x];
                    }
                }
                break;
            }
            case 3: {
                NewImage.fillNoiseShort(ip);
            }
        }
        if (fill == 4) {
            ip.invertLut();
        }
        ImagePlus imp = new ImagePlus(title, ip);
        if (slices > 1 && !(ok = NewImage.createStack(imp, ip, slices, 1, options))) {
            imp = null;
        }
        imp.getProcessor().setMinAndMax(0.0, 65535.0);
        return imp;
    }

    private static void fillNoiseShort(ImageProcessor ip) {
        ip.add(Short.MAX_VALUE);
        ip.noise(7940.0);
    }

    public static ImagePlus createUnsignedShortImage(String title, int width, int height, int slices, int options) {
        return NewImage.createShortImage(title, width, height, slices, options);
    }

    public static ImagePlus createFloatImage(String title, int width, int height, int slices, int options) {
        boolean ok;
        int fill = NewImage.getFill(options);
        int size = NewImage.getSize(width, height);
        if (size < 0) {
            return null;
        }
        float[] pixels = new float[size];
        FloatProcessor ip = new FloatProcessor(width, height, pixels, null);
        switch (fill) {
            case 1: 
            case 4: {
                break;
            }
            case 2: {
                float[] ramp = new float[width];
                for (int i = 0; i < width; ++i) {
                    ramp[i] = (float)((double)i * 1.0 / (double)width);
                }
                for (int y = 0; y < height; ++y) {
                    int offset = y * width;
                    for (int x = 0; x < width; ++x) {
                        pixels[offset++] = ramp[x];
                    }
                }
                break;
            }
            case 3: {
                NewImage.fillNoiseFloat(ip);
            }
        }
        if (fill == 4) {
            ip.invertLut();
        }
        ImagePlus imp = new ImagePlus(title, ip);
        if (slices > 1 && !(ok = NewImage.createStack(imp, ip, slices, 2, options))) {
            imp = null;
        }
        if (fill != 3) {
            imp.getProcessor().setMinAndMax(0.0, 1.0);
        }
        return imp;
    }

    private static void fillNoiseFloat(ImageProcessor ip) {
        ip.noise(1.0);
    }

    private static int getSize(int width, int height) {
        long size = (long)width * (long)height;
        if (size > Integer.MAX_VALUE) {
            IJ.error("Image is too large. ImageJ does not support\nsingle images larger than 2 gigapixels.");
            return -1;
        }
        return (int)size;
    }

    public static void open(String title, int width, int height, int nSlices, int type, int options) {
        int bitDepth = 8;
        if (type == 1) {
            bitDepth = 16;
        } else if (type == 2) {
            bitDepth = 32;
        } else if (type == 3) {
            bitDepth = 24;
        }
        long startTime = System.currentTimeMillis();
        ImagePlus imp = NewImage.createImage(title, width, height, nSlices, bitDepth, options);
        if (imp != null) {
            WindowManager.checkForDuplicateName = true;
            imp.show();
            IJ.showStatus(IJ.d2s((double)(System.currentTimeMillis() - startTime) / 1000.0, 2) + " seconds");
        }
    }

    public static ImagePlus createImage(String title, int width, int height, int nSlices, int bitDepth, int options) {
        ImagePlus imp = null;
        switch (bitDepth) {
            case 8: {
                imp = NewImage.createByteImage(title, width, height, nSlices, options);
                break;
            }
            case 16: {
                imp = NewImage.createShortImage(title, width, height, nSlices, options);
                break;
            }
            case 32: {
                imp = NewImage.createFloatImage(title, width, height, nSlices, options);
                break;
            }
            case 24: {
                if ((options & 0x10) != 0) {
                    imp = NewImage.createIntImage(title, width, height, nSlices, options);
                    break;
                }
                imp = NewImage.createRGBImage(title, width, height, nSlices, options);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid bitDepth: " + bitDepth);
            }
        }
        return imp;
    }

    boolean showDialog() {
        if (staticType < 0 || staticType > 3) {
            staticType = 0;
        }
        if (staticFillWith < 0 || staticFillWith > 3) {
            staticFillWith = 4;
        }
        GenericDialog gd = new GenericDialog("New Image...");
        gd.addStringField("Name:", name, 12);
        gd.addChoice("Type:", types, types[staticType]);
        gd.addChoice("Fill with:", fill, fill[staticFillWith]);
        gd.addNumericField("Width:", staticWidth, 0, 5, "pixels");
        gd.addNumericField("Height:", staticHeight, 0, 5, "pixels");
        gd.addNumericField("Slices:", staticSlices, 0, 5, "");
        gd.showDialog();
        if (gd.wasCanceled()) {
            return false;
        }
        name = gd.getNextString();
        String s2 = gd.getNextChoice();
        this.gtype = s2.startsWith("8") ? 0 : (s2.startsWith("16") ? 1 : (s2.endsWith("RGB") || s2.endsWith("rgb") ? 3 : 2));
        this.gfill = gd.getNextChoiceIndex();
        this.gwidth = (int)gd.getNextNumber();
        this.gheight = (int)gd.getNextNumber();
        this.gslices = (int)gd.getNextNumber();
        if (this.gslices < 1) {
            this.gslices = 1;
        }
        if (this.gwidth < 1 || this.gheight < 1) {
            IJ.error("New Image", "Width and height must be >0");
            return false;
        }
        if (!IJ.isMacro()) {
            staticWidth = this.gwidth;
            staticHeight = this.gheight;
            staticSlices = this.gslices;
            staticType = this.gtype;
            staticFillWith = this.gfill;
        }
        return true;
    }

    void openImage() {
        if (!this.showDialog()) {
            return;
        }
        try {
            NewImage.open(name, this.gwidth, this.gheight, this.gslices, this.gtype, this.gfill);
        }
        catch (OutOfMemoryError e) {
            IJ.outOfMemory("New Image...");
        }
    }

    public static void savePreferences(Properties prefs) {
        prefs.put(TYPE, Integer.toString(staticType));
        prefs.put(FILL, Integer.toString(staticFillWith));
        prefs.put(WIDTH, Integer.toString(staticWidth));
        prefs.put(HEIGHT, Integer.toString(staticHeight));
        prefs.put(SLICES, Integer.toString(staticSlices));
    }
}

