/*
 * Decompiled with CFR 0.152.
 */
package ij.gui;

import ij.IJ;
import ij.ImagePlus;
import ij.WindowManager;
import ij.gui.ImageCanvas;
import ij.gui.OvalRoi;
import ij.gui.Roi;
import ij.gui.ShapeRoi;
import ij.gui.Toolbar;
import java.awt.Point;
import java.awt.Polygon;

class RoiBrush
implements Runnable {
    static int ADD = 0;
    static int SUBTRACT = 1;
    static int leftClick = 16;
    static int alt = 9;
    static int shift = 1;
    private Polygon poly;
    private Point previousP;
    private int mode = ADD;

    RoiBrush() {
        Thread thread2 = new Thread((Runnable)this, "RoiBrush");
        thread2.start();
    }

    @Override
    public void run() {
        int size = Toolbar.getBrushSize();
        ImagePlus img = WindowManager.getCurrentImage();
        if (img == null) {
            return;
        }
        ImageCanvas ic = img.getCanvas();
        if (ic == null) {
            return;
        }
        Roi roi = img.getRoi();
        if (roi != null && !roi.isArea()) {
            img.deleteRoi();
        }
        Point p = ic.getCursorLoc();
        if (roi != null && !roi.contains(p.x, p.y)) {
            this.mode = SUBTRACT;
        }
        while (true) {
            if ((p = ic.getCursorLoc()).equals(this.previousP)) {
                IJ.wait(1);
                continue;
            }
            this.previousP = p;
            int flags = ic.getModifiers();
            if ((flags & leftClick) == 0) {
                return;
            }
            if ((flags & shift) != 0) {
                this.mode = ADD;
            } else if ((flags & alt) != 0) {
                this.mode = SUBTRACT;
            }
            if (this.mode == ADD) {
                this.addCircle(img, p.x, p.y, size);
                continue;
            }
            this.subtractCircle(img, p.x, p.y, size);
        }
    }

    void addCircle(ImagePlus img, int x, int y, int width) {
        Roi roi = img.getRoi();
        Roi roi2 = roi;
        if (roi2 != null) {
            if (!(roi2 instanceof ShapeRoi)) {
                roi2 = new ShapeRoi(roi2);
            }
            ((ShapeRoi)roi2).or(this.getCircularRoi(x, y, width));
            roi2.copyAttributes(roi);
        } else {
            roi2 = new OvalRoi(x - width / 2, y - width / 2, width, width);
        }
        img.setRoi(roi2);
    }

    void subtractCircle(ImagePlus img, int x, int y, int width) {
        Roi roi = img.getRoi();
        Roi roi2 = roi;
        if (roi2 != null) {
            if (!(roi2 instanceof ShapeRoi)) {
                roi2 = new ShapeRoi(roi2);
            }
            ((ShapeRoi)roi2).not(this.getCircularRoi(x, y, width));
            roi2.copyAttributes(roi);
            img.setRoi(roi2);
        }
    }

    ShapeRoi getCircularRoi(int x, int y, int width) {
        if (this.poly == null) {
            OvalRoi roi = new OvalRoi(x - width / 2, y - width / 2, width, width);
            this.poly = ((Roi)roi).getPolygon();
            int i = 0;
            while (i < this.poly.npoints) {
                int n = i;
                this.poly.xpoints[n] = this.poly.xpoints[n] - x;
                int n2 = i++;
                this.poly.ypoints[n2] = this.poly.ypoints[n2] - y;
            }
        }
        return new ShapeRoi(x, y, this.poly);
    }
}

