/*
 * Decompiled with CFR 0.152.
 */
package ij.io;

import ij.IJ;
import ij.Macro;
import ij.Prefs;
import ij.io.DragAndDropHandler;
import ij.io.OpenDialog;
import ij.plugin.frame.Recorder;
import ij.util.Java2;
import java.awt.EventQueue;
import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.LookAndFeel;

public class DirectoryChooser {
    private String directory;
    private String title;

    public DirectoryChooser(String title) {
        this.title = title;
        if (IJ.isMacOSX() && !Prefs.useJFileChooser) {
            this.getDirectoryUsingFileDialog(title);
        } else {
            String macroOptions = Macro.getOptions();
            if (macroOptions != null) {
                this.directory = Macro.getValue(macroOptions, title, null);
            }
            if (this.directory == null) {
                if (EventQueue.isDispatchThread()) {
                    this.getDirectoryUsingJFileChooserOnThisThread(title);
                } else {
                    this.getDirectoryUsingJFileChooser(title);
                }
            }
        }
    }

    void getDirectoryUsingJFileChooser(final String title) {
        LookAndFeel saveLookAndFeel = Java2.getLookAndFeel();
        Java2.setSystemLookAndFeel();
        try {
            EventQueue.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    JFileChooser chooser = new JFileChooser();
                    chooser.setDialogTitle(title);
                    chooser.setFileSelectionMode(1);
                    chooser.setDragEnabled(true);
                    chooser.setTransferHandler(new DragAndDropHandler(chooser));
                    String defaultDir = OpenDialog.getDefaultDirectory();
                    if (defaultDir != null) {
                        File f = new File(defaultDir);
                        if (IJ.debugMode) {
                            IJ.log("DirectoryChooser,setSelectedFileW: " + f);
                        }
                        chooser.setSelectedFile(f);
                    }
                    chooser.setApproveButtonText("Select");
                    if (chooser.showOpenDialog(null) == 0) {
                        File file2 = chooser.getSelectedFile();
                        DirectoryChooser.this.directory = file2.getAbsolutePath();
                        DirectoryChooser.this.directory = IJ.addSeparator(DirectoryChooser.this.directory);
                        OpenDialog.setDefaultDirectory(DirectoryChooser.this.directory);
                    }
                }
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
        Java2.setLookAndFeel(saveLookAndFeel);
    }

    void getDirectoryUsingJFileChooserOnThisThread(String title) {
        LookAndFeel saveLookAndFeel = Java2.getLookAndFeel();
        Java2.setSystemLookAndFeel();
        try {
            JFileChooser chooser = new JFileChooser();
            chooser.setDialogTitle(title);
            chooser.setFileSelectionMode(1);
            chooser.setDragEnabled(true);
            chooser.setTransferHandler(new DragAndDropHandler(chooser));
            String defaultDir = OpenDialog.getDefaultDirectory();
            if (defaultDir != null) {
                File f = new File(defaultDir);
                if (IJ.debugMode) {
                    IJ.log("DirectoryChooser,setSelectedFile: " + f);
                }
                chooser.setSelectedFile(f);
            }
            chooser.setApproveButtonText("Select");
            if (chooser.showOpenDialog(null) == 0) {
                File file2 = chooser.getSelectedFile();
                this.directory = file2.getAbsolutePath();
                this.directory = IJ.addSeparator(this.directory);
                OpenDialog.setDefaultDirectory(this.directory);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        Java2.setLookAndFeel(saveLookAndFeel);
    }

    void getDirectoryUsingFileDialog(String title) {
        OpenDialog od;
        String odDir;
        boolean saveUseJFC = Prefs.useJFileChooser;
        Prefs.useJFileChooser = false;
        System.setProperty("apple.awt.fileDialogForDirectories", "true");
        String dir = null;
        String name = null;
        String defaultDir = OpenDialog.getDefaultDirectory();
        if (defaultDir != null) {
            File f = new File(defaultDir);
            dir = f.getParent();
            name = f.getName();
        }
        if (IJ.debugMode) {
            IJ.log("DirectoryChooser: dir=\"" + dir + "\",  file=\"" + name + "\"");
        }
        if ((odDir = (od = new OpenDialog(title, dir, null)).getDirectory()) == null) {
            this.directory = null;
        } else {
            this.directory = odDir + od.getFileName() + "/";
            OpenDialog.setDefaultDirectory(this.directory);
        }
        System.setProperty("apple.awt.fileDialogForDirectories", "false");
        Prefs.useJFileChooser = saveUseJFC;
    }

    public String getDirectory() {
        if (IJ.debugMode) {
            IJ.log("DirectoryChooser.getDirectory: " + this.directory);
        }
        if (Recorder.record && !IJ.isMacOSX()) {
            Recorder.recordPath(this.title, this.directory);
        }
        return this.directory;
    }

    public static void setDefaultDirectory(String dir) {
        if (dir == null || new File(dir).isDirectory()) {
            OpenDialog.setDefaultDirectory(dir);
        }
    }
}

